/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import com.sun.jini.config.Config;
import java.rmi.MarshalledObject;
import java.util.Enumeration;
import java.util.Vector;
import net.jini.config.Configuration;
import net.jini.discovery.DiscoveryManagement;
import org.jini.rio.event.DynamicEventConsumer;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.event.RemoteServiceEventListener;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.resource.ThreadPool;

public class PooledEventConsumer
extends DynamicEventConsumer
implements RemoteServiceEventListener {
    protected Vector subscribers = new Vector();
    private ThreadPool pool = null;
    private static final int DEFAULT_POOL_MIN = 0;
    private static final int DEFAULT_POOL_MAX = 100;

    public PooledEventConsumer(EventDescriptor edTemplate) throws Exception {
        this(edTemplate, null, null, null, "PooledEventConsumer", null);
    }

    public PooledEventConsumer(EventDescriptor edTemplate, Configuration config) throws Exception {
        this(edTemplate, null, null, null, "PooledEventConsumer", config);
    }

    public PooledEventConsumer(EventDescriptor edTemplate, String identifier, Configuration config) throws Exception {
        this(edTemplate, null, null, null, identifier, config);
    }

    public PooledEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener) throws Exception {
        this(edTemplate, listener, null, null, "PooledEventConsumer", null);
    }

    public PooledEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, Configuration config) throws Exception {
        this(edTemplate, listener, null, null, "PooledEventConsumer", config);
    }

    public PooledEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, String identifier, Configuration config) throws Exception {
        this(edTemplate, listener, null, null, identifier, config);
    }

    public PooledEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, MarshalledObject handback) throws Exception {
        this(edTemplate, listener, handback, (DiscoveryManagement)null);
    }

    public PooledEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, MarshalledObject handback, DiscoveryManagement dMgr) throws Exception {
        this(edTemplate, listener, handback, dMgr, "PooledEventConsumer", null);
    }

    public PooledEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, MarshalledObject handback, DiscoveryManagement dMgr, String identifier, Configuration config) throws Exception {
        super(edTemplate, null, handback, dMgr, config);
        super.register(this, null);
        this.register(listener, handback);
        int poolMin = 0;
        int poolMax = 100;
        if (config != null) {
            poolMin = Config.getIntEntry((Configuration)config, (String)"org.jini.rio.event.PooledEventConsumer", (String)"threadPoolMinimum", (int)0, (int)0, (int)50);
            int minPoolMax = poolMin + 1;
            poolMax = Config.getIntEntry((Configuration)config, (String)"org.jini.rio.event.PooledEventConsumer", (String)"threadPoolMaximum", (int)100, (int)minPoolMax, (int)Integer.MAX_VALUE);
        }
        this.pool = new ThreadPool(identifier, poolMin, poolMax);
    }

    @Override
    public void notify(RemoteServiceEvent event) {
        Enumeration e = this.subscribers.elements();
        while (e.hasMoreElements()) {
            RemoteServiceEventListener l = (RemoteServiceEventListener)e.nextElement();
            try {
                PoolableThread thread = (PoolableThread)this.pool.get();
                thread.execute((Runnable)new EventRunnable(event, l));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                l.notify(event);
            }
        }
    }

    @Override
    public boolean register(RemoteServiceEventListener listener, MarshalledObject handback) {
        this.handback = handback;
        return this.subscribers.add(listener);
    }

    @Override
    public boolean deregister(RemoteServiceEventListener listener) {
        return this.subscribers.remove(listener);
    }

    public ThreadPool getPool() {
        return this.pool;
    }

    public void setPool(ThreadPool pool) {
        this.pool = pool;
    }

    public int getMinThreads() {
        return this.pool.getMin();
    }

    public void setMinThreads(int minThreads) throws Exception {
        this.pool.setMin(minThreads);
    }

    public int getMaxThreads() {
        return this.pool.getMax();
    }

    public void setMaxThreads(int maxThreads) {
        this.pool.setMax(maxThreads);
    }

    public String getIdentifier() {
        return this.pool.getIdentifier();
    }

    public void setIdentifier(String identifier) {
        this.pool.setIdentifier(identifier);
    }

    static class EventRunnable
    implements Runnable {
        RemoteServiceEvent event;
        RemoteServiceEventListener listener;

        public EventRunnable(RemoteServiceEvent event, RemoteServiceEventListener listener) {
            this.event = event;
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.notify(this.event);
        }
    }
}

