/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import net.jini.discovery.DiscoveryManagement;
import org.jini.rio.event.DynamicEventConsumer;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.RemotePropertyChangeEvent;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.event.RemoteServiceEventListener;

public class RemotePropertyChangeConsumer
implements RemoteServiceEventListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private EventDescriptor eventTemplate;
    private DynamicEventConsumer eventConsumer;

    public RemotePropertyChangeConsumer(DiscoveryManagement dmgr) throws Exception {
        this(dmgr, 8475432875L);
    }

    public RemotePropertyChangeConsumer(DiscoveryManagement dmgr, long eventID) throws Exception {
        this.eventTemplate = new EventDescriptor(RemotePropertyChangeEvent.class, new Long(eventID));
        this.eventConsumer = new DynamicEventConsumer(this.eventTemplate, (RemoteServiceEventListener)this, dmgr);
    }

    @Override
    public void notify(RemoteServiceEvent rEvent) {
        RemotePropertyChangeEvent event = (RemotePropertyChangeEvent)rEvent;
        PropertyChangeEvent pce = event.getEvent();
        PropertyChangeEvent localEvent = new PropertyChangeEvent(event.getSource(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
        this.propertyChangeSupport.firePropertyChange(localEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public EventDescriptor getEventTemplate() {
        return this.eventTemplate;
    }

    public DynamicEventConsumer getEventConsumer() {
        return this.eventConsumer;
    }
}

