/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.event.DispatchEventHandler;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventHandler;
import org.jini.rio.event.NoEventConsumerException;
import org.jini.rio.event.RemotePropertyChangeEvent;

public class RemotePropertyChangeDispatcher
implements PropertyChangeListener {
    private EventDescriptor eventDescriptor;
    private EventHandler eventHandler;
    static final Logger logger = Logger.getLogger("org.jini.rio.event");

    public RemotePropertyChangeDispatcher() throws Exception {
        this(8475432875L);
    }

    public RemotePropertyChangeDispatcher(long eventID) throws Exception {
        this.eventDescriptor = new EventDescriptor(RemotePropertyChangeEvent.class, new Long(eventID));
        this.eventHandler = new DispatchEventHandler(this.eventDescriptor);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        RemotePropertyChangeEvent remoteEvent = new RemotePropertyChangeEvent(evt);
        try {
            this.eventHandler.fire(remoteEvent);
        }
        catch (RemoteException e) {
            logger.log(Level.SEVERE, "DispatchEventHandler fire invocation", e);
        }
        catch (NoEventConsumerException e) {
            logger.warning("No EventConsumers registered");
        }
    }

    public EventDescriptor getEventDescriptor() {
        return this.eventDescriptor;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }
}

