/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventHandler;
import org.jini.rio.event.NoEventConsumerException;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.resources.servicecore.ServiceResource;

public class RoundRobinEventHandler
extends EventHandler {
    static Logger logger = Logger.getLogger("org.jini.rio.event");

    public RoundRobinEventHandler(EventDescriptor descriptor) throws Exception {
        super(descriptor);
    }

    public RoundRobinEventHandler(EventDescriptor descriptor, Configuration config) throws Exception {
        super(descriptor, config);
    }

    @Override
    public void fire(RemoteServiceEvent event) throws NoEventConsumerException, RemoteException {
        event.setEventID(this.descriptor.eventID);
        event.setSequenceNumber(this.sequenceNumber);
        while (true) {
            ServiceResource sr;
            if ((sr = this.getNextServiceResource()) == null) {
                throw new NoEventConsumerException("No event consumers");
            }
            try {
                EventHandler.EventRegistrationResource er = (EventHandler.EventRegistrationResource)sr.getResource();
                RemoteEventListener listener = er.getListener();
                MarshalledObject handback = er.getHandback();
                event.setHandback(handback);
                this.t0 = System.currentTimeMillis();
                listener.notify((RemoteEvent)event);
                this.t1 = System.currentTimeMillis();
                this.sendTime = this.t1 - this.t0;
                if (this.responseWatch != null) {
                    this.responseWatch.setElapsedTime(this.sendTime, this.t1);
                }
                ++this.sequenceNumber;
                ++this.sent;
                this.printStats(0);
            }
            catch (UnknownEventException uee) {
                try {
                    this.resourceMgr.removeResource(sr);
                    this.landlord.cancel(sr.getCookie());
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Removing/Cancelling an EventConsumer from UnknownEventException", ex);
                }
                continue;
            }
            catch (RemoteException re) {
                try {
                    this.resourceMgr.removeResource(sr);
                    this.landlord.cancel(sr.getCookie());
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Removing/Cancelling an EventConsumer from RemoteException", ex);
                }
                continue;
            }
            break;
        }
    }
}

