/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jmx;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import net.jini.id.Uuid;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.jsb.ServiceBeanContext;

public class JMXUtil {
    static final Logger LOGGER = Logger.getLogger(JMXUtil.class.getName());

    public static CompositeData createCompositeData(Object data, String name, String description) throws IntrospectionException, InvocationTargetException, IllegalAccessException, OpenDataException {
        Map map = JMXUtil.toMap(data);
        CompositeType compositeType = JMXUtil.createCompositeType(map, name, description);
        return new CompositeDataSupport(compositeType, map);
    }

    public static Map toMap(Object data) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(data.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            String key = propertyDescriptor.getName();
            Method readMethod = propertyDescriptor.getReadMethod();
            Object value = null;
            if (readMethod != null) {
                value = readMethod.invoke(data, null);
            }
            if (value == null) continue;
            if (!JMXUtil.isOpenType(key)) {
                value = value.toString();
            }
            map.put(key, value);
        }
        return map;
    }

    public static CompositeType createCompositeType(Map m, String compositeTypeName, String compositeTypeDescription) throws OpenDataException {
        String[] keys = new String[m.size()];
        OpenType[] types = new OpenType[m.size()];
        int index = 0;
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String key;
            keys[index] = key = (String)i.next();
            types[index] = JMXUtil.getOpenType(m.get(key).getClass().getName(), null);
            ++index;
        }
        return new CompositeType(compositeTypeName, compositeTypeDescription, keys, keys, types);
    }

    public static OpenType getOpenType(String classString, OpenType defaultType) {
        if (classString == null) {
            throw new NullPointerException("classString is null");
        }
        if (classString.equals("void")) {
            return SimpleType.VOID;
        }
        if (!JMXUtil.isOpenType(classString)) {
            throw new InvalidOpenTypeException(classString);
        }
        if (classString.equals(String.class.getName())) {
            return SimpleType.STRING;
        }
        if (classString.equals(Boolean.class.getName())) {
            return SimpleType.BOOLEAN;
        }
        if (classString.equals(Long.class.getName())) {
            return SimpleType.LONG;
        }
        if (classString.equals(Integer.class.getName())) {
            return SimpleType.INTEGER;
        }
        if (classString.equals(Float.class.getName())) {
            return SimpleType.FLOAT;
        }
        if (classString.equals(Double.class.getName())) {
            return SimpleType.DOUBLE;
        }
        if (defaultType != null) {
            return defaultType;
        }
        throw new InvalidOpenTypeException("Unsupported type: " + classString);
    }

    public static boolean isOpenType(String classname) {
        return Arrays.asList(OpenType.ALLOWED_CLASSNAMES).contains(classname);
    }

    public static String getJMXName(ServiceBeanContext context, String defaultDomain) {
        Uuid uuid = context.getServiceBeanManager().getServiceID();
        String jmxName = (String)context.getInitParameter("jmxName");
        ClassBundle[] exports = context.getServiceElement().getExportBundles();
        String type = exports[0].getClassName();
        int ndx = type.lastIndexOf(".");
        type = ndx > 0 ? type.substring(ndx + 1) : "Service";
        if (jmxName == null) {
            jmxName = defaultDomain + ":type=" + type;
            context.getServiceBeanConfig().addInitParameter("jmxName", jmxName);
        }
        return jmxName + ",uuid=" + uuid;
    }

    public static ObjectName getObjectName(ServiceBeanContext context, String defaultDomain, String name) throws MalformedObjectNameException {
        String jmxName = JMXUtil.getJMXName(context, defaultDomain);
        String oName = jmxName + ",name=" + name;
        return ObjectName.getInstance(oName);
    }

    public static ObjectName getObjectName(ServiceBeanContext context, String defaultDomain, String name, String id) throws MalformedObjectNameException {
        String jmxName = JMXUtil.getJMXName(context, defaultDomain);
        String oName = jmxName + ",name=" + name + ",id=" + id;
        return ObjectName.getInstance(oName);
    }
}

