/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jsb;

import com.j_spaces.core.jini.SharedDiscoveryManagement;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.AggregateConfig;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryManagement;
import org.jini.rio.associations.AssociationMgmt;
import org.jini.rio.boot.CommonClassLoader;
import org.jini.rio.core.AssociationManagement;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.jsb.ComponentLoader;
import org.jini.rio.core.jsb.ComputeResourceManager;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.jsb.ServiceBeanManager;
import org.jini.rio.jsb.JSBManager;
import org.jini.rio.qos.ComputeResource;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.qos.measurable.MeasurableCapability;
import org.jini.rio.watch.WatchDataSourceRegistry;
import org.jini.rio.watch.WatchRegistry;

public class JSBContext
implements ServiceBeanContext,
ComputeResourceManager {
    private ServiceElement sElem;
    private ServiceBeanManager serviceBeanManager;
    private DiscoveryManagement serviceDiscoMgmt;
    private Object computeResource;
    private String exportCodebase;
    private List platformList = new ArrayList();
    private AssociationManagement associationManagement;
    private Configuration sharedConfig;
    private WatchRegistry watchRegistry;
    private static final String COMPONENT = "org.jini.rio.jsb";
    private static Logger logger = Logger.getLogger("org.jini.rio.jsb");
    final ServiceID parentServiceID;

    public JSBContext(ServiceElement sElem, ServiceID parentServiceID, ServiceBeanManager serviceBeanManager, Object computeResource, Configuration sharedConfig) {
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        if (serviceBeanManager == null) {
            throw new NullPointerException("serviceBeanManager is null");
        }
        if (computeResource == null) {
            throw new NullPointerException("computeResource is null");
        }
        this.setServiceElement(sElem);
        this.parentServiceID = parentServiceID;
        this.serviceBeanManager = serviceBeanManager;
        this.computeResource = computeResource;
        this.sharedConfig = sharedConfig;
        ClassBundle[] exportBundles = sElem.getExportBundles();
        this.exportCodebase = exportBundles[0].getCodebase();
    }

    public Configuration getSharedConfiguration() {
        return this.sharedConfig;
    }

    @Override
    public ServiceID getParentServiceID() {
        return this.parentServiceID;
    }

    public void setServiceElement(ServiceElement newElem) {
        if (newElem == null) {
            throw new NullPointerException("sElem is null");
        }
        boolean update = this.sElem != null;
        this.sElem = newElem;
        if (this.serviceBeanManager instanceof JSBManager) {
            ((JSBManager)this.serviceBeanManager).setServiceElement(this.sElem);
        }
        if (update && this.associationManagement != null) {
            this.associationManagement.setServiceBeanContext(this);
        }
    }

    @Override
    public ComponentLoader getComponentLoader() {
        return CommonClassLoader.getInstance();
    }

    @Override
    public String getExportCodebase() {
        return this.exportCodebase;
    }

    @Override
    public Configuration getConfiguration() throws ConfigurationException {
        Object serviceBeanConfig = null;
        serviceBeanConfig = this.sharedConfig != null ? new AggregateConfig(this.sharedConfig, this.sElem.getServiceBeanConfig().getConfigArgs()) : ConfigurationProvider.getInstance((String[])this.sElem.getServiceBeanConfig().getConfigArgs());
        return serviceBeanConfig;
    }

    @Override
    public ServiceBeanConfig getServiceBeanConfig() {
        return this.sElem.getServiceBeanConfig();
    }

    @Override
    public ServiceElement getServiceElement() {
        return this.sElem;
    }

    public void setServiceBeanManager(ServiceBeanManager serviceBeanManager) {
        if (serviceBeanManager == null) {
            throw new NullPointerException("serviceBeanManager us null");
        }
        this.serviceBeanManager = serviceBeanManager;
    }

    @Override
    public ServiceBeanManager getServiceBeanManager() {
        return this.serviceBeanManager;
    }

    @Override
    public ComputeResourceManager getComputeResourceManager() {
        return this;
    }

    @Override
    public Object getInitParameter(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.sElem.getServiceBeanConfig().getInitParameters().get(name);
    }

    @Override
    public Iterator getInitParameterNames() {
        return this.sElem.getServiceBeanConfig().getInitParameters().keySet().iterator();
    }

    public String getOperationalStringName() {
        return this.sElem.getOperationalStringName();
    }

    @Override
    public synchronized DiscoveryManagement getDiscoveryManagement() throws IOException {
        if (this.serviceDiscoMgmt == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Create DiscoveryManagement for " + this.sElem.getName());
            }
            this.serviceDiscoMgmt = SharedDiscoveryManagement.getLookupDiscoveryManager((String[])this.sElem.getServiceBeanConfig().getGroups(), (LookupLocator[])this.sElem.getServiceBeanConfig().getLocators(), null);
        }
        return this.serviceDiscoMgmt;
    }

    @Override
    public AssociationManagement getAssociationManagement() {
        if (this.associationManagement == null) {
            AssociationMgmt defaultAssocMgmt = new AssociationMgmt();
            try {
                this.associationManagement = (AssociationManagement)this.getConfiguration().getEntry(COMPONENT, "associationManagement", AssociationManagement.class, (Object)defaultAssocMgmt);
            }
            catch (ConfigurationException e) {
                logger.log(Level.WARNING, "Creating AssociationManagement, will use default", e);
                this.associationManagement = defaultAssocMgmt;
            }
        }
        return this.associationManagement;
    }

    @Override
    public WatchRegistry getWatchRegistry() {
        if (this.watchRegistry == null) {
            try {
                Configuration config = this.getConfiguration();
                this.watchRegistry = (WatchRegistry)config.getEntry(COMPONENT, "watchRegistry", WatchRegistry.class, (Object)new WatchDataSourceRegistry());
                this.watchRegistry.setServiceBeanContext(this);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Getting watchRegistry", e);
            }
        }
        return this.watchRegistry;
    }

    @Override
    public Object getComputeResource() {
        return this.computeResource;
    }

    @Override
    public PlatformCapability getPlatformCapability(String description) {
        if (description == null) {
            throw new NullPointerException("description is null");
        }
        return ((ComputeResource)this.computeResource).getPlatformCapability(description);
    }

    @Override
    public PlatformCapability[] getMatchedPlatformCapabilities() {
        ServiceLevelAgreements slas = this.sElem.getServiceLevelAgreements();
        ServiceLevelAgreements.SystemRequirement[] requirements = slas.getSystemRequirements();
        ArrayList<PlatformCapability> list = new ArrayList<PlatformCapability>();
        if (requirements.length >= 0) {
            PlatformCapability[] pCaps = ((ComputeResource)this.computeResource).getPlatformCapabilities();
            for (int i = 0; i < requirements.length; ++i) {
                for (int j = 0; j < pCaps.length; ++j) {
                    if (!pCaps[j].supports(requirements[i])) continue;
                    list.add(pCaps[j]);
                }
            }
        }
        return list.toArray(new PlatformCapability[list.size()]);
    }

    @Override
    public PlatformCapability addPlatformCapability(String className, URL location, String description, Map mapping) {
        if (className == null) {
            throw new NullPointerException("className is null");
        }
        PlatformCapability pCap = null;
        try {
            URL[] uRLArray;
            if (location == null) {
                uRLArray = null;
            } else {
                URL[] uRLArray2 = new URL[1];
                uRLArray = uRLArray2;
                uRLArray2[0] = location;
            }
            pCap = JSBContext.createPlatformCapability(className, uRLArray, mapping);
            if (description != null) {
                pCap.setDescription(description);
            }
            ((ComputeResource)this.computeResource).addPlatformCapability(pCap);
            this.platformList.add(pCap);
        }
        catch (Throwable t) {
            Throwable cause = t;
            if (t.getCause() != null) {
                cause = t.getCause();
            }
            logger.log(Level.WARNING, "Adding PlatformCapability", cause);
        }
        return pCap;
    }

    public static PlatformCapability createPlatformCapability(String className, URL[] classPath, Map mapping) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (className == null) {
            throw new NullPointerException("className is null");
        }
        PlatformCapability pCap = null;
        CommonClassLoader cl = CommonClassLoader.getInstance();
        if (!cl.testComponentExistence(className)) {
            if (classPath != null && classPath.length != 0) {
                cl.addComponent(className, classPath);
            } else {
                throw new IllegalArgumentException("Cannot load PlatformCapability {" + className + "}, unknown location");
            }
        }
        Class clazz = cl.loadClass(className);
        pCap = (PlatformCapability)clazz.newInstance();
        if (mapping != null) {
            pCap.defineAll(mapping);
        }
        return pCap;
    }

    @Override
    public boolean removePlatformCapability(PlatformCapability pCap) {
        if (pCap == null) {
            throw new NullPointerException("pCap is null");
        }
        boolean removed = false;
        if (this.platformList.contains(pCap)) {
            removed = ((ComputeResource)this.computeResource).removePlatformCapability(pCap, true);
            this.platformList.remove(pCap);
        }
        return removed;
    }

    public void removePlatformCapabilities() {
        for (PlatformCapability pCap : this.platformList) {
            ((ComputeResource)this.computeResource).removePlatformCapability(pCap, true);
        }
        this.platformList.clear();
    }

    @Override
    public MeasurableCapability[] getMatchedMeasurableCapabilities() {
        ArrayList<MeasurableCapability> list = new ArrayList<MeasurableCapability>();
        SLA[] slas = this.sElem.getServiceLevelAgreements().getServiceSLAs();
        MeasurableCapability[] mCaps = ((ComputeResource)this.computeResource).getMeasurableCapabilities();
        for (int i = 0; i < slas.length; ++i) {
            for (int j = 0; j < mCaps.length; ++j) {
                if (!mCaps[j].getId().equals(slas[i].getIdentifier())) continue;
                list.add(mCaps[j]);
            }
        }
        return list.toArray(new MeasurableCapability[list.size()]);
    }
}

