/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jsb;

import com.sun.jini.start.LifeCycle;
import com.sun.jini.start.ServiceProxyAccessor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.ProxyAccessor;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.JSBInstantiationException;
import org.jini.rio.core.jsb.ServiceBean;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.jsb.ServiceBeanFactory;

public class JSBLoader
implements ServiceBeanFactory {
    static String COMPONENT = "org.jini.rio.jsb";
    static final Logger logger = Logger.getLogger(COMPONENT);
    private static final Class[] activationTypes = new Class[]{String[].class, LifeCycle.class};
    private static final Class[] startType = new Class[]{ServiceBeanContext.class};

    @Override
    public ServiceBeanFactory.Created create(ServiceBeanContext context) throws JSBInstantiationException {
        Object impl;
        Object proxy;
        block10: {
            proxy = null;
            impl = null;
            Thread currentThread = Thread.currentThread();
            try {
                ClassBundle jsbBundle = context.getServiceElement().getComponentBundle();
                ClassLoader jsbCL = currentThread.getContextClassLoader();
                Class<?> implClass = jsbCL.loadClass(jsbBundle.getClassName());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Load service class: {0}", implClass);
                }
                if (JSBLoader.useActivationConstructor(implClass) && !JSBLoader.isServiceBean(implClass)) {
                    Constructor<?> constructor = implClass.getDeclaredConstructor(activationTypes);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Obtained implementation constructor: {0}", constructor);
                    }
                    constructor.setAccessible(true);
                    LifeCycle lifeCycle = (LifeCycle)context.getServiceBeanManager().getDiscardManager();
                    impl = constructor.newInstance(context.getServiceBeanConfig().getConfigArgs(), lifeCycle);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Obtained implementation instance: {0}", (Object)impl);
                    }
                    proxy = impl instanceof ServiceProxyAccessor ? ((ServiceProxyAccessor)impl).getServiceProxy() : (impl instanceof ProxyAccessor ? ((ProxyAccessor)impl).getProxy() : null);
                    break block10;
                }
                if (JSBLoader.isServiceBean(implClass)) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Activating as ServiceBean");
                    }
                    Constructor<?> constructor = implClass.getConstructor(null);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Obtained implementation constructor: {0}", constructor);
                    }
                    impl = constructor.newInstance(null);
                    ServiceBean instance = impl;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Obtained implementation instance: {0}", instance);
                    }
                    proxy = instance.start(context);
                    break block10;
                }
                throw new IllegalStateException("Class [" + implClass + "] is not a service bean");
            }
            catch (Exception e) {
                throw new JSBInstantiationException("Service Instantiation Exception", e);
            }
        }
        return new ServiceBeanFactory.Created(impl, proxy);
    }

    static boolean useActivationConstructor(Class clazz) {
        try {
            clazz.getDeclaredConstructor(activationTypes);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
    }

    static boolean isServiceBean(Class clazz) {
        try {
            clazz.getMethod("start", startType);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
    }

    static boolean hasZeroArgConstructor(Class clazz) {
        try {
            clazz.getConstructor(null);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
    }

    static URL[] convertToURLs(String[] array) throws MalformedURLException {
        URL[] urlArray = new URL[array.length];
        for (int i = 0; i < array.length; ++i) {
            urlArray[i] = array[i].startsWith("http:") ? new URL(array[i]) : new File(array[i]).toURI().toURL();
        }
        return urlArray;
    }
}

