/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jsb;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotificationBroadcasterSupport;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.jsb.DiscardManager;
import org.jini.rio.core.jsb.ServiceBeanManager;
import org.jini.rio.core.jsb.ServiceElementChangeListener;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.qos.ComputeResource;

public class JSBManager
implements ServiceBeanManager {
    private static final String COMPONENT = "org.jini.rio.jsb";
    private static Logger logger = Logger.getLogger("org.jini.rio.jsb");
    private DiscardManager discardManager;
    private OperationalStringManager opStringManager;
    private ServiceElement sElem;
    private Uuid serviceID;
    private MarshalledInstance marshalledInstance;
    private final Object computeResource;
    private final ArrayList listenerList = new ArrayList();
    boolean updating = false;
    protected final NotificationBroadcasterSupport notificationBroadcasterSupport = new NotificationBroadcasterSupport();

    public JSBManager(ServiceElement sElem, Object computeResource) {
        if (sElem == null) {
            throw new IllegalArgumentException("sElem is null");
        }
        this.sElem = sElem;
        this.computeResource = computeResource;
    }

    public void setServiceElement(ServiceElement newElem) {
        if (newElem == null) {
            throw new IllegalArgumentException("sElem is null");
        }
        ServiceElement preElem = this.sElem;
        this.sElem = newElem;
        try {
            this.updating = true;
            this.stateChange(preElem, this.sElem);
        }
        finally {
            this.updating = false;
        }
    }

    public void setServiceID(Uuid serviceID) {
        if (serviceID == null) {
            throw new NullPointerException("serviceID is null");
        }
        this.serviceID = serviceID;
    }

    @Override
    public Uuid getServiceID() {
        return this.serviceID;
    }

    public void setMarshalledInstance(MarshalledInstance mi) {
        if (mi == null) {
            throw new NullPointerException("marshalledInstance is null");
        }
        this.marshalledInstance = mi;
    }

    public void setDiscardManager(DiscardManager discardManager) {
        if (discardManager == null) {
            throw new NullPointerException("discardManager is null");
        }
        this.discardManager = discardManager;
    }

    @Override
    public DiscardManager getDiscardManager() {
        return this.discardManager;
    }

    public void setOperationalStringManager(OperationalStringManager opStringManager) {
        this.opStringManager = opStringManager;
    }

    @Override
    public OperationalStringManager getOperationalStringManager() {
        return this.opStringManager;
    }

    @Override
    public void update(ServiceBeanConfig sbConfig) throws Exception {
        if (sbConfig == null) {
            throw new NullPointerException("ServiceBeanConfig is null");
        }
        if (this.sElem == null) {
            logger.log(Level.WARNING, "No ServiceElement to update ServiceBeanConfig");
            return;
        }
        if (this.updating) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Updating ServiceElement, ServiceBeanConfig update ignored");
            }
            return;
        }
        ServiceElement preElem = ServiceElementUtil.copyServiceElement(this.sElem);
        Long instanceID = this.sElem.getServiceBeanConfig().getInstanceID();
        this.sElem.setServiceBeanConfig(sbConfig);
        if (instanceID != null) {
            this.sElem = ServiceElementUtil.prepareInstanceID(this.sElem, false, instanceID);
        } else {
            logger.log(Level.WARNING, "No instanceID for [" + this.sElem.getName() + "] to update");
        }
        if (this.opStringManager == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "No OperationalStringManager to update ServiceBeanConfig");
            }
            return;
        }
        this.opStringManager.updateServiceBeanInstance(this.getServiceBeanInstance());
        this.stateChange(preElem, this.sElem);
    }

    public void increment() throws Exception {
        this.increment(null);
    }

    @Override
    public void increment(ServiceProvisionListener listener) throws Exception {
        if (this.opStringManager == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "No OperationalStringManager to increment service");
            }
            return;
        }
        this.opStringManager.increment(this.sElem, false, listener, false);
    }

    @Override
    public void decrement(boolean destroy) throws Exception {
        if (this.opStringManager == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "No OperationalStringManager to decrement service");
            }
            return;
        }
        this.opStringManager.decrement(this.getServiceBeanInstance(), false, destroy, false);
    }

    @Override
    public void relocate(ServiceProvisionListener listener, Uuid uuid) throws Exception {
        if (this.opStringManager == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "No OperationalStringManager to relocate service");
            }
            return;
        }
        if (this.sElem.getProvisionType() != 1) {
            throw new Exception("Relocation only available for DYNAMIC services");
        }
        this.opStringManager.relocate(this.getServiceBeanInstance(), listener, uuid);
    }

    @Override
    public ServiceBeanInstance getServiceBeanInstance() {
        return new ServiceBeanInstance(this.serviceID, this.marshalledInstance, this.sElem.getServiceBeanConfig(), this.getHostAddress(), this.getHostName());
    }

    void stateChange(ServiceElement preElem, ServiceElement postElem) {
        this.notifyListeners(preElem, postElem);
    }

    private String getHostAddress() {
        return ((ComputeResource)this.computeResource).getAddress().getHostAddress();
    }

    private String getHostName() {
        return ((ComputeResource)this.computeResource).getAddress().getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ServiceElementChangeListener l) {
        if (l == null) {
            throw new NullPointerException("can't add null listener");
        }
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ServiceElementChangeListener l) {
        if (l == null) {
            return;
        }
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            if (this.listenerList.contains(l)) {
                this.listenerList.remove(l);
            }
        }
    }

    @Override
    public NotificationBroadcasterSupport getNotficationBroadcasterSupport() {
        return this.notificationBroadcasterSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void notifyListeners(ServiceElement preElem, ServiceElement postElem) {
        ServiceElementChangeListener[] listeners = null;
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            listeners = this.listenerList.toArray(new ServiceElementChangeListener[this.listenerList.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].changed(preElem, postElem);
        }
    }
}

