/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jsb;

import com.gigaspaces.start.SystemBoot;
import com.gigaspaces.start.SystemConfig;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.start.LifeCycle;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.LookupGroups;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.boot.CommonClassLoader;
import org.jini.rio.boot.MulticastStatus;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.JSBControlException;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.jsb.DiscardManager;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.cybernode.ServiceBeanLoader;
import org.jini.rio.jsb.JSBContext;
import org.jini.rio.jsb.JSBManager;
import org.jini.rio.log.LoggerConfig;
import org.jini.rio.qos.ComputeResource;
import org.jini.rio.resources.client.LookupCachePool;

public class ServiceBeanActivation {
    private static final Logger LOGGER = Logger.getLogger(ServiceBeanActivation.class.getName());
    public static final String BOOT_OPSTRING = "System-Core";
    static final String COMPONENT = "org.jini.rio.jsb";
    public static final String BOOT_COMPONENT = "org.jini.rio.boot";
    public static final String BOOT_CONFIG_COMPONENT = "org.jini.rio.boot.configComponent";
    static LifeCycleManager sbLifeCycleManager;
    static final Logger logger;
    static final String BOOT_COOKIE = "boot-cookie";
    static final String FDH = "org.jini.rio.resources.client.AdminFaultDetectionHandler";

    public static ServiceBeanContext getServiceBeanContext(String configComponent, String defaultServiceName, String defaultOpStringName, String defualtjmxName, ClassBundle defaultFDH, String[] configArgs, ClassLoader loader) throws Exception {
        if (configComponent == null) {
            throw new NullPointerException("configComponent is null");
        }
        if (defaultServiceName == null) {
            throw new NullPointerException("defaultServiceName is null");
        }
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("using classloader [" + loader + "]");
        }
        HashMap configParms = new HashMap();
        Configuration config = ConfigurationProvider.getInstance((String[])configArgs, (ClassLoader)loader);
        configParms.putAll(ServiceBeanActivation.readServiceBeanConfig(configComponent, defaultServiceName, defaultOpStringName, config));
        ServiceBeanConfig sbConfig = new ServiceBeanConfig(configParms, configArgs);
        sbConfig.addInitParameter(BOOT_CONFIG_COMPONENT, configComponent);
        String jmxName = (String)config.getEntry(configComponent, "jmxName", String.class, (Object)defualtjmxName);
        if (jmxName != null) {
            sbConfig.addInitParameter("jmxName", jmxName);
        }
        sbConfig.addInitParameter(BOOT_COMPONENT, BOOT_COOKIE);
        ServiceLevelAgreements sla = new ServiceLevelAgreements();
        URL[] urls = ((URLClassLoader)loader).getURLs();
        if (urls.length == 0) {
            throw new RuntimeException("Unknown Export Codebase");
        }
        String exportCodebase = urls[0].toExternalForm();
        if (exportCodebase.indexOf(".jar") != -1 || "ide".equals(System.getProperty("com.gigaspaces.mode"))) {
            int index = exportCodebase.lastIndexOf(47);
            if (index != -1) {
                exportCodebase = exportCodebase.substring(0, index + 1);
            }
        } else {
            throw new RuntimeException("Cannot determine export codebase [" + exportCodebase + "]");
        }
        if (exportCodebase.startsWith("httpmd")) {
            exportCodebase = "http" + exportCodebase.substring(6);
        }
        ClassBundle exportBundle = new ClassBundle("");
        exportBundle.setCodebase(exportCodebase);
        for (int i = 0; i < urls.length; ++i) {
            String jar = urls[i].getFile();
            int index = jar.lastIndexOf(47);
            if (index != -1) {
                jar = jar.substring(1);
            }
            exportBundle.addJAR(jar);
        }
        ClassBundle defaultFDHBundle = defaultFDH;
        if (defaultFDHBundle == null) {
            defaultFDHBundle = new ClassBundle(FDH);
        }
        if (!defaultFDHBundle.hasMethod("setConfiguration")) {
            defaultFDHBundle.addMethod("setConfiguration", new Object[]{new String[]{"-"}});
        }
        ClassBundle fdhBundle = (ClassBundle)config.getEntry(configComponent, "faultDetectionHandler", ClassBundle.class, (Object)defaultFDHBundle);
        sla.addSystemThreshold("System", new ThresholdValues(new double[]{0.0, 0.99}));
        ServiceElement sElem = new ServiceElement(0, sbConfig, sla, new ClassBundle[]{exportBundle}, fdhBundle);
        if (sbLifeCycleManager == null) {
            sbLifeCycleManager = new LifeCycleManager();
        }
        ComputeResource computeResource = ServiceBeanActivation.readBootConfig(configArgs, loader);
        Uuid serviceID = UuidFactory.generate();
        JSBManager jsbManager = new JSBManager(sElem, computeResource);
        jsbManager.setDiscardManager(sbLifeCycleManager);
        jsbManager.setServiceID(serviceID);
        JSBContext jsbContext = new JSBContext(sElem, null, jsbManager, computeResource, null);
        return jsbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map readServiceBeanConfig(String configComponent, String defaultServiceName, String defaultOpStringName, Configuration config) throws Exception {
        if (configComponent == null) {
            throw new NullPointerException("configComponent is null");
        }
        if (defaultServiceName == null) {
            throw new NullPointerException("defaultServiceName is null");
        }
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        HashMap<String, Object> configParms = new HashMap<String, Object>();
        ClassLoader cCL = Thread.currentThread().getContextClassLoader();
        CommonClassLoader common = CommonClassLoader.getInstance();
        Thread.currentThread().setContextClassLoader((ClassLoader)common);
        try {
            LookupCachePool.getInstance().setConfiguration(ServiceConfigLoader.getConfiguration());
        }
        finally {
            Thread.currentThread().setContextClassLoader(cCL);
        }
        configParms.put("configComponent", configComponent);
        String serviceName = (String)config.getEntry(configComponent, "serviceName", String.class, (Object)defaultServiceName);
        configParms.put("serviceName", serviceName);
        String serviceComment = (String)config.getEntry(configComponent, "serviceComment", String.class, null);
        if (serviceComment != null) {
            configParms.put("serviceComment", serviceComment);
        }
        String opStringName = (String)config.getEntry(configComponent, "opStringName", String.class, (Object)defaultOpStringName);
        configParms.put("opStringName", opStringName);
        String logDirectory = (String)config.getEntry(configComponent, "logDirectory", String.class, (Object)System.getProperty("com.gs.persistency.logDirectory"));
        if (logDirectory != null) {
            configParms.put("logDirectory", logDirectory);
        }
        String[] groups = LookupGroups.all();
        try {
            groups = (String[])config.getEntry(configComponent, "initialLookupGroups", String[].class, (Object)BootUtil.toArray((String)SystemInfo.singleton().lookup().groups()));
        }
        catch (ConfigurationException e) {
            LOGGER.log(Level.INFO, "Groups Not Defined.  Defaulting to ALL_GROUPS");
            groups = new String[]{"all"};
        }
        configParms.put("lookupGroups", groups);
        LookupLocator[] lookupLocators = null;
        try {
            lookupLocators = (LookupLocator[])config.getEntry(configComponent, "initialLookupLocators", LookupLocator[].class, (Object)BootUtil.toLookupLocators((String)SystemInfo.singleton().lookup().locators()));
        }
        catch (ConfigurationException ex) {
            LOGGER.log(Level.INFO, "Not Using Locators");
        }
        LoggerConfig[] logConfigs = (LoggerConfig[])config.getEntry(configComponent, "loggerConfigs", LoggerConfig[].class, null);
        if (logConfigs != null) {
            for (int i = 0; i < logConfigs.length; ++i) {
                logConfigs[i].getLogger();
            }
        }
        if (lookupLocators != null) {
            configParms.put("lookupLocators", lookupLocators);
        }
        return configParms;
    }

    static ComputeResource readBootConfig(String[] configArgs, ClassLoader loader) throws Exception {
        if (configArgs == null) {
            throw new NullPointerException("configArgs are null");
        }
        if (loader == null) {
            throw new NullPointerException("loader are null");
        }
        Configuration config = ConfigurationProvider.getInstance((String[])configArgs, (ClassLoader)loader);
        Boolean multiCheck = (Boolean)config.getEntry(BOOT_COMPONENT, "verifyMulticast", Boolean.class, (Object)false);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Verify multicast [" + multiCheck + "]");
        }
        if (multiCheck.booleanValue()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Verifying multicast, wait up to 10 seconds ... ");
            }
            MulticastStatus.checkMulticast(10000);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Multicast responds ok");
            }
        }
        Boolean createShutdownHook = (Boolean)config.getEntry(BOOT_COMPONENT, "createShutdownHook", Boolean.class, (Object)true);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Create ShutdownHook [" + createShutdownHook + "]");
        }
        if (createShutdownHook.booleanValue()) {
            boolean ok = false;
            if (sbLifeCycleManager != null) {
                if (!sbLifeCycleManager.isShutDownHookRegistered()) {
                    ok = true;
                }
            } else {
                ok = true;
            }
            if (ok) {
                ShutdownHook shutdownHook = new ShutdownHook();
                SystemBoot.addShutdownHook((Thread)shutdownHook);
                if (sbLifeCycleManager != null) {
                    sbLifeCycleManager.setShutDownHookRegistered();
                }
            }
        }
        String computeResourceConfig = SystemInfo.singleton().locations().config() + "/services/services.config";
        ComputeResource defaultComputeResource = new ComputeResource(SystemConfig.appendOverrides((String)computeResourceConfig), config);
        return (ComputeResource)config.getEntry(BOOT_COMPONENT, "computeResource", ComputeResource.class, (Object)defaultComputeResource, (Object)config);
    }

    static {
        logger = Logger.getLogger(COMPONENT);
    }

    static class ShutdownHook
    extends Thread {
        private volatile boolean ran = false;

        ShutdownHook() {
            super("ShutdownHook");
        }

        @Override
        public void run() {
            if (this.ran) {
                return;
            }
            this.ran = true;
            try {
                if (sbLifeCycleManager != null) {
                    sbLifeCycleManager.terminate();
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Terminating ServiceBean", t);
            }
        }
    }

    public static class LifeCycleManager
    implements DiscardManager,
    LifeCycle {
        boolean terminated = false;
        List sbProxies = Collections.synchronizedList(new ArrayList());
        volatile boolean shutdownHookRegistered = false;

        public void register(Object sbProxy, ServiceBeanContext context) throws JSBControlException {
            try {
                if (sbProxy == null) {
                    throw new NullPointerException("sbProxy is null");
                }
                if (context == null) {
                    throw new NullPointerException("context is null");
                }
                this.sbProxies.add(sbProxy);
                ServiceBeanLoader.advertise(sbProxy, context);
            }
            catch (Throwable t) {
                String name = context == null ? "unknown name" : context.getServiceElement().getName();
                throw new JSBControlException("ServiceBean [" + name + "] advertise failed", t);
            }
        }

        void setShutDownHookRegistered() {
            this.shutdownHookRegistered = true;
        }

        boolean isShutDownHookRegistered() {
            return this.shutdownHookRegistered;
        }

        public void terminate() {
            if (!this.terminated) {
                for (Object sbProxy : this.sbProxies) {
                    try {
                        if (sbProxy instanceof Administrable) {
                            Administrable admin = (Administrable)sbProxy;
                            Object adminObject = admin.getAdmin();
                            if (adminObject instanceof DestroyAdmin) {
                                DestroyAdmin destroyAdmin = (DestroyAdmin)adminObject;
                                destroyAdmin.destroy();
                                this.terminated = true;
                                continue;
                            }
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.fine("No DestroyAdmin capabilities");
                            continue;
                        }
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("No Administrable capabilities");
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, "Terminating ServiceBean", t);
                    }
                }
            }
        }

        @Override
        public void discard() {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }

        public boolean unregister(Object impl) {
            if (this.terminated) {
                return true;
            }
            this.terminate();
            return true;
        }
    }
}

