/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jsb;

import com.gigaspaces.internal.utils.ClassLoaderCleaner;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.jini.SharedLeaseRenewalManager;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.sun.jini.config.Config;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.reliableLog.LogException;
import com.sun.jini.start.ServiceProxyAccessor;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.activation.ActivationGroup;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryManagement;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Comment;
import net.jini.lookup.entry.Name;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.jini.rio.boot.RioServiceDescriptor;
import org.jini.rio.boot.ServiceClassLoader;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.Association;
import org.jini.rio.core.AssociationManagement;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.jsb.DiscardManager;
import org.jini.rio.core.jsb.ServiceBean;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.jsb.ServiceBeanManager;
import org.jini.rio.core.jsb.ServiceBeanState;
import org.jini.rio.core.jsb.ServiceElementChangeListener;
import org.jini.rio.core.jsb.ServiceState;
import org.jini.rio.entry.ApplianceInfo;
import org.jini.rio.entry.ComputeResourceUtilization;
import org.jini.rio.entry.OperationalStringEntry;
import org.jini.rio.entry.StandardServiceType;
import org.jini.rio.event.DispatchEventHandler;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventHandler;
import org.jini.rio.jmx.JMXUtil;
import org.jini.rio.jmx.MBeanServerFactory;
import org.jini.rio.jsb.JSBContext;
import org.jini.rio.jsb.JSBManager;
import org.jini.rio.jsb.ServiceBeanAdapterMBean;
import org.jini.rio.jsb.ServiceBeanContextManager;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.qos.ComputeResource;
import org.jini.rio.qos.ComputeResourceObserver;
import org.jini.rio.qos.SLAThresholdEvent;
import org.jini.rio.qos.SLAThresholdEventAdapter;
import org.jini.rio.resources.client.HeartbeatClient;
import org.jini.rio.resources.persistence.PersistentStore;
import org.jini.rio.resources.servicecore.Joiner;
import org.jini.rio.resources.servicecore.LandlordLessor;
import org.jini.rio.resources.servicecore.ServiceAdmin;
import org.jini.rio.resources.servicecore.ServiceAdminImpl;
import org.jini.rio.resources.servicecore.ServiceProvider;
import org.jini.rio.resources.servicecore.ServiceResource;

public abstract class ServiceBeanAdapter
extends ServiceProvider
implements ServiceBean,
ServiceState,
ServiceProxyAccessor,
ServerProxyTrust,
ProxyAccessor,
ServiceBeanAdapterMBean,
MBeanRegistration,
NotificationEmitter {
    static final String LOGGER = "org.jini.rio.jsb";
    protected ServiceBeanContext context;
    protected Uuid uuid;
    protected ServiceID serviceID;
    protected ServiceAdminImpl admin;
    protected Joiner joiner = new Joiner();
    private Remote serviceBeanRemoteRef;
    protected Object proxy;
    private Exporter exporter;
    protected ComputeResource computeResource;
    protected ComputeResourceObserver computeResourceObserver;
    protected String logDirName;
    protected SnapshotThread snapshotter;
    protected ServiceBeanContextManager contextMgr;
    protected PersistentStore store;
    protected int state = 0;
    private volatile boolean inShutdown = false;
    private ServiceElementChangeManager sElemChangeMgr;
    private DispatchEventHandler slaEventHandler;
    private LandlordLessor monitorLandlord;
    protected ServiceBeanState jsbState = new ServiceBeanState();
    protected ActivationID activationID;
    protected String serviceBeanComponent;
    static final Logger logger = Logger.getLogger("org.jini.rio.jsb");
    private ActivationSystem activationSystem;
    private HeartbeatClient heartbeatClient;
    private LoginContext loginContext;
    private long maxUnexportDelay;
    private long unexportRetryDelay;
    long started;
    protected ObjectName objectName;
    protected MBeanServer mbeanServer;
    protected final List mbeanNoticationInfoList = new ArrayList();
    protected SLAThresholdEventAdapter slaThresholdEventAdapter;
    protected volatile ClassLoader serviceClassLoader = this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    protected volatile ClassLoader contextClassLoader;

    public ServiceBeanAdapter() {
        this.started = System.currentTimeMillis();
        this.serviceBeanComponent = this.getClass().getPackage() != null ? this.getClass().getPackage().getName() : this.getClass().getName();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Set configuration component name as : " + this.serviceBeanComponent);
        }
    }

    @Override
    public Object start(final ServiceBeanContext context) throws Exception {
        block11: {
            if (context == null) {
                throw new NullPointerException("ServiceBeanContext is null");
            }
            try {
                Configuration config = context.getConfiguration();
                try {
                    this.loginContext = (LoginContext)Config.getNonNullEntry((Configuration)config, (String)this.serviceBeanComponent, (String)"loginContext", LoginContext.class);
                }
                catch (NoSuchEntryException noSuchEntryException) {
                    // empty catch block
                }
                PrivilegedExceptionAction doStart = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ServiceBeanAdapter.this.doStart(context);
                    }
                };
                if (this.loginContext != null) {
                    this.loginContext.login();
                    try {
                        Subject.doAsPrivileged(this.loginContext.getSubject(), doStart, null);
                        break block11;
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getCause();
                    }
                }
                doStart.run();
            }
            catch (Throwable t) {
                this.jsbState.setState(6);
                Throwable cause = this.getRootCause(t);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "ServiceBean [" + context.getServiceElement().getName() + "] start failed", cause);
                }
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new Error(cause.getMessage(), cause);
            }
        }
        return this.proxy;
    }

    private Throwable getRootCause(Throwable thrown) {
        Throwable cause;
        Throwable t = cause = thrown;
        while (t != null) {
            t = cause.getCause();
            if (t == null) continue;
            cause = t;
        }
        return cause;
    }

    protected Object doStart(ServiceBeanContext context) throws Exception {
        if (this.jsbState.getState() < 3) {
            this.setConfiguration(context.getConfiguration());
            this.setWatchRegistry(context.getWatchRegistry());
            this.exporter = this.getExporter(context.getConfiguration());
            this.serviceBeanRemoteRef = this.exportDo(this.exporter);
            this.proxy = null;
            if (this.jsbState.getState() < 1) {
                this.initialize(context);
                this.jsbState.setState(1);
            } else {
                this.getServiceProxy();
            }
            this.jsbState.setState(3);
        } else {
            this.computeResourceObserver.setSource(this.proxy);
        }
        return this.proxy;
    }

    @Override
    public void initialize(ServiceBeanContext context) throws Exception {
        this.initialize(context, null);
    }

    public void initialize(ServiceBeanContext context, PersistentStore store) throws Exception {
        if (context == null) {
            throw new NullPointerException("ServiceBeanContext is null");
        }
        this.logDirName = context.getServiceElement().getServiceBeanConfig().getLogDir();
        if (store != null) {
            if (this.logDirName == null) {
                throw new NullPointerException("log directory is null");
            }
            this.store = store;
            ServiceBeanManager jsbManager = context.getServiceBeanManager();
            this.contextMgr = new ServiceBeanContextManager(context);
            this.snapshotter = new SnapshotThread(this.getClass().getName());
            ServiceBeanContext restoredContext = this.contextMgr.restoreContext(store);
            this.context = restoredContext == null ? context : restoredContext;
            ((JSBContext)this.context).setServiceBeanManager(jsbManager);
            this.snapshotter.start();
        } else {
            this.context = context;
        }
        this.maxUnexportDelay = Config.getLongEntry((Configuration)context.getConfiguration(), (String)this.serviceBeanComponent, (String)"maxUnexportDelay", (long)5000L, (long)1L, (long)60000L);
        this.unexportRetryDelay = Config.getLongEntry((Configuration)context.getConfiguration(), (String)this.serviceBeanComponent, (String)"unexportRetryDelay", (long)1000L, (long)1L, (long)Long.MAX_VALUE);
        this.getUuid();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Create ServiceID from UUID " + this.uuid.toString());
        }
        this.serviceID = new ServiceID(this.uuid.getMostSignificantBits(), this.uuid.getLeastSignificantBits());
        EventDescriptor slaEventDesc = SLAThresholdEvent.getEventDescriptor();
        this.slaEventHandler = new DispatchEventHandler(slaEventDesc, context.getConfiguration());
        this.eventTable.put(slaEventDesc.eventID, this.slaEventHandler);
        this.addAttribute((Entry)slaEventDesc);
        this.computeResource = (ComputeResource)context.getComputeResourceManager().getComputeResource();
        this.computeResourceObserver = new ComputeResourceObserver(this.computeResource, this.uuid, context.getServiceElement(), this.slaEventHandler, this.joiner);
        this.computeResourceObserver.setSource(this.getServiceProxy());
        this.sElemChangeMgr = new ServiceElementChangeManager();
        context.getServiceBeanManager().addListener(this.sElemChangeMgr);
        this.initializeJMX(this);
        this.doInitialize(context);
    }

    protected void doInitialize(ServiceBeanContext context) throws Exception {
    }

    protected void initializeJMX(Object mbean) throws Exception {
        ObjectName objectName = this.createObjectName(this.context);
        MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
        mbeanServer.registerMBean(mbean, objectName);
        this.slaThresholdEventAdapter = new SLAThresholdEventAdapter(objectName, this.getNotificationBroadcasterSupport());
        this.register(SLAThresholdEvent.getEventDescriptor(), this.slaThresholdEventAdapter, null, Long.MAX_VALUE);
        this.mbeanNoticationInfoList.add(this.slaThresholdEventAdapter.getNotificationInfo());
    }

    protected void destroyJMX() {
        if (this.mbeanServer != null && this.objectName != null) {
            try {
                this.mbeanServer.unregisterMBean(this.objectName);
            }
            catch (InstanceNotFoundException e) {
                logger.warning(e.toString());
            }
            catch (MBeanRegistrationException e) {
                logger.warning(e.toString());
            }
        }
    }

    protected ObjectName createObjectName(ServiceBeanContext context) throws MalformedObjectNameException {
        ObjectName objectName = JMXUtil.getObjectName(context, this.serviceBeanComponent, context.getServiceElement().getName());
        return objectName;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        this.mbeanServer = mBeanServer;
        return objectName;
    }

    @Override
    public void postRegister(Boolean aBoolean) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.mbeanServer = null;
        this.objectName = null;
    }

    public ServiceBeanContext getServiceBeanContext() {
        return this.context;
    }

    @Deprecated
    public AssociationManagement getAssociationManagement() {
        return this.context.getAssociationManagement();
    }

    @Deprecated
    public Association[] getAssociations() {
        if (this.context.getAssociationManagement() != null) {
            return this.context.getAssociationManagement().getAssociations();
        }
        return null;
    }

    protected Remote getExportedProxy() {
        return this.serviceBeanRemoteRef;
    }

    protected Object createProxy() {
        return this.getExportedProxy();
    }

    @Override
    public Object getServiceProxy() {
        if (this.proxy == null || this.jsbState.getState() < 3) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    public Object getProxy() {
        return this.getExportedProxy();
    }

    public TrustVerifier getProxyVerifier() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(this.getClass().getName(), "getProxyVerifier");
        }
        return new BasicProxyTrustVerifier(this.getServiceProxy());
    }

    @Deprecated
    public DiscoveryManagement getDiscoveryManager() throws IOException {
        return this.context.getDiscoveryManagement();
    }

    public EventHandler getSLAEventHandler() {
        return this.slaEventHandler;
    }

    public void addAttribute(Entry attribute) {
        if (attribute == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("attribute is null");
            }
            return;
        }
        this.joiner.addAttribute(attribute);
        if (this.jsbState.getState() == 5) {
            JoinManager jMgr = this.getJoinManager();
            if (jMgr != null) {
                jMgr.addAttributes(new Entry[]{attribute});
            } else {
                throw new NullPointerException("JoinManager is null");
            }
        }
    }

    public void addAttributes(Entry[] attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes are null");
        }
        for (int i = 0; i < attributes.length; ++i) {
            this.addAttribute(attributes[i]);
        }
    }

    @Override
    public void advertise() throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "[" + this.context.getServiceElement().getName() + "] ServiceBeanAdapter.advertise()");
        }
        try {
            this.doAdvertise();
        }
        catch (IOException ioe) {
            this.jsbState.setState(6);
            throw ioe;
        }
        catch (RuntimeException re) {
            this.jsbState.setState(6);
            throw re;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "[" + this.context.getServiceElement().getName() + "] set state to ADVERTISED");
        }
        this.jsbState.setState(5);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Service-Id: [" + this.getServiceID() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doAdvertise() throws IOException {
        ArrayList<Object> attrList;
        block17: {
            Thread currentThread;
            ClassLoader cCL;
            if (this.jsbState.getState() == 5) {
                if (!logger.isLoggable(Level.FINEST)) return;
                logger.log(Level.FINEST, "Already advertised [" + this.context.getServiceElement().getName() + "]");
                return;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[" + this.context.getServiceElement().getName() + "] verify transition");
            }
            this.jsbState.verifyTransition(5);
            attrList = new ArrayList<Object>();
            String opStringName = this.context.getServiceElement().getOperationalStringName();
            if (opStringName != null) {
                attrList.add((Object)new OperationalStringEntry(opStringName));
            }
            ApplianceInfo aInfo = new ApplianceInfo();
            aInfo.initialize(this.computeResource.getAddress());
            attrList.add((Object)aInfo);
            Name name = new Name(this.context.getServiceElement().getName());
            attrList.add(name);
            String comment = this.context.getServiceElement().getServiceBeanConfig().getComment();
            if (comment != null) {
                attrList.add(new Comment(comment));
            }
            StandardServiceType sType = new StandardServiceType();
            sType.name = name.name;
            if (comment != null) {
                sType.description = comment;
            }
            attrList.add((Object)sType);
            try {
                if (this.computeResourceObserver != null) {
                    ComputeResourceUtilization computeResourceUtilization = this.computeResourceObserver.getComputeResourceUtilization();
                    attrList.add(computeResourceUtilization);
                    this.computeResourceObserver.setIgnore(false);
                }
            }
            catch (Exception qe) {
                logger.log(Level.WARNING, "Setting ComputeResourceUtilization Entry", qe);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[" + this.context.getServiceElement().getName() + "] do the join");
            }
            boolean swapCLs = !((cCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(currentThread = Thread.currentThread()){
                final /* synthetic */ Thread val$currentThread;
                {
                    this.val$currentThread = thread;
                }

                public Object run() {
                    return this.val$currentThread.getContextClassLoader();
                }
            })) instanceof ServiceClassLoader);
            try {
                final ClassLoader myCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return this.getClass().getClassLoader();
                    }
                });
                if (swapCLs) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            currentThread.setContextClassLoader(myCL);
                            return null;
                        }
                    });
                }
                this.context.getConfiguration();
                if (!swapCLs) break block17;
            }
            catch (Exception myCL) {
                if (swapCLs) {
                    AccessController.doPrivileged(new PrivilegedAction(currentThread, cCL){
                        final /* synthetic */ Thread val$currentThread;
                        final /* synthetic */ ClassLoader val$cCL;
                        {
                            this.val$currentThread = thread;
                            this.val$cCL = classLoader;
                        }

                        public Object run() {
                            this.val$currentThread.setContextClassLoader(this.val$cCL);
                            return null;
                        }
                    });
                }
                break block17;
                catch (Throwable throwable) {
                    if (!swapCLs) throw throwable;
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        try {
            this.joiner.asyncJoin(this.getServiceProxy(), this.getServiceID(), attrList.toArray(new Entry[attrList.size()]), this.context.getDiscoveryManagement(), SharedLeaseRenewalManager.getLeaseRenewalManager(), this.context.getConfiguration());
            return;
        }
        catch (ConfigurationException e) {
            throw new IOException("Configuration failure with async join " + e.getMessage());
        }
    }

    @Override
    public void unadvertise() {
        if (this.jsbState.getState() != 5 || this.jsbState.getState() == 4 || this.jsbState.isAborted()) {
            return;
        }
        try {
            if (this.joiner != null) {
                this.joiner.terminate();
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Terminating Joiner", t);
        }
        finally {
            this.jsbState.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean force) {
        this.jsbState.verifyTransition(2);
        if (this.activationID != null) {
            try {
                this.activationSystem.unregisterObject(this.activationID);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception calling ActivationSystem.unregisterObject", e);
            }
        }
        UnexportTask unexportTask = new UnexportTask(this.exporter, force);
        unexportTask.start();
        try {
            unexportTask.join();
        }
        catch (InterruptedException e) {
            logger.warning("UnexportTask interrupted");
        }
        finally {
            this.proxy = null;
            this.jsbState.setState(2);
        }
        if (this.monitorLandlord != null) {
            this.monitorLandlord.stop(true);
        }
        if (this.activationID != null) {
            try {
                ActivationGroup.inactive((ActivationID)this.activationID, (Exporter)this.exporter);
            }
            catch (ActivationException e) {
                logger.log(Level.INFO, "ActivationGroup.inactive failed, " + e.getLocalizedMessage() + ", service is stopped");
            }
            catch (RemoteException e) {
                logger.log(Level.WARNING, "Calling ActivationGroup.inactive", e);
            }
        }
    }

    @Override
    public Object getAdmin() {
        ServiceAdmin adminProxy = null;
        try {
            if (this.admin == null) {
                Exporter adminExporter = this.getAdminExporter();
                this.admin = this.contextMgr != null ? new ServiceAdminImpl(this, adminExporter, this.contextMgr.getContextAttributeLogHandler()) : new ServiceAdminImpl(this, adminExporter);
            }
            this.admin.setServiceBeanContext(this.getServiceBeanContext());
            adminProxy = this.admin.getServiceAdmin();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Getting ServiceAdminImpl", t);
        }
        return adminProxy;
    }

    public void undeployEvent() {
    }

    @Override
    public void destroy() {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            this.destroy(false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean force) {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            if (this.inShutdown) {
                return;
            }
            this.inShutdown = true;
            if (this.snapshotter != null) {
                this.snapshotter.interrupt();
            }
            if (this.computeResourceObserver != null) {
                this.computeResourceObserver.setIgnore(true);
                this.computeResourceObserver.disconnect();
            }
            if (this.sElemChangeMgr != null) {
                this.context.getServiceBeanManager().removeListener(this.sElemChangeMgr);
            }
            if (this.slaEventHandler != null) {
                this.slaEventHandler.terminate();
            }
            try {
                this.unadvertise();
            }
            catch (IllegalStateException e) {
                logger.log(Level.WARNING, "Unadvertising ServiceBean", e);
            }
            if (this.context.getAssociationManagement() != null) {
                this.context.getAssociationManagement().terminate();
            }
            if (this.context instanceof JSBContext) {
                ((JSBContext)this.context).removePlatformCapabilities();
            }
            if (this.watchRegistry != null) {
                this.watchRegistry.closeAll();
            }
            if (this.heartbeatClient != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Terminating HeartbeatClient");
                }
                this.heartbeatClient.terminate();
            }
            try {
                this.context.getDiscoveryManagement().terminate();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "DiscoveryManagement termination", t);
            }
            try {
                this.stop(force);
            }
            catch (IllegalStateException e) {
                logger.log(Level.WARNING, "Stopping ServiceBean", e);
            }
            ServiceBeanManager serviceBeanManager = this.context.getServiceBeanManager();
            if (serviceBeanManager != null) {
                DiscardManager discardMgr = serviceBeanManager.getDiscardManager();
                if (discardMgr != null) {
                    discardMgr.discard();
                } else {
                    logger.warning("DiscardManager is null, unable to discard");
                }
            } else {
                logger.warning("ServiceBeanManager is null, unable to discard");
            }
            if (this.admin != null) {
                try {
                    this.admin.unexport(true);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Unexporting ServiceAdminImpl", e);
                }
            }
            if (this.loginContext != null) {
                try {
                    this.loginContext.logout();
                }
                catch (LoginException e) {
                    logger.log(Level.WARNING, "logout failed", e);
                }
            }
            this.destroyJMX();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
            this.cleanClassLoaders();
            this.serviceClassLoader = null;
            this.contextClassLoader = null;
        }
    }

    protected void cleanClassLoaders() {
        this.cleanClassLoader(this.contextClassLoader);
        if (this.contextClassLoader != this.serviceClassLoader && this.serviceClassLoader != null) {
            this.cleanClassLoader(this.serviceClassLoader);
        }
        Introspector.flushCaches();
    }

    private void cleanClassLoader(ClassLoader classLoaderToClean) {
        block5: {
            RioServiceDescriptor.getGlobalPolicy().setPolicy(classLoaderToClean, null);
            ClassLoaderCleaner.clearReferences((ClassLoader)classLoaderToClean);
            if (classLoaderToClean instanceof URLClassLoader) {
                try {
                    Method method = URLClassLoader.class.getDeclaredMethod("close", new Class[0]);
                    method.invoke((Object)classLoaderToClean, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("no close method found on service class loader [" + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)classLoaderToClean) + "], this could happen if JDK which is older than 7 is being used and should be ignored");
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, "failed invoking close method on class loader [" + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)classLoaderToClean) + "], this could cause file descriptor leaks on some OS", e);
                }
            }
        }
    }

    public int getState() {
        return this.jsbState.getState();
    }

    public synchronized Lease monitor(long duration) throws LeaseDeniedException, RemoteException {
        if (this.monitorLandlord == null) {
            try {
                this.monitorLandlord = new LandlordLessor(this.context.getConfiguration());
            }
            catch (ConfigurationException e) {
                throw new RemoteException("Failed to create landlord leasor", e);
            }
        }
        if (duration <= 0L) {
            throw new LeaseDeniedException("lease duration of [" + duration + "] is invalid");
        }
        String phonyResource = this.getClass().getName() + ":" + System.currentTimeMillis();
        ServiceResource serviceResource = new ServiceResource(phonyResource);
        Lease lease = this.monitorLandlord.newLease(serviceResource, duration);
        return lease;
    }

    public void startHeartbeat(String[] configArgs) throws ConfigurationException, RemoteException {
        if (this.heartbeatClient == null) {
            this.heartbeatClient = new HeartbeatClient(this.uuid);
        }
        this.heartbeatClient.addHeartbeatServer(configArgs);
    }

    public void ping() throws RemoteException {
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    @Override
    public Uuid getUuid() {
        if (this.uuid != null) {
            return this.uuid;
        }
        this.uuid = this.context.getServiceBeanManager().getServiceID();
        if (this.uuid == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("UUID is unknown, generate new UUID");
            }
            this.uuid = UuidFactory.generate();
            ((JSBManager)this.context.getServiceBeanManager()).setServiceID(this.uuid);
        }
        return this.uuid;
    }

    public JoinManager getJoinManager() {
        return this.joiner.getJoinManager();
    }

    protected Exporter getExporter() {
        return this.exporter;
    }

    protected Exporter getExporter(Configuration config) throws Exception {
        Exporter exporter;
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        if (this.isActivatable() && this.activationID != null) {
            ProxyPreparer activationIdPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)this.serviceBeanComponent, (String)"activationIdPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            ProxyPreparer activationSystemPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)this.serviceBeanComponent, (String)"activationSystemPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            this.activationID = (ActivationID)activationIdPreparer.prepareProxy((Object)this.activationID);
            this.activationSystem = (ActivationSystem)activationSystemPreparer.prepareProxy((Object)ActivationGroup.getSystem());
            exporter = ExporterConfig.getExporter(config, this.serviceBeanComponent, "serverExporter");
            exporter = new ActivationExporter(this.activationID, exporter);
        } else {
            exporter = ExporterConfig.getExporter(config, this.serviceBeanComponent, "serverExporter");
        }
        return exporter;
    }

    protected Remote exportDo(Exporter exporter) throws Exception {
        if (exporter == null) {
            throw new NullPointerException("exporter is null");
        }
        return exporter.export((Remote)((Object)this));
    }

    @Override
    public Date getStarted() {
        return new Date(this.getStartTime());
    }

    public long getStartTime() {
        return this.started;
    }

    @Override
    public String[] getLookupGroups() {
        return this.admin.getLookupGroups();
    }

    @Override
    public void setLookupGroups(String[] groups) {
        this.admin.setLookupGroups(groups);
    }

    protected Exporter getAdminExporter() throws ConfigurationException {
        Exporter adminExporter = ExporterConfig.getExporter(this.context.getConfiguration(), this.serviceBeanComponent, "adminExporter");
        return adminExporter;
    }

    private boolean isActivatable() {
        try {
            this.getClass().getConstructor(ActivationID.class, MarshalledObject.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws ListenerNotFoundException {
        this.getNotificationBroadcasterSupport().removeNotificationListener(listener, filter, object);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.getNotificationBroadcasterSupport().addNotificationListener(listener, filter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.getNotificationBroadcasterSupport().removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.mbeanNoticationInfoList.toArray(new MBeanNotificationInfo[this.mbeanNoticationInfoList.size()]);
    }

    public NotificationBroadcasterSupport getNotificationBroadcasterSupport() {
        return this.context.getServiceBeanManager().getNotficationBroadcasterSupport();
    }

    public class SnapshotThread
    extends Thread {
        SnapshotThread(String name) {
            super(name + ":SnapshotThread");
            this.setDaemon(true);
        }

        public synchronized void takeSnapshot() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                SnapshotThread snapshotThread = this;
                synchronized (snapshotThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                try {
                    ServiceBeanAdapter.this.store.snapshot();
                }
                catch (InterruptedIOException e) {
                    return;
                }
                catch (Exception e) {
                    if (e instanceof LogException && ((LogException)e).detail instanceof InterruptedIOException) {
                        return;
                    }
                    logger.log(Level.WARNING, "Snapshotting ServiceBean", e);
                }
            }
        }
    }

    class ServiceElementChangeManager
    implements ServiceElementChangeListener {
        ServiceElementChangeManager() {
        }

        @Override
        public void changed(ServiceElement preElem, ServiceElement postElem) {
            if (ServiceBeanAdapter.this.joiner.getJoinManager() != null && ServiceElementUtil.hasDifferentServiceUIs(new Entry[0], postElem, ServiceBeanAdapter.this.context.getExportCodebase())) {
                try {
                    ArrayList<Entry> eList = new ArrayList<Entry>();
                    Entry[] current = ServiceBeanAdapter.this.joiner.getJoinManager().getAttributes();
                    for (int i = 0; i < current.length; ++i) {
                        eList.add(current[i]);
                    }
                    Configuration config = ConfigurationProvider.getInstance((String[])postElem.getServiceBeanConfig().getConfigArgs());
                    Entry[] serviceUIs = (Entry[])config.getEntry(ServiceBeanAdapter.this.serviceBeanComponent, "serviceUIs", Entry[].class, (Object)new Entry[0], (Object)ServiceBeanAdapter.this.context.getExportCodebase());
                    for (int i = 0; i < serviceUIs.length; ++i) {
                        eList.add(serviceUIs[i]);
                    }
                    Entry[] attrs = eList.toArray(new Entry[eList.size()]);
                    if (ServiceBeanAdapter.this.joiner.getJoinManager() != null) {
                        ServiceBeanAdapter.this.joiner.getJoinManager().setAttributes(attrs);
                    }
                }
                catch (ConfigurationException e) {
                    logger.log(Level.WARNING, "Getting or Applying modified ServiceUIs", e);
                }
            }
        }
    }

    private class UnexportTask
    extends Thread {
        Exporter exporter;
        boolean force;

        UnexportTask(Exporter exporter, boolean force) {
            super("UnexportTask");
            this.exporter = exporter;
            this.force = force;
        }

        @Override
        public void run() {
            boolean unexported = false;
            long start = SystemTime.timeMillis();
            if (!this.force) {
                long now;
                long end_time;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Unexporting " + ServiceBeanAdapter.this.context.getServiceElement().getName() + ", maxUnexportDelay=" + ServiceBeanAdapter.this.maxUnexportDelay + ", unexportRetryDelay=" + ServiceBeanAdapter.this.unexportRetryDelay);
                }
                if ((end_time = (now = SystemTime.timeMillis()) + ServiceBeanAdapter.this.maxUnexportDelay) < 0L) {
                    end_time = Long.MAX_VALUE;
                }
                while (!unexported && now < end_time) {
                    unexported = this.exporter.unexport(false);
                    if (unexported) continue;
                    try {
                        long sleepTime = Math.min(ServiceBeanAdapter.this.unexportRetryDelay, end_time - now);
                        UnexportTask.sleep(sleepTime);
                        now = SystemTime.timeMillis();
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.INFO, "exception encountered unexport retry delay sleep, , continuing", e);
                        break;
                    }
                }
            }
            if (!unexported) {
                unexported = this.unexportDo(true);
            }
            if (logger.isLoggable(Level.FINEST)) {
                long end = SystemTime.timeMillis();
                logger.finest("Unexported " + ServiceBeanAdapter.this.context.getServiceElement().getName() + ", [" + unexported + "] time allocated : " + (end - start));
            }
        }

        boolean unexportDo(boolean force) {
            boolean result = false;
            try {
                result = this.exporter.unexport(force);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unexporting ServiceBean", e);
            }
            return result;
        }
    }
}

