/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jsb;

import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.jsb.JSBContext;
import org.jini.rio.resources.persistence.PersistentStore;
import org.jini.rio.resources.persistence.SnapshotHandler;
import org.jini.rio.resources.persistence.StoreException;
import org.jini.rio.resources.persistence.SubStore;

public class ServiceBeanContextManager {
    private ServiceBeanContext context;
    private ContextAttributeLogHandler attributeLogHandler = new ContextAttributeLogHandler();
    private static final Logger logger = Logger.getLogger("org.jini.rio.jsb");

    public ServiceBeanContextManager(ServiceBeanContext context) {
        this.context = context;
    }

    public ContextAttributeLogHandler getContextAttributeLogHandler() {
        return this.attributeLogHandler;
    }

    public void takeSnapshot(DiscoveryManagement dm) throws Exception {
        this.attributeLogHandler.discoMgmt = dm;
        this.attributeLogHandler.takeSnapshot();
    }

    public ServiceBeanContext restoreContext(PersistentStore store) throws StoreException {
        try {
            store.acquireMutatorLock();
            store.addSubStore(this.attributeLogHandler);
        }
        finally {
            store.releaseMutatorLock();
        }
        ServiceBeanContext ctxt = this.attributeLogHandler.getRestoredContext();
        if (ctxt != null) {
            this.context = ctxt;
        }
        return ctxt;
    }

    public class ContextAttributeLogHandler
    extends LogHandler
    implements SubStore,
    SnapshotHandler {
        ReliableLog log;
        ServiceBeanContext restoredContext = null;
        DiscoveryManagement discoMgmt = null;
        static final String logDirName = "ContextAttributes";

        void setDiscoveryManagement(DiscoveryManagement discoMgmt) {
            this.discoMgmt = discoMgmt;
        }

        @Override
        public void setDirectory(File dir) throws IOException {
            try {
                this.log = new ReliableLog(dir.getCanonicalPath(), (LogHandler)this);
                this.log.recover();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Problem recovering/creating log", e);
                throw new IOException("ServiceBeanContextManager: log [" + dir.getCanonicalPath() + "] is corrupted:" + e.getLocalizedMessage());
            }
        }

        @Override
        public String subDirectory() {
            return logDirName;
        }

        public void snapshot(OutputStream out) throws Exception {
            if (this.discoMgmt == null) {
                throw new NullPointerException("DiscoveryManagement cannot be null");
            }
            ObjectOutputStream oostream = new ObjectOutputStream(out);
            oostream.writeUTF(logDirName);
            oostream.writeObject(ServiceBeanContextManager.this.context);
            if (this.discoMgmt instanceof DiscoveryGroupManagement) {
                DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)this.discoMgmt;
                String[] groups = dgm.getGroups();
                if (groups == null) {
                    groups = new String[]{"all"};
                }
                oostream.writeObject(groups);
            } else {
                oostream.writeObject(new String[0]);
            }
            if (this.discoMgmt instanceof DiscoveryLocatorManagement) {
                DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)this.discoMgmt;
                oostream.writeObject(dlm.getLocators());
            } else {
                oostream.writeObject(new LookupLocator[0]);
            }
            oostream.flush();
        }

        public void recover(InputStream in) throws Exception {
            ObjectInputStream oistream = new ObjectInputStream(in);
            if (!logDirName.equals(oistream.readUTF())) {
                throw new IOException("log from wrong implementation");
            }
            JSBContext jsbContext = (JSBContext)oistream.readObject();
            ServiceElement sElem = jsbContext.getServiceElement();
            ServiceBeanConfig sAttr = sElem.getServiceBeanConfig();
            try {
                String[] groups = (String[])oistream.readObject();
                LookupLocator[] locators = (LookupLocator[])oistream.readObject();
                sAttr.setGroups(groups);
                sAttr.setLocators(locators);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Couldn't get groups or locators", t);
            }
            sElem.setServiceBeanConfig(sAttr);
            jsbContext.setServiceElement(sElem);
            this.restoredContext = jsbContext;
        }

        public ServiceBeanContext getRestoredContext() {
            return this.restoredContext;
        }

        public void applyUpdate(Object update) throws Exception {
            throw new UnsupportedOperationException("ContextAttributeLogHandler : Recovering log update this should not happen");
        }

        @Override
        public void takeSnapshot() throws IOException {
            this.log.snapshot();
        }

        @Override
        public void updatePerformed(int updateCount) {
        }

        @Override
        public void prepareDestroy() {
            try {
                if (this.log != null) {
                    this.log.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Problem closing log during destroy", e);
                logger.warning("Ignoring and going on");
            }
        }
    }
}

