/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jsb;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import net.jini.config.ConfigurationException;
import org.jini.rio.core.SLA;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.event.EventHandler;
import org.jini.rio.jmx.JMXUtil;
import org.jini.rio.jmx.MBeanServerFactory;
import org.jini.rio.qos.SLAPolicyHandler;
import org.jini.rio.qos.SLAPolicyHandlerFactory;
import org.jini.rio.qos.SLAThresholdEventAdapter;
import org.jini.rio.qos.measurable.MeasurableCapability;
import org.jini.rio.watch.BoundedThresholdManager;
import org.jini.rio.watch.ThresholdManager;
import org.jini.rio.watch.WatchDescriptor;
import org.jini.rio.watch.WatchInjector;

public class ServiceBeanSLAManager {
    private Object impl;
    private Object proxy;
    private ServiceBeanContext context;
    private EventHandler slaEventHandler;
    private List slaPolicyHandlers = Collections.synchronizedList(new ArrayList());
    private WatchInjector watchInjector;
    private Hashtable thresholdManagerReg = new Hashtable();
    private SLAThresholdEventAdapter slaAdapter;
    static final String COMPONENT = ServiceBeanSLAManager.class.getName();
    static final Logger logger = Logger.getLogger(COMPONENT);

    public ServiceBeanSLAManager(Object impl, Object proxy, ServiceBeanContext context, EventHandler slaEventHandler) throws IntrospectionException {
        if (impl == null) {
            throw new NullPointerException("impl is null");
        }
        if (proxy == null) {
            throw new NullPointerException("proxy is null");
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (slaEventHandler == null) {
            throw new NullPointerException("slaEventHandler is null");
        }
        this.impl = impl;
        this.proxy = proxy;
        this.context = context;
        this.slaEventHandler = slaEventHandler;
        this.watchInjector = new WatchInjector(impl, context);
    }

    public void terminate() {
        this.watchInjector.terminate();
        SLAPolicyHandler[] slaps = this.getSLAPolicyHandlers();
        for (int i = 0; i < slaps.length; ++i) {
            slaps[i].disconnect();
        }
    }

    public void addSLAs(SLA[] slas) {
        for (int i = 0; i < slas.length; ++i) {
            String identifier = slas[i].getIdentifier();
            WatchDescriptor[] wds = slas[i].getWatchDescriptors();
            if (wds.length > 0) {
                identifier = wds[0].getName();
            }
            SLAPolicyHandler handler = null;
            MeasurableCapability mCap = this.getMeasurableCapability(identifier);
            if (mCap != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[" + this.context.getServiceElement().getName() + "] SLA [" + identifier + "] correlates to a MeasurableCapability");
                }
                try {
                    handler = this.createSLAPolicyHandler(slas[i], null);
                    BoundedThresholdManager tMgr = new BoundedThresholdManager();
                    tMgr.setThresholdValues(slas[i]);
                    handler.setThresholdManager(tMgr);
                    mCap.addSecondaryThresholdManager(tMgr);
                    this.thresholdManagerReg.put(tMgr, mCap);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("[" + this.context.getServiceElement().getName() + "] SLA ID [" + identifier + "], associated to MeasurableCapability=" + mCap.getClass().getName() + ", SLAPolicyHandler=" + handler.getClass().getName());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Creating SLAPolicyHandler for system SLA [" + slas[i].getIdentifier() + "]", e);
                }
            } else {
                try {
                    handler = this.createSLAPolicyHandler(slas[i], this.impl.getClass().getClassLoader());
                    for (int j = 0; j < wds.length; ++j) {
                        try {
                            this.watchInjector.inject(wds[j]);
                            continue;
                        }
                        catch (ConfigurationException e) {
                            logger.log(Level.WARNING, "Injecting Watch [" + wds[j].getName() + "] for SLA [" + slas[i].getIdentifier() + "]", e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Creating SLAPolicyHandler for SLA [" + slas[i].getIdentifier() + "]", e);
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[" + this.context.getServiceElement().getName() + "] Adding SLA [" + identifier + "] to the Watch Registry for subsequent association");
            }
            if (handler == null) continue;
            this.context.getWatchRegistry().addThresholdListener(identifier, handler);
        }
    }

    public void updateSLAs(SLA[] slas) {
        ArrayList toDiscardList = new ArrayList(this.slaPolicyHandlers);
        ArrayList<SLA> toAddList = new ArrayList<SLA>();
        for (int i = 0; i < slas.length; ++i) {
            SLAPolicyHandler slap = this.getSLAPolicyHandler(slas[i]);
            if (slap == null) {
                toAddList.add(slas[i]);
                continue;
            }
            toDiscardList.remove(slap);
            if (SLAPolicyHandlerFactory.slaPolicyHandlerChanged(slas[i], slap)) {
                this.removeSLAPolicyHandler(slap);
                toAddList.add(slas[i]);
                continue;
            }
            slap.updateSLA(slas[i]);
            WatchDescriptor[] wd = slas[i].getWatchDescriptors();
            for (int j = 0; j < wd.length; ++j) {
                try {
                    this.watchInjector.modify(wd[j]);
                    continue;
                }
                catch (ConfigurationException e) {
                    logger.log(Level.WARNING, "Modifying WatchDescriptor [" + wd[j].getName() + "] for SLA [" + slas[i].getIdentifier() + "]", e);
                }
            }
        }
        this.addSLAs(toAddList.toArray(new SLA[toAddList.size()]));
        SLAPolicyHandler[] discardable = toDiscardList.toArray(new SLAPolicyHandler[toDiscardList.size()]);
        for (int i = 0; i < discardable.length; ++i) {
            this.removeSLAPolicyHandler(discardable[i]);
        }
        this.discardWatches(slas);
    }

    public void createSLAThresholdEventAdapter() {
        block5: {
            if (this.slaAdapter != null) {
                return;
            }
            if (this.slaPolicyHandlers.size() > 0) {
                try {
                    ObjectName objectName = JMXUtil.getObjectName(this.context, "", this.context.getServiceElement().getName());
                    if (MBeanServerFactory.getMBeanServer().isRegistered(objectName)) {
                        this.slaAdapter = new SLAThresholdEventAdapter(objectName, this.context.getServiceBeanManager().getNotficationBroadcasterSupport());
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.log(Level.FINE, "Registering SLAThresholdEventAdapter", e);
                }
            }
        }
    }

    private SLAPolicyHandler createSLAPolicyHandler(SLA sla, ClassLoader loader) throws Exception {
        SLAPolicyHandler slappy = SLAPolicyHandlerFactory.create(sla, this.proxy, this.proxy, this.slaEventHandler, this.context, loader);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[" + this.context.getServiceElement().getName() + "] SLA [" + sla.getIdentifier() + "] Created SLAPolicyHandler [" + slappy.getClass().getName() + "]");
        }
        this.slaPolicyHandlers.add(slappy);
        return slappy;
    }

    private SLAPolicyHandler[] getSLAPolicyHandlers() {
        SLAPolicyHandler[] handlers = this.slaPolicyHandlers.toArray(new SLAPolicyHandler[this.slaPolicyHandlers.size()]);
        return handlers;
    }

    private SLAPolicyHandler getSLAPolicyHandler(SLA sla) {
        if (sla != null) {
            SLAPolicyHandler[] slappys = this.getSLAPolicyHandlers();
            for (int i = 0; i < slappys.length; ++i) {
                if (!slappys[i].getID().equals(sla.getIdentifier())) continue;
                return slappys[i];
            }
        }
        return null;
    }

    private void removeSLAPolicyHandler(SLAPolicyHandler slaPolicyHandler) {
        this.slaPolicyHandlers.remove(slaPolicyHandler);
        slaPolicyHandler.disconnect();
        ThresholdManager tMgr = slaPolicyHandler.getThresholdManager();
        MeasurableCapability mCap = (MeasurableCapability)this.thresholdManagerReg.remove(tMgr);
        if (mCap != null) {
            mCap.removeSecondaryThresholdManager(tMgr);
        }
    }

    private void discardWatches(SLA[] serviceSLAs) {
        if (this.watchInjector == null) {
            return;
        }
        String[] createdWatches = this.watchInjector.getWatchNames();
        if (createdWatches.length == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(createdWatches));
        WatchDescriptor[] configuredWatches = this.getWatchDescriptors(serviceSLAs);
        block0: for (int i = 0; i < configuredWatches.length; ++i) {
            for (int j = 0; j < createdWatches.length; ++j) {
                if (!configuredWatches[i].getName().equals(createdWatches[j])) continue;
                list.remove(createdWatches[j]);
                continue block0;
            }
        }
        String[] remove = list.toArray(new String[list.size()]);
        for (int i = 0; i < remove.length; ++i) {
            this.watchInjector.remove(remove[i]);
        }
    }

    private WatchDescriptor[] getWatchDescriptors(SLA[] slas) {
        ArrayList<WatchDescriptor> list = new ArrayList<WatchDescriptor>();
        for (int i = 0; i < slas.length; ++i) {
            WatchDescriptor[] wDesc = slas[i].getWatchDescriptors();
            for (int j = 0; j < wDesc.length; ++j) {
                list.add(wDesc[j]);
            }
        }
        return list.toArray(new WatchDescriptor[list.size()]);
    }

    private MeasurableCapability getMeasurableCapability(String id) {
        MeasurableCapability[] mCaps = this.context.getComputeResourceManager().getMatchedMeasurableCapabilities();
        for (int i = 0; i < mCaps.length; ++i) {
            if (!id.equals(mCaps[i].getId())) continue;
            return mCaps[i];
        }
        return null;
    }
}

