/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.jsb;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.sun.jini.lookup.entry.LookupAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.discovery.LookupGroups;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.log.LoggerConfig;
import org.jini.rio.monitor.ServiceElementManager;

public class ServiceElementUtil {
    private static Logger logger = Logger.getLogger("org.jini.rio.jsb.ServiceElementUtil");

    public static void setCodebase(ServiceElement sElem, String codebase) {
        if (sElem == null || codebase == null) {
            throw new NullPointerException("parameters cannot be null");
        }
        if (sElem.getComponentBundle() != null) {
            sElem.getComponentBundle().setCodebase(codebase);
        }
        for (int i = 0; i < sElem.getExportBundles().length; ++i) {
            sElem.getExportBundles()[i].setCodebase(codebase);
        }
    }

    public static boolean hasHTTPCodebase(ServiceElement sElem) {
        if (sElem == null) {
            throw new NullPointerException("parameters cannot be null");
        }
        boolean httpCodebase = false;
        if (sElem.getComponentBundle() != null && sElem.getComponentBundle().getCodebase().startsWith("http")) {
            httpCodebase = true;
        } else if (sElem.getExportBundles().length > 0) {
            httpCodebase = sElem.getExportBundles()[0].getCodebase().startsWith("http");
        }
        return httpCodebase;
    }

    public static boolean hasDifferentLoggerConfig(ServiceElement sElem1, ServiceElement sElem2) {
        if (sElem1 == null || sElem2 == null) {
            throw new NullPointerException("parameters cannot be null");
        }
        boolean different = false;
        Map map = sElem2.getServiceBeanConfig().getConfigurationParamaters();
        LoggerConfig[] loggerConfigs2 = (LoggerConfig[])map.get("loggerConfig");
        map = sElem1.getServiceBeanConfig().getConfigurationParamaters();
        LoggerConfig[] loggerConfigs1 = (LoggerConfig[])map.get("loggerConfig");
        for (int i = 0; i < loggerConfigs2.length; ++i) {
            if (LoggerConfig.isNewLogger(loggerConfigs2[i], loggerConfigs1)) {
                different = true;
                break;
            }
            if (!LoggerConfig.levelChanged(loggerConfigs2[i], loggerConfigs1)) continue;
            different = true;
            break;
        }
        return different;
    }

    public static boolean hasDifferentServiceUIs(Entry[] serviceUIs, ServiceElement sElem2, String codebase) {
        if (serviceUIs == null || sElem2 == null || codebase == null) {
            throw new NullPointerException("parameters cannot be null");
        }
        try {
            Configuration config2 = ConfigurationProvider.getInstance((String[])sElem2.getServiceBeanConfig().getConfigArgs());
            String className = sElem2.getComponentBundle().getClassName();
            String serviceBeanComponent = className.substring(0, className.lastIndexOf("."));
            Entry[] serviceUIs1 = (Entry[])config2.getEntry(serviceBeanComponent, "serviceUIs", Entry[].class, (Object)new Entry[0], (Object)codebase);
            return !LookupAttributes.equal((Entry[])serviceUIs, (Entry[])serviceUIs1);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Getting ServiceUIs from ServiceElement", e);
            }
            return false;
        }
    }

    public static boolean hasDifferentGroups(ServiceElement sElem1, ServiceElement sElem2) {
        if (sElem1 == null || sElem2 == null) {
            throw new NullPointerException("parameters cannot be null");
        }
        boolean different = false;
        String[] groups1 = sElem1.getServiceBeanConfig().getGroups();
        String[] groups2 = sElem2.getServiceBeanConfig().getGroups();
        if (groups1 == LookupGroups.all() && groups2 == LookupGroups.all()) {
            return false;
        }
        if (groups1.length != groups2.length) {
            different = true;
        } else {
            for (int i = 0; i < groups1.length; ++i) {
                boolean matched = false;
                for (int j = 0; j < groups2.length; ++j) {
                    if (!groups1[i].equals(groups2[j])) continue;
                    matched = true;
                    break;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[" + sElem1.getName() + "] groups1 [" + groups1[i] + "] matched in groups2 : " + matched);
                }
                if (matched) continue;
                different = true;
                break;
            }
        }
        return different;
    }

    public static boolean hasDifferentLocators(ServiceElement sElem1, ServiceElement sElem2) {
        if (sElem1 == null || sElem2 == null) {
            throw new NullPointerException("parameters cannot be null");
        }
        LookupLocator[] locs1 = sElem1.getServiceBeanConfig().getLocators();
        LookupLocator[] locs2 = sElem2.getServiceBeanConfig().getLocators();
        return ServiceElementUtil.areLocatorsDifferent(locs1, locs2);
    }

    public static boolean areLocatorsDifferent(LookupLocator[] locs1, LookupLocator[] locs2) {
        boolean different = false;
        if (locs1 == null && locs2 == null) {
            return false;
        }
        if (locs1 == null || locs2 == null) {
            return true;
        }
        if (locs1.length != locs2.length) {
            different = true;
        } else {
            for (int i = 0; i < locs1.length; ++i) {
                boolean matched = false;
                for (int j = 0; j < locs2.length; ++j) {
                    if (!locs1[i].equals((Object)locs2[j])) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                different = true;
                break;
            }
        }
        return different;
    }

    public static ServiceElement prepareInstanceID(ServiceElement sElem, boolean copy, long id) {
        ServiceElement elem = sElem;
        if (copy) {
            elem = ServiceElementUtil.copyServiceElement(sElem);
        }
        Map parms = elem.getServiceBeanConfig().getConfigurationParamaters();
        parms.put("instanceID", new Long(id));
        ServiceBeanConfig sbConfig = new ServiceBeanConfig(parms, elem.getServiceBeanConfig().getConfigArgs());
        Map initParms = elem.getServiceBeanConfig().getInitParameters();
        for (Map.Entry e : initParms.entrySet()) {
            sbConfig.addInitParameter(e.getKey(), e.getValue());
        }
        elem.setServiceBeanConfig(sbConfig);
        return elem;
    }

    public static ServiceBeanInstance prepareInstanceID(ServiceBeanInstance sbi, long id) {
        Map parms = sbi.getServiceBeanConfig().getConfigurationParamaters();
        parms.put("instanceID", new Long(id));
        ServiceBeanConfig sbConfig = new ServiceBeanConfig(parms, sbi.getServiceBeanConfig().getConfigArgs());
        Map initParms = sbi.getServiceBeanConfig().getInitParameters();
        for (Map.Entry e : initParms.entrySet()) {
            sbConfig.addInitParameter(e.getKey(), e.getValue());
        }
        sbi.setServiceBeanConfig(sbConfig);
        return sbi;
    }

    public static ServiceElement prepareInstanceID(ServiceElement sElem, long id) {
        return ServiceElementUtil.prepareInstanceID(sElem, true, id);
    }

    public static synchronized long getNextID(long[] lArray) {
        long nextID = 1L;
        if (lArray.length > 0) {
            Arrays.sort(lArray);
            int i = 0;
            int x = 1;
            while (i < lArray.length) {
                if (lArray[i] != (long)x) {
                    nextID = x;
                    break;
                }
                nextID = x + 1;
                ++i;
                ++x;
            }
        }
        return nextID;
    }

    public static ServiceElement copyServiceElement(ServiceElement sElem) {
        ServiceElement elem = new ServiceElement(sElem.getProvisionType(), sElem.getServiceBeanConfig(), sElem.getServiceLevelAgreements(), sElem.getExportBundles(), sElem.getFaultDetectionHandlerBundle(), sElem.getComponentBundle());
        elem.setPlanned(sElem.getPlanned());
        elem.setRelocateInstanceCount(sElem.getRelocateInstanceCount());
        elem.setCluster(sElem.getCluster());
        elem.setMaxPerMachine(sElem.getMaxPerMachine());
        elem.setMaxPerPhysicalMachine(sElem.getMaxPerPhysicalMachine());
        elem.setRequiresIsolation(sElem.isRequiresIsolation());
        elem.setRequiredZones(sElem.getRequiredZones());
        elem.setMaxPerZone(sElem.getMaxPerZone());
        elem.setTotalNumberOfServices(sElem.getTotalNumberOfServices());
        elem.setMatchOnName(sElem.getMatchOnName());
        elem.setAutoAdvertise(sElem.getAutoAdvertise());
        elem.setDiscoveryManagementPooling(sElem.getDiscoveryManagementPooling());
        elem.setAssociationDescriptors(sElem.getAssociationDescriptors());
        return elem;
    }

    public static ServiceBeanConfig addConfigParameter(ServiceBeanConfig sbc, Object key, Object value) {
        if (sbc == null || key == null || value == null) {
            throw new NullPointerException("parameters cannot be null");
        }
        Map configParms = sbc.getConfigurationParamaters();
        configParms.put(key, value);
        ServiceBeanConfig newConfig = new ServiceBeanConfig(configParms, sbc.getConfigArgs());
        Map initParms = sbc.getInitParameters();
        for (Map.Entry e : initParms.entrySet()) {
            newConfig.addInitParameter(e.getKey(), e.getValue());
        }
        return newConfig;
    }

    public static boolean matchesServiceElement(ServiceElement sElem, String name, String[] interfaces, String opStringName) {
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        if (interfaces == null) {
            throw new NullPointerException("interfaces is null");
        }
        boolean found = false;
        ClassBundle[] exports = sElem.getExportBundles();
        for (int i = 0; i < exports.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < interfaces.length; ++j) {
                if (!exports[i].getClassName().equals(interfaces[j])) continue;
                matched = true;
            }
            if (!matched) continue;
            found = true;
            break;
        }
        if (found) {
            boolean attrsMatch = true;
            if (opStringName != null && !sElem.getOperationalStringName().equals(opStringName)) {
                attrsMatch = false;
            }
            if (attrsMatch && name != null && !name.equals(sElem.getName())) {
                attrsMatch = false;
            }
            return attrsMatch;
        }
        return false;
    }

    public static String getNameWithId(ServiceElement serviceElement) {
        StringBuffer sb = new StringBuffer();
        sb.append(serviceElement.getName());
        if (serviceElement.getServiceBeanConfig() == null || serviceElement.getServiceBeanConfig().getInstanceID() == null) {
            sb.append(" [?]");
        } else {
            sb.append(" [").append(serviceElement.getServiceBeanConfig().getInstanceID()).append("]");
        }
        return sb.toString();
    }

    public static Collection<ServiceElementManager> sortServiceElementManagersByMode(Vector<ServiceElementManager> managers) {
        try {
            Class<?> puServiceClass = Thread.currentThread().getContextClassLoader().loadClass("org.openspaces.pu.container.servicegrid.PUServiceBean");
            ArrayList<ServiceElementManager> singleBackupElements = new ArrayList<ServiceElementManager>();
            ArrayList<ServiceElementManager> nonBackupElements = new ArrayList<ServiceElementManager>();
            Enumeration<ServiceElementManager> e = managers.elements();
            while (e.hasMoreElements()) {
                ServiceElementManager svcElemMgr = e.nextElement();
                ServiceBeanInstance[] instances = svcElemMgr.getServiceBeanInstances();
                if (svcElemMgr.getServiceElement().getProcessingUnitType().equals("STATEFUL")) {
                    if (instances.length == 1) {
                        if (ServiceElementUtil.isBackupService(instances[0].getService(), puServiceClass)) {
                            singleBackupElements.add(svcElemMgr);
                            continue;
                        }
                        nonBackupElements.add(svcElemMgr);
                        continue;
                    }
                    svcElemMgr.setServiceBeenList(ServiceElementUtil.sortElementsByMode(instances, puServiceClass));
                    nonBackupElements.add(svcElemMgr);
                    continue;
                }
                nonBackupElements.add(svcElemMgr);
            }
            singleBackupElements.addAll(nonBackupElements);
            return singleBackupElements;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "failed to sort serviceElementManagers", e);
            }
            return managers;
        }
    }

    private static ArrayList<ServiceBeanInstance> sortElementsByMode(ServiceBeanInstance[] instances, Class puServiceClass) {
        try {
            ArrayList<ServiceBeanInstance> backupInstances = new ArrayList<ServiceBeanInstance>();
            ArrayList<ServiceBeanInstance> nonBackupInstances = new ArrayList<ServiceBeanInstance>();
            for (ServiceBeanInstance instance : instances) {
                if (ServiceElementUtil.isBackupService(instance.getService(), puServiceClass)) {
                    backupInstances.add(instance);
                    continue;
                }
                nonBackupInstances.add(instance);
            }
            backupInstances.addAll(nonBackupInstances);
            return backupInstances;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "failed to sort instances", e);
            }
            ArrayList<ServiceBeanInstance> result = new ArrayList<ServiceBeanInstance>();
            Collections.addAll(result, instances);
            return result;
        }
    }

    private static boolean isBackupService(Object serviceObj, Class puServiceClass) {
        block3: {
            try {
                SpaceMode[] spacesModes;
                for (SpaceMode mode : spacesModes = (SpaceMode[])puServiceClass.getMethod("listSpacesModes", new Class[0]).invoke(serviceObj, new Object[0])) {
                    if (!mode.equals((Object)SpaceMode.BACKUP)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINEST)) break block3;
                logger.log(Level.FINEST, "failed to determine if service is a backup", e);
            }
        }
        return false;
    }
}

