/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.log;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogBuffer
extends Logger {
    private static final ThreadLocalLogBuffer buffer = new ThreadLocalLogBuffer();
    private final Logger logger;

    private LogBuffer(String name, Logger logger) {
        super(name, null);
        this.logger = logger;
    }

    public static synchronized LogBuffer getLogger(String name) {
        String logBufferName = "logBuffer." + name;
        LogManager manager = LogManager.getLogManager();
        LogBuffer result = (LogBuffer)manager.getLogger(logBufferName);
        if (result == null) {
            Logger logger = Logger.getLogger(name);
            LogBuffer logBuffer = new LogBuffer(logBufferName, logger);
            manager.addLogger(logBuffer);
            result = (LogBuffer)manager.getLogger(logBufferName);
        }
        return result;
    }

    public LogBuffer append(String msg) {
        buffer.get().append(msg);
        return this;
    }

    public LogBuffer append(Object msg) {
        buffer.get().append(String.valueOf(msg));
        return this;
    }

    public LogBuffer append(String msg, Throwable thrown) {
        buffer.get().append(msg).append(thrown);
        return this;
    }

    public void flush(Level level) {
        this.logger.log(level, buffer.get().toString());
        buffer.reset();
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public void log(LogRecord record) {
        this.logger.log(record);
    }

    private static class ThreadLocalLogBuffer
    extends ThreadLocal<StringBuilder> {
        private ThreadLocalLogBuffer() {
        }

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }

        @Override
        public StringBuilder get() {
            StringBuilder local = (StringBuilder)super.get();
            if (local == null) {
                super.set(this.initialValue());
            }
            return (StringBuilder)super.get();
        }

        public void reset() {
            super.set(null);
        }
    }
}

