/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.log;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerConfig
implements Serializable {
    static final long serialVersionUID = 1L;
    private String loggerName;
    private Level level;
    private boolean useParentHandlers;
    private String resourceBundleName;
    private LogHandlerConfig[] handlers;
    private static Logger myLogger = Logger.getLogger("org.jini.rio.log");
    private transient Logger logger;

    public LoggerConfig(String loggerName, Level level, LogHandlerConfig[] logHandlerConfigs) {
        this(loggerName, level, true, null, logHandlerConfigs);
    }

    public LoggerConfig(String loggerName, Level level, boolean useParentHandlers, LogHandlerConfig[] logHandlerConfigs) {
        this(loggerName, level, useParentHandlers, null, logHandlerConfigs);
    }

    public LoggerConfig(String loggerName, Level level, boolean useParentHandlers, String resourceBundleName, LogHandlerConfig[] logHandlerConfigs) {
        if (loggerName == null) {
            throw new NullPointerException("loggerName is null");
        }
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        this.loggerName = loggerName;
        this.level = level;
        this.resourceBundleName = resourceBundleName;
        this.useParentHandlers = useParentHandlers;
        if (logHandlerConfigs != null) {
            this.handlers = new LogHandlerConfig[logHandlerConfigs.length];
            System.arraycopy(logHandlerConfigs, 0, this.handlers, 0, this.handlers.length);
        }
    }

    public Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        if (this.resourceBundleName != null) {
            if (myLogger.isLoggable(Level.FINEST)) {
                myLogger.finest("Creating Logger [" + this.loggerName + "] with Resource Bundle [" + this.resourceBundleName + "]");
            }
            this.logger = Logger.getLogger(this.loggerName, this.resourceBundleName);
        } else {
            if (myLogger.isLoggable(Level.FINEST)) {
                myLogger.finest("Creating Logger [" + this.loggerName + "]");
            }
            this.logger = Logger.getLogger(this.loggerName);
        }
        if (myLogger.isLoggable(Level.FINEST)) {
            myLogger.finest("Logger [" + this.loggerName + "] uses parent handlers : " + this.useParentHandlers);
        }
        this.logger.setUseParentHandlers(this.useParentHandlers);
        if (myLogger.isLoggable(Level.FINEST)) {
            myLogger.finest("Logger [" + this.loggerName + "] requesting Level : " + this.level.getName());
        }
        if (this.logger.getLevel() != null) {
            if (this.level.intValue() < this.logger.getLevel().intValue()) {
                if (myLogger.isLoggable(Level.FINEST)) {
                    myLogger.finest("Logger [" + this.loggerName + "] Level set to : " + this.level.getName());
                }
                this.logger.setLevel(this.level);
            } else if (myLogger.isLoggable(Level.FINEST)) {
                myLogger.finest("Logger [" + this.loggerName + "] Level : " + this.level.getName() + " not applied, maintaining level : " + this.logger.getLevel().getName());
            }
        } else {
            if (myLogger.isLoggable(Level.FINEST)) {
                myLogger.finest("Logger [" + this.loggerName + "] Level set to : " + this.level.getName());
            }
            this.logger.setLevel(this.level);
        }
        for (int i = 0; i < this.handlers.length; ++i) {
            try {
                boolean handlerClassAssociated = false;
                Handler[] currentHandlers = this.logger.getHandlers();
                String candidateHandler = this.handlers[i].getHandlerClassName();
                for (int j = 0; j < currentHandlers.length; ++j) {
                    if (!currentHandlers[j].getClass().getName().equals(candidateHandler)) continue;
                    handlerClassAssociated = true;
                    break;
                }
                if (!handlerClassAssociated) {
                    if (myLogger.isLoggable(Level.FINEST)) {
                        myLogger.finest("Logger [" + this.loggerName + "] adding Handler [" + this.handlers[i].getHandlerClassName() + "]");
                    }
                    this.logger.addHandler(this.handlers[i].getHandler());
                    continue;
                }
                if (!myLogger.isLoggable(Level.FINEST)) continue;
                myLogger.finest("Logger [" + this.loggerName + "] has Handler [" + this.handlers[i].getHandlerClassName() + "] associated");
                continue;
            }
            catch (Throwable t) {
                myLogger.log(Level.SEVERE, "Getting Handler [" + this.handlers[i].getHandlerClassName() + "] for Logger [" + this.loggerName + "]", t.getCause() == null ? t : t.getCause());
            }
        }
        return this.logger;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Level getLoggerLevel() {
        return this.level;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.loggerName.hashCode();
        hc = 37 * hc + this.level.hashCode();
        for (int i = 0; i < this.handlers.length; ++i) {
            hc = 37 * hc + this.handlers[i].hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LoggerConfig)) {
            return false;
        }
        LoggerConfig that = (LoggerConfig)obj;
        if (this.loggerName.equals(that.loggerName) && this.level.equals(that.level)) {
            if (this.handlers.length == that.handlers.length) {
                for (int i = 0; i < this.handlers.length; ++i) {
                    boolean matched = false;
                    for (int j = 0; j < that.handlers.length; ++j) {
                        if (!this.handlers[i].equals(that.handlers[j])) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Logger=" + this.loggerName + ", Level=" + this.level + ", UseParentHandlers=" + this.useParentHandlers + "\n");
        for (int i = 0; i < this.handlers.length; ++i) {
            buffer.append("Handler=" + this.handlers[i].getHandlerClassName() + ", Level=" + this.handlers[i].getHandlerLevel());
            if (this.handlers[i].formatterClassName != null) {
                buffer.append(", Formatter=" + this.handlers[i].formatterClassName + "\n");
                continue;
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static boolean isNewLogger(LoggerConfig lConf, LoggerConfig[] loggerConfigs) {
        boolean matched = false;
        for (int i = 0; i < loggerConfigs.length; ++i) {
            if (!loggerConfigs[i].getLoggerName().equals(lConf.getLoggerName())) continue;
            matched = true;
        }
        return !matched;
    }

    public static boolean levelChanged(LoggerConfig lConf, LoggerConfig[] loggerConfigs) {
        boolean levelChanged = false;
        for (int i = 0; i < loggerConfigs.length; ++i) {
            if (!loggerConfigs[i].getLoggerName().equals(lConf.getLoggerName()) || loggerConfigs[i].getLoggerLevel().equals(lConf.getLoggerLevel())) continue;
            levelChanged = true;
            break;
        }
        return levelChanged;
    }

    public static class LogHandlerConfig
    implements Serializable {
        static final long serialVersionUID = 1L;
        private transient Handler handler;
        private String handlerClassName;
        private String formatterClassName;
        private Level level;
        private Map handlerArgs = new HashMap();
        private List handlerArgList = new LinkedList();

        public LogHandlerConfig(String handlerClassName, Level level) {
            this(handlerClassName, level, null, null);
        }

        public LogHandlerConfig(String handlerClassName, Level level, List params) {
            this(handlerClassName, level, params, null);
        }

        public LogHandlerConfig(String handlerClassName, Level level, List params, String formatterClassName) {
            if (handlerClassName == null) {
                throw new NullPointerException("handlerClassName is null");
            }
            if (level == null) {
                throw new NullPointerException("level is null");
            }
            this.handlerClassName = handlerClassName;
            this.level = level;
            if (params != null) {
                this.handlerArgList.addAll(params);
            }
            this.formatterClassName = formatterClassName;
        }

        public LogHandlerConfig(Handler handler, Level level) {
            if (handler == null) {
                throw new NullPointerException("handler is null");
            }
            if (level == null) {
                throw new NullPointerException("level is null");
            }
            this.handler = handler;
            this.level = level;
            this.handler.setLevel(level);
            this.handlerClassName = handler.getClass().getName();
        }

        String getHandlerClassName() {
            return this.handlerClassName;
        }

        public Level getHandlerLevel() {
            return this.level;
        }

        public int hashCode() {
            int hc = 17;
            hc = 37 * hc + this.handlerClassName.hashCode();
            hc = 37 * hc + this.level.hashCode();
            return hc;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LogHandlerConfig)) {
                return false;
            }
            LogHandlerConfig that = (LogHandlerConfig)obj;
            return this.handlerClassName.equals(that.handlerClassName) && this.level.equals(that.level);
        }

        public Handler getHandler() throws Exception {
            if (this.handler == null) {
                Class<?> handlerClass = Thread.currentThread().getContextClassLoader().loadClass(this.handlerClassName);
                if (this.handlerArgList.size() > 0) {
                    Class[] parameterTypes = this.getParameterTypes();
                    Object[] initArgs = this.getInitArgs();
                    Constructor<?> constructor = handlerClass.getConstructor(parameterTypes);
                    this.handler = (Handler)constructor.newInstance(initArgs);
                } else {
                    this.handler = (Handler)handlerClass.newInstance();
                }
                this.handler.setLevel(this.level);
                if (this.formatterClassName != null) {
                    Class<?> formatClass = Class.forName(this.formatterClassName, true, Thread.currentThread().getContextClassLoader());
                    Formatter formatter = (Formatter)formatClass.newInstance();
                    this.handler.setFormatter(formatter);
                }
            }
            return this.handler;
        }

        private Class[] getParameterTypes() throws Exception {
            LinkedList classes = new LinkedList();
            ListIterator it = this.handlerArgList.listIterator();
            while (it.hasNext()) {
                FormalArgument arg = (FormalArgument)it.next();
                String param = arg.getDataType();
                if (param.equals("boolean")) {
                    classes.add(Boolean.TYPE);
                    continue;
                }
                if (param.equals("byte")) {
                    classes.add(Byte.TYPE);
                    continue;
                }
                if (param.equals("short")) {
                    classes.add(Short.TYPE);
                    continue;
                }
                if (param.equals("int")) {
                    classes.add(Integer.TYPE);
                    continue;
                }
                if (param.equals("long")) {
                    classes.add(Long.TYPE);
                    continue;
                }
                if (param.equals("float")) {
                    classes.add(Float.TYPE);
                    continue;
                }
                if (param.equals("double")) {
                    classes.add(Double.TYPE);
                    continue;
                }
                classes.add(Class.forName(param, true, this.getClass().getClassLoader()));
            }
            return classes.toArray(new Class[classes.size()]);
        }

        private Object[] getInitArgs() throws Exception {
            LinkedList<Object> values = new LinkedList<Object>();
            ListIterator it = this.handlerArgList.listIterator();
            while (it.hasNext()) {
                FormalArgument arg = (FormalArgument)it.next();
                String type = arg.getDataType();
                String value = arg.getValue();
                if (type.equals("boolean")) {
                    values.add(Boolean.valueOf(value));
                    continue;
                }
                if (type.equals("byte")) {
                    values.add(new Byte(value));
                    continue;
                }
                if (type.equals("short")) {
                    values.add(new Short(value));
                    continue;
                }
                if (type.equals("int")) {
                    values.add(new Integer(value));
                    continue;
                }
                if (type.equals("long")) {
                    values.add(new Long(value));
                    continue;
                }
                if (type.equals("float")) {
                    values.add(new Float(value));
                    continue;
                }
                if (type.equals("double")) {
                    values.add(new Double(value));
                    continue;
                }
                Class<?> clazz = Class.forName(type, true, this.getClass().getClassLoader());
                if (clazz == String.class) {
                    value = this.transformString(value);
                    values.add(value);
                    continue;
                }
                if (clazz == Boolean.class) {
                    values.add(Boolean.valueOf(value));
                    continue;
                }
                if (clazz == Byte.class) {
                    values.add(new Byte(value));
                    continue;
                }
                if (clazz == Short.class) {
                    values.add(new Short(value));
                    continue;
                }
                if (clazz == Integer.class) {
                    values.add(new Integer(value));
                    continue;
                }
                if (clazz == Long.class) {
                    values.add(new Long(value));
                    continue;
                }
                if (clazz == Float.class) {
                    values.add(new Float(value));
                    continue;
                }
                if (clazz != Double.class) continue;
                values.add(new Double(value));
            }
            return values.toArray(new Object[values.size()]);
        }

        String transformString(String input) {
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while ((index = input.indexOf("${")) != -1) {
                buffer.append(input.substring(0, index));
                int end = input.indexOf("}");
                if (end == -1) continue;
                String value = input.substring(index + 2, end);
                if (value.equals("/")) {
                    buffer.append(File.separator);
                } else {
                    String property = System.getProperty(value);
                    if (property == null) {
                        throw new RuntimeException("Cannot resolve property [" + value + "]");
                    }
                    buffer.append(property);
                }
                input = buffer.toString() + input.substring(end + 1);
                buffer.delete(0, buffer.length());
            }
            return input;
        }
    }

    public static class FormalArgument
    implements Serializable {
        static final long serialVersionUID = 1L;
        private String dataType;
        private String value;

        public FormalArgument(String dataType, String value) {
            this.dataType = dataType;
            this.value = value;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getValue() {
            return this.value;
        }
    }
}

