/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.grid.esm.ESM;
import com.j_spaces.core.jini.SharedLeaseRenewalManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.lookup.BackwardsServiceDiscoveryManager;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import org.jini.rio.monitor.InternalEsmFinder;

public class EsmMonitor
implements ServiceDiscoveryListener,
InternalEsmFinder {
    private static Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.esmmonitor");
    private final LinkedHashMap<ServiceID, ESM> esm;
    private final Configuration config;
    private final DiscoveryManagement discoveryManagement;
    private final AtomicReference<BackwardsServiceDiscoveryManager> sdmReference;

    public EsmMonitor(Configuration config, DiscoveryManagement discoveryManagement) {
        if (config == null) {
            throw new NullPointerException("config cannot be null");
        }
        this.discoveryManagement = discoveryManagement;
        this.esm = new LinkedHashMap();
        this.config = config;
        this.sdmReference = new AtomicReference<Object>(null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BackwardsServiceDiscoveryManager sdm = EsmMonitor.this.initServiceDiscoveryManager();
                    ServiceTemplate template = new ServiceTemplate(null, new Class[]{ESM.class}, null);
                    sdm.createLookupCache(template, null, (ServiceDiscoveryListener)EsmMonitor.this);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "GSM failed to initialize discovery of ESM", e);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAdded(ServiceDiscoveryEvent event) {
        Object service = event.getPostEventServiceItem().service;
        ServiceID serviceID = event.getPostEventServiceItem().serviceID;
        if (service instanceof ESM) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Service ESM Added with uid [" + serviceID + "]");
            }
            try {
                LinkedHashMap<ServiceID, ESM> linkedHashMap = this.esm;
                synchronized (linkedHashMap) {
                    this.esm.put(serviceID, (ESM)service);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to add [ESM] with uid [" + serviceID + "]", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(ServiceDiscoveryEvent event) {
        ServiceID serviceID = event.getPreEventServiceItem().serviceID;
        LinkedHashMap<ServiceID, ESM> linkedHashMap = this.esm;
        synchronized (linkedHashMap) {
            this.esm.remove(serviceID);
        }
    }

    public void serviceChanged(ServiceDiscoveryEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ESM getESM() {
        LinkedHashMap<ServiceID, ESM> linkedHashMap = this.esm;
        synchronized (linkedHashMap) {
            ESM firstESM = null;
            Iterator<ESM> iterator = this.esm.values().iterator();
            if (iterator.hasNext()) {
                firstESM = iterator.next();
            }
            return firstESM;
        }
    }

    public void terminate() {
        this.terminateServiceDiscoveryManager();
    }

    private BackwardsServiceDiscoveryManager initServiceDiscoveryManager() throws IOException, ConfigurationException {
        this.sdmReference.set(new BackwardsServiceDiscoveryManager(this.discoveryManagement, SharedLeaseRenewalManager.getLeaseRenewalManager(), this.config));
        return this.sdmReference.get();
    }

    private void terminateServiceDiscoveryManager() {
        BackwardsServiceDiscoveryManager sdm = this.sdmReference.get();
        if (sdm != null) {
            sdm.terminate();
        }
    }
}

