/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import java.rmi.RemoteException;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.ServiceElementManager;

public class ExtraStatelessInstanceHandler
implements Runnable {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.grid.gsm");
    private static final Logger _xlogger = Logger.getLogger("com.gigaspaces.grid.gsm.xhandler");
    private static final int HANDLE_EXTRA_STATELESS_INSTANCES_RETRIES = Integer.getInteger("com.gs.handle-extra-stateless-instances.retries", 60);
    private int _retries = HANDLE_EXTRA_STATELESS_INSTANCES_RETRIES;
    private ServiceElementManager _serviceElementManager;
    private ServiceBeanInstance _newlyAddedInstance;
    private ServiceBeanInstance _existingInstance;

    public ExtraStatelessInstanceHandler(ServiceElementManager serviceElementManager, ServiceBeanInstance newlyAddedInstance, ServiceBeanInstance existingInstance) {
        this._serviceElementManager = serviceElementManager;
        this._newlyAddedInstance = newlyAddedInstance;
        this._existingInstance = existingInstance;
        _xlogger.info("Handling duplicate instances: " + newlyAddedInstance.toString() + ", " + existingInstance.toString());
    }

    @Override
    public void run() {
        if (this._retries-- == 0) {
            if (this._serviceElementManager.getActive()) {
                _logger.warning("Exhausted " + HANDLE_EXTRA_STATELESS_INSTANCES_RETRIES + " retry attempts to handle extra instance. Instances: " + this._newlyAddedInstance.toString() + ", " + this._existingInstance.toString());
            } else {
                _logger.fine("GSM is not active for " + this._serviceElementManager.getServiceElement() + " and retry limit reached.");
            }
            throw new CancellationException();
        }
        if (_xlogger.isLoggable(Level.FINE)) {
            _xlogger.fine("Trying for the " + (HANDLE_EXTRA_STATELESS_INSTANCES_RETRIES - this._retries) + " time");
        }
        if (!this._serviceElementManager.getActive()) {
            if (_xlogger.isLoggable(Level.FINE)) {
                _xlogger.fine("GSM is not active for " + this._serviceElementManager.getServiceElement() + " - retry later.");
            }
            return;
        }
        try {
            InstantiatorResource instantiatorResourceNewlyAddedInstance;
            if (_xlogger.isLoggable(Level.FINE)) {
                _xlogger.fine("Checking if GSC of the newly added instance is available: " + this._newlyAddedInstance.toString());
            }
            if ((instantiatorResourceNewlyAddedInstance = this._serviceElementManager.getInstantiatorResourceByServiceBeanID(this._newlyAddedInstance.getServiceBeanID())) == null) {
                if (_xlogger.isLoggable(Level.FINE)) {
                    _xlogger.fine("Could not find GSC of the newly added instance: " + this._newlyAddedInstance.getPresentationName());
                }
                return;
            }
        }
        catch (RemoteException e) {
            if (_xlogger.isLoggable(Level.FINE)) {
                _xlogger.log(Level.FINE, "Could not find GSC of the newly added instance: " + this._newlyAddedInstance.getPresentationName(), e);
            }
            return;
        }
        try {
            InstantiatorResource instantiatorResourceExistingInstance;
            if (_xlogger.isLoggable(Level.FINE)) {
                _xlogger.fine("Checking if GSC of the existing instance is available: " + this._existingInstance.toString());
            }
            if ((instantiatorResourceExistingInstance = this._serviceElementManager.getInstantiatorResourceByServiceBeanID(this._existingInstance.getServiceBeanID())) == null) {
                if (_xlogger.isLoggable(Level.FINE)) {
                    _xlogger.fine("Could not find GSC of the existing instance: " + this._existingInstance.getPresentationName());
                }
                return;
            }
        }
        catch (RemoteException e) {
            if (_xlogger.isLoggable(Level.FINE)) {
                _xlogger.log(Level.FINE, "Could not find GSC of the existing instance: " + this._existingInstance.getPresentationName(), e);
            }
            return;
        }
        _xlogger.warning("Destroying duplicate instances: " + this._newlyAddedInstance.toString() + ", " + this._existingInstance.toString());
        try {
            _xlogger.info("Destroying newly added instance: " + this._newlyAddedInstance.toString());
            this._serviceElementManager.destroyService(this._newlyAddedInstance.getService(), this._newlyAddedInstance.getServiceBeanID(), true);
        }
        catch (Exception e) {
            _xlogger.log(Level.WARNING, "Failed to destroy instance " + this._newlyAddedInstance.toString(), e);
        }
        try {
            _xlogger.info("Destroying existing instance: " + this._existingInstance.toString());
            this._serviceElementManager.redeploy(this._existingInstance);
        }
        catch (Exception e) {
            _xlogger.log(Level.WARNING, "Failed to redeploy instance " + this._existingInstance.toString(), e);
        }
        if (_xlogger.isLoggable(Level.FINE)) {
            _xlogger.fine("The two instances are destroyed.");
        }
        throw new CancellationException();
    }
}

