/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.core.FaultDetectionHandler;

public class FaultDetectionHandlerTable {
    private final Hashtable<ServiceID, FdhHolder> fdhTable = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnique(ServiceID serviceId, FdhHolder fdhHolder) {
        Hashtable<ServiceID, FdhHolder> hashtable = this.fdhTable;
        synchronized (hashtable) {
            if (this.fdhTable.containsKey(serviceId)) {
                return false;
            }
            this.fdhTable.put(serviceId, fdhHolder);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countUniqueInstanceIDs() {
        ArrayList<Long> ids = new ArrayList<Long>(this.fdhTable.size());
        Hashtable<ServiceID, FdhHolder> hashtable = this.fdhTable;
        synchronized (hashtable) {
            for (FdhHolder fdh : this.fdhTable.values()) {
                if (ids.contains(fdh.instanceId)) continue;
                ids.add(fdh.instanceId);
            }
        }
        return ids.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInstanceID(Long instanceId) {
        Hashtable<ServiceID, FdhHolder> hashtable = this.fdhTable;
        synchronized (hashtable) {
            for (FdhHolder fdh : this.fdhTable.values()) {
                if (!fdh.instanceId.equals(instanceId)) continue;
                return true;
            }
        }
        return false;
    }

    public FdhHolder remove(ServiceID serviceId) {
        return this.fdhTable.remove(serviceId);
    }

    public Collection<FdhHolder> values() {
        return this.fdhTable.values();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<ServiceID, FdhHolder> entry : this.fdhTable.entrySet()) {
            sb.append(" {serviceId:").append(entry.getKey()).append("{instanceId:").append(entry.getValue().getInstanceId()).append(",").append("fdh:").append(entry.getValue().getHandler().toString()).append("}").append("},");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public static class FdhHolder {
        private final FaultDetectionHandler handler;
        private final Long instanceId;

        public FdhHolder(FaultDetectionHandler handler, Long instanceId) {
            this.handler = handler;
            this.instanceId = instanceId;
        }

        public FaultDetectionHandler getHandler() {
            return this.handler;
        }

        public Long getInstanceId() {
            return this.instanceId;
        }
    }
}

