/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.grid.zone.ZoneHelper;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.id.Uuid;
import org.jini.rio.associations.AssociationMatchFilter;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.MeasuredResource;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.provision.ServiceBeanInstantiator;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.qos.capability.system.StorageCapability;

public class InstantiatorResource {
    private final ServiceBeanInstantiator instantiator;
    private int serviceLimit;
    private final MarshalledObject handback;
    private volatile ResourceCapability resourceCapability;
    private volatile boolean dynamicEnabled = false;
    private final HashMap<ServiceElement, List<ServiceElementHolder>> serviceElementMap = new HashMap();
    private int serviceElementCount = 0;
    private final HashMap<ServiceElement, List<ServiceElement>> inProcessMap = new HashMap();
    private final String instantiatorName;
    private final Uuid instantiatorUuid;
    private int inProcessCount = 0;
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.provision");

    public InstantiatorResource(ServiceBeanInstantiator instantiator, String instantiatorName, Uuid instantiatorUuid, MarshalledObject handback, ResourceCapability resourceCapability, int serviceLimit) {
        this.instantiator = instantiator;
        this.instantiatorName = instantiatorName;
        this.instantiatorUuid = instantiatorUuid;
        this.handback = handback;
        this.resourceCapability = resourceCapability;
        this.serviceLimit = serviceLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addServiceElementInstance(ServiceElement sElem, Uuid uuid) {
        HashMap<ServiceElement, List<ServiceElementHolder>> hashMap = this.serviceElementMap;
        synchronized (hashMap) {
            List<ServiceElementHolder> list = this.serviceElementMap.get(sElem);
            if (list == null) {
                ArrayList<ServiceElementHolder> newList = new ArrayList<ServiceElementHolder>(1);
                newList.add(new ServiceElementHolder(sElem, uuid));
                this.serviceElementMap.put(sElem, newList);
            } else {
                list.add(new ServiceElementHolder(sElem, uuid));
            }
            ++this.serviceElementCount;
        }
    }

    void fillWithActiveServiceRecords() throws RemoteException {
        ServiceRecord[] records = this.getActiveServiceRecords();
        this.setServiceRecords(records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceRecords(ServiceRecord[] records) {
        HashMap<ServiceElement, List<ServiceElementHolder>> hashMap = this.serviceElementMap;
        synchronized (hashMap) {
            this.serviceElementCount = 0;
            this.serviceElementMap.clear();
            for (int i = 0; i < records.length; ++i) {
                ServiceElement sElem = records[i].getServiceElement();
                this.addServiceElementInstance(sElem, records[i].getServiceID());
            }
        }
    }

    String getName() {
        return this.instantiatorName;
    }

    Uuid getInstantiatorUuid() {
        return this.instantiatorUuid;
    }

    ServiceRecord[] getActiveServiceRecords() throws RemoteException {
        return this.getInstantiator().getServiceRecords(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasServiceElementInstance(ServiceElement sElem, Uuid uuid) {
        HashMap<ServiceElement, List<ServiceElementHolder>> hashMap = this.serviceElementMap;
        synchronized (hashMap) {
            List<ServiceElementHolder> list = this.serviceElementMap.get(sElem);
            if (list != null) {
                for (ServiceElementHolder serviceElementHolder : list) {
                    if (!uuid.equals((Object)serviceElementHolder.uuid)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceElementInstance(ServiceElement sElem, Uuid uuid) {
        HashMap<ServiceElement, List<ServiceElementHolder>> hashMap = this.serviceElementMap;
        synchronized (hashMap) {
            List<ServiceElementHolder> list = this.serviceElementMap.get(sElem);
            if (list != null) {
                Iterator<ServiceElementHolder> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ServiceElementHolder serviceElementHolder = iterator.next();
                    if (!uuid.equals((Object)serviceElementHolder.uuid)) continue;
                    iterator.remove();
                    --this.serviceElementCount;
                }
                if (list.isEmpty()) {
                    this.serviceElementMap.remove(sElem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceElement[] getServiceElements() {
        ArrayList<ServiceElement> result = new ArrayList<ServiceElement>(this.serviceElementCount);
        HashMap<ServiceElement, List<ServiceElementHolder>> hashMap = this.serviceElementMap;
        synchronized (hashMap) {
            Collection<List<ServiceElementHolder>> values = this.serviceElementMap.values();
            for (List<ServiceElementHolder> list : values) {
                for (ServiceElementHolder serviceElementHolder : list) {
                    result.add(serviceElementHolder.sElem);
                }
            }
        }
        return result.toArray(new ServiceElement[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceElement[] getAllServiceElements() {
        int i;
        ServiceElement[] serviceElementsInprocess;
        ServiceElement[] serviceElements;
        HashMap<ServiceElement, List<ServiceElement>> hashMap = this.inProcessMap;
        synchronized (hashMap) {
            HashMap<ServiceElement, List<ServiceElementHolder>> hashMap2 = this.serviceElementMap;
            synchronized (hashMap2) {
                serviceElements = this.getServiceElements();
                serviceElementsInprocess = this.getServiceElementsInprocess();
            }
        }
        if (serviceElements.length == 0) {
            return serviceElementsInprocess;
        }
        if (serviceElementsInprocess.length == 0) {
            return serviceElements;
        }
        ServiceElement[] elems = new ServiceElement[serviceElements.length + serviceElementsInprocess.length];
        for (i = 0; i < serviceElements.length; ++i) {
            elems[i] = serviceElements[i];
        }
        for (i = 0; i < serviceElementsInprocess.length; ++i) {
            elems[serviceElements.length + i] = serviceElementsInprocess[i];
        }
        return elems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearServiceElementInstances() {
        HashMap<ServiceElement, List<ServiceElementHolder>> hashMap = this.serviceElementMap;
        synchronized (hashMap) {
            this.serviceElementMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getServiceElementInstances(ServiceElement sElem) {
        int numInstances = 0;
        HashMap<ServiceElement, List<ServiceElementHolder>> hashMap = this.serviceElementMap;
        synchronized (hashMap) {
            List<ServiceElementHolder> list = this.serviceElementMap.get(sElem);
            if (list != null) {
                numInstances = list.size();
            }
        }
        return numInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getServiceElementCount() {
        HashMap<ServiceElement, List<ServiceElementHolder>> hashMap = this.serviceElementMap;
        synchronized (hashMap) {
            return this.serviceElementCount;
        }
    }

    ServiceBeanInstantiator getInstantiator() {
        return this.instantiator;
    }

    public MarshalledObject getHandback() {
        return this.handback;
    }

    ResourceCapability getResourceCapability() {
        return this.resourceCapability;
    }

    void setResourceCapability(ResourceCapability resourceCapability) {
        this.resourceCapability = resourceCapability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceLimit(int serviceLimit) {
        InstantiatorResource instantiatorResource = this;
        synchronized (instantiatorResource) {
            this.serviceLimit = serviceLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getServiceLimit() {
        int limit = 0;
        InstantiatorResource instantiatorResource = this;
        synchronized (instantiatorResource) {
            limit = this.serviceLimit;
        }
        return limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementProvisionCounter(ServiceElement sElem) {
        HashMap<ServiceElement, List<ServiceElement>> hashMap = this.inProcessMap;
        synchronized (hashMap) {
            ++this.inProcessCount;
            List<ServiceElement> list = this.inProcessMap.get(sElem);
            if (list == null) {
                ArrayList<ServiceElement> newList = new ArrayList<ServiceElement>(1);
                newList.add(sElem);
                this.inProcessMap.put(sElem, newList);
            } else {
                list.add(sElem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementProvisionCounter(ServiceElement sElem) {
        HashMap<ServiceElement, List<ServiceElement>> hashMap = this.inProcessMap;
        synchronized (hashMap) {
            List<ServiceElement> list = this.inProcessMap.get(sElem);
            if (list != null) {
                if (list.remove(sElem)) {
                    --this.inProcessCount;
                    if (list.isEmpty()) {
                        this.inProcessMap.remove(sElem);
                    }
                } else if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Decremented service: " + sElem + " not found. Mapping: " + this.inProcessMap);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInProcessCounter() {
        HashMap<ServiceElement, List<ServiceElement>> hashMap = this.inProcessMap;
        synchronized (hashMap) {
            return this.inProcessCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInProcessCounter(ServiceElement sElem) {
        int count = 0;
        HashMap<ServiceElement, List<ServiceElement>> hashMap = this.inProcessMap;
        synchronized (hashMap) {
            List<ServiceElement> list = this.inProcessMap.get(sElem);
            if (list != null) {
                count = list.size();
            }
        }
        return count;
    }

    public ServiceElement[] getServiceElementsInprocess() {
        return this.getServiceElementsInprocess(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceElement[] getServiceElementsInprocess(ServiceElement exclude) {
        boolean includeAll = exclude == null;
        ArrayList<ServiceElement> result = new ArrayList<ServiceElement>();
        HashMap<ServiceElement, List<ServiceElement>> hashMap = this.inProcessMap;
        synchronized (hashMap) {
            Collection<List<ServiceElement>> values = this.inProcessMap.values();
            for (List<ServiceElement> sElemList : values) {
                for (ServiceElement element : sElemList) {
                    if (!includeAll || element.equals(exclude)) continue;
                    result.add(element);
                }
            }
        }
        return result.toArray(new ServiceElement[result.size()]);
    }

    String getHostName() {
        return this.resourceCapability.getHostName();
    }

    String getHostAddress() {
        return this.resourceCapability.getAddress();
    }

    long getProcessId() {
        return this.resourceCapability.getProcessId();
    }

    String[] getZones() {
        return this.resourceCapability.getZones();
    }

    void setDynamicEnabledOn() {
        this.dynamicEnabled = true;
    }

    boolean getDynamicEnabled() {
        return this.dynamicEnabled;
    }

    boolean canProvision(ServiceElement sElem, InstantiatorResource[] deployedInstntiatorResources) throws IOException, ClassNotFoundException {
        int i;
        int numInstances;
        String provType;
        if (sElem.getPlanned() == 0) {
            return false;
        }
        String string = provType = sElem.getProvisionType() == 1 ? "Dynamic" : "Fixed";
        if (this.getServiceElementCount() == this.serviceLimit) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Do not allocate " + provType + " service [" + sElem + "] on " + this + ", service limit of [" + this.serviceLimit + "] has been met");
            }
            return false;
        }
        if (sElem.isRequiresIsolation() && (numInstances = this.getServiceElementCount() + this.getInProcessCounter()) != 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Do not allocate " + provType + " service [" + ServiceElementUtil.getNameWithId(sElem) + "] on " + this + ", requires isolation [" + sElem.isRequiresIsolation() + "] has been met");
            }
            return false;
        }
        if (sElem.getMaxPerMachine() != -1 && (numInstances = this.getServiceElementInstances(sElem) + this.getInProcessCounter(sElem)) >= sElem.getMaxPerMachine()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Do not allocate " + provType + " service [" + ServiceElementUtil.getNameWithId(sElem) + "] on " + this + ", maximum number of services [" + sElem.getMaxPerMachine() + "] per vm has been met");
            }
            return false;
        }
        if (sElem.getMaxPerPhysicalMachine() != -1 && deployedInstntiatorResources != null) {
            int count = 0;
            for (int i2 = 0; i2 < deployedInstntiatorResources.length; ++i2) {
                int deployedCount = deployedInstntiatorResources[i2].getServiceElementInstances(sElem) + deployedInstntiatorResources[i2].getInProcessCounter(sElem);
                if (deployedCount <= 0) continue;
                if (deployedInstntiatorResources[i2].getHostAddress().equals(this.getHostAddress()) && deployedInstntiatorResources[i2].getHostName().equals(this.getHostName())) {
                    count += deployedCount;
                }
                if (count < sElem.getMaxPerPhysicalMachine()) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Do not allocate " + provType + " service [" + ServiceElementUtil.getNameWithId(sElem) + "] on " + this + ", maximum number of services [" + sElem.getMaxPerPhysicalMachine() + "] per machine has been met");
                }
                return false;
            }
        }
        if (sElem.getRequiredZones() != null && sElem.getRequiredZones().length > 0) {
            boolean found = false;
            for (String requiredZone : sElem.getRequiredZones()) {
                if (!ZoneHelper.zoneExists((String)requiredZone, (String[])this.resourceCapability.getZones())) continue;
                found = true;
                break;
            }
            if (!found) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Do not allocate [" + sElem + "] on " + this + ", required zones: " + Arrays.toString(sElem.getRequiredZones()) + " are not met by existing zones: " + Arrays.toString(this.resourceCapability.getZones()));
                }
                return false;
            }
        }
        if (sElem.getMaxPerZone() != null && !sElem.getMaxPerZone().isEmpty() && deployedInstntiatorResources != null) {
            for (Map.Entry<String, Integer> entry : sElem.getMaxPerZone().entrySet()) {
                if (!ZoneHelper.zoneExists((String)entry.getKey(), (String[])this.getZones())) continue;
                int count = 0;
                for (i = 0; i < deployedInstntiatorResources.length; ++i) {
                    int deployedCount = deployedInstntiatorResources[i].getServiceElementInstances(sElem) + deployedInstntiatorResources[i].getInProcessCounter(sElem);
                    if (deployedCount <= 0) continue;
                    if (ZoneHelper.zoneExists((String)entry.getKey(), (String[])deployedInstntiatorResources[i].getZones())) {
                        count += deployedCount;
                    }
                    if (count < entry.getValue()) continue;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Do not allocate " + provType + " service [" + ServiceElementUtil.getNameWithId(sElem) + "] on " + this + ", maximum number of services [" + entry.getValue() + "] per zone [" + entry.getKey() + "] has been met");
                    }
                    return false;
                }
            }
        }
        if (sElem.getProvisionType() == 2) {
            int actual;
            int planned = sElem.getPlanned();
            int numAllowed = planned - (actual = this.getServiceElementInstances(sElem));
            if (numAllowed <= 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Do not allocate " + provType + " service [" + sElem + "] on " + this + ", has [" + actual + "] instance(s), planned [" + planned + "]");
                }
                return false;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, this + ", has [" + actual + "] instance(s), planned [" + planned + "] of " + provType + " service [" + sElem + "]");
            }
        }
        if (!this.meetsColocationRequirements(sElem)) {
            if (logger.isLoggable(Level.FINER)) {
                StringBuffer b = new StringBuffer();
                b.append("Do not allocate " + provType + " service [" + sElem + "] on " + this + ", required collocated services not present: ");
                AssociationDescriptor[] aDesc = sElem.getAssociationDescriptors();
                int found = 0;
                for (i = 0; i < aDesc.length; ++i) {
                    if (aDesc[i].getAssociationType().getType() != 3) continue;
                    if (found > 0) {
                        b.append(", ");
                    }
                    ++found;
                    b.append(aDesc[i].getName());
                }
                logger.finer("{" + b.toString() + "}");
            }
            return false;
        }
        if (!this.meetsOpposedRequirements(sElem)) {
            return false;
        }
        if (!this.resourceCapability.measuredResourcesWithinRange()) {
            if (logger.isLoggable(Level.FINER)) {
                StringBuffer buffer = new StringBuffer();
                MeasuredResource[] badResources = this.resourceCapability.getMeasuredResources(2);
                for (int i3 = 0; i3 < badResources.length; ++i3) {
                    buffer.append("\n[" + badResources[i3].getIdentifier() + "] Low=[" + badResources[i3].getThresholdValues().getLowThreshold() + "], High=[" + badResources[i3].getThresholdValues().getHighThreshold() + "], Actual=[" + badResources[i3].getValue() + "]");
                }
                logger.finer(this + " not eligible for " + provType + " service [" + sElem + "], MeasuredResources have exceeded threshold constraints : " + buffer.toString());
            }
            return false;
        }
        if (this.meetsGeneralRequirements(sElem) && this.meetsQuantitativeRequirements(sElem)) {
            Collection unsupportedReqs = this.meetsQualitativeRequirements(sElem.getServiceLevelAgreements());
            if (unsupportedReqs.size() == 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this + " meets qualitative requirements for [" + sElem + "]");
                }
                return true;
            }
            int x = 0;
            StringBuffer buffer = new StringBuffer();
            Iterator it = unsupportedReqs.iterator();
            while (it.hasNext()) {
                if (x > 0) {
                    buffer.append(", ");
                }
                buffer.append("[" + it.next().toString() + "]");
                ++x;
            }
            String unsupportedReqsString = buffer.toString();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this + " does not meet qualitative requirements for " + provType + " service [" + sElem + "], determine if SystemRequirement objects can be provisioned : " + unsupportedReqsString);
            }
            if (!this.resourceCapability.supportsPersistentProvisioning()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Cannot allocate " + provType + " service [" + sElem + "] to " + this + ", required SystemRequirement objects cannot be provisioned");
                }
                return false;
            }
            boolean provisionableCaps = true;
            for (ServiceLevelAgreements.SystemRequirement sysReq : unsupportedReqs) {
                if (sysReq.getSoftwareLoad() != null) continue;
                provisionableCaps = false;
                break;
            }
            if (!provisionableCaps) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this + " does not meet qualitative requirements for " + provType + "service [" + sElem + "] PlatformCapability objects are not be provisionable : " + unsupportedReqsString);
                }
                return false;
            }
            int requiredSize = 0;
            for (ServiceLevelAgreements.SystemRequirement sysReq : unsupportedReqs) {
                requiredSize += sysReq.getSoftwareLoad().getSoftwareDownloadAttributes().getDownloadSize();
                if (sysReq.getSoftwareLoad().getPostInstallAttributes() == null || sysReq.getSoftwareLoad().getPostInstallAttributes().getSoftwareDownloadAttributes() == null) continue;
                requiredSize += sysReq.getSoftwareLoad().getPostInstallAttributes().getSoftwareDownloadAttributes().getDownloadSize();
            }
            if (requiredSize < 0) {
                throw new IOException("Unable to obtain SoftwareLoad size");
            }
            if (this.supportsStorageRequirement(requiredSize, this.resourceCapability.getPlatformCapabilities())) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this + " supports provisioning requirements for " + provType + " service [" + sElem + "]");
                }
                sElem.setProvisionablePlatformCapabilities(unsupportedReqs);
                return true;
            }
            if (logger.isLoggable(Level.FINER)) {
                double avail = this.getAvailableStorage(this.resourceCapability.getPlatformCapabilities());
                double GB = Math.pow(1024.0, 3.0);
                logger.finer(this + " does not have adequate disk-space for " + provType + "service [" + sElem + "]. Required=" + requiredSize + ", Available=" + (avail /= GB) + " GB");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this + " does not meet general or quantitative requirements for " + provType + " service [" + sElem + "]");
        }
        return false;
    }

    boolean supportsStorageRequirement(int requestedSize, PlatformCapability[] pCaps) {
        boolean supports = false;
        for (int i = 0; i < pCaps.length; ++i) {
            if (!(pCaps[i] instanceof StorageCapability)) continue;
            try {
                StorageCapability storage = (StorageCapability)pCaps[i];
                supports = storage.supports(requestedSize);
                break;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return supports;
    }

    boolean supportsSystemRequirement(int requestedSize, Class requirement, PlatformCapability[] pCaps) {
        boolean supports = false;
        for (int i = 0; i < pCaps.length; ++i) {
            if (!pCaps[i].getClass().isAssignableFrom(requirement)) continue;
            try {
                StorageCapability storage = (StorageCapability)pCaps[i];
                supports = storage.supports(requestedSize);
                break;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return supports;
    }

    double getAvailableStorage(PlatformCapability[] pCaps) {
        double available = -1.0;
        for (int i = 0; i < pCaps.length; ++i) {
            if (!(pCaps[i] instanceof StorageCapability)) continue;
            StorageCapability storage = (StorageCapability)pCaps[i];
            Double dCap = (Double)storage.getValue("Capacity");
            if (dCap == null) break;
            available = dCap;
            break;
        }
        return available;
    }

    boolean meetsGeneralRequirements(ServiceElement sElem) throws ClassNotFoundException {
        String[] machineCluster = sElem.getCluster();
        if (machineCluster != null && machineCluster.length > 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("ServiceBean [" + sElem + "] has a cluster requirement");
            }
            boolean found = false;
            for (int i = 0; i < machineCluster.length; ++i) {
                if (!machineCluster[i].equals(this.resourceCapability.getAddress()) && !machineCluster[i].equals(this.resourceCapability.getHostName())) continue;
                found = true;
            }
            if (!found) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this + " not found in cluster requirement for [" + sElem + "]");
                }
                return false;
            }
        }
        return true;
    }

    boolean meetsColocationRequirements(ServiceElement sElem) {
        boolean provisionable = true;
        AssociationDescriptor[] aDescs = sElem.getAssociationDescriptors();
        for (int i = 0; i < aDescs.length; ++i) {
            boolean ok = false;
            if (aDescs[i].getAssociationType().getType() == 3) {
                if (this.matches(this.getAssociationMatchFilter(aDescs[i]), aDescs[i], this.getServiceElements())) {
                    ok = true;
                    break;
                }
            } else {
                ok = true;
            }
            if (ok) continue;
            provisionable = false;
            break;
        }
        return provisionable;
    }

    boolean meetsOpposedRequirements(ServiceElement sElem) {
        int i;
        boolean provisionable = true;
        AssociationDescriptor[] aDescs = sElem.getAssociationDescriptors();
        StringBuffer errorLog = new StringBuffer();
        String provType = sElem.getProvisionType() == 1 ? "Dynamic" : "Fixed";
        errorLog.append("Do not allocate " + provType + " service [" + sElem + "] to " + this);
        for (i = 0; i < aDescs.length; ++i) {
            if (aDescs[i].getAssociationType().getType() != 4 || !this.matches(this.getAssociationMatchFilter(aDescs[i]), aDescs[i], this.getServiceElementsInprocess(sElem))) continue;
            provisionable = false;
            break;
        }
        if (provisionable) {
            for (i = 0; i < aDescs.length; ++i) {
                if (aDescs[i].getAssociationType().getType() != 4 || !this.matches(this.getAssociationMatchFilter(aDescs[i]), aDescs[i], this.getServiceElements())) continue;
                provisionable = false;
                break;
            }
        }
        if (!provisionable) {
            errorLog.append("opposed services detected: ");
            AssociationDescriptor[] aDesc = sElem.getAssociationDescriptors();
            for (int i2 = 0; i2 < aDesc.length; ++i2) {
                if (aDesc[i2].getAssociationType().getType() != 4) continue;
                if (i2 > 0) {
                    errorLog.append(", ");
                }
                errorLog.append("[" + (i2 + 1) + "] " + aDesc[i2].getName());
            }
        }
        if (provisionable) {
            ServiceElement[] elems = this.getServiceElements();
            int found = 0;
            StringBuffer b = new StringBuffer();
            block3: for (int i3 = 0; i3 < elems.length; ++i3) {
                AssociationDescriptor[] ad = elems[i3].getAssociationDescriptors();
                for (int j = 0; j < ad.length; ++j) {
                    if (ad[j].getAssociationType().getType() != 4 || !this.matches(this.getAssociationMatchFilter(ad[j]), ad[j], new ServiceElement[]{sElem})) continue;
                    if (logger.isLoggable(Level.FINER)) {
                        if (found > 0) {
                            b.append(", ");
                        }
                        ++found;
                        b.append(ad[i3].getName());
                        continue;
                    }
                    ++found;
                    continue block3;
                }
            }
            if (found > 0) {
                provisionable = false;
                errorLog.append("existing services have opposed associations: ");
                errorLog.append("{" + b.toString() + "}");
            }
        }
        if (!provisionable && logger.isLoggable(Level.FINER)) {
            logger.finer(errorLog.toString());
        }
        return provisionable;
    }

    private boolean matches(AssociationMatchFilter filter, AssociationDescriptor descriptor, ServiceElement[] elems) {
        boolean matches = false;
        for (int i = 0; i < elems.length; ++i) {
            if (!filter.check(descriptor, elems[i])) continue;
            matches = true;
            break;
        }
        return matches;
    }

    Collection meetsQualitativeRequirements(ServiceLevelAgreements sla) throws ClassNotFoundException {
        PlatformCapability[] platformCapabilities = this.resourceCapability.getPlatformCapabilities();
        ServiceLevelAgreements.SystemRequirement[] jsbRequirements = sla.getSystemRequirements();
        ArrayList<ServiceLevelAgreements.SystemRequirement> unsupportedReqs = new ArrayList<ServiceLevelAgreements.SystemRequirement>();
        if (jsbRequirements.length == 0) {
            return unsupportedReqs;
        }
        for (int i = 0; i < jsbRequirements.length; ++i) {
            boolean supported = false;
            for (int j = 0; j < platformCapabilities.length; ++j) {
                if (!platformCapabilities[j].supports(jsbRequirements[i])) continue;
                supported = true;
                break;
            }
            if (supported) continue;
            unsupportedReqs.add(jsbRequirements[i]);
        }
        return unsupportedReqs;
    }

    boolean meetsQuantitativeRequirements(ServiceElement sElem) {
        ServiceLevelAgreements sla = sElem.getServiceLevelAgreements();
        boolean provisionable = true;
        String[] systemThresholdIDs = sla.getSystemThresholdIDs();
        if (systemThresholdIDs.length == 0) {
            return true;
        }
        MeasuredResource[] measured = this.resourceCapability.getMeasuredResources();
        if (measured == null || measured.length < systemThresholdIDs.length) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this + " only has [" + measured.length + "] MeasuredCapability instances, ServiceBean [" + sElem + "] has a requirement to test [" + systemThresholdIDs.length + "]");
            }
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        if (logger.isLoggable(Level.FINER)) {
            buffer.append("Evaluate [" + systemThresholdIDs.length + "] System Threshold Requirements for [" + sElem + "] using " + this);
        }
        for (int i = 0; i < systemThresholdIDs.length; ++i) {
            boolean supported = false;
            ThresholdValues systemThreshold = sla.getSystemThresholdValue(systemThresholdIDs[i]);
            if (systemThresholdIDs[i].equals("System")) {
                double systemUtilization = systemThreshold.getHighThreshold();
                if (systemUtilization < this.resourceCapability.getUtilization()) {
                    if (logger.isLoggable(Level.FINER)) {
                        buffer.append("\nCannot meet system utilization requirement. Desired [" + systemUtilization + "], Actual [" + this.resourceCapability.getUtilization() + "]");
                        logger.finest(buffer.toString());
                    }
                    return false;
                }
                supported = true;
                if (logger.isLoggable(Level.FINER)) {
                    buffer.append("\n[System] utilization requirement met. Desired [" + systemUtilization + "], Actual [" + this.resourceCapability.getUtilization() + "]");
                }
            }
            for (int j = 0; j < measured.length; ++j) {
                if (!measured[j].getIdentifier().equals(systemThresholdIDs[i])) continue;
                if (measured[j].evaluate(systemThreshold)) {
                    supported = true;
                    if (!logger.isLoggable(Level.FINER)) break;
                    buffer.append("\n[" + systemThresholdIDs[i] + "] utilization requirement met. Desired Low=[" + systemThreshold.getLowThreshold() + "], High=[" + systemThreshold.getHighThreshold() + "], Actual=[" + measured[j].getValue() + "]");
                    break;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                buffer.append("\nCannot meet [" + systemThresholdIDs[i] + "] utilization requirement. Desired Low=[" + systemThreshold.getLowThreshold() + "], High=[" + systemThreshold.getHighThreshold() + "], Actual=[" + measured[j].getValue() + "]");
            }
            if (supported) continue;
            provisionable = false;
            break;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(buffer.toString());
        }
        return provisionable;
    }

    private AssociationMatchFilter getAssociationMatchFilter(AssociationDescriptor descriptor) {
        DefaultAssociationMatchFilter defaultFilter = new DefaultAssociationMatchFilter();
        Configuration config = null;
        AssociationMatchFilter filter = null;
        try {
            config = ConfigurationProvider.getInstance((String[])descriptor.getConfigArgs());
            filter = (AssociationMatchFilter)config.getEntry("service.association", "filter", AssociationMatchFilter.class, (Object)defaultFilter);
        }
        catch (ConfigurationException e) {
            filter = defaultFilter;
            logger.log(Level.WARNING, "Getting AssociationMatchFilter for association [" + descriptor.toString() + "]", e);
        }
        return filter;
    }

    public String toString() {
        if (this.getProcessId() == -1L) {
            return this.getName() + " host[" + this.getHostName() + "/" + this.getHostAddress() + "] service-id[" + this.getInstantiatorUuid() + "]";
        }
        return this.getName() + " pid[" + this.getProcessId() + "] host[" + this.getHostName() + "/" + this.getHostAddress() + "] service-id[" + this.getInstantiatorUuid() + "]";
    }

    class DefaultAssociationMatchFilter
    implements AssociationMatchFilter {
        static final String SPACE_PROPERTY_PREFIX = "gs.space.url.arg.";

        DefaultAssociationMatchFilter() {
        }

        @Override
        public boolean check(AssociationDescriptor descriptor, ServiceElement element) {
            String[] configArgs = element.getServiceBeanConfig().getConfigArgs();
            boolean isGS = false;
            for (int i = 0; i < configArgs.length; ++i) {
                if (configArgs[i].indexOf("SpaceHandler") == -1) continue;
                isGS = true;
                break;
            }
            if (!isGS) {
                return ServiceElementUtil.matchesServiceElement(element, descriptor.getName(), descriptor.getInterfaceNames(), descriptor.getOperationalStringName());
            }
            String spaceName = element.getName();
            Properties spaceProps = new Properties();
            spaceProps.putAll((Map<?, ?>)element.getServiceBeanConfig().getInitParameters());
            if (!descriptor.getName().equals(element.getName()) && spaceProps.getProperty("gs.space.url.arg.spaceName") != null) {
                spaceName = spaceProps.getProperty("gs.space.url.arg.spaceName");
            }
            return spaceName.equals(descriptor.getName());
        }
    }

    private static final class ServiceElementHolder {
        final ServiceElement sElem;
        final Uuid uuid;

        ServiceElementHolder(ServiceElement sElem, Uuid uuid) {
            this.sElem = sElem;
            this.uuid = uuid;
        }
    }
}

