/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.sun.jini.landlord.LeasedResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.ServiceResourceSelector;
import org.jini.rio.resources.servicecore.ServiceResource;

public class LeastActiveSelector
extends ServiceResourceSelector {
    private static final Logger LOGGER = Logger.getLogger(LeastActiveSelector.class.getName());
    private final LeastActiveComparator comparator = new LeastActiveComparator();

    public LeastActiveSelector() {
        this.collection = new ArrayList();
    }

    @Override
    public void serviceResourceSelected(ServiceResource resource) {
    }

    @Override
    protected void update(LeasedResource resource) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort() {
        StringBuilder logBuff = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            logBuff = new StringBuilder("\n");
        }
        ArrayList tmp = new ArrayList(this.collection.size());
        Collection collection = this.collection;
        synchronized (collection) {
            tmp.addAll(this.collection);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            logBuff.append("Sorting: ").append(Arrays.asList(tmp)).append("\n");
        }
        Collections.sort(tmp, this.comparator);
        if (LOGGER.isLoggable(Level.FINEST)) {
            logBuff.append("Sorted: ").append(Arrays.asList(this.collection)).append("\n");
        }
        collection = this.collection;
        synchronized (collection) {
            tmp.retainAll(this.collection);
            this.collection.removeAll(tmp);
            this.collection.addAll(tmp);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            logBuff.append("Returned: ").append(Arrays.asList(this.collection)).append("\n");
            LOGGER.finest(logBuff.toString());
        }
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem, Uuid uuid, boolean inclusive) throws Exception {
        this.sort();
        return super.getServiceResource(sElem, uuid, inclusive);
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement elem, Set<Uuid> excludedUuids) throws Exception {
        this.sort();
        return super.getServiceResource(elem, excludedUuids);
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem) throws Exception {
        this.sort();
        return super.getServiceResource(sElem);
    }

    private class LeastActiveComparator
    implements Comparator {
        private LeastActiveComparator() {
        }

        public int compare(Object object1, Object object2) {
            if (object1 == object2) {
                return 0;
            }
            int count1 = 0;
            int planned1 = 0;
            int count2 = 0;
            int planned2 = 0;
            ServiceResource serviceResource1 = (ServiceResource)object1;
            try {
                InstantiatorResource instantiatorResource1 = (InstantiatorResource)serviceResource1.getResource();
                count1 = instantiatorResource1.getActiveServiceRecords().length;
                planned1 = instantiatorResource1.getInProcessCounter();
            }
            catch (Throwable throwable) {
                count1 = Integer.MAX_VALUE;
                LeastActiveSelector.this.dropServiceResource(serviceResource1);
            }
            ServiceResource serviceResource2 = (ServiceResource)object2;
            try {
                InstantiatorResource instantiatorResource2 = (InstantiatorResource)serviceResource2.getResource();
                count2 = instantiatorResource2.getActiveServiceRecords().length;
                planned2 = instantiatorResource2.getInProcessCounter();
            }
            catch (Throwable throwable) {
                count2 = Integer.MAX_VALUE;
                LeastActiveSelector.this.dropServiceResource(serviceResource2);
            }
            return count1 + planned1 - (count2 + planned2);
        }
    }
}

