/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.grid.zone.ZoneHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.PriorityZoneComponent;
import org.jini.rio.monitor.RoundRobinSelector;
import org.jini.rio.resources.servicecore.ServiceResource;

public class LeastRoundRobinSelector
extends RoundRobinSelector {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.selector");
    private static final ContainerComparator containerComparator = new ContainerComparator();

    public LeastRoundRobinSelector() {
        this.collection = new LinkedList();
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem, Uuid uuid, boolean inclusive) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem, uuid, inclusive);
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem, Set<Uuid> excludedUuids) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem, excludedUuids);
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort(ServiceElement sElem) {
        ArrayList<ServiceResource> listOfResources = new ArrayList<ServiceResource>(this.collection.size());
        Collection collection = this.collection;
        synchronized (collection) {
            listOfResources.addAll(this.collection);
        }
        this.sort(sElem, listOfResources);
        collection = this.collection;
        synchronized (collection) {
            listOfResources.retainAll(this.collection);
            this.collection.removeAll(listOfResources);
            ((LinkedList)this.collection).addAll(0, listOfResources);
        }
    }

    private void sort(ServiceElement sElem, Collection<ServiceResource> listOfResources) {
        boolean probPrimary = true;
        String primaryZoneStr = (String)sElem.getServiceBeanConfig().getInitParameters().get("primaryZone");
        LinkedHashSet primaryZone = primaryZoneStr != null ? ZoneHelper.parseZones((String)primaryZoneStr) : null;
        ArrayList<Container> containers = new ArrayList<Container>(listOfResources.size());
        for (ServiceResource serviceResource : listOfResources) {
            InstantiatorResource instantiatorResource = (InstantiatorResource)serviceResource.getResource();
            Container container = new Container(serviceResource);
            container.setZones(instantiatorResource.getZones());
            if (primaryZoneStr != null && (instantiatorResource.getServiceElementInstances(sElem) > 0 || instantiatorResource.getInProcessCounter(sElem) > 0)) {
                probPrimary = false;
            }
            container.calcWeight();
            containers.add(container);
        }
        if (primaryZoneStr != null) {
            sElem.setProbPrimary(probPrimary);
            for (Container container : containers) {
                container.setPriorityZone(primaryZone, probPrimary);
            }
        }
        Collections.sort(containers, containerComparator);
        if (logger.isLoggable(Level.FINE)) {
            String msg = this.toString(containers);
            logger.fine("Sorting for : " + sElem + "\n" + msg);
        }
        listOfResources.clear();
        for (Container container : containers) {
            listOfResources.add(container.serviceResource);
        }
    }

    private String toString(List<Container> containers) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (Container container : containers) {
            InstantiatorResource resource = (InstantiatorResource)container.serviceResource.getResource();
            sb.append(resource).append(" weights: ").append(container.getWeight()).append(" actual: ").append(container.getActual()).append(" planned: ").append(container.getPlanned());
            if (logger.isLoggable(Level.FINEST)) {
                sb.append(" zones: ").append(container.getZones());
                sb.append(" priorityZone: ").append(container.getPriorityZone());
            }
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static final class ContainerComparator
    implements Comparator<Container> {
        private ContainerComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            if (c1.getPriorityZone() == c2.getPriorityZone()) {
                if (c1.getWeight() == c2.getWeight()) {
                    return c1.getPlanned() - c2.getPlanned();
                }
                return c1.getWeight() - c2.getWeight();
            }
            return c1.getPriorityZone() - c2.getPriorityZone();
        }
    }

    private static final class Container
    extends PriorityZoneComponent {
        private final ServiceResource serviceResource;
        int actual;
        int planned;

        public Container(ServiceResource serviceResource) {
            this.serviceResource = serviceResource;
        }

        public void calcWeight() {
            InstantiatorResource instantiatorResource = (InstantiatorResource)this.serviceResource.getResource();
            List<ServiceElement> actualElements = Arrays.asList(instantiatorResource.getServiceElements());
            ArrayList<ServiceElement> plannedElements = new ArrayList<ServiceElement>(Arrays.asList(instantiatorResource.getServiceElementsInprocess()));
            plannedElements.removeAll(actualElements);
            this.actual = actualElements.size();
            this.planned = plannedElements.size();
        }

        public int getActual() {
            return this.actual;
        }

        public int getPlanned() {
            return this.planned;
        }

        public int getWeight() {
            return this.getActual() + this.getPlanned();
        }
    }
}

