/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.jsb.ServiceBeanState;
import org.jini.rio.core.jsb.ServiceState;
import org.jini.rio.log.LogBuffer;
import org.jini.rio.monitor.InstantiatorResource;

@Deprecated
public class MaxPrimariesPerPhysicalMachine {
    private static final LogBuffer logBuffer = LogBuffer.getLogger(MaxPrimariesPerPhysicalMachine.class.getName());
    private final InstantiatorResource thisGsc;
    private final ServiceElement newService;
    private final InstantiatorResource[] allGscs;

    public MaxPrimariesPerPhysicalMachine(InstantiatorResource instantiatorResource, ServiceElement newService, InstantiatorResource[] deployedInstantiatorResources) {
        this.thisGsc = instantiatorResource;
        this.newService = newService;
        this.allGscs = deployedInstantiatorResources;
        if (logBuffer.isLoggable(Level.FINEST)) {
            logBuffer.append("\n Trying to allocate ").append(newService).append(" on ").append(this.thisGsc);
        }
    }

    public boolean meetsConstraint() {
        try {
            int maxPrimariesPerPhysicalMachine = this.calculateMaxPrimariesPerPhysicalMachine(this.numberOfPhysicalMachines());
            if (this.isConstraintMeaningless(maxPrimariesPerPhysicalMachine)) {
                boolean bl = true;
                return bl;
            }
            if (this.serviceWillServeAsBackup()) {
                boolean bl = true;
                return bl;
            }
            if (this.meetsConstraint(maxPrimariesPerPhysicalMachine, this.gscsOnThisPhysicalMachine())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (logBuffer.isLoggable(Level.FINEST)) {
                logBuffer.flush(Level.FINEST);
            }
        }
    }

    private boolean isConstraintMeaningless(int maxPrimariesPerPhysicalMachine) {
        return maxPrimariesPerPhysicalMachine == this.newService.getTotalNumberOfServices();
    }

    private boolean serviceWillServeAsBackup() {
        for (InstantiatorResource gsc : this.allGscs) {
            ServiceElement[] serviceElements;
            for (ServiceElement service : serviceElements = gsc.getAllServiceElements()) {
                if (!this.isFromSamePartition(service)) continue;
                if (logBuffer.isLoggable(Level.FINEST)) {
                    logBuffer.append("\n\t found ").append(service).append(" from same partition on ").append(gsc).append("\n\t --> will serve as backup.");
                }
                return true;
            }
        }
        return false;
    }

    private boolean isFromSamePartition(ServiceElement examinedService) {
        return this.isFromSameCluster(examinedService) && this.newService.isSameServiceName(examinedService);
    }

    private int numberOfPhysicalMachines() {
        HashSet<String> listOfPhysicalMachines = new HashSet<String>();
        for (InstantiatorResource gsc : this.allGscs) {
            listOfPhysicalMachines.add(gsc.getHostAddress());
        }
        return listOfPhysicalMachines.size();
    }

    private int calculateMaxPrimariesPerPhysicalMachine(int numberOfPhysicalMachines) {
        int maxPrimariesPerPhysicalMachine = (int)Math.ceil(1.0 * (double)this.newService.getTotalNumberOfServices() / (double)numberOfPhysicalMachines);
        return maxPrimariesPerPhysicalMachine;
    }

    private InstantiatorResource[] gscsOnThisPhysicalMachine() {
        ArrayList<InstantiatorResource> gscsOnThisPhysicalMachine = new ArrayList<InstantiatorResource>();
        for (InstantiatorResource gsc : this.allGscs) {
            if (!this.thisGsc.getHostAddress().equals(gsc.getHostAddress())) continue;
            gscsOnThisPhysicalMachine.add(gsc);
        }
        return gscsOnThisPhysicalMachine.toArray(new InstantiatorResource[gscsOnThisPhysicalMachine.size()]);
    }

    private boolean meetsConstraint(int maxPrimariesPerPhysicalMachine, InstantiatorResource[] gscsOnThisPhysicalMachine) {
        int totalPrimariesFound = 0;
        for (InstantiatorResource gsc : gscsOnThisPhysicalMachine) {
            int maxMatches;
            int primariesOnGsc;
            if ((totalPrimariesFound += (primariesOnGsc = this.lookupPrimariesOnGSC(gsc, maxMatches = maxPrimariesPerPhysicalMachine - totalPrimariesFound))) < maxPrimariesPerPhysicalMachine) continue;
            return false;
        }
        return true;
    }

    private int lookupPrimariesOnGSC(InstantiatorResource gsc, int maxMatches) {
        Object[] servicesFromSameCluster = this.getAllServiceElementsFromSameCluster(gsc);
        if (logBuffer.isLoggable(Level.FINEST)) {
            logBuffer.append("\n\t looking for primaries on ").append(gsc).append(", maxMatches: " + maxMatches).append("\n\t services from same cluster: ").append(Arrays.toString(servicesFromSameCluster));
        }
        int numOfPrimaries = 0;
        for (ServiceElement serviceElement : servicesFromSameCluster) {
            if (!this.containsAPrimaryService(gsc, serviceElement)) continue;
            ++numOfPrimaries;
            if (logBuffer.isLoggable(Level.FINEST)) {
                logBuffer.append("\n\t - found primary of partition: ").append(serviceElement.getName()).append(", numOfPrimaries: ").append(numOfPrimaries);
            }
            if (numOfPrimaries >= maxMatches) break;
        }
        return numOfPrimaries;
    }

    private ServiceElement[] getAllServiceElementsFromSameCluster(InstantiatorResource gsc) {
        ServiceElement[] allServiceElements;
        ArrayList<ServiceElement> list = new ArrayList<ServiceElement>();
        for (ServiceElement serviceElement : allServiceElements = gsc.getAllServiceElements()) {
            if (!this.isFromSameCluster(serviceElement)) continue;
            list.add(serviceElement);
        }
        return list.toArray(new ServiceElement[list.size()]);
    }

    private boolean isFromSameCluster(ServiceElement examinedService) {
        return this.newService.isSameOperationalString(examinedService);
    }

    private boolean containsAPrimaryService(InstantiatorResource gsc, ServiceElement service) {
        block3: {
            try {
                ServiceBeanInstance[] serviceBeanInstances;
                for (ServiceBeanInstance serviceInstance : serviceBeanInstances = this.getServiceBeanInstances(gsc, service)) {
                    Object serviceObj = serviceInstance.getService();
                    if (!this.isServiceAPrimary(serviceObj)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                if (!logBuffer.isLoggable(Level.FINEST)) break block3;
                logBuffer.append("\n\t failed to determine if GSC contains a primary, caught: ", e);
            }
        }
        return false;
    }

    private ServiceBeanInstance[] getServiceBeanInstances(InstantiatorResource gsc, ServiceElement service) throws RemoteException {
        int retries;
        if (logBuffer.isLoggable(Level.FINEST)) {
            logBuffer.append("\n\t looking for primary of partition: ").append(service.getName());
        }
        ServiceBeanInstance[] serviceBeanInstances = gsc.getInstantiator().getServiceBeanInstances(service);
        int max_retries = 120;
        for (retries = 0; retries < max_retries && serviceBeanInstances.length == 0 && gsc.getInProcessCounter(service) > 0; ++retries) {
            this.sleep(1000L);
            serviceBeanInstances = gsc.getInstantiator().getServiceBeanInstances(service);
        }
        if (logBuffer.isLoggable(Level.FINEST)) {
            logBuffer.append("\n\t ..retries: ").append(retries).append(", instances: ").append(serviceBeanInstances.length);
        }
        return serviceBeanInstances;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isServiceAPrimary(Object serviceObj) {
        block6: {
            try {
                Class<?> puServiceClass = Thread.currentThread().getContextClassLoader().loadClass("org.openspaces.pu.container.servicegrid.PUServiceBean");
                if (puServiceClass.isAssignableFrom(serviceObj.getClass())) {
                    ServiceState serviceState;
                    int state;
                    if (serviceObj instanceof ServiceState && (state = this.getServiceState(serviceState = (ServiceState)serviceObj)) != 5) {
                        return false;
                    }
                    Object[] spacesModes = (SpaceMode[])puServiceClass.getMethod("listSpacesModes", new Class[0]).invoke(serviceObj, new Object[0]);
                    if (logBuffer.isLoggable(Level.FINEST)) {
                        logBuffer.append("\n\t - service modes: ").append(Arrays.toString(spacesModes));
                    }
                    for (Object mode : spacesModes) {
                        if (!mode.equals((Object)SpaceMode.PRIMARY)) continue;
                        return true;
                    }
                    break block6;
                }
                return false;
            }
            catch (Exception e) {
                if (!logBuffer.isLoggable(Level.FINEST)) break block6;
                logBuffer.append("\n\t failed to determine if service is a primary, caught: ", e);
            }
        }
        return false;
    }

    private int getServiceState(ServiceState serviceState) throws RemoteException {
        int state = serviceState.getState();
        while (ServiceBeanState.isInProgress(state) && !ServiceBeanState.hasErrors(state)) {
            if (logBuffer.isLoggable(Level.FINEST)) {
                logBuffer.append("\n\t ..service state: ").append(ServiceBeanState.toString(state));
            }
            this.sleep(5000L);
            state = serviceState.getState();
        }
        if (logBuffer.isLoggable(Level.FINEST)) {
            logBuffer.append(", service state: ").append(ServiceBeanState.toString(state));
        }
        return state;
    }
}

