/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.monitor.ProvisionMonitorImpl;
import org.jini.rio.monitor.ProvisionRequest;
import org.jini.rio.resources.servicecore.ServiceResource;

abstract class PendingServiceElementManager {
    TreeMap<Key, ProvisionRequest> collection = new TreeMap();
    long collectionIndex = 1L;
    String type;
    static Logger logger = ProvisionMonitorImpl.logger;

    PendingServiceElementManager(String type) {
        this.type = type;
    }

    String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean addProvisionRequest(ProvisionRequest request, long index) {
        Long l;
        int added;
        block12: {
            if (this.isUndeployed(request)) {
                if (!logger.isLoggable(Level.FINER)) return false;
                logger.finer("Ignore addition of provision request for [" + request.sElem + "] - " + request.sElem.getOperationalStringName() + " has been un-deployed");
                return false;
            }
            added = 0;
            try {
                ProvisionRequest[] provisionRequests;
                TreeMap<Key, ProvisionRequest> treeMap = this.collection;
                // MONITORENTER : treeMap
                for (ProvisionRequest next : provisionRequests = this.getProvisionRequests(request.sElem)) {
                    if (!this.equalProvisionRequests(request, next)) continue;
                    added = 0;
                    int n = 0;
                    // MONITOREXIT : treeMap
                    if (added) {
                        if (!logger.isLoggable(Level.FINEST)) return n != 0;
                        logger.finer("Accept addition of provision request for [" + request.sElem + "]");
                        return n != 0;
                    }
                    if (!logger.isLoggable(Level.FINER)) return n != 0;
                    logger.finer("Ignore addition of duplicate provision request for [" + request.sElem + "]");
                    return n != 0;
                }
                if (index == 0L) {
                    long l2 = this.collectionIndex++;
                    l = new Long(l2);
                    break block12;
                }
                l = new Long(index);
            }
            catch (Throwable throwable) {
                if (added) {
                    if (!logger.isLoggable(Level.FINEST)) throw throwable;
                    logger.finer("Accept addition of provision request for [" + request.sElem + "]");
                    throw throwable;
                }
                if (!logger.isLoggable(Level.FINER)) throw throwable;
                logger.finer("Ignore addition of duplicate provision request for [" + request.sElem + "]");
                throw throwable;
            }
        }
        Long keyIndex = l;
        Key key = new Key(request.sElem, keyIndex, request.timestamp);
        request.markPending(true);
        this.collection.put(key, request);
        added = 1;
        int n = 1;
        // MONITOREXIT : treeMap
        if (added) {
            if (!logger.isLoggable(Level.FINEST)) return n != 0;
            logger.finer("Accept addition of provision request for [" + request.sElem + "]");
            return n != 0;
        }
        if (!logger.isLoggable(Level.FINER)) return n != 0;
        logger.finer("Ignore addition of duplicate provision request for [" + request.sElem + "]");
        return n != 0;
    }

    public boolean equalProvisionRequests(ProvisionRequest request, ProvisionRequest other) {
        if (request.sElem.equals(other.sElem)) {
            Long id = request.sElem.getInstanceId();
            Long otherId = other.sElem.getInstanceId();
            return id.equals(otherId);
        }
        return false;
    }

    public boolean isUndeployed(ProvisionRequest request) {
        boolean undeployed;
        block2: {
            undeployed = false;
            try {
                int deploymentStatus = request.opStringMgr.getOperationalString().getStatus();
                undeployed = 0 == deploymentStatus;
            }
            catch (RemoteException e) {
                undeployed = true;
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "Failed to add provision request - " + e, e);
            }
        }
        return undeployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSize() {
        int size = 0;
        TreeMap<Key, ProvisionRequest> treeMap = this.collection;
        synchronized (treeMap) {
            size = this.collection.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCount(ServiceElement sElem) {
        int count = 0;
        TreeMap<Key, ProvisionRequest> treeMap = this.collection;
        synchronized (treeMap) {
            Collection<ProvisionRequest> c = this.collection.values();
            if (c != null) {
                for (ProvisionRequest pr : c) {
                    if (!pr.sElem.equals(sElem)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProvisionRequest[] removeServiceElement(ServiceElement sElem, int numToRemove) {
        ArrayList<ProvisionRequest> removals = new ArrayList<ProvisionRequest>();
        TreeMap<Key, ProvisionRequest> treeMap = this.collection;
        synchronized (treeMap) {
            Iterator<ProvisionRequest> iterator = this.collection.values().iterator();
            while (numToRemove > 0 && iterator.hasNext()) {
                ProvisionRequest pr = iterator.next();
                if (!sElem.equals(pr.sElem)) continue;
                removals.add(pr);
                iterator.remove();
                --numToRemove;
            }
        }
        if (removals.size() > 0 && logger.isLoggable(Level.FINER)) {
            logger.finer(this.type + ": removing [" + removals.size() + "] [" + sElem.getName() + "] instances");
        }
        return removals.toArray(new ProvisionRequest[removals.size()]);
    }

    ProvisionRequest[] removeServiceElement(ServiceElement sElem) {
        return this.removeServiceElement(sElem, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServiceBeanInstance(ServiceBeanInstance sbi) {
        TreeMap<Key, ProvisionRequest> treeMap = this.collection;
        synchronized (treeMap) {
            Iterator<ProvisionRequest> iterator = this.collection.values().iterator();
            while (iterator.hasNext()) {
                ProvisionRequest pr = iterator.next();
                if (pr.instance == null || !pr.instance.equals(sbi) && !pr.instance.getPresentationName().equals(sbi.getPresentationName())) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasServiceElement(ServiceElement sElem) {
        TreeMap<Key, ProvisionRequest> treeMap = this.collection;
        synchronized (treeMap) {
            for (ProvisionRequest pr : this.collection.values()) {
                if (!sElem.equals(pr.sElem)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProvisionRequests(ServiceElement sElem) {
        TreeMap<Key, ProvisionRequest> treeMap = this.collection;
        synchronized (treeMap) {
            for (ProvisionRequest pr : this.collection.values()) {
                if (!sElem.equals(pr.sElem)) continue;
                Long id = pr.sElem.getServiceBeanConfig().getInstanceID();
                ServiceElement newElem = sElem;
                if (id != null) {
                    newElem = ServiceElementUtil.prepareInstanceID(sElem, (long)id.intValue());
                }
                pr.sElem = newElem;
            }
        }
    }

    abstract ServiceElement[] getInProcessProvisionRequests();

    abstract void process();

    abstract void process(ServiceResource var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProvisionRequest[] getProvisionRequests(ServiceElement sElem) {
        ProvisionRequest[] prs = null;
        TreeMap<Key, ProvisionRequest> treeMap = this.collection;
        synchronized (treeMap) {
            if (sElem == null) {
                Collection<ProvisionRequest> c = this.collection.values();
                prs = c.toArray(new ProvisionRequest[c.size()]);
            } else {
                ArrayList<ProvisionRequest> items = new ArrayList<ProvisionRequest>();
                Collection<ProvisionRequest> values = this.collection.values();
                for (ProvisionRequest pr : values) {
                    if (!sElem.equals(pr.sElem)) continue;
                    items.add(pr);
                }
                prs = items.toArray(new ProvisionRequest[items.size()]);
            }
        }
        return prs;
    }

    ProvisionRequest[] getProvisionRequests() {
        return this.getProvisionRequests(null);
    }

    void dumpCollection(String prefix) {
        if (logger.isLoggable(Level.FINEST)) {
            ProvisionRequest[] elements = this.getProvisionRequests(null);
            StringBuffer buffer = new StringBuffer();
            buffer.append(prefix);
            int x = 1;
            buffer.append("\n" + this.type + " collection size : " + elements.length + "\n");
            buffer.append("--\n");
            for (int i = 0; i < elements.length; ++i) {
                ServiceElement sElem = elements[i].sElem;
                buffer.append(x++ + " " + sElem.getDebugName() + "\n");
            }
            buffer.append("--");
            logger.finest(buffer.toString());
        }
    }

    static class Key
    implements Comparable {
        final int priority = 0;
        final ServiceElement sElem;
        final long index;
        final long timestamp;

        Key(ServiceElement sElem, long index, long timestamp) {
            this.sElem = sElem;
            this.index = index;
            this.timestamp = timestamp;
        }

        public int compareTo(Object o) {
            String thatNameWIthID;
            String thisNameWithID;
            if (!(o instanceof Key)) {
                throw new ClassCastException();
            }
            if (this == o) {
                return 0;
            }
            Key that = (Key)o;
            int comparison = Integer.valueOf(this.priority).compareTo(that.priority);
            if (comparison == 0 && (comparison = (thisNameWithID = ServiceElementUtil.getNameWithId(this.sElem).toLowerCase()).compareTo(thatNameWIthID = ServiceElementUtil.getNameWithId(that.sElem).toLowerCase())) == 0 && (comparison = Long.valueOf(this.timestamp).compareTo(that.timestamp)) == 0) {
                comparison = Long.valueOf(this.index).compareTo(that.index);
            }
            return comparison;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Key{");
            sb.append("priority=").append(0);
            sb.append(", sElem=").append(this.sElem);
            sb.append(", index=").append(this.index);
            sb.append(", timestamp=").append(this.timestamp);
            sb.append('}');
            return sb.toString();
        }
    }
}

