/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.ProvisionRequest;
import org.jini.rio.monitor.event.Event;

public class ProvisionLifeCycleEvent
implements Externalizable,
Event {
    private static final long serialVersionUID = 1L;
    public static final int ALLOCATION_ATTEMPT = 0;
    public static final int ALLOCATION_SUCCESS = 1;
    public static final int ALLOCATION_FAILURE = 2;
    public static final int PENDING_ALLOCATION = 3;
    private int status;
    private String processingUnitName;
    private String processingUnitInstanceName;
    private String gscServiceId;
    private String exception;
    private boolean uninstantiable;

    public ProvisionLifeCycleEvent(int status) {
        this.status = status;
    }

    public ProvisionLifeCycleEvent() {
    }

    public ProvisionLifeCycleEvent parse(ServiceElement serviceElement) {
        if (serviceElement == null) {
            return this;
        }
        this.processingUnitName = serviceElement.getOperationalStringName();
        this.processingUnitInstanceName = ServiceElementUtil.getNameWithId(serviceElement);
        return this;
    }

    public ProvisionLifeCycleEvent parse(InstantiatorResource resource) {
        if (resource == null) {
            return this;
        }
        this.gscServiceId = resource.getInstantiatorUuid().toString();
        return this;
    }

    public ProvisionLifeCycleEvent parse(ProvisionRequest request) {
        if (request == null) {
            return this;
        }
        if (request.sElem != null) {
            this.parse(request.sElem);
        }
        if (request.instance != null) {
            this.processingUnitInstanceName = request.instance.getPresentationName();
        }
        return this;
    }

    public ProvisionLifeCycleEvent parse(ServiceBeanInstance instance) {
        if (instance == null) {
            return this;
        }
        this.processingUnitInstanceName = instance.getPresentationName();
        if (instance.getServiceBeanConfig() != null) {
            this.processingUnitName = instance.getServiceBeanConfig().getOperationalStringName();
        }
        return this;
    }

    public ProvisionLifeCycleEvent parse(String failureReason, boolean reProvision) {
        this.uninstantiable = !reProvision;
        this.exception = failureReason;
        return this;
    }

    public String getProcessingUnitName() {
        return this.processingUnitName;
    }

    public String getProcessingUnitInstanceName() {
        return this.processingUnitInstanceName;
    }

    public String getGscServiceId() {
        return this.gscServiceId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getException() {
        return this.exception;
    }

    public boolean isUninstantiable() {
        return this.uninstantiable;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        switch (this.status) {
            case 0: {
                builder.append("Attempt to allocate");
                break;
            }
            case 1: {
                builder.append("Successfully allocated");
                break;
            }
            case 2: {
                builder.append("Failed to allocate");
                break;
            }
            case 3: {
                builder.append("Pending allocation for");
                break;
            }
            default: {
                builder.append("unknown action: ").append(this.status);
            }
        }
        if (this.processingUnitInstanceName != null) {
            builder.append(' ').append("an instance of").append(' ').append('[').append(this.processingUnitInstanceName).append(']');
        } else {
            builder.append(' ').append('[').append(this.processingUnitName).append(']');
        }
        if (this.gscServiceId != null) {
            builder.append(' ').append("on GSC ").append('[').append(this.gscServiceId).append(']');
        }
        if (this.exception != null) {
            builder.append(" - ").append(this.exception).append(']');
        }
        return builder.toString();
    }

    public String toString() {
        return this.getMessage();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.status);
        IOUtils.writeString((ObjectOutput)out, (String)this.processingUnitName);
        IOUtils.writeString((ObjectOutput)out, (String)this.processingUnitInstanceName);
        IOUtils.writeString((ObjectOutput)out, (String)this.gscServiceId);
        out.writeBoolean(this.uninstantiable);
        IOUtils.writeString((ObjectOutput)out, (String)this.exception);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.status = in.readInt();
        this.processingUnitName = IOUtils.readString((ObjectInput)in);
        this.processingUnitInstanceName = IOUtils.readString((ObjectInput)in);
        this.gscServiceId = IOUtils.readString((ObjectInput)in);
        this.uninstantiable = in.readBoolean();
        this.exception = IOUtils.readString((ObjectInput)in);
    }
}

