/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.annotation.lrmi.MonitoringPriority;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.provision.ProvisionManager;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.resources.servicecore.Service;

public interface ProvisionMonitor
extends ProvisionManager,
Service {
    @MonitoringPriority
    public OperationalStringManager getPrimary(String var1) throws RemoteException, OperationalStringException;

    public boolean assignBackupFor(ProvisionMonitor var1) throws RemoteException;

    public boolean removeBackupFor(ProvisionMonitor var1) throws RemoteException;

    public boolean isManaging() throws RemoteException;

    public void update(PeerInfo var1) throws RemoteException;

    public PeerInfo getPeerInfo() throws RemoteException;

    public static class PeerInfo
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2L;
        private final ProvisionMonitor service;
        private Integer backupCount;
        private final Long id;
        private final long processId;
        private final String name;
        private final String hostName;
        private final String hostAddress;

        public PeerInfo(String name, ProvisionMonitor service, long id, ResourceCapability resourceCapability) {
            this.id = new Long(id);
            this.backupCount = new Integer(0);
            this.name = name;
            this.service = service;
            this.hostName = resourceCapability.getHostName();
            this.hostAddress = resourceCapability.getAddress();
            this.processId = resourceCapability.getProcessId();
        }

        public PeerInfo() {
            this.id = -1L;
            this.name = null;
            this.service = null;
            this.hostName = null;
            this.hostAddress = null;
            this.processId = -1L;
        }

        public String getName() {
            return this.name;
        }

        public Long getID() {
            return this.id;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public long getProcessId() {
            return this.processId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBackupCount(int bCount) {
            if (bCount < 0) {
                throw new NullPointerException("backupCount must be positive");
            }
            PeerInfo peerInfo = this;
            synchronized (peerInfo) {
                this.backupCount = new Integer(bCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer getBackupCount() {
            Integer bCount = null;
            PeerInfo peerInfo = this;
            synchronized (peerInfo) {
                bCount = this.backupCount;
            }
            return bCount;
        }

        public ProvisionMonitor getService() {
            return this.service;
        }

        public int hashCode() {
            return this.service.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PeerInfo)) {
                return false;
            }
            PeerInfo that = (PeerInfo)o;
            return this.service.equals(that.service);
        }

        public int compareTo(Object o) {
            if (!(o instanceof PeerInfo)) {
                throw new ClassCastException();
            }
            PeerInfo that = (PeerInfo)o;
            if (this.backupCount.equals(that.backupCount)) {
                return this.id.compareTo(that.id);
            }
            return this.backupCount.compareTo(that.backupCount);
        }

        public String toString() {
            if (this.getProcessId() == -1L) {
                return this.getName() + " host[" + this.getHostName() + "/" + this.getHostAddress() + "]";
            }
            return this.getName() + " pid[" + this.getProcessId() + "] host[" + this.getHostName() + "/" + this.getHostAddress() + "]";
        }
    }
}

