/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Map;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.monitor.ProvisionMonitorAdmin;
import org.jini.rio.resources.servicecore.ServiceAdminProxy;

public class ProvisionMonitorAdminProxy
extends ServiceAdminProxy
implements ProvisionMonitorAdmin,
Serializable {
    private static final long serialVersionUID = 2L;

    static ProvisionMonitorAdminProxy getInstance(ProvisionMonitorAdmin serviceAdmin, ProvisionMonitorAdmin localAdmin, Uuid id) {
        if (serviceAdmin instanceof RemoteMethodControl) {
            return new ConstrainableProvisionMonitorAdminProxy(serviceAdmin, localAdmin, id, null);
        }
        return new ProvisionMonitorAdminProxy(serviceAdmin, localAdmin, id);
    }

    private ProvisionMonitorAdminProxy(ProvisionMonitorAdmin serviceAdmin, ProvisionMonitorAdmin localAdmin, Uuid uuid) {
        super(serviceAdmin, localAdmin, uuid);
    }

    @Override
    public String getDeployURL() throws RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).getDeployURL();
    }

    @Override
    public Map deploy(URL opStringURL) throws OperationalStringException, RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).deploy(opStringURL);
    }

    @Override
    public Map deploy(URL opStringURL, ServiceProvisionListener listener) throws OperationalStringException, RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).deploy(opStringURL, listener);
    }

    @Override
    public Map deploy(OperationalString opString) throws OperationalStringException, RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).deploy(opString);
    }

    @Override
    public Map deploy(OperationalString opString, ServiceProvisionListener listener) throws OperationalStringException, RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).deploy(opString, listener);
    }

    @Override
    public boolean undeploy(String opStringName) throws OperationalStringException, RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).undeploy(opStringName);
    }

    @Override
    public boolean removeUndeployed(String opStringName) throws RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).removeUndeployed(opStringName);
    }

    @Override
    public boolean hasDeployed(String opStringName) throws RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).hasDeployed(opStringName);
    }

    @Override
    public OperationalStringManager[] getOperationalStringManagers() throws RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).getOperationalStringManagers();
    }

    @Override
    public OperationalStringManager getOperationalStringManager(String name) throws OperationalStringException, RemoteException {
        return ((DeployAdmin)((Object)this.getProxy())).getOperationalStringManager(name);
    }

    @Override
    public ProvisionMonitor.PeerInfo[] getBackupInfo() throws RemoteException {
        return ((ProvisionMonitorAdmin)this.getProxy()).getBackupInfo();
    }

    static final class ConstrainableProvisionMonitorAdminProxy
    extends ProvisionMonitorAdminProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;

        private ConstrainableProvisionMonitorAdminProxy(ProvisionMonitorAdmin serviceAdmin, ProvisionMonitorAdmin localAdmin, Uuid id, MethodConstraints constraints) {
            super(ConstrainableProvisionMonitorAdminProxy.constrainServer(serviceAdmin, constraints), ConstrainableProvisionMonitorAdminProxy.constrainServer(localAdmin, constraints), id);
        }

        private static ProvisionMonitorAdmin constrainServer(ProvisionMonitorAdmin serviceAdmin, MethodConstraints constraints) {
            if (serviceAdmin == null) {
                return null;
            }
            Method[] methods = ProvisionMonitorAdmin.class.getMethods();
            Method[] methodMapping = new Method[methods.length * 2];
            for (int i = 0; i < methodMapping.length; ++i) {
                methodMapping[i] = methods[i / 2];
            }
            return (ProvisionMonitorAdmin)((RemoteMethodControl)serviceAdmin).setConstraints(ConstrainableProxyUtil.translateConstraints((MethodConstraints)constraints, (Method[])methodMapping));
        }

        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableProvisionMonitorAdminProxy((ProvisionMonitorAdmin)this.serviceAdmin, (ProvisionMonitorAdmin)this.localAdmin, this.uuid, constraints);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.serviceAdmin).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.serviceAdmin);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.serviceAdmin instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableProvisionMonitorAdminProxy.readObject failure : serviceAdmin does not implement constrainable functionality");
            }
        }
    }
}

