/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import java.io.Serializable;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.monitor.ProvisionMonitorEventAdapter;

public class ProvisionMonitorEvent
extends RemoteServiceEvent
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final long ID = 2764185076071141340L;
    public static final int SERVICE_ELEMENT_UPDATED = 1;
    public static final int SERVICE_BEAN_INCREMENTED = 2;
    public static final int SERVICE_BEAN_DECREMENTED = 3;
    public static final int SERVICE_ELEMENT_ADDED = 4;
    public static final int SERVICE_ELEMENT_REMOVED = 5;
    public static final int OPSTRING_DEPLOYED = 6;
    public static final int OPSTRING_UNDEPLOYED = 7;
    public static final int OPSTRING_UPDATED = 8;
    public static final int SERVICE_BEAN_INSTANCE_UPDATED = 9;
    public static final int REDEPLOY_REQUEST = 10;
    public static final int SERVICE_PROVISIONED = 11;
    public static final int SERVICE_FAILED = 12;
    public static final int OPSTRING_MGR_CHANGED = 13;
    private int action = 0;
    private final String opStringName;
    private ServiceElement sElem;
    private OperationalString opString;
    private Object[] redeploymentParms;
    private ServiceBeanInstance instance;

    public ProvisionMonitorEvent(Object source, int action, ServiceElement sElem) {
        super(source);
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        this.opStringName = sElem.getOperationalStringName();
        this.action = action;
        this.sElem = sElem;
    }

    public ProvisionMonitorEvent(Object source, int action, OperationalString opString) {
        super(source);
        if (opString == null) {
            throw new NullPointerException("opString is null");
        }
        this.action = action;
        this.opString = opString;
        this.opStringName = opString.getName();
    }

    public ProvisionMonitorEvent(Object source, String opStringName, ServiceBeanInstance instance) {
        super(source);
        if (opStringName == null) {
            throw new NullPointerException("opStringName cannot be null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is null");
        }
        this.action = 9;
        this.instance = instance;
        this.opStringName = opStringName;
    }

    public ProvisionMonitorEvent(Object source, int action, String opStringName, ServiceElement sElem, ServiceBeanInstance instance) {
        super(source);
        if (opStringName == null) {
            throw new NullPointerException("opStringName cannot be null");
        }
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        this.action = action;
        this.sElem = sElem;
        this.instance = instance;
        this.opStringName = opStringName;
    }

    public ProvisionMonitorEvent(Object source, String opStringName, ServiceElement sElem, ServiceBeanInstance instance, Object[] args) {
        super(source);
        if (opStringName == null) {
            throw new NullPointerException("opStringName cannot be null");
        }
        if (args == null) {
            throw new NullPointerException("redeploymentParms cannot be null");
        }
        this.action = 10;
        this.opStringName = opStringName;
        this.sElem = sElem;
        this.instance = instance;
        this.redeploymentParms = new Object[args.length];
        System.arraycopy(args, 0, this.redeploymentParms, 0, this.redeploymentParms.length);
    }

    public int getAction() {
        return this.action;
    }

    public String getOperationalStringName() {
        return this.opStringName;
    }

    public ServiceElement getServiceElement() {
        return this.sElem;
    }

    public OperationalString getOperationalString() {
        return this.opString;
    }

    public ServiceBeanInstance getServiceBeanInstance() {
        return this.instance;
    }

    public Object[] getRedeploymentParms() {
        return this.redeploymentParms;
    }

    public String toString() {
        return ProvisionMonitorEventAdapter.getMessage(this);
    }
}

