/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import java.rmi.RemoteException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.UnknownEventException;
import org.jini.rio.event.EventNotificationAdapter;
import org.jini.rio.monitor.ProvisionMonitorEvent;

public class ProvisionMonitorEventAdapter
extends EventNotificationAdapter {
    private static final String EVENT_TYPE_SERVICE_ELEMENT_UPDATED = "ProvisionMonitorEvent.serviceElementUpdated";
    private static final String EVENT_TYPE_SERVICE_ELEMENT_ADDED = "ProvisionMonitorEvent.serviceElementAdded";
    private static final String EVENT_TYPE_SERVICE_ELEMENT_REMOVED = "ProvisionMonitorEvent.serviceElementRemoved";
    private static final String EVENT_TYPE_SERVICE_BEAN_INCREMENTED = "ProvisionMonitorEvent.serviceBeanIncremented";
    private static final String EVENT_TYPE_SERVICE_BEAN_DECREMENTED = "ProvisionMonitorEvent.serviceBeanDecremented";
    private static final String EVENT_TYPE_SERVICE_BEAN_INSTANCE_UPDATED = "ProvisionMonitorEvent.serviceBeanInstanceUpdated";
    private static final String EVENT_TYPE_OPSTRING_DEPLOYED = "ProvisionMonitorEvent.opstringDeployed";
    private static final String EVENT_TYPE_OPSTRING_UNDEPLOYED = "ProvisionMonitorEvent.opstringUndeployed";
    private static final String EVENT_TYPE_OPSTRING_UPDATED = "ProvisionMonitorEvent.opstringUpdated";
    private static final String EVENT_TYPE_OPSTRING_MGR_CHANGED = "ProvisionMonitorEvent.opstringMgrChanged";
    private static final String EVENT_TYPE_SERVICE_PROVISIONED = "ProvisionMonitorEvent.serviceProvisioned";
    private static final String EVENT_TYPE_SERVICE_FAILED = "ProvisionMonitorEvent.serviceFailed";
    private static final String EVENT_TYPE_REDEPLOY_REQUEST = "ProvisionMonitorEvent.redeployRequest";
    private static final MBeanNotificationInfo NOTIFICATION_INFO = new MBeanNotificationInfo(new String[]{"ProvisionMonitorEvent.serviceElementUpdated", "ProvisionMonitorEvent.serviceElementAdded", "ProvisionMonitorEvent.serviceElementRemoved", "ProvisionMonitorEvent.serviceBeanIncremented", "ProvisionMonitorEvent.serviceBeanDecremented", "ProvisionMonitorEvent.serviceBeanInstanceUpdated", "ProvisionMonitorEvent.opstringDeployed", "ProvisionMonitorEvent.opstringUndeployed", "ProvisionMonitorEvent.opstringUpdated", "ProvisionMonitorEvent.opstringMgrChanged", "ProvisionMonitorEvent.serviceProvisioned", "ProvisionMonitorEvent.serviceFailed", "ProvisionMonitorEvent.redeployRequest"}, Notification.class.getName(), "ProvisionMonitorEvent");

    public ProvisionMonitorEventAdapter(ObjectName objectName, NotificationBroadcasterSupport notificationBroadcasterSupport) {
        super(objectName, notificationBroadcasterSupport);
    }

    @Override
    public void notify(RemoteEvent theEvent) throws UnknownEventException, RemoteException {
        if (theEvent == null) {
            throw new NullPointerException("event is null");
        }
        if (!(theEvent instanceof ProvisionMonitorEvent)) {
            throw new UnknownEventException("Not a ProvisionMonitorEvent [" + theEvent.getClass().getName() + "]");
        }
        ProvisionMonitorEvent event = (ProvisionMonitorEvent)theEvent;
        String type = this.getNotificationType(event);
        Notification notification = new Notification(type, (Object)this.objectName, event.getSequenceNumber(), ProvisionMonitorEventAdapter.getMessage(event));
        this.notificationBroadcasterSupport.sendNotification(notification);
    }

    @Override
    public MBeanNotificationInfo getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    private String getNotificationType(ProvisionMonitorEvent event) throws UnknownEventException {
        String type;
        switch (event.getAction()) {
            case 6: {
                type = EVENT_TYPE_OPSTRING_DEPLOYED;
                break;
            }
            case 13: {
                type = EVENT_TYPE_OPSTRING_MGR_CHANGED;
                break;
            }
            case 7: {
                type = EVENT_TYPE_OPSTRING_UNDEPLOYED;
                break;
            }
            case 8: {
                type = EVENT_TYPE_OPSTRING_UPDATED;
                break;
            }
            case 10: {
                type = EVENT_TYPE_REDEPLOY_REQUEST;
                break;
            }
            case 3: {
                type = EVENT_TYPE_SERVICE_BEAN_DECREMENTED;
                break;
            }
            case 2: {
                type = EVENT_TYPE_SERVICE_BEAN_INCREMENTED;
                break;
            }
            case 9: {
                type = EVENT_TYPE_SERVICE_BEAN_INSTANCE_UPDATED;
                break;
            }
            case 4: {
                type = EVENT_TYPE_SERVICE_ELEMENT_ADDED;
                break;
            }
            case 5: {
                type = EVENT_TYPE_SERVICE_ELEMENT_REMOVED;
                break;
            }
            case 1: {
                type = EVENT_TYPE_SERVICE_ELEMENT_UPDATED;
                break;
            }
            case 12: {
                type = EVENT_TYPE_SERVICE_FAILED;
                break;
            }
            case 11: {
                type = EVENT_TYPE_SERVICE_PROVISIONED;
                break;
            }
            default: {
                throw new UnknownEventException();
            }
        }
        return type;
    }

    public static String getMessage(ProvisionMonitorEvent event) {
        String data = null;
        switch (event.getAction()) {
            case 6: {
                data = "[" + event.getOperationalStringName() + "] deployed";
                break;
            }
            case 13: {
                data = "Manager for [" + event.getOperationalStringName() + "] changed";
                break;
            }
            case 7: {
                data = "[" + event.getOperationalStringName() + "] Undeployed";
                break;
            }
            case 8: {
                data = "[" + event.getOperationalStringName() + "] Updated";
                break;
            }
            case 10: {
                data = "[" + event.getOperationalStringName() + "] Redeployed";
                break;
            }
            case 3: {
                data = "[" + event.getServiceElement().getName() + "] Decremented";
                break;
            }
            case 2: {
                data = "[" + event.getServiceElement().getName() + "] Incremented";
                break;
            }
            case 9: {
                data = "[" + event.getServiceElement().getName() + "] instance updated";
                break;
            }
            case 4: {
                data = "[" + event.getServiceElement().getName() + "] added to deployment";
                break;
            }
            case 5: {
                data = "[" + event.getServiceElement().getName() + "] Removed from deployment";
                break;
            }
            case 1: {
                data = "[" + event.getServiceElement().getName() + "] Updated";
                break;
            }
            case 12: {
                data = "[" + event.getServiceElement().getName() + "] Failed";
                break;
            }
            case 11: {
                data = "[" + event.getServiceElement().getName() + "] Provisioned";
            }
        }
        return data;
    }
}

