/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.grid.security.gsm.SecuredGSMProxy;
import com.gigaspaces.grid.security.gsm.SecuredOperationalStringManager;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.internal.quiesce.QuiesceTask;
import com.gigaspaces.start.SystemConfig;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.jini.SharedLeaseRenewalManager;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.threadpool.DynamicExecutors;
import com.j_spaces.kernel.threadpool.monitor.FutureExecutorService;
import com.sun.jini.config.Config;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.start.LifeCycle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import net.jini.admin.Administrable;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import net.jini.lookup.BackwardsServiceDiscoveryManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.jini.rio.boot.PUZipUtils;
import org.jini.rio.boot.ServiceClassLoader;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.FaultDetectionHandler;
import org.jini.rio.core.FaultDetectionListener;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.Schedule;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceElementTracker;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.jsb.ServiceBeanAdmin;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.provision.ServiceBeanInstantiator;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.event.BasicEventConsumer;
import org.jini.rio.event.DispatchEventHandler;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventHandler;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.event.RemoteServiceEventListener;
import org.jini.rio.jsb.ServiceBeanActivation;
import org.jini.rio.jsb.ServiceBeanAdapter;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.EsmMonitor;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.InternalOpStringManagerFinder;
import org.jini.rio.monitor.ProvisionFailureEvent;
import org.jini.rio.monitor.ProvisionFailureEventAdapter;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.monitor.ProvisionMonitorAdminImpl;
import org.jini.rio.monitor.ProvisionMonitorEvent;
import org.jini.rio.monitor.ProvisionMonitorEventAdapter;
import org.jini.rio.monitor.ProvisionMonitorEventTask;
import org.jini.rio.monitor.ProvisionMonitorImplMBean;
import org.jini.rio.monitor.ProvisionMonitorProxy;
import org.jini.rio.monitor.ProvisionRequest;
import org.jini.rio.monitor.RecordHolder;
import org.jini.rio.monitor.ServiceChannel;
import org.jini.rio.monitor.ServiceElementManager;
import org.jini.rio.monitor.ServiceProvisioner;
import org.jini.rio.monitor.event.ConcurrentEventsStore;
import org.jini.rio.monitor.event.Events;
import org.jini.rio.monitor.leader.ActiveProvisionMonitor;
import org.jini.rio.opstring.OpString;
import org.jini.rio.opstring.OpStringLoader;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.resources.client.FaultDetectionHandlerFactory;
import org.jini.rio.resources.client.ServiceDiscoveryAdapter;
import org.jini.rio.resources.persistence.PersistentStore;
import org.jini.rio.resources.persistence.SnapshotHandler;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.servicecore.ServiceAdmin;
import org.jini.rio.resources.servicecore.ServiceResource;
import org.jini.rio.resources.util.RioManifest;
import org.jini.rio.tools.webster.Webster;
import org.jini.rio.watch.StopWatch;

public class ProvisionMonitorImpl
extends ServiceBeanAdapter
implements ProvisionMonitor,
ProvisionMonitorImplMBean,
InternalOpStringManagerFinder {
    static final String CONFIG_COMPONENT = "org.jini.rio.monitor";
    static Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm");
    static Logger peerLogger = Logger.getLogger("com.gigaspaces.grid.gsm.peer");
    Vector opStringManagers = new Vector();
    ArrayList pendingManagers = new ArrayList();
    EventHandler monitorEventHandler;
    FutureExecutorService monitorEventPool;
    EventHandler failureHandler;
    ServiceProvisioner provisioner;
    OpStringLoader opStringLoader;
    StopWatch provisionWatch;
    static final int LOG_VERSION = 1;
    int logToSnapshotThresh = 10;
    OpStringLogHandler opStringLogHandler;
    boolean inRecovery;
    ProvisionMonitorPeer provisionMonitorPeer;
    EsmMonitor esmMonitor;
    private Configuration config;
    Timer taskTimer;
    private final ConcurrentEventsStore eventsStore = new ConcurrentEventsStore();
    private ActiveProvisionMonitor activeProvisionMonitor;
    private final Webster webster = SystemConfig.getInstance().getWebster();

    public ProvisionMonitorImpl() throws Exception {
    }

    public ProvisionMonitorImpl(String[] configArgs, LifeCycle lifeCycle) throws Exception {
        this();
        this.bootstrap(configArgs);
    }

    public ProvisionMonitorImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        this();
        this.activationID = activationID;
        this.bootstrap((String[])data.get());
    }

    protected void bootstrap(String[] configArgs) throws Exception {
        try {
            String fdh = "com.gigaspaces.grid.gsm.GSMFaultDetectionHandler";
            Object[] fdhConfigArgs = new Object[]{new String[]{"-", "com.gigaspaces.grid.gsm.GSMFaultDetectionHandler.invocationDelay=" + System.getProperty("com.gigaspaces.grid.gsm.GSMFaultDetectionHandler.invocationDelay", "1000"), "com.gigaspaces.grid.gsm.GSMFaultDetectionHandler.retryCount=" + System.getProperty("com.gigaspaces.grid.gsm.GSMFaultDetectionHandler.retryCount", "1"), "com.gigaspaces.grid.gsm.GSMFaultDetectionHandler.retryTimeout=" + System.getProperty("com.gigaspaces.grid.gsm.GSMFaultDetectionHandler.retryTimeout", "500")}};
            ClassBundle faultDetectionHandler = new ClassBundle(fdh, null, new String[]{"setConfiguration"}, new Object[]{fdhConfigArgs});
            this.context = ServiceBeanActivation.getServiceBeanContext(CONFIG_COMPONENT, "GSM", "Service Grid Infrastructure", "com.gigaspaces.grid:type=GSM", faultDetectionHandler, configArgs, this.getClass().getClassLoader());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Getting ServiceElement", e);
            throw e;
        }
        try {
            this.start(this.context);
            ServiceBeanActivation.LifeCycleManager lMgr = (ServiceBeanActivation.LifeCycleManager)this.context.getServiceBeanManager().getDiscardManager();
            lMgr.register(this.getServiceProxy(), this.context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Register to LifeCycleManager", e);
            throw e;
        }
    }

    @Override
    public void destroy(boolean force) {
        if (this.opStringManagers != null) {
            Enumeration e = this.opStringManagers.elements();
            while (e.hasMoreElements()) {
                OpStringManager opMgr = (OpStringManager)e.nextElement();
                opMgr.terminate(false, false);
            }
        }
        if (this.provisionWatch != null) {
            this.watchRegistry.deregister(this.provisionWatch);
        }
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
        }
        if (this.provisioner != null) {
            this.provisioner.terminate();
        }
        if (this.provisionMonitorPeer != null) {
            this.provisionMonitorPeer.terminate();
        }
        if (this.esmMonitor != null) {
            this.esmMonitor.terminate();
        }
        if (this.activeProvisionMonitor != null) {
            this.activeProvisionMonitor.terminate();
        }
        if (this.snapshotter != null) {
            this.snapshotter.interrupt();
        }
        if (this.store != null) {
            try {
                this.store.destroy();
            }
            catch (Exception t) {
                logger.log(Level.WARNING, "While destroying persistent store", t);
            }
        }
        super.destroy(force);
    }

    @Override
    public Object getAdmin() {
        ServiceAdmin adminProxy = null;
        try {
            if (this.admin == null) {
                Exporter adminExporter = this.getAdminExporter();
                this.admin = this.contextMgr != null ? new ProvisionMonitorAdminImpl(this, adminExporter, (SnapshotHandler)this.contextMgr.getContextAttributeLogHandler()) : new ProvisionMonitorAdminImpl(this, adminExporter);
            }
            this.admin.setServiceBeanContext(this.getServiceBeanContext());
            adminProxy = this.admin.getServiceAdmin();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Getting ProvisionMonitorAdminImpl", t);
        }
        return adminProxy;
    }

    @Override
    protected Object createProxy() {
        ProvisionMonitorProxy proxy = ProvisionMonitorProxy.getInstance((ProvisionMonitor)this.getExportedProxy(), this.getUuid());
        return proxy;
    }

    protected ServiceInfo getServiceInfo() {
        URL implUrl = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        String build = null;
        try {
            RioManifest rioManifest = new RioManifest(implUrl);
            build = rioManifest.getRioBuild();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Getting Rio Manifest", e);
        }
        if (build == null) {
            build = "0";
        }
        return new ServiceInfo(this.context.getServiceElement().getName(), "Sun Microsystems, Inc.", "", "v3.2 Build " + build, "", "");
    }

    public OperationalStringManager[] getOperationalStringManagers() {
        if (this.opStringManagers.isEmpty()) {
            return new OperationalStringManager[0];
        }
        ArrayList<OpStringManager> list = new ArrayList<OpStringManager>();
        Enumeration e = this.opStringManagers.elements();
        while (e.hasMoreElements()) {
            OpStringManager opMgr = (OpStringManager)e.nextElement();
            list.add(opMgr);
        }
        OperationalStringManager[] os = new OperationalStringManager[list.size()];
        int i = 0;
        for (OpStringManager opMgr : list) {
            os[i++] = opMgr.getProxy();
        }
        return os;
    }

    public OperationalStringManager getOperationalStringManager(String name) throws OperationalStringException {
        OperationalStringManager mgr = null;
        Enumeration e = this.opStringManagers.elements();
        while (e.hasMoreElements()) {
            OpStringManager opMgr = (OpStringManager)e.nextElement();
            if (!opMgr.getName().equals(name)) continue;
            mgr = opMgr.getProxy();
            break;
        }
        if (mgr == null) {
            throw new OperationalStringException(String.format("Unmanaged OperationalString [%s]", name));
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map deploy(String opStringUrl) throws MalformedURLException {
        if (opStringUrl == null) {
            throw new NullPointerException("argument cannot be null");
        }
        URL url = null;
        File f = new File(opStringUrl);
        url = f.exists() ? f.toURI().toURL() : new URL(opStringUrl);
        HashMap<String, String> m = null;
        final Thread currentThread = Thread.currentThread();
        ClassLoader cCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return currentThread.getContextClassLoader();
            }
        });
        boolean swapCLs = !(cCL instanceof ServiceClassLoader);
        try {
            final ClassLoader myCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return this.getClass().getClassLoader();
                }
            });
            if (swapCLs) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        currentThread.setContextClassLoader(myCL);
                        return null;
                    }
                });
            }
            m = this.deploy(url, null);
            if (!swapCLs) return m;
        }
        catch (OperationalStringException e) {
            try {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                if (m == null) {
                    m = new HashMap<String, String>();
                }
                m.put(cause.getClass().getName(), cause.getMessage());
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Deploying [" + opStringUrl + "]", e);
                }
                if (!swapCLs) return m;
            }
            catch (Throwable throwable) {
                if (!swapCLs) throw throwable;
                AccessController.doPrivileged(new PrivilegedAction(currentThread, cCL){
                    final /* synthetic */ Thread val$currentThread;
                    final /* synthetic */ ClassLoader val$cCL;
                    {
                        this.val$currentThread = thread;
                        this.val$cCL = classLoader;
                    }

                    public Object run() {
                        this.val$currentThread.setContextClassLoader(this.val$cCL);
                        return null;
                    }
                });
                throw throwable;
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            return m;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return m;
    }

    public String getDeployURL() throws RemoteException {
        return this.webster.getURL();
    }

    public Map deploy(URL opStringUrl, ServiceProvisionListener listener) throws OperationalStringException {
        if (opStringUrl == null) {
            throw new IllegalArgumentException("OperationalString URL cannot be null");
        }
        if (this.activeProvisionMonitor.isActivePassive() && !this.activeProvisionMonitor.isActive()) {
            throw new OperationalStringException("Deploy of [" + opStringUrl + "] cannot be issued to a non active GSM");
        }
        HashMap map = new HashMap();
        try {
            OperationalString[] opStrings = this.opStringLoader.parseOperationalString(opStringUrl);
            if (opStrings != null) {
                for (int i = 0; i < opStrings.length; ++i) {
                    if (!this.opStringExists(opStrings[i].getName())) {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, "Deploying [" + opStrings[i].getName() + "]");
                        }
                        this.addOperationalString(opStrings[i], map, null, null, listener);
                        continue;
                    }
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.log(Level.INFO, "Ignoring deployment request - [" + opStrings[i].getName() + "] is already deployed");
                }
            }
        }
        catch (Throwable t) {
            throw new OperationalStringException("Failed to deploy", t);
        }
        return map;
    }

    public Map deploy(OperationalString opString, ServiceProvisionListener listener) throws OperationalStringException {
        if (opString == null) {
            throw new IllegalArgumentException("OperationalString cannot be null");
        }
        if (this.activeProvisionMonitor.isActivePassive() && !this.activeProvisionMonitor.isActive()) {
            try {
                logger.warning("Not an active GSM - deployment requests will be redirected and will take longer to complete");
                return this.redirectDeploymentRequestToActivePeer(opString, listener);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to deploy [" + opString + "]", e);
                throw new OperationalStringException("Failed to deploy [" + opString + "]", e);
            }
        }
        String opStringName = opString.getName();
        logger.log(Level.INFO, "Deploying " + opStringName + " " + this.deploymentDetailsToString(opString));
        HashMap map = new HashMap();
        try {
            if (!this.opStringExists(opStringName)) {
                this.addOperationalString(opString, map, null, null, listener);
            } else {
                OpStringManager opMgr = this.getOpStringManager(opStringName);
                if (opMgr != null) {
                    opMgr.verifyAndInitiateDispatch(listener);
                } else {
                    logger.info("Ignoring request to re-deploy [" + opString + "] - already exists in pending queue");
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to deploy [" + opString + "]", t);
            throw new OperationalStringException("Failed to deploy [" + opString + "]", t);
        }
        return map;
    }

    private String deploymentDetailsToString(OperationalString opString) {
        StringBuilder details = new StringBuilder();
        details.append('{');
        ServiceElement svcElem = opString.getServices()[0];
        String puType = String.valueOf(svcElem.getServiceBeanConfig().getInitParameters().get("pu.type"));
        details.append("type=" + puType.toLowerCase());
        details.append(", instances=").append(svcElem.getServiceBeanConfig().getInitParameters().get("numberOfInstances"));
        Integer numberOfBackups = (Integer)svcElem.getServiceBeanConfig().getInitParameters().get("numberOfBackups");
        if (numberOfBackups != null && puType.equals("STATEFUL")) {
            details.append(", backups=").append(numberOfBackups);
        }
        if (svcElem.getRequiredZones() != null) {
            details.append(", zones=" + Arrays.toString(svcElem.getRequiredZones()));
        }
        if (svcElem.getMaxPerZone() != null && !svcElem.getMaxPerZone().isEmpty()) {
            details.append(", max-per-zone=" + svcElem.getMaxPerZone());
        }
        if (svcElem.isRequiresIsolation()) {
            details.append(", requires-isolation=true");
        }
        if (svcElem.getMaxPerMachine() > 0) {
            details.append(", max-instances-per-vm=" + svcElem.getMaxPerMachine());
        }
        if (svcElem.getMaxPerPhysicalMachine() > 0) {
            details.append(", max-instances-per-machine=" + svcElem.getMaxPerPhysicalMachine());
        }
        if (svcElem.getApplicationName() != null) {
            details.append(", application=" + svcElem.getApplicationName());
        }
        if (svcElem.getInstanceDeploymentDependencies() != null && !svcElem.getInstanceDeploymentDependencies().isEmpty()) {
            details.append(", dependencies=" + Arrays.toString(svcElem.getInstanceDeploymentDependencies().getRequiredDependenciesNames()));
        }
        details.append('}');
        return details.toString();
    }

    @Override
    public boolean undeploy(String opStringName) {
        boolean undeployed = false;
        try {
            undeployed = this.undeploy(opStringName, true);
        }
        catch (OperationalStringException e) {
            logger.log(Level.WARNING, "Undeploying [" + opStringName + "]", e);
        }
        return undeployed;
    }

    public boolean undeploy(String opStringName, boolean terminate) throws OperationalStringException {
        if (terminate) {
            logger.log(Level.INFO, "Undeploying " + opStringName);
        }
        if (opStringName == null) {
            throw new NullPointerException("Parameters cannot be null");
        }
        OpStringManager opMgr = this.getOpStringManager(opStringName);
        if (opMgr == null) {
            throw new OperationalStringException("GSM not found");
        }
        if (!opMgr.isActive()) {
            try {
                OperationalStringManager o = this.getPrimary(opStringName);
                if (o == null) {
                    throw new OperationalStringException("Failed to find active GSM to undeploy from");
                }
                if (o instanceof SecuredOperationalStringManager) {
                    throw new OperationalStringException("Security limitation - need to call 'undeploy' on active GSM");
                }
                return o.undeploy();
            }
            catch (ConnectException ce) {
                if (!(ce.getCause() instanceof ClosedChannelException)) {
                    throw new OperationalStringException("Caught " + ce + " while redirecting undeploy request for " + opStringName, ce);
                }
            }
            catch (RemoteException e) {
                throw new OperationalStringException("Failed to request undeploy from active GSM", e);
            }
        }
        opMgr.setDeploymentStatus(0);
        OperationalString opString = opMgr.doGetOperationalString();
        this.stateChanged(opMgr, true);
        opMgr.terminate(terminate, true);
        ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)this.getEventProxy(), 7, opString);
        this.processEvent(event);
        return true;
    }

    public boolean removeUndeployed(String opStringName) {
        if (opStringName == null) {
            throw new IllegalArgumentException("opStringName is null");
        }
        OpStringManager opMgr = this.getOpStringManager(opStringName);
        if (opMgr == null) {
            return false;
        }
        opMgr.setDeploymentStatus(0);
        this.provisionMonitorPeer.notify(new ProvisionMonitorEvent((Object)this.getEventProxy(), 7, opMgr.doGetOperationalString()));
        return true;
    }

    public boolean hasDeployed(String opStringName) {
        if (opStringName == null) {
            throw new NullPointerException("Parameters cannot be null");
        }
        return this.opStringExists(opStringName);
    }

    @Override
    public TabularData getDeployments() {
        String[] itemNames = new String[]{"Name", "Status", "Role", "Deployed"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.DATE};
        TabularDataSupport tabularDataSupport = null;
        try {
            CompositeType row = new CompositeType("Deployments", "Deployments", itemNames, itemNames, itemTypes);
            TabularType tabularType = new TabularType("Deployments", "Deployments", row, new String[]{"Name"});
            tabularDataSupport = new TabularDataSupport(tabularType);
            OpStringManager[] mgrs = this.opStringManagers.toArray(new OpStringManager[this.opStringManagers.size()]);
            for (int i = 0; i < mgrs.length; ++i) {
                Date deployed = null;
                if (mgrs[i].getDeploymentDates().length > 0) {
                    Date[] dDates = mgrs[i].getDeploymentDates();
                    deployed = dDates[dDates.length - 1];
                }
                int status = mgrs[i].doGetOperationalString().getStatus();
                String sStatus = null;
                switch (status) {
                    case 3: {
                        sStatus = "Broken";
                        break;
                    }
                    case 4: {
                        sStatus = "Compromised";
                        break;
                    }
                    case 5: {
                        sStatus = "Intact";
                        break;
                    }
                    case 1: {
                        sStatus = "Scheduled";
                    }
                }
                String role = mgrs[i].isActive() ? "Primary" : "Backup";
                Object[] data = new Object[]{mgrs[i].getName(), sStatus, role, deployed};
                CompositeDataSupport compositeData = new CompositeDataSupport(row, itemNames, data);
                tabularDataSupport.put(compositeData);
            }
        }
        catch (OpenDataException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        return tabularDataSupport;
    }

    public ProvisionMonitor.PeerInfo[] getBackupInfo() {
        return this.provisionMonitorPeer.getBackupInfo();
    }

    @Override
    public ProvisionMonitor.PeerInfo getPeerInfo() throws RemoteException {
        return this.provisionMonitorPeer.doGetPeerInfo();
    }

    @Override
    public boolean assignBackupFor(ProvisionMonitor primary) throws RemoteException {
        return this.provisionMonitorPeer.addAsBackupFor(primary);
    }

    @Override
    public boolean removeBackupFor(ProvisionMonitor primary) throws RemoteException {
        return this.provisionMonitorPeer.removeAsBackupFor(primary);
    }

    @Override
    public boolean isManaging() throws RemoteException {
        return this.activeProvisionMonitor.isActive();
    }

    @Override
    public void update(ProvisionMonitor.PeerInfo peerInfo) throws RemoteException {
        this.provisionMonitorPeer.peerUpdated(peerInfo);
    }

    @Override
    public EventRegistration register(ServiceBeanInstantiator instantiator, MarshalledObject handback, ResourceCapability resourceCapability, int serviceLimit, long duration, ServiceRecord[] serviceRecords) throws LeaseDeniedException, RemoteException {
        return this.provisioner.register(instantiator, handback, resourceCapability, serviceLimit, duration, serviceRecords);
    }

    @Override
    public void update(ServiceBeanInstantiator instantiator, ResourceCapability resourceCapability, int serviceLimit, ServiceRecord[] serviceRecords) throws UnknownLeaseException, RemoteException {
        this.provisioner.handleFeedback(instantiator, resourceCapability, serviceLimit, serviceRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpStringManager addOperationalString(OperationalString opString, Map map, OpStringManager parent, DeployAdmin dAdmin, ServiceProvisionListener listener) throws Exception {
        OpStringManager opMgr;
        block31: {
            opMgr = null;
            try {
                OpStringManager mgr;
                boolean activeState = this.activeProvisionMonitor.isActiveActive() ? dAdmin == null : this.activeProvisionMonitor.isActive();
                this.activeProvisionMonitor.getAndSetActive(opString.getName(), activeState);
                if (!this.opStringExists(opString.getName())) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Adding processing unit [" + opString.getName() + "] active [" + this.activeProvisionMonitor.isActive(opString.getName()) + "]");
                    }
                    ArrayList arrayList = this.pendingManagers;
                    synchronized (arrayList) {
                        this.pendingManagers.add(opString.getName());
                    }
                    try {
                        opMgr = new OpStringManager(opString, parent, this.activeProvisionMonitor, this.config);
                    }
                    catch (RemoteException e) {
                        logger.log(Level.WARNING, "Creating OpStringManager", e);
                        OpStringManager opStringManager = null;
                        ArrayList arrayList2 = this.pendingManagers;
                        synchronized (arrayList2) {
                            this.pendingManagers.remove(opString.getName());
                        }
                        return opStringManager;
                    }
                    Map errorMap = opMgr.init(listener);
                    this.opStringManagers.add(opMgr);
                    if (dAdmin != null) {
                        OperationalStringManager activeMgr = null;
                        HashMap<ServiceElement, ServiceBeanInstance[]> elemInstanceMap = new HashMap<ServiceElement, ServiceBeanInstance[]>();
                        try {
                            activeMgr = dAdmin.getOperationalStringManager(opString.getName());
                            ServiceElement[] elems = opString.getServices();
                            for (int i = 0; i < elems.length; ++i) {
                                try {
                                    ServiceBeanInstance[] instances = activeMgr.getServiceBeanInstances(elems[i]);
                                    elemInstanceMap.put(elems[i], instances);
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.log(Level.WARNING, "Getting GSCs from active GSM", e);
                                }
                            }
                            opMgr.startManager(listener, elemInstanceMap);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Getting active GSM", e);
                        }
                    } else {
                        opMgr.startManager(listener);
                    }
                    if (map != null) {
                        map.putAll(errorMap);
                    }
                    this.stateChanged(opMgr, false);
                    OperationalString[] nestedStrings = opString.getNestedOperationalStrings();
                    for (int i = 0; i < nestedStrings.length; ++i) {
                        this.addOperationalString(nestedStrings[i], map, opMgr, dAdmin, listener);
                    }
                    break block31;
                }
                if (parent != null && (mgr = this.getOpStringManager(opString.getName())) != null) {
                    parent.addNested(mgr);
                }
            }
            finally {
                ArrayList arrayList = this.pendingManagers;
                synchronized (arrayList) {
                    this.pendingManagers.remove(opString.getName());
                }
            }
        }
        if (opMgr != null && this.activeProvisionMonitor.isActive(opString.getName())) {
            ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)this.getEventProxy(), 6, opMgr.doGetOperationalString());
            this.processEvent(event);
        }
        return opMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean opStringExists(String opString) {
        boolean exists = false;
        ArrayList arrayList = this.pendingManagers;
        synchronized (arrayList) {
            for (String name : this.pendingManagers) {
                if (!name.equals(opString)) continue;
                exists = true;
                break;
            }
        }
        if (!exists) {
            Enumeration e = this.opStringManagers.elements();
            while (e.hasMoreElements()) {
                OpStringManager opMgr = (OpStringManager)e.nextElement();
                if (!opString.equals(opMgr.getName())) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    protected ProvisionMonitor getEventProxy() {
        return (ProvisionMonitor)this.getServiceProxy();
    }

    @Override
    public OpStringManager getOpStringManager(String name) {
        if (name == null) {
            return null;
        }
        Enumeration e = this.opStringManagers.elements();
        while (e.hasMoreElements()) {
            OpStringManager opMgr = (OpStringManager)e.nextElement();
            if (!name.equals(opMgr.getName())) continue;
            return opMgr;
        }
        return null;
    }

    protected OperationalString[] getOperationalStrings() {
        if (this.opStringManagers.isEmpty()) {
            return new OperationalString[0];
        }
        ArrayList<OpStringManager> list = new ArrayList<OpStringManager>();
        Enumeration e = this.opStringManagers.elements();
        while (e.hasMoreElements()) {
            OpStringManager opMgr = (OpStringManager)e.nextElement();
            if (!opMgr.isTopLevel()) continue;
            list.add(opMgr);
        }
        OperationalString[] os = new OperationalString[list.size()];
        int i = 0;
        for (OpStringManager opMgr : list) {
            try {
                os[i++] = opMgr.getOperationalString();
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Getting all processing units", e2);
            }
        }
        return os;
    }

    @Override
    public void initialize(ServiceBeanContext context) throws Exception {
        try {
            this.logDirName = context.getServiceElement().getServiceBeanConfig().getLogDir();
            if (this.logDirName != null) {
                this.opStringLogHandler = new OpStringLogHandler();
                this.store = new PersistentStore(this.logDirName, this.opStringLogHandler, this.opStringLogHandler);
                logger.log(Level.INFO, "using absolute logdir path [" + this.store.getStoreLocation() + "]");
                this.store.snapshot();
                super.initialize(context, this.store);
                this.inRecovery = false;
            } else {
                super.initialize(context);
            }
            this.config = context.getConfiguration();
            if (this.config == null) {
                throw new NullPointerException("config cannot be null");
            }
            this.activeProvisionMonitor = new ActiveProvisionMonitor(this);
            this.esmMonitor = new EsmMonitor(this.config, context.getDiscoveryManagement());
            this.provisioner = new ServiceProvisioner(this.config, this, this.esmMonitor, this.activeProvisionMonitor);
            this.provisionWatch = new StopWatch("Provision Clock", this.config);
            this.watchRegistry.register(this.provisionWatch);
            int provisionMonitorEventTaskPoolMinimum = 3;
            int provisionMonitorEventTaskPoolMaximum = 10;
            int provisionMonitorEventTaskPoolKeepAliveTime = 60000;
            int provisionMonitorEventTaskPoolWaitTime = 60000;
            try {
                provisionMonitorEventTaskPoolMinimum = Config.getIntEntry((Configuration)this.config, (String)CONFIG_COMPONENT, (String)"provisionMonitorEventTaskPoolMinimum", (int)provisionMonitorEventTaskPoolMinimum, (int)1, (int)20);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception getting provisionMonitorEventTaskPoolMinimum", t);
            }
            try {
                provisionMonitorEventTaskPoolMaximum = Config.getIntEntry((Configuration)this.config, (String)CONFIG_COMPONENT, (String)"provisionMonitorEventTaskPoolMaximum", (int)provisionMonitorEventTaskPoolMaximum, (int)(provisionMonitorEventTaskPoolMinimum + 1), (int)100);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception getting provisionMonitorEventTaskPoolMaximum", t);
            }
            try {
                provisionMonitorEventTaskPoolKeepAliveTime = Config.getIntEntry((Configuration)this.config, (String)CONFIG_COMPONENT, (String)"provisionMonitorEventTaskPoolKeepAliveTime", (int)provisionMonitorEventTaskPoolKeepAliveTime, (int)1, (int)Integer.MAX_VALUE);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception getting provisionMonitorEventTaskPoolKeepAliveTime", t);
            }
            try {
                provisionMonitorEventTaskPoolWaitTime = Config.getIntEntry((Configuration)this.config, (String)CONFIG_COMPONENT, (String)"provisionMonitorEventTaskPoolWaitTime", (int)provisionMonitorEventTaskPoolWaitTime, (int)1, (int)Integer.MAX_VALUE);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception getting provisionMonitorEventTaskPoolWaitTime", t);
            }
            this.monitorEventPool = DynamicExecutors.newEventThreadPool((int)provisionMonitorEventTaskPoolMinimum, (int)provisionMonitorEventTaskPoolMaximum, (long)provisionMonitorEventTaskPoolKeepAliveTime, (long)provisionMonitorEventTaskPoolWaitTime, (ThreadFactory)DynamicExecutors.daemonThreadFactory((String)"ProvisionMonitorEventPool"));
            EventDescriptor clientEventDesc = new EventDescriptor(ProvisionMonitorEvent.class, new Long(2764185076071141340L));
            this.monitorEventHandler = new DispatchEventHandler(clientEventDesc, this.config);
            this.eventTable.put(clientEventDesc.eventID, this.monitorEventHandler);
            EventDescriptor failureEventDesc = new EventDescriptor(ProvisionFailureEvent.class, new Long(-7832310585750966248L));
            this.failureHandler = new DispatchEventHandler(failureEventDesc, this.config);
            this.eventTable.put(new Long(-7832310585750966248L), this.failureHandler);
            this.registerEventAdapters();
            this.provisioner.setProvisionFailureHandler(this.failureHandler);
            this.provisioner.setEventSource(this.getEventProxy());
            this.provisioner.setWatch(this.provisionWatch);
            this.addAttribute((Entry)clientEventDesc);
            this.addAttribute((Entry)failureEventDesc);
            this.addAttribute((Entry)this.getServiceInfo());
            this.opStringLoader = this.getOpStringLoader();
            long initialOpStringLoadDelay = 5000L;
            try {
                initialOpStringLoadDelay = Config.getLongEntry((Configuration)this.config, (String)CONFIG_COMPONENT, (String)"initialOpStringLoadDelay", (long)initialOpStringLoadDelay, (long)1L, (long)Long.MAX_VALUE);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception getting initialOpStringLoadDelay", t);
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("initialOpStringLoadDelay=" + initialOpStringLoadDelay);
            }
            this.taskTimer = new Timer(true);
            if (this.store != null && this.opStringLogHandler != null) {
                this.opStringLogHandler.processRecoveredOpStrings();
                this.opStringLogHandler.processUpdatedOpStrings();
            }
            this.provisionMonitorPeer = new ProvisionMonitorPeer(context.getDiscoveryManagement());
            long now = System.currentTimeMillis();
            this.taskTimer.schedule((TimerTask)new InitialOpStringLoadTask(this.config), new Date(now + initialOpStringLoadDelay));
            if (this.serviceID == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating new ServiceID from UUID=" + this.getUuid().toString());
                }
                this.serviceID = new ServiceID(this.getUuid().getMostSignificantBits(), this.getUuid().getLeastSignificantBits());
            }
            if (this.store != null) {
                this.store.snapshot();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unrecoverable initialization exception", e);
            this.destroy();
        }
    }

    private void registerEventAdapters() throws LeaseDeniedException, UnknownEventException, RemoteException {
        EventDescriptor provisionFailureEventDescriptor = new EventDescriptor(ProvisionFailureEvent.class, -7832310585750966248L);
        ProvisionFailureEventAdapter provisionFailureEventAdapter = new ProvisionFailureEventAdapter(this.objectName, this.getNotificationBroadcasterSupport());
        this.register(provisionFailureEventDescriptor, provisionFailureEventAdapter, null, Long.MAX_VALUE);
        this.mbeanNoticationInfoList.add(provisionFailureEventAdapter.getNotificationInfo());
        EventDescriptor provisionMonitorEventDescriptor = new EventDescriptor(ProvisionMonitorEvent.class, 2764185076071141340L);
        ProvisionMonitorEventAdapter provisionMonitorEventAdapter = new ProvisionMonitorEventAdapter(this.objectName, this.getNotificationBroadcasterSupport());
        this.register(provisionMonitorEventDescriptor, provisionMonitorEventAdapter, null, Long.MAX_VALUE);
        this.mbeanNoticationInfoList.add(provisionMonitorEventAdapter.getNotificationInfo());
    }

    protected OpStringLoader getOpStringLoader() throws Exception {
        return new OpStringLoader(this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stateChanged(OpStringManager opMgr, boolean remove) {
        if (this.inRecovery || this.store == null) {
            return;
        }
        if (!opMgr.isActive()) {
            return;
        }
        try {
            this.store.acquireMutatorLock();
            int action = remove ? 1 : 0;
            this.store.update(new MarshalledObject<RecordHolder>(new RecordHolder(opMgr.getOperationalString(), action)));
        }
        catch (IllegalStateException ise) {
            logger.log(Level.WARNING, "OperationalString state change notification", ise);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "OperationalString state change notification", t);
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    protected void processEvent(ProvisionMonitorEvent event) {
        try {
            this.monitorEventPool.submit((Runnable)new ProvisionMonitorEventTask(this.monitorEventHandler, event));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Creating a ProvisionMonitorEventTask", e);
        }
    }

    @Override
    public OperationalStringManager getPrimary(String name) throws RemoteException {
        OperationalStringManager mgr = null;
        try {
            mgr = this.getOperationalStringManager(name);
            if (mgr.isManaging()) {
                return mgr;
            }
        }
        catch (OperationalStringException operationalStringException) {
            // empty catch block
        }
        mgr = null;
        ProvisionMonitor[] monitors = this.provisionMonitorPeer.getProvisionMonitorPeers();
        for (int i = 0; i < monitors.length; ++i) {
            try {
                DeployAdmin dAdmin = (DeployAdmin)monitors[i].getAdmin();
                OperationalStringManager operationalStringManager = dAdmin.getOperationalStringManager(name);
                if (!operationalStringManager.isManaging()) continue;
                mgr = operationalStringManager;
                break;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Getting the managing GSM for [" + name + "]", e);
            }
        }
        return mgr;
    }

    private Map redirectDeploymentRequestToActivePeer(OperationalString opString, ServiceProvisionListener listener) throws RemoteException, OperationalStringException {
        for (ProvisionMonitor monitor : this.provisionMonitorPeer.getProvisionMonitorPeers()) {
            if (!monitor.isManaging()) continue;
            logger.info("Redirecting deploy request of [" + opString + "] to " + monitor.getPeerInfo());
            DeployAdmin deployAdmin = (DeployAdmin)monitor.getAdmin();
            String puPath = (String)opString.getServices()[0].getServiceBeanConfig().getInitParameters().get("puPath");
            File puFile = new File(System.getProperty("com.gs.deploy") + "/" + puPath);
            try {
                PUZipUtils.uploadProcessingUnit((String)deployAdmin.getDeployURL(), (String)puPath, (File)puFile);
                return deployAdmin.deploy(opString, listener);
            }
            catch (Exception e) {
                throw new OperationalStringException("Failed to redirect deployment request of [" + opString + " to " + monitor.getPeerInfo(), e);
            }
        }
        throw new OperationalStringException("Failed to find active GSM to deploy [" + opString + "]");
    }

    public static int getIntegerFromString(String s, int defaultValue) {
        int value;
        if (s == null) {
            return defaultValue;
        }
        try {
            value = new Integer(s);
        }
        catch (NumberFormatException e) {
            value = defaultValue;
        }
        return value;
    }

    void dumpOpStringError(Map errorMap) {
        if (!errorMap.isEmpty()) {
            Set keys = errorMap.keySet();
            StringBuffer sb = new StringBuffer();
            sb.append("+========================+\n");
            for (Object comp : keys) {
                sb.append("Component: ");
                sb.append(comp);
                Object o = errorMap.get(comp);
                if (o instanceof Throwable) {
                    StackTraceElement[] el = ((Throwable)o).getStackTrace();
                    for (int i = 0; i < el.length; ++i) {
                        sb.append("\tat ");
                        sb.append(el[i]);
                        sb.append("\n");
                    }
                    continue;
                }
                sb.append(" ");
                sb.append(o.toString());
            }
            sb.append("\n+========================+");
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, sb.toString());
            }
        }
    }

    public void dumpGSMInfo(PrintWriter writer) {
        writer.println("\n----- Grid Service Manager Info -----");
        writer.println(this.provisionMonitorPeer.myPeerInfo);
        writer.println("Service Id: " + this.serviceID);
        writer.println("Lookup Groups: " + Arrays.toString(this.admin.getLookupGroups()));
        writer.println("Lookup Locators: " + Arrays.toString(this.admin.getLookupLocators()));
    }

    public void dumpProcessingUnits(PrintWriter writer) {
        OperationalStringManager[] opStringManagers;
        writer.println("\n----- Processing Units -----");
        ArrayList<String> managed = new ArrayList<String>();
        ArrayList<String> monitored = new ArrayList<String>();
        for (OperationalStringManager opStringManager : opStringManagers = this.getOperationalStringManagers()) {
            try {
                String opStringName = opStringManager.getOperationalString().getName();
                if (opStringManager.isManaging()) {
                    managed.add(opStringName);
                    continue;
                }
                monitored.add(opStringName);
            }
            catch (RemoteException re) {
                writer.println("Caught Exception while extracting information for: [" + opStringManager + "]");
            }
        }
        writer.println("Managed Processing Units: " + managed);
        writer.println("Monitored Processing Units: " + monitored);
        writer.println("Processing units being added: " + this.pendingManagers);
        writer.println("Processing unit instances being provisioned: " + this.provisioner.inProcess);
        ArrayList<String> pending = new ArrayList<String>();
        ServiceProvisioner.PendingManager pendingManager = this.provisioner.getPendingManager();
        ProvisionRequest[] provisionRequests = pendingManager.getProvisionRequests();
        for (ProvisionRequest provisionRequest : provisionRequests) {
            pending.add(provisionRequest.sElem.toString());
        }
        writer.println("Processing units pending to be provisioned: " + pending);
        if (!monitored.isEmpty()) {
            writer.println("\n----- Processing Units managed by other GSMs -----");
            for (String opStringName : monitored) {
                try {
                    OperationalStringManager primary = this.getPrimary(opStringName);
                    if (primary == null) {
                        writer.println("Unknown managing GSM for processing unit: [" + opStringName + "]");
                        continue;
                    }
                    try {
                        writer.println("Processing Unit: [" + opStringName + "] is managed by: " + primary.getPeerInfoString());
                    }
                    catch (RemoteException re) {
                        writer.println("Managing GSM for: [" + opStringName + "] is unreachable, caught: " + re + "\n\t" + primary);
                    }
                }
                catch (Exception e) {
                    writer.println("Caught Exception while trying to find managing GSM for processing unit: [" + opStringName + "] - " + JSpaceUtilities.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public void dumpServiceElementInstances(PrintWriter writer) {
        OperationalStringManager[] opStringManagers;
        writer.println("\n----- ServiceElements -----");
        for (OperationalStringManager opStringManager : opStringManagers = this.getOperationalStringManagers()) {
            try {
                OperationalString operationalString = opStringManager.getOperationalString();
                String opStringName = operationalString.getName();
                writer.append("\n[" + opStringName + "] ").append(this.deploymentDetailsToString(operationalString));
                ServiceElement[] services = operationalString.getServices();
                writer.append("\n - status: ").append(OpString.convertStatusToString(operationalString.getStatus()).toUpperCase()).append(", managed: " + opStringManager.isManaging());
                for (ServiceElement serviceElement : services) {
                    writer.append("\n   - ").append(serviceElement.getName()).append(", actual: " + serviceElement.getActual()).append(", planned: " + serviceElement.getPlanned());
                }
                writer.println();
            }
            catch (RemoteException re) {
                writer.println("Caught Exception while extracting information for: [" + opStringManager + "]");
            }
        }
        writer.println();
    }

    public void dumpGridServiceContainersRegistered(PrintWriter writer) {
        LeasedResource[] leasedResources;
        writer.println("\n----- Grid Service Containers -----");
        writer.println("Grid Service Containers registered: " + this.provisioner.landlord.total());
        for (LeasedResource resource : leasedResources = this.provisioner.landlord.getLeasedResources()) {
            if (!(resource instanceof ServiceResource)) continue;
            InstantiatorResource gsc = (InstantiatorResource)((ServiceResource)resource).getResource();
            writer.println("\t " + gsc + "\t - zones: " + (gsc.getZones() == null ? "N/A" : "\t - zones: " + Arrays.toString(gsc.getZones())));
            Object[] activeServiceElements = gsc.getServiceElements();
            writer.println("\t\t processing unit instances: " + Arrays.toString(activeServiceElements));
            Object[] inProcessServiceElements = gsc.getServiceElementsInprocess();
            writer.println("\t\t instantiating: " + Arrays.toString(inProcessServiceElements));
        }
    }

    public void dumpGridServiceManagersRegistered(PrintWriter writer) {
        writer.println("\n----- Grid Service Managers -----");
        if (this.provisionMonitorPeer.backup != null) {
            writer.println("GSM assigned as a backup: " + this.provisionMonitorPeer.getPeerInfo(this.provisionMonitorPeer.backup));
        } else {
            writer.println("GSM assigned as a backup: none");
        }
        if (this.provisionMonitorPeer.backupList.isEmpty()) {
            writer.println("Serving as a backup for GSMs: none");
        } else {
            ArrayList<ProvisionMonitor.PeerInfo> backupFor = new ArrayList<ProvisionMonitor.PeerInfo>(this.provisionMonitorPeer.backupList.size());
            for (ProvisionMonitor provisionMonitor : this.provisionMonitorPeer.backupList) {
                backupFor.add(this.provisionMonitorPeer.getPeerInfo(provisionMonitor));
            }
            writer.println("Serving as a backup for GSMs: " + backupFor);
        }
        ProvisionMonitor.PeerInfo[] peers = this.provisionMonitorPeer.getPeers();
        writer.println("Grid Service Managers registered: " + peers.length);
        for (ProvisionMonitor.PeerInfo peerInfo : peers) {
            writer.println("\t " + peerInfo);
        }
    }

    protected Events getEvents(long cursor, int maxEvents) {
        return this.eventsStore.getEventsFromCursor(cursor, maxEvents);
    }

    protected boolean isInstancesBeingProvisioned(String name) {
        return this.provisioner.getProvisionTasksCount(name) > 0;
    }

    protected PoolableThread executeQuiesce(QuiesceTask quiesceTask) {
        return this.provisioner.execute(quiesceTask);
    }

    class OpStringLogHandler
    extends LogHandler
    implements SnapshotHandler {
        Vector recoveredOpstrings = new Vector();
        Vector updatedOpstrings = new Vector();
        boolean opStringsRecovered = false;

        OpStringLogHandler() {
        }

        public void snapshot(OutputStream out) throws IOException {
            ObjectOutputStream oostream = new ObjectOutputStream(out);
            oostream.writeUTF(ProvisionMonitorImpl.class.getName());
            oostream.writeInt(1);
            ArrayList<OperationalString> list = new ArrayList<OperationalString>();
            OperationalString[] opStrings = ProvisionMonitorImpl.this.getOperationalStrings();
            for (int i = 0; i < opStrings.length; ++i) {
                list.add(opStrings[i]);
            }
            oostream.writeObject(new MarshalledObject(list));
            oostream.flush();
        }

        public void recover(InputStream in) throws Exception {
            ProvisionMonitorImpl.this.inRecovery = true;
            ObjectInputStream oistream = new ObjectInputStream(in);
            if (!ProvisionMonitorImpl.class.getName().equals(oistream.readUTF())) {
                throw new IOException("Log from wrong implementation");
            }
            if (oistream.readInt() != 1) {
                throw new IOException("Wrong log format version");
            }
            MarshalledObject mo = (MarshalledObject)oistream.readObject();
            ArrayList list = (ArrayList)mo.get();
            for (OperationalString opString : list) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Recovered : " + opString.getName());
                }
                this.recoveredOpstrings.add(opString);
                this.opStringsRecovered = true;
            }
        }

        public void applyUpdate(Object update) throws Exception {
            if (update instanceof MarshalledObject) {
                RecordHolder holder = (RecordHolder)((MarshalledObject)update).get();
                this.updatedOpstrings.add(holder);
                this.opStringsRecovered = true;
            }
        }

        @Override
        public void updatePerformed(int updateCount) {
            if (updateCount >= ProvisionMonitorImpl.this.logToSnapshotThresh) {
                ProvisionMonitorImpl.this.snapshotter.takeSnapshot();
            }
        }

        @Override
        public void takeSnapshot() {
            ProvisionMonitorImpl.this.snapshotter.takeSnapshot();
        }

        boolean opStringsRecovered() {
            return this.opStringsRecovered;
        }

        void processRecoveredOpStrings() {
            Enumeration e = this.recoveredOpstrings.elements();
            while (e.hasMoreElements()) {
                OperationalString opString = (OperationalString)e.nextElement();
                try {
                    if (!ProvisionMonitorImpl.this.opStringExists(opString.getName())) {
                        HashMap map = new HashMap();
                        ProvisionMonitorImpl.this.addOperationalString(opString, map, null, null, null);
                        ProvisionMonitorImpl.this.dumpOpStringError(map);
                        continue;
                    }
                    OpStringManager opMgr = ProvisionMonitorImpl.this.getOpStringManager(opString.getName());
                    Map map = opMgr.updateOperationalString(opString);
                    ProvisionMonitorImpl.this.dumpOpStringError(map);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Processing recovered OperationalStrings", ex);
                }
            }
            this.recoveredOpstrings.clear();
        }

        void processUpdatedOpStrings() throws OperationalStringException {
            Enumeration e = this.updatedOpstrings.elements();
            while (e.hasMoreElements()) {
                RecordHolder holder = (RecordHolder)e.nextElement();
                OperationalString opString = holder.getOperationalString();
                try {
                    if (holder.getAction() == 0) {
                        if (!ProvisionMonitorImpl.this.opStringExists(opString.getName())) {
                            HashMap map = new HashMap();
                            ProvisionMonitorImpl.this.addOperationalString(opString, map, null, null, null);
                            ProvisionMonitorImpl.this.dumpOpStringError(map);
                            continue;
                        }
                        OpStringManager opMgr = ProvisionMonitorImpl.this.getOpStringManager(opString.getName());
                        Map map = opMgr.updateOperationalString(opString);
                        ProvisionMonitorImpl.this.dumpOpStringError(map);
                        continue;
                    }
                    ProvisionMonitorImpl.this.undeploy(opString.getName(), false);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Processing updated OperationalStrings", ex);
                }
            }
            this.updatedOpstrings.clear();
        }
    }

    class ProvisionMonitorPeer
    extends ServiceDiscoveryAdapter
    implements RemoteServiceEventListener,
    FaultDetectionListener,
    Runnable {
        ProvisionMonitor.PeerInfo myPeerInfo;
        BasicEventConsumer eventConsumer;
        Map opStringTable = new HashMap();
        List<ProvisionMonitor> backupList = new ArrayList<ProvisionMonitor>();
        ProvisionMonitor backup;
        Set<ProvisionMonitor.PeerInfo> peerSet = new TreeSet<ProvisionMonitor.PeerInfo>();
        boolean localBackup = false;
        Hashtable fdhTable = new Hashtable();
        ServiceTemplate template;
        DiscoveryManagement dm;
        BackwardsServiceDiscoveryManager sdm;
        LookupCache lCache;

        ProvisionMonitorPeer(DiscoveryManagement dm) {
            try {
                this.dm = dm;
                Random rand = new Random(System.currentTimeMillis());
                long randomNumber = rand.nextLong();
                this.myPeerInfo = new ProvisionMonitor.PeerInfo("GSM", (ProvisionMonitor)ProvisionMonitorImpl.this.getServiceProxy(), randomNumber, ProvisionMonitorImpl.this.computeResource.getResourceCapability());
                this.eventConsumer = new BasicEventConsumer(new EventDescriptor(ProvisionMonitorEvent.class, new Long(2764185076071141340L)), this, ProvisionMonitorImpl.this.config);
                this.template = new ServiceTemplate(null, new Class[]{ProvisionMonitor.class}, null);
                new Thread(this).start();
            }
            catch (Exception e) {
                peerLogger.log(Level.WARNING, "Constructing a ProvisionMonitorPeer", e);
            }
        }

        void terminate() {
            Enumeration en = this.fdhTable.elements();
            while (en.hasMoreElements()) {
                FaultDetectionHandler fdh = (FaultDetectionHandler)en.nextElement();
                fdh.terminate();
            }
            this.eventConsumer.deregister(this);
            if (this.eventConsumer != null) {
                this.eventConsumer.terminate();
            }
            if (this.sdm != null) {
                this.sdm.terminate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addAsBackupFor(ProvisionMonitor primary) {
            boolean assigned = false;
            int listSize = 0;
            List<ProvisionMonitor> list = this.backupList;
            synchronized (list) {
                if (!this.backupList.contains(primary)) {
                    assigned = this.backupList.add(primary);
                }
                listSize = this.backupList.size();
            }
            if (assigned) {
                ProvisionMonitor.PeerInfo peer = this.getPeerInfo(primary);
                ProvisionMonitor[] provisioners = this.getProvisionMonitorPeers();
                if (peer == null) {
                    ProvisionMonitor[] adjustedProvisioners = new ProvisionMonitor[provisioners.length + 1];
                    if (provisioners.length > 0) {
                        System.arraycopy(provisioners, 0, adjustedProvisioners, 0, provisioners.length);
                    }
                    adjustedProvisioners[provisioners.length] = primary;
                    provisioners = adjustedProvisioners;
                }
                this.myPeerInfo.setBackupCount(listSize);
                new Thread(new PeerNotificationTask(provisioners, this.myPeerInfo)).start();
            }
            return assigned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeAsBackupFor(ProvisionMonitor primary) {
            boolean removed = false;
            int listSize = 0;
            List<ProvisionMonitor> list = this.backupList;
            synchronized (list) {
                removed = this.backupList.remove(primary);
                listSize = this.backupList.size();
            }
            if (removed) {
                this.myPeerInfo.setBackupCount(listSize);
                this.notifyPeers(this.myPeerInfo);
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProvisionMonitor.PeerInfo doGetPeerInfo() {
            List<ProvisionMonitor> list = this.backupList;
            synchronized (list) {
                int bCount = this.backupList.size();
                this.myPeerInfo.setBackupCount(bCount);
            }
            return this.myPeerInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProvisionMonitor.PeerInfo[] getBackupInfo() {
            ArrayList<ProvisionMonitor.PeerInfo> list = new ArrayList<ProvisionMonitor.PeerInfo>();
            Set<ProvisionMonitor.PeerInfo> set = this.peerSet;
            synchronized (set) {
                Iterator<ProvisionMonitor.PeerInfo> it = this.peerSet.iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
            }
            return list.toArray(new ProvisionMonitor.PeerInfo[list.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void peerUpdated(ProvisionMonitor.PeerInfo peer) {
            if (peer == null) {
                if (peerLogger.isLoggable(Level.FINE)) {
                    peerLogger.log(Level.FINE, "Failed to update backup count for unknown GSM");
                }
                return;
            }
            Set<ProvisionMonitor.PeerInfo> set = this.peerSet;
            synchronized (set) {
                if (this.peerSet.remove(peer)) {
                    this.peerSet.add(peer);
                }
            }
            if (peerLogger.isLoggable(Level.FINE)) {
                peerLogger.log(Level.FINE, "Updated backup count for GSM - [" + peer + "], backups [" + peer.getBackupCount() + "]");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProvisionMonitor.PeerInfo addProvisioner(ServiceItem item) {
            ProvisionMonitor.PeerInfo peer = null;
            try {
                if (ProvisionMonitorImpl.this.getServiceProxy().equals(item.service)) {
                    return null;
                }
                peer = ((ProvisionMonitor)item.service).getPeerInfo();
                if (!this.allowedToConnect(peer.getService())) {
                    peerLogger.log(Level.WARNING, "Security restriction - unable to connect with GSM - [" + peer + "] service-id[" + item.serviceID + "]");
                    return null;
                }
                Set<ProvisionMonitor.PeerInfo> set = this.peerSet;
                synchronized (set) {
                    this.peerSet.add(peer);
                }
                peerLogger.log(Level.INFO, "Registered GSM - [" + peer + "] service-id[" + item.serviceID + "]");
                this.eventConsumer.register(item);
                this.importOperationalStringsWithRetries((ProvisionMonitor)item.service);
            }
            catch (Exception e) {
                peerLogger.log(Level.WARNING, "Failed Registering GSM - service-id[" + item.serviceID + "]", e);
            }
            return peer;
        }

        private boolean allowedToConnect(ProvisionMonitor provisionMonitor) {
            return !(provisionMonitor instanceof SecuredGSMProxy) ^ this.myPeerInfo.getService() instanceof SecuredGSMProxy;
        }

        @Override
        public void serviceAdded(ServiceDiscoveryEvent sdEvent) {
            ServiceItem item = sdEvent.getPostEventServiceItem();
            ProvisionMonitor.PeerInfo peer = this.getPeerInfo((ProvisionMonitor)item.service);
            if (peer != null) {
                return;
            }
            peer = this.addProvisioner(item);
            if (peer == null) {
                return;
            }
            if (this.backup == null) {
                if (peerLogger.isLoggable(Level.FINE)) {
                    peerLogger.log(Level.FINE, "GSM has no backup, trying to assign [" + peer + "] as backup");
                }
                this.doAssignment(peer);
            } else if (this.localBackup && !this.myPeerInfo.getHostAddress().equals(peer.getHostAddress()) && !this.myPeerInfo.getHostName().equals(peer.getHostName())) {
                ProvisionMonitor currentBackup = this.backup;
                if (this.doAssignment(peer)) {
                    try {
                        currentBackup.removeBackupFor((ProvisionMonitor)ProvisionMonitorImpl.this.getServiceProxy());
                    }
                    catch (Exception e) {
                        peerLogger.log(Level.WARNING, "Failed removing backup on local-machine", e);
                    }
                }
            }
            this.setFaultDetectionHandler(item.service, item.serviceID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceFailure(Object service, ServiceID serviceID) {
            this.eventConsumer.deregister(serviceID, false);
            ProvisionMonitor primary = null;
            ProvisionMonitor.PeerInfo info = this.getPeerInfo((ProvisionMonitor)service);
            if (info == null) {
                if (peerLogger.isLoggable(Level.FINE)) {
                    peerLogger.log(Level.FINE, "Non-registered GSM has left the network. service-id[" + serviceID + "]");
                }
                return;
            }
            Set<ProvisionMonitor.PeerInfo> set = this.peerSet;
            synchronized (set) {
                if (this.peerSet.remove(info) && peerLogger.isLoggable(Level.INFO)) {
                    peerLogger.log(Level.INFO, "Unregistered GSM - [" + info + "] service-id[" + serviceID + "]");
                }
            }
            if (this.backup != null && this.backup.equals(service)) {
                if (peerLogger.isLoggable(Level.FINE)) {
                    peerLogger.log(Level.FINE, "Backup GSM has left the network. service-id[" + serviceID + "]");
                }
                if (!this.assignBackup()) {
                    this.backup = null;
                    if (peerLogger.isLoggable(Level.FINE)) {
                        peerLogger.log(Level.FINE, "Did not locate another GSM to set as backup. service-id[" + serviceID + "]");
                    }
                }
            }
            boolean removedBackup = false;
            int listSize = 0;
            List<ProvisionMonitor> list = this.backupList;
            synchronized (list) {
                int index = this.backupList.indexOf(service);
                if (index != -1) {
                    removedBackup = true;
                    primary = this.backupList.remove(index);
                    listSize = this.backupList.size();
                }
            }
            if (removedBackup) {
                this.myPeerInfo.setBackupCount(listSize);
                this.notifyPeers(this.myPeerInfo);
            }
            List opMgrList = null;
            Map index = this.opStringTable;
            synchronized (index) {
                opMgrList = (List)this.opStringTable.remove(primary);
            }
            if (opMgrList != null) {
                if (peerLogger.isLoggable(Level.INFO)) {
                    peerLogger.log(Level.INFO, "Served as backup of GSM - [" + info + "], service-list: " + opMgrList);
                }
                if (ProvisionMonitorImpl.this.activeProvisionMonitor.isActiveActive()) {
                    for (OpStringManager opMgr : opMgrList) {
                        opMgr.setActive(true);
                        if (!peerLogger.isLoggable(Level.FINE)) continue;
                        peerLogger.log(Level.FINE, "Now managing: " + opMgr.getName());
                    }
                    if (peerLogger.isLoggable(Level.INFO)) {
                        peerLogger.log(Level.INFO, "GSM took over management of: " + opMgrList);
                    }
                }
                for (OpStringManager opMgr : opMgrList) {
                    if (!opMgr.isActive()) continue;
                    ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), 13, opMgr.doGetOperationalString());
                    ProvisionMonitorImpl.this.processEvent(event);
                }
            } else if (peerLogger.isLoggable(Level.INFO)) {
                peerLogger.log(Level.INFO, "Did not serve as backup of GSM - [" + info + "]");
            }
            this.fdhTable.remove(serviceID);
        }

        void notifyPeers(ProvisionMonitor.PeerInfo info) {
            new Thread(new PeerNotificationTask(this.getProvisionMonitorPeers(), info)).start();
        }

        boolean assignBackup() {
            boolean assignedBackup = false;
            ProvisionMonitor.PeerInfo[] peers = this.getPeers();
            if (peers.length > 0) {
                for (int i = 0; i < peers.length; ++i) {
                    if (this.myPeerInfo.getHostAddress().equals(peers[i].getHostAddress()) || this.myPeerInfo.getHostName().equals(peers[i].getHostName()) || !this.doAssignment(peers[i])) continue;
                    assignedBackup = true;
                    this.localBackup = false;
                    break;
                }
                if (!assignedBackup && this.doAssignment(peers[0])) {
                    this.localBackup = true;
                    assignedBackup = true;
                }
            }
            return assignedBackup;
        }

        boolean doAssignment(ProvisionMonitor.PeerInfo peer) {
            boolean assigned = false;
            try {
                ProvisionMonitor service = peer.getService();
                this.addAsBackupFor(service);
                this.backup = service;
                this.backup.assignBackupFor((ProvisionMonitor)ProvisionMonitorImpl.this.getServiceProxy());
                if (peerLogger.isLoggable(Level.INFO)) {
                    peerLogger.log(Level.INFO, "Assigned " + peer + " as backup");
                }
                assigned = true;
            }
            catch (Exception e) {
                String message = e.getMessage() != null ? e.getMessage() : e.toString();
                peerLogger.log(Level.WARNING, "Caught " + message + " when trying to assign " + peer + " as backup", e);
            }
            return assigned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProvisionMonitor.PeerInfo[] getPeers() {
            ProvisionMonitor.PeerInfo[] peers = null;
            Set<ProvisionMonitor.PeerInfo> set = this.peerSet;
            synchronized (set) {
                peers = this.peerSet.toArray(new ProvisionMonitor.PeerInfo[this.peerSet.size()]);
            }
            return peers;
        }

        ProvisionMonitor[] getProvisionMonitorPeers() {
            ProvisionMonitor.PeerInfo[] peers = this.getPeers();
            ProvisionMonitor[] provisioners = new ProvisionMonitor[peers.length];
            for (int i = 0; i < provisioners.length; ++i) {
                provisioners[i] = peers[i].getService();
            }
            return provisioners;
        }

        ProvisionMonitor.PeerInfo getPeerInfo(ProvisionMonitor monitor) {
            ProvisionMonitor.PeerInfo[] peers = this.getPeers();
            ProvisionMonitor.PeerInfo peer = null;
            for (int i = 0; i < peers.length; ++i) {
                if (!peers[i].getService().equals(monitor)) continue;
                peer = peers[i];
                break;
            }
            return peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(RemoteServiceEvent event) {
            try {
                Object eventSource = event.getSource();
                if (!(eventSource instanceof ProvisionMonitor)) {
                    if (peerLogger.isLoggable(Level.FINE)) {
                        peerLogger.log(Level.FINE, "ProvisionMonitorPeer: unknown event source : " + eventSource.getClass().getName());
                    }
                    return;
                }
                ProvisionMonitor remoteMonitor = (ProvisionMonitor)eventSource;
                String opStringName = null;
                OpStringManager opMgr = null;
                ProvisionMonitorEvent pme = (ProvisionMonitorEvent)event;
                OperationalString opString = pme.getOperationalString();
                ServiceElement sElem = pme.getServiceElement();
                int action = pme.getAction();
                switch (action) {
                    case 1: 
                    case 2: 
                    case 3: {
                        String sAction = "SERVICE_ELEMENT_UPDATED";
                        if (action == 2) {
                            sAction = "SERVICE_BEAN_INCREMENTED";
                        }
                        if (action == 3) {
                            sAction = "SERVICE_BEAN_DECREMENTED";
                        }
                        if (sElem == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: " + sAction + " sElem is null");
                            }
                            return;
                        }
                        opStringName = sElem.getOperationalStringName();
                        if (peerLogger.isLoggable(Level.FINEST)) {
                            peerLogger.finest("ProvisionMonitorPeer: " + sAction + ", opstring: " + opStringName);
                        }
                        if ((opMgr = ProvisionMonitorImpl.this.getOpStringManager(opStringName)) == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: " + sAction + " opstring [" + opStringName + "] not found");
                            }
                            return;
                        }
                        try {
                            opMgr.doUpdateServiceElement(sElem);
                        }
                        catch (Exception e) {
                            peerLogger.log(Level.WARNING, "Updating service: " + sElem, e);
                        }
                        break;
                    }
                    case 4: {
                        if (sElem == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_ELEMENT_ADDED sElem is null");
                            }
                            return;
                        }
                        opStringName = sElem.getOperationalStringName();
                        if (peerLogger.isLoggable(Level.FINEST)) {
                            peerLogger.finest("ProvisionMonitorPeer: SERVICE_ELEMENT_ADDED, opstring: " + opStringName);
                        }
                        if ((opMgr = ProvisionMonitorImpl.this.getOpStringManager(opStringName)) == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_ELEMENT_ADDED opstring [" + opStringName + "] not found");
                            }
                            return;
                        }
                        try {
                            opMgr.doAddServiceElement(sElem);
                        }
                        catch (Exception e) {
                            peerLogger.log(Level.WARNING, "Adding ServiceElement to OperationalStringManager", e);
                        }
                        break;
                    }
                    case 5: {
                        if (sElem == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_ELEMENT_REMOVED sElem is null");
                            }
                            return;
                        }
                        opStringName = sElem.getOperationalStringName();
                        if (peerLogger.isLoggable(Level.FINEST)) {
                            peerLogger.finest("ProvisionMonitorPeer: SERVICE_ELEMENT_REMOVED, opstring: " + opStringName);
                        }
                        if ((opMgr = ProvisionMonitorImpl.this.getOpStringManager(opStringName)) == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_ELEMENT_REMOVED opstring [" + opStringName + "] not found");
                            }
                            return;
                        }
                        try {
                            opMgr.doRemoveServiceElement(sElem, false);
                        }
                        catch (Exception e) {
                            peerLogger.log(Level.WARNING, "Removing ServiceElement from OperationalStringManager", e);
                        }
                        break;
                    }
                    case 6: {
                        if (opString == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: OPSTRING_DEPLOYED opstring is null");
                            }
                            return;
                        }
                        DeployAdmin deployAdmin = (DeployAdmin)remoteMonitor.getAdmin();
                        this.opStringProcessor(opString, remoteMonitor, deployAdmin);
                        if (!peerLogger.isLoggable(Level.FINEST)) break;
                        peerLogger.finest("ProvisionMonitorPeer: OPSTRING_DEPLOYED, opstring: " + opString.getName());
                        break;
                    }
                    case 7: {
                        if (opString == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: OPSTRING_UNDEPLOYED opstring is null");
                            }
                            return;
                        }
                        if (peerLogger.isLoggable(Level.FINEST)) {
                            peerLogger.finest("ProvisionMonitorPeer: OPSTRING_UNDEPLOYED, opstring: " + opString.getName());
                        }
                        if ((opMgr = ProvisionMonitorImpl.this.getOpStringManager(opString.getName())) == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: OPSTRING_UNDEPLOYED for opstring [" + opString.getName() + "] not found");
                            }
                            return;
                        }
                        opMgr.setDeploymentStatus(0);
                        opMgr.terminate(false, false);
                        Map map = this.opStringTable;
                        synchronized (map) {
                            if (this.opStringTable.containsKey(remoteMonitor)) {
                                List list = (List)this.opStringTable.get(remoteMonitor);
                                list.remove(opMgr);
                                this.opStringTable.put(remoteMonitor, list);
                            }
                            break;
                        }
                    }
                    case 13: {
                        if (opString == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: OPSTRING_MGR_CHANGED opstring is null");
                            }
                            return;
                        }
                        if (peerLogger.isLoggable(Level.FINE)) {
                            peerLogger.fine("ProvisionMonitorPeer: OPSTRING_MGR_CHANGED, opstring: " + opString.getName());
                        }
                        if ((opMgr = ProvisionMonitorImpl.this.getOpStringManager(opString.getName())) == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: OPSTRING_MGR_CHANGED opstring [" + opString.getName() + "] not found");
                            }
                            return;
                        }
                        Map map = this.opStringTable;
                        synchronized (map) {
                            List list = null;
                            list = this.opStringTable.containsKey(remoteMonitor) ? (List)this.opStringTable.get(remoteMonitor) : new ArrayList();
                            if (!list.contains(opMgr)) {
                                list.add(opMgr);
                                this.opStringTable.put(remoteMonitor, list);
                                if (peerLogger.isLoggable(Level.FINE)) {
                                    peerLogger.fine("ProvisionMonitorPeer: Reset backup peer for [" + opString.getName() + "] to " + remoteMonitor.toString());
                                }
                            } else if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.fine("ProvisionMonitorPeer: Already a backup for [" + opString.getName() + "] to " + remoteMonitor.toString());
                            }
                            break;
                        }
                    }
                    case 8: {
                        if (opString == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: OPSTRING_UNDEPLOYED opstring is null");
                            }
                            return;
                        }
                        if (peerLogger.isLoggable(Level.FINEST)) {
                            peerLogger.finest("ProvisionMonitorPeer: OPSTRING_UPDATED, opstring: " + opString.getName());
                        }
                        if ((opMgr = ProvisionMonitorImpl.this.getOpStringManager(opString.getName())) == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: OPSTRING_UPDATED for opstring [" + opString.getName() + "] not found");
                            }
                            return;
                        }
                        opMgr.doUpdateOperationalString(opString);
                        break;
                    }
                    case 9: {
                        ServiceBeanInstance instance = pme.getServiceBeanInstance();
                        if (instance == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_BEAN_INSTANCE_UPDATED instance is null");
                            }
                            return;
                        }
                        opStringName = pme.getOperationalStringName();
                        if (peerLogger.isLoggable(Level.FINEST)) {
                            peerLogger.finest("ProvisionMonitorPeer: SERVICE_BEAN_INSTANCE_UPDATED, opstring: " + opStringName);
                        }
                        if ((opMgr = ProvisionMonitorImpl.this.getOpStringManager(opStringName)) == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_BEAN_INSTANCE_UPDATED for opstring [" + opStringName + "] not found");
                            }
                            return;
                        }
                        try {
                            opMgr.doUpdateServiceBeanInstance(instance);
                        }
                        catch (Exception e) {
                            peerLogger.log(Level.WARNING, "Updating OperationalStringManager's ServiceBeanInstance", e);
                        }
                        break;
                    }
                    case 11: {
                        ServiceBeanInstance instance = pme.getServiceBeanInstance();
                        if (instance == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_PROVISIONED instance is null");
                            }
                            return;
                        }
                        opStringName = pme.getOperationalStringName();
                        if (peerLogger.isLoggable(Level.FINEST)) {
                            peerLogger.finest("ProvisionMonitorPeer: SERVICE_PROVISIONED, opstring: " + opStringName);
                        }
                        if ((opMgr = ProvisionMonitorImpl.this.getOpStringManager(opStringName)) == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_PROVISIONED for opstring [" + opStringName + "] OpStringManager not found");
                            }
                            return;
                        }
                        ServiceElementManager mgr = opMgr.getServiceElementManager(sElem);
                        if (mgr == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: SERVICE_PROVISIONED for opstring [" + opStringName + "] ServiceElementManager not found");
                            }
                            return;
                        }
                        if (!opMgr.isManaging()) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("notified of SERVICE_PROVISIONED for [" + opStringName + "] updating current plan [" + mgr.getServiceElement().getPlanned() + "] with new plan [" + sElem.getPlanned() + "]");
                            }
                            mgr.updatePlanOnServiceProvisionedEvent(sElem.getPlanned());
                        }
                        mgr.importServiceBeanInstance(instance);
                        ServiceChannel channel = ServiceChannel.getInstance();
                        channel.broadcast(new ServiceChannel.ServiceChannelEvent(this, sElem, instance, 1));
                        break;
                    }
                    case 10: {
                        opMgr = ProvisionMonitorImpl.this.getOpStringManager(pme.getOperationalStringName());
                        if (opMgr == null) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.log(Level.FINE, "ProvisionMonitorPeer: REDEPLOY_REQUEST opstring [" + opStringName + "] not found");
                            }
                            return;
                        }
                        Object[] parms = pme.getRedeploymentParms();
                        Date redeployDate = (Date)parms[0];
                        boolean clean = (Boolean)parms[1];
                        ServiceProvisionListener listener = (ServiceProvisionListener)parms[2];
                        long delay = redeployDate.getTime() - System.currentTimeMillis();
                        if (delay <= 0L) {
                            if (!peerLogger.isLoggable(Level.FINE)) break;
                            peerLogger.log(Level.FINE, "ProvisionMonitorPeer: REDEPLOY_REQUEST for opstring [" + opStringName + "] startTime has already passed, scheduled redeployment cancelled");
                            break;
                        }
                        opMgr.doScheduleReploymentTask(delay, pme.getServiceElement(), pme.getServiceBeanInstance(), clean, listener);
                    }
                }
            }
            catch (Throwable t) {
                peerLogger.log(Level.WARNING, "ProvisionMonitorEvent notification", t);
            }
        }

        @Override
        public void run() {
            try {
                this.sdm = new BackwardsServiceDiscoveryManager(this.dm, SharedLeaseRenewalManager.getLeaseRenewalManager(), ProvisionMonitorImpl.this.config);
                this.lCache = this.sdm.createLookupCache(this.template, null, (ServiceDiscoveryListener)this);
                if (!this.assignBackup() && peerLogger.isLoggable(Level.INFO)) {
                    peerLogger.log(Level.INFO, "A backup GSM has not yet been discovered. To ensure high availability, make sure that another GSM is running.");
                }
            }
            catch (Exception e) {
                peerLogger.log(Level.WARNING, "GSM discovery", e);
            }
        }

        void setFaultDetectionHandler(Object service, ServiceID serviceID) {
            try {
                if (serviceID == null) {
                    peerLogger.info("No ServiceID for newly discovered ProvisionMonitor, cant setup FDH");
                    return;
                }
                ServiceBeanAdmin sbAdmin = (ServiceBeanAdmin)((Administrable)service).getAdmin();
                ClassBundle fdhBundle = sbAdmin.getServiceElement().getFaultDetectionHandlerBundle();
                FaultDetectionHandler fdh = FaultDetectionHandlerFactory.getFaultDetectionHandler(fdhBundle, service.getClass().getClassLoader());
                fdh.register(this);
                fdh.monitor(service, serviceID, this.lCache);
                this.fdhTable.put(serviceID, fdh);
            }
            catch (Exception e) {
                peerLogger.log(Level.WARNING, "Setting FaultDetectionHandler for a newly discovered ProvisionMonitor", e);
                this.serviceFailure(service, serviceID);
            }
        }

        void importOperationalStringsWithRetries(ProvisionMonitor peer) {
            for (int retry = 6; retry > 0; --retry) {
                try {
                    boolean changed = this.importOperationalStrings(peer);
                    if (!changed) break;
                    if (retry > 0) {
                        ProvisionMonitor.PeerInfo peerInfo = this.getPeerInfo(peer);
                        peerLogger.log(Level.INFO, "Performing another recovery attempt from peer GSM [" + peerInfo + "] (until no new Processing Units recovered). Retry [" + retry + "] more time(s).");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    peerLogger.log(Level.INFO, "Not performing another recovery attempt from peer GSM. Max number of retries reached.");
                    continue;
                }
                catch (IOException e) {
                    if (peerLogger.isLoggable(Level.FINEST)) {
                        peerLogger.log(Level.FINEST, "Caught exception trying to extract operational string from peer. Retry [" + retry + "] more time(s).", e);
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (retry != 0) continue;
                    peerLogger.log(Level.SEVERE, "Unable to recover processing units", e);
                    continue;
                }
                catch (Exception e) {
                    peerLogger.log(Level.SEVERE, "Failed to recover processing units", e);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean importOperationalStrings(ProvisionMonitor peer) throws RemoteException, InterruptedException {
            if (peerLogger.isLoggable(Level.FINE)) {
                peerLogger.fine("Before import, GSM (active=" + ProvisionMonitorImpl.this.activeProvisionMonitor.isActive() + ") has processing units: " + Arrays.toString(ProvisionMonitorImpl.this.getOperationalStrings()));
            }
            boolean changed = false;
            ProvisionMonitor.PeerInfo remotePeerInfo = peer.getPeerInfo();
            DeployAdmin peerDeployAdmin = (DeployAdmin)peer.getAdmin();
            OperationalStringManager[] opStringMgrs = peerDeployAdmin.getOperationalStringManagers();
            if (opStringMgrs == null || opStringMgrs.length == 0) {
                if (peerLogger.isLoggable(Level.INFO)) {
                    peerLogger.info("Remote peer [" + remotePeerInfo + "] does not have any processing units");
                }
                return changed;
            }
            Object[] remoteOpStrings = new OperationalString[opStringMgrs.length];
            for (int i = 0; i < opStringMgrs.length; ++i) {
                remoteOpStrings[i] = opStringMgrs[i].getOperationalString();
            }
            if (peerLogger.isLoggable(Level.INFO)) {
                peerLogger.info("Remote peer [" + remotePeerInfo + "] has " + remoteOpStrings.length + " processing units " + Arrays.toString(remoteOpStrings));
            }
            ArrayList<String> recoveredOpStrings = new ArrayList<String>(opStringMgrs.length);
            if (ProvisionMonitorImpl.this.activeProvisionMonitor.isActivePassive()) {
                for (Object remoteOpString : remoteOpStrings) {
                    recoveredOpStrings.add(remoteOpString.getName());
                    this.opStringProcessor((OperationalString)remoteOpString, peer, peerDeployAdmin);
                }
            } else {
                for (int i = 0; i < remoteOpStrings.length; ++i) {
                    String OpStringName = remoteOpStrings[i].getName();
                    boolean isManaged = false;
                    boolean isManagedBySelf = false;
                    boolean isManagedByPeer = false;
                    block8: for (int r = 1; r <= 12; ++r) {
                        OpStringManager selfOperationalStringManager = ProvisionMonitorImpl.this.getOpStringManager(OpStringName);
                        if (selfOperationalStringManager != null && selfOperationalStringManager.isManaging()) {
                            isManaged = true;
                            isManagedBySelf = true;
                            break;
                        }
                        if (ProvisionMonitorImpl.this.getPrimary(OpStringName) != null) {
                            isManaged = true;
                            for (int peerIndex = 0; peerIndex < opStringMgrs.length; ++peerIndex) {
                                if (!opStringMgrs[peerIndex].isManaging()) continue;
                                isManagedByPeer = true;
                                break block8;
                            }
                            break;
                        }
                        if (peerLogger.isLoggable(Level.INFO)) {
                            peerLogger.info("Waiting for a GSM to manage [" + OpStringName + "], retry [" + r + "]");
                        }
                        Thread.sleep(5000L);
                    }
                    if (isManaged) {
                        if (isManagedByPeer) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.fine("GSM - [" + remotePeerInfo + "] is managing [" + OpStringName + "]");
                            }
                            recoveredOpStrings.add(OpStringName);
                        } else if (isManagedBySelf) {
                            if (peerLogger.isLoggable(Level.FINE)) {
                                peerLogger.fine("GSM is already managing [" + OpStringName + "]");
                            }
                        } else if (peerLogger.isLoggable(Level.FINE)) {
                            peerLogger.fine("Another GSM is managing [" + OpStringName + "]");
                        }
                        if (isManagedByPeer || isManagedBySelf) {
                            boolean opstringProcessorChanged = this.opStringProcessor((OperationalString)remoteOpStrings[i], peer, peerDeployAdmin);
                            changed = changed || opstringProcessorChanged;
                            continue;
                        }
                        if (!peerLogger.isLoggable(Level.FINEST)) continue;
                        peerLogger.finest("Not processing [" + OpStringName + "]");
                        continue;
                    }
                    peerLogger.warning("Could not find a GSM that is managing [" + OpStringName + "]; Acquiring control over [" + OpStringName + "]");
                    boolean added = this.opStringProcessor((OperationalString)remoteOpStrings[i], peer, null);
                    changed = changed || added;
                }
            }
            if (peerLogger.isLoggable(Level.INFO)) {
                if (recoveredOpStrings.isEmpty()) {
                    peerLogger.info("No processing units recovered from GSM - [" + remotePeerInfo + "]");
                } else {
                    peerLogger.info("Completed recovery of processing units from GSM - [" + remotePeerInfo + "]; Recovered: " + recoveredOpStrings);
                }
                if (peerLogger.isLoggable(Level.FINEST)) {
                    OperationalString[] operationalStrings;
                    ArrayList<String> active = new ArrayList<String>();
                    ArrayList<String> nonActive = new ArrayList<String>();
                    StringBuilder sb = new StringBuilder();
                    for (OperationalString opString : operationalStrings = ProvisionMonitorImpl.this.getOperationalStrings()) {
                        try {
                            OperationalStringManager opStringManager = ProvisionMonitorImpl.this.getOperationalStringManager(opString.getName());
                            if (opStringManager.isManaging()) {
                                active.add(opString.getName());
                                continue;
                            }
                            nonActive.add(opString.getName());
                        }
                        catch (OperationalStringException e) {
                            nonActive.add(opString.getName() + " " + e);
                        }
                    }
                    List list = null;
                    Map map = this.opStringTable;
                    synchronized (map) {
                        list = (List)this.opStringTable.get(peer);
                    }
                    peerLogger.finest("Recovery Status:\n\t Imported from GSM - [" + remotePeerInfo + "]: " + (list == null ? "[]" : list) + "\n\t Managing: " + active + "\n\t Monitoring: " + nonActive + "\n");
                }
            }
            if (peerLogger.isLoggable(Level.FINE)) {
                peerLogger.fine("After import, GSM (active=" + ProvisionMonitorImpl.this.activeProvisionMonitor.isActive() + ") has processing units: " + Arrays.toString(ProvisionMonitorImpl.this.getOperationalStrings()));
            }
            return changed;
        }

        boolean opStringProcessor(OperationalString opString, ProvisionMonitor peer, DeployAdmin peerDeployAdmin) {
            boolean changes = false;
            try {
                changes = this.addPeerOpString(opString, peer, peerDeployAdmin);
                OperationalString[] nested = opString.getNestedOperationalStrings();
                for (int i = 0; i < nested.length; ++i) {
                    boolean addedNested = this.opStringProcessor(nested[i], peer, peerDeployAdmin);
                    changes = changes || addedNested;
                }
            }
            catch (Exception e) {
                peerLogger.log(Level.WARNING, "Adding processing unit [" + opString.getName() + "]", e);
            }
            return changes;
        }

        synchronized boolean addPeerOpString(OperationalString opString, ProvisionMonitor peer, DeployAdmin peerDeployAdmin) {
            boolean changes = false;
            HashMap map = new HashMap();
            try {
                boolean changesDuringAdd;
                boolean resolveConflict = false;
                if (!ProvisionMonitorImpl.this.opStringExists(opString.getName())) {
                    OpStringManager opMgr;
                    if (peerLogger.isLoggable(Level.INFO)) {
                        peerLogger.log(Level.INFO, "Adding [" + opString.getName() + "] from GSM - [" + peer.getPeerInfo() + "]");
                    }
                    if ((opMgr = ProvisionMonitorImpl.this.addOperationalString(opString, map, null, peerDeployAdmin, null)) == null) {
                        resolveConflict = true;
                    } else {
                        changesDuringAdd = this.addToOpStringTable(peer, opMgr);
                        changes = changes || changesDuringAdd;
                    }
                } else {
                    resolveConflict = true;
                }
                if (resolveConflict) {
                    OpStringManager localMgr = ProvisionMonitorImpl.this.getOpStringManager(opString.getName());
                    if (localMgr.isActive() && ProvisionMonitorImpl.this.activeProvisionMonitor.isActiveActive()) {
                        boolean changesDuringResolve = this.resolveConflict(opString, peer, peerDeployAdmin);
                        changes = changes || changesDuringResolve;
                    } else {
                        changesDuringAdd = this.addToOpStringTable(peer, localMgr);
                        changes = changes || changesDuringAdd;
                    }
                }
            }
            catch (Throwable t) {
                peerLogger.log(Level.WARNING, "Failed to recover [" + opString.getName() + "] from GSM", t);
            }
            return changes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addToOpStringTable(ProvisionMonitor peer, OpStringManager opMgr) {
            List list = null;
            Map map = this.opStringTable;
            synchronized (map) {
                list = this.opStringTable.containsKey(peer) ? (List)this.opStringTable.get(peer) : new ArrayList();
                if (!list.contains(opMgr)) {
                    list.add(opMgr);
                    this.opStringTable.put(peer, list);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean resolveConflict(OperationalString opString, ProvisionMonitor peer, DeployAdmin peerDeployAdmin) {
            boolean addAsBackup = false;
            OpStringManager localMgr = null;
            OperationalStringManager peerMgr = null;
            try {
                ProvisionMonitor.PeerInfo peerInfo = this.getPeerInfo(peer);
                if (peerLogger.isLoggable(Level.FINE)) {
                    peerLogger.fine("GSM - [" + peerInfo + "] also has [" + opString.getName() + "] deployed");
                }
                localMgr = ProvisionMonitorImpl.this.getOpStringManager(opString.getName());
                peerMgr = peerDeployAdmin.getOperationalStringManager(opString.getName());
                if (!peerMgr.isManaging()) {
                    if (peerLogger.isLoggable(Level.FINE)) {
                        peerLogger.fine("GSM - [" + peerInfo + "] is not managing [" + opString.getName() + "], no conflict observed");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (peerLogger.isLoggable(Level.WARNING)) {
                    peerLogger.warning("GSM - [" + peerInfo + "] is also managing [" + opString.getName() + "], conflict observed - resolving");
                }
                Date[] peerDates = peerMgr.getDeploymentDates();
                Date[] localDates = localMgr.getDeploymentDates();
                if (peerDates.length == 0 && localDates.length == 0) {
                    int result;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("No Peer or Local dates");
                    }
                    if ((result = this.myPeerInfo.compareTo(peerInfo)) < 0) {
                        if (peerLogger.isLoggable(Level.INFO)) {
                            peerLogger.info("Assign GSM - [" + peerInfo + "] as backup for [" + opString.getName() + "]");
                        }
                        peerMgr.setManaging(false);
                    } else {
                        if (peerLogger.isLoggable(Level.INFO)) {
                            peerLogger.info("Set this GSM as backup for [" + opString.getName() + "]");
                        }
                        localMgr.setManaging(false);
                        addAsBackup = true;
                    }
                } else if (peerDates.length == 0 && localDates.length > 0) {
                    if (peerLogger.isLoggable(Level.INFO)) {
                        peerLogger.info("No Peer deployment dates, set GSM - [" + peerInfo + "] as backup for [" + opString.getName() + "]");
                    }
                    peerMgr.setManaging(false);
                } else if (peerDates.length > 0 && localDates.length == 0) {
                    if (peerLogger.isLoggable(Level.INFO)) {
                        peerLogger.info("No Local deployment dates, set Local as backup for [" + opString.getName() + "]");
                    }
                    localMgr.setManaging(false);
                    addAsBackup = true;
                } else {
                    Date lastPeerDate = peerDates[peerDates.length - 1];
                    Date lastLocalDate = localDates[localDates.length - 1];
                    if (lastPeerDate.equals(lastLocalDate)) {
                        int result;
                        if (peerLogger.isLoggable(Level.FINE)) {
                            peerLogger.fine("Last deployment dates are equal");
                        }
                        if ((result = this.myPeerInfo.compareTo(peerInfo)) < 0) {
                            if (peerLogger.isLoggable(Level.INFO)) {
                                peerLogger.info("Local is preferred, set GSM - [" + peerInfo + "] as backup for [" + opString.getName() + "]");
                            }
                            peerMgr.setManaging(false);
                        } else {
                            if (peerLogger.isLoggable(Level.INFO)) {
                                peerLogger.info("Peer is preferred, set Local as backup for [" + opString.getName() + "]");
                            }
                            localMgr.setManaging(false);
                        }
                    } else if (lastPeerDate.before(lastLocalDate)) {
                        if (peerLogger.isLoggable(Level.INFO)) {
                            peerLogger.info("Peer deployed before Local, set Local as backup for [" + opString.getName() + "]");
                        }
                        localMgr.setManaging(false);
                        addAsBackup = true;
                    } else {
                        if (peerLogger.isLoggable(Level.INFO)) {
                            peerLogger.info("Local deployed before Peer, set GSM - [" + peerInfo + "] as backup for [" + opString.getName() + "]");
                        }
                        peerMgr.setManaging(false);
                    }
                }
            }
            catch (OperationalStringException peerInfo) {
            }
            catch (RemoteException e) {
                peerLogger.log(Level.WARNING, "RemoteException trying to resolve OperationalStringManager supremacy", e);
            }
            finally {
                if (addAsBackup) {
                    localMgr.doUpdateOperationalString(opString);
                    this.addToOpStringTable(peer, localMgr);
                }
            }
            return true;
        }
    }

    static class PeerNotificationTask
    implements Runnable {
        ProvisionMonitor[] peers;
        ProvisionMonitor.PeerInfo info;

        PeerNotificationTask(ProvisionMonitor[] peers, ProvisionMonitor.PeerInfo info) {
            this.peers = peers;
            this.info = info;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.peers.length; ++i) {
                try {
                    this.peers[i].update(this.info);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception notifying ProvisionMonitor", e);
                }
            }
        }
    }

    static class RedeploymentTask
    extends TimerTask {
        OpStringManager opMgr;
        ServiceBeanInstance instance;
        ServiceElement sElem;
        boolean clean = false;
        ServiceProvisionListener listener;

        RedeploymentTask(OpStringManager opMgr, ServiceElement sElem, ServiceBeanInstance instance, boolean clean, ServiceProvisionListener listener) {
            this.opMgr = opMgr;
            this.instance = instance;
            this.sElem = sElem;
            this.clean = clean;
            this.listener = listener;
        }

        @Override
        public void run() {
            if (!this.opMgr.isActive()) {
                if (logger.isLoggable(Level.FINEST)) {
                    String name = "unknown";
                    if (this.instance == null && this.sElem == null) {
                        name = this.opMgr.getName();
                    } else {
                        if (this.sElem != null) {
                            name = this.sElem.getName();
                        }
                        if (this.instance != null) {
                            name = this.instance.getServiceBeanConfig().getName();
                        }
                    }
                    logger.finest("Redeployment request for [" + name + "] cancelled, OpStringManager is not primary");
                }
                this.cancel();
                return;
            }
            try {
                if (this.instance == null && this.sElem == null) {
                    this.opMgr.doRedeploy(this.clean, this.listener);
                } else {
                    this.opMgr.doRedeploy(this.sElem, this.instance, this.clean, this.listener);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Executing Scheduled Redeployment", e);
            }
            finally {
                this.cancel();
            }
        }

        @Override
        public boolean cancel() {
            if (this.opMgr != null) {
                this.opMgr.removeTask(this);
            }
            return super.cancel();
        }
    }

    public class OpStringManager
    implements OperationalStringManager,
    ServerProxyTrust {
        OperationalString opString;
        Vector svcElemMgrs = new Vector();
        Vector nestedManagers = new Vector();
        Vector parents = new Vector();
        private final ActiveProvisionMonitor activeProvisionMonitor;
        Exporter exporter;
        OperationalStringManager proxy;
        List scheduledTaskList = Collections.synchronizedList(new ArrayList());
        List deployDateList = Collections.synchronizedList(new ArrayList());
        int deployStatus;
        ProxyPreparer serviceProvisionListenerPreparer;

        public OpStringManager(OperationalString opString, OpStringManager parent, ActiveProvisionMonitor activeProvisionMonitor, Configuration config) throws RemoteException {
            config = config == null ? EmptyConfiguration.INSTANCE : config;
            try {
                this.exporter = ExporterConfig.getExporter(config, ProvisionMonitorImpl.CONFIG_COMPONENT, "opStringManagerExporter");
                this.serviceProvisionListenerPreparer = (ProxyPreparer)config.getEntry(ProvisionMonitorImpl.CONFIG_COMPONENT, "serviceProvisionListenerPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            }
            catch (ConfigurationException e) {
                logger.log(Level.WARNING, "Getting opStringManager Exporter", e);
            }
            this.opString = opString;
            this.activeProvisionMonitor = activeProvisionMonitor;
            this.proxy = (OperationalStringManager)this.exporter.export((Remote)this);
            if (parent != null) {
                this.addParent(parent);
                parent.addNested(this);
            }
        }

        @Override
        public String getDeployURL() throws RemoteException, MalformedURLException {
            return ProvisionMonitorImpl.this.webster.getURL();
        }

        @Override
        public String getDeployHost() throws RemoteException, MalformedURLException {
            return ProvisionMonitorImpl.this.webster.getAddress();
        }

        @Override
        public String getPeerInfoString() throws RemoteException {
            return ProvisionMonitorImpl.this.getPeerInfo().toString();
        }

        @Override
        public String getDeployPath() throws RemoteException {
            return System.getProperty("com.gs.deploy");
        }

        @Override
        public long getLastModified(String puName) throws RemoteException {
            File file = new File(System.getProperty("com.gs.deploy") + "/" + puName);
            if (!file.exists()) {
                return -1L;
            }
            return file.lastModified();
        }

        @Override
        public boolean undeploy() throws OperationalStringException, RemoteException {
            return ((DeployAdmin)ProvisionMonitorImpl.this.getAdmin()).undeploy(this.getName());
        }

        OperationalStringManager getProxy() {
            return this.proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean newActive) {
            OpStringManager opStringManager = this;
            synchronized (opStringManager) {
                boolean prevActiveStatus = this.activeProvisionMonitor.getAndSetActive(this.opString.getName(), newActive);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set active status for [" + this.opString.getName() + "] to: " + newActive + ", previous status: " + prevActiveStatus);
                }
                if (prevActiveStatus != newActive) {
                    if (newActive) {
                        this.updateInstantiatorResources();
                    }
                    ServiceElementManager[] mgrs = this.getServiceElementManagers();
                    ServiceElement[] sElems = new ServiceElement[mgrs.length];
                    for (int i = 0; i < mgrs.length; ++i) {
                        mgrs[i].setActive(newActive);
                        sElems[i] = mgrs[i].getServiceElement();
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("GSM [" + this.getProxy().toString() + "] set active [" + newActive + "] for processing unit [" + this.getName() + "]");
                    }
                    if (newActive) {
                        this.updateServiceElements(sElems);
                    }
                    OpStringManager[] nestedMgrs = this.nestedManagers.toArray(new OpStringManager[this.nestedManagers.size()]);
                    for (int i = 0; i < nestedMgrs.length; ++i) {
                        nestedMgrs[i].setActive(newActive);
                    }
                }
            }
            boolean downloadPuWhenBecomingBackupGsm = Boolean.getBoolean("com.gigaspaces.grid.gsm.downloadPuWhenBecomingBackup");
            if (!newActive && downloadPuWhenBecomingBackupGsm) {
                this.downloadOperationStringFromPeerIfNotManaging();
            }
        }

        private void downloadOperationStringFromPeerIfNotManaging() {
            block18: {
                if (this.activeProvisionMonitor.isActive(this.opString.getName())) {
                    return;
                }
                OperationalStringManager activeGSM = null;
                try {
                    activeGSM = ProvisionMonitorImpl.this.getPrimary(this.getName());
                }
                catch (Exception e) {
                    if (peerLogger.isLoggable(Level.WARNING)) {
                        peerLogger.log(Level.WARNING, "Failed to find managing GSM to download [" + this.getName() + "] from", e);
                    }
                    return;
                }
                if (activeGSM != null) {
                    String deployURL = null;
                    try {
                        String deployName = (String)this.opString.getServices()[0].getServiceBeanConfig().getInitParameters().get("puPath");
                        File extractToPath = new File(System.getProperty("com.gs.deploy") + "/" + deployName);
                        if (peerLogger.isLoggable(Level.FINEST)) {
                            peerLogger.finest("local getDeployPath(): " + this.getDeployPath() + " activeGSM.getDeployPath(): " + activeGSM.getDeployPath());
                        }
                        if (this.getDeployPath().equals(activeGSM.getDeployPath())) {
                            if (peerLogger.isLoggable(Level.FINEST)) {
                                peerLogger.info("local getDeployHost(): " + this.getDeployHost() + " activeGSM.getDeployHost(): " + activeGSM.getDeployHost());
                            }
                            if (this.getDeployHost().equals(activeGSM.getDeployHost())) {
                                if (peerLogger.isLoggable(Level.FINE)) {
                                    peerLogger.fine("No need to download [" + this.getName() + "] from managing GSM since both use the same deploy directory [" + this.getDeployPath() + "] and same host [" + this.getDeployHost() + "]");
                                }
                                return;
                            }
                            if (peerLogger.isLoggable(Level.FINEST)) {
                                peerLogger.finest("local file.exists(): " + extractToPath.exists() + " lastModified(): " + extractToPath.lastModified() + " activeGSM.getLastModified(): " + activeGSM.getLastModified(deployName));
                            }
                            if (extractToPath.exists() && extractToPath.lastModified() == activeGSM.getLastModified(deployName)) {
                                if (peerLogger.isLoggable(Level.FINE)) {
                                    peerLogger.fine("No need to download [" + this.getName() + "] from managing GSM since both use the same shared deploy directory [" + this.getDeployPath() + "] and have same timestamp [" + extractToPath.lastModified() + "]");
                                }
                                return;
                            }
                        }
                        deployURL = activeGSM.getDeployURL() + deployName;
                        if (peerLogger.isLoggable(Level.INFO)) {
                            peerLogger.info("Downloading [" + this.getName() + "] into [" + extractToPath.getAbsolutePath() + "] from managing GSM located at [" + deployURL + "] ...");
                        }
                        URL url = new URL(deployURL);
                        this.deleteDir(extractToPath);
                        extractToPath.mkdirs();
                        File workLocation = new File(System.getProperty("com.gs.work", SystemInfo.singleton().locations().work() + "/gsm"));
                        long size = PUZipUtils.downloadProcessingUnit((String)deployName, (URL)url, (File)extractToPath, (File)workLocation);
                        if (peerLogger.isLoggable(Level.INFO)) {
                            NumberFormat nf = NumberFormat.getInstance();
                            nf.setMaximumFractionDigits(2);
                            String suffix = "kb";
                            float factor = 1024.0f;
                            if (size > 0x100000L) {
                                suffix = "mb";
                                factor = 1048576.0f;
                            }
                            peerLogger.info("Downloaded [" + this.getName() + "], size [" + nf.format((float)size / factor) + suffix + "] to [" + extractToPath.getAbsolutePath() + "]");
                        }
                    }
                    catch (Exception e) {
                        if (!peerLogger.isLoggable(Level.SEVERE)) break block18;
                        peerLogger.log(Level.SEVERE, "Failed to download [" + this.getName() + "] from GSM", e);
                    }
                }
            }
        }

        public boolean deleteDir(File dir) {
            String[] children;
            if (!dir.exists()) {
                return true;
            }
            boolean globalSuccess = true;
            if (dir.isDirectory() && (children = dir.list()) != null) {
                for (int i = 0; i < children.length; ++i) {
                    boolean success = this.deleteDir(new File(dir, children[i]));
                    if (success) continue;
                    globalSuccess = false;
                }
            }
            if (!dir.delete()) {
                globalSuccess = false;
            }
            return globalSuccess;
        }

        @Override
        public void setManaging(boolean newActive) throws RemoteException {
            this.setActive(newActive);
        }

        boolean isActive() {
            return this.activeProvisionMonitor.isActive(this.opString.getName());
        }

        @Override
        public boolean isManaging() throws RemoteException {
            return this.isActive();
        }

        @Override
        public Date[] getDeploymentDates() {
            return this.deployDateList.toArray(new Date[this.deployDateList.size()]);
        }

        void setDeploymentStatus(int status) {
            this.opString.setDeployed(status);
            this.deployStatus = status;
            if (this.deployStatus == 0 && this.nestedManagers.size() > 0) {
                OpStringManager[] nestedMgrs = this.nestedManagers.toArray(new OpStringManager[this.nestedManagers.size()]);
                for (int i = 0; i < nestedMgrs.length; ++i) {
                    if (nestedMgrs[i].getParentCount() != 1) continue;
                    nestedMgrs[i].setDeploymentStatus(0);
                }
            }
        }

        void addDeploymentDate(Date date) {
            if (date != null) {
                this.deployDateList.add(date);
            }
        }

        Map init(ServiceProvisionListener listener) throws Exception {
            HashMap<String, Throwable> map = new HashMap<String, Throwable>();
            ServiceElement[] sElems = this.opString.getServices();
            for (int i = 0; i < sElems.length; ++i) {
                try {
                    if (sElems[i].getExportBundles().length > 0) {
                        this.createServiceElementManager(sElems[i], false, listener);
                        continue;
                    }
                    map.put(sElems[i].getName(), new Exception("No ExportBundles"));
                    continue;
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    logger.log(Level.WARNING, "Creating ServiceElementManager for [" + sElems[i].getName() + "]", e);
                    map.put(sElems[i].getName(), cause);
                    throw e;
                }
            }
            this.downloadOperationStringFromPeerIfNotManaging();
            return map;
        }

        void startManager(ServiceProvisionListener listener) {
            this.startManager(listener, new HashMap());
        }

        void startManager(ServiceProvisionListener listener, Map knownInstanceMap) {
            boolean scheduled = false;
            Schedule schedule = this.opString.getSchedule();
            Date startDate = schedule.getStartDate();
            long now = System.currentTimeMillis();
            long delay = startDate.getTime() - now;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("OperationalString [" + this.getName() + "] Start Date=[" + startDate.toString() + "], Delay [" + delay + "]");
            }
            if (delay > 0L || schedule.getDuration() > 0L) {
                DeploymentTask deploymentTask = new DeploymentTask(this);
                this.addTask(deploymentTask);
                if (schedule.getDuration() > 0L) {
                    ProvisionMonitorImpl.this.taskTimer.scheduleAtFixedRate((TimerTask)deploymentTask, startDate, schedule.getDuration() + schedule.getRepeatInterval());
                } else {
                    ProvisionMonitorImpl.this.taskTimer.schedule((TimerTask)deploymentTask, startDate);
                }
                scheduled = true;
                this.setDeploymentStatus(1);
            }
            if (!scheduled) {
                this.addDeploymentDate(new Date(System.currentTimeMillis()));
                this.setDeploymentStatus(2);
                ServiceElementManager[] mgrs = this.getServiceElementManagers();
                for (int i = 0; i < mgrs.length; ++i) {
                    ServiceElement elem = mgrs[i].getServiceElement();
                    ServiceBeanInstance[] instances = (ServiceBeanInstance[])knownInstanceMap.get(elem);
                    try {
                        int alreadyRunning = mgrs[i].startManager(listener, instances);
                        if (alreadyRunning <= 0) continue;
                        this.updateServiceElements(new ServiceElement[]{mgrs[i].getServiceElement()});
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Starting ServiceElementManager", e);
                    }
                }
            }
        }

        void createServiceElementManager(ServiceElement sElem, boolean start, ServiceProvisionListener listener) throws Exception {
            int alreadyRunning;
            ServiceElementManager svcElemMgr = new ServiceElementManager(sElem, this.proxy, ProvisionMonitorImpl.this.provisioner, ProvisionMonitorImpl.this.getUuid(), this.isActive(), ProvisionMonitorImpl.this.config, ProvisionMonitorImpl.this.eventsStore);
            svcElemMgr.setEventPool(ProvisionMonitorImpl.this.monitorEventPool);
            svcElemMgr.setEventSource(ProvisionMonitorImpl.this.getEventProxy());
            svcElemMgr.setEventHandler(ProvisionMonitorImpl.this.monitorEventHandler);
            this.svcElemMgrs.add(svcElemMgr);
            if (start && (alreadyRunning = svcElemMgr.startManager(listener)) > 0) {
                this.updateServiceElements(new ServiceElement[]{sElem});
            }
        }

        @Override
        public Map updateOperationalString(OperationalString newOpString) throws OperationalStringException, RemoteException {
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            Map map = this.doUpdateOperationalString(newOpString);
            ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), 8, this.doGetOperationalString());
            ProvisionMonitorImpl.this.processEvent(event);
            return map;
        }

        Map doUpdateOperationalString(OperationalString newOpString) {
            if (newOpString == null) {
                throw new NullPointerException("OperationalString cannot be null");
            }
            HashMap<String, Throwable> map = new HashMap<String, Throwable>();
            ServiceElement[] sElems = newOpString.getServices();
            Vector notRefreshed = new Vector(this.svcElemMgrs);
            for (int i = 0; i < sElems.length; ++i) {
                try {
                    ServiceElementManager svcElemMgr = this.getServiceElementManager(sElems[i]);
                    if (svcElemMgr == null) {
                        this.createServiceElementManager(sElems[i], true, null);
                        continue;
                    }
                    svcElemMgr.setServiceElement(sElems[i]);
                    notRefreshed.remove(svcElemMgr);
                    continue;
                }
                catch (Exception e) {
                    map.put(sElems[i].getName(), e);
                    logger.log(Level.WARNING, "Refreshing ServiceElementManagers", e);
                }
            }
            OperationalString[] nested = newOpString.getNestedOperationalStrings();
            for (int i = 0; i < nested.length; ++i) {
                if (!ProvisionMonitorImpl.this.opStringExists(nested[i].getName())) {
                    try {
                        ProvisionMonitorImpl.this.addOperationalString(nested[i], map, this, null, null);
                    }
                    catch (Exception e) {
                        Throwable cause = e.getCause();
                        if (cause == null) {
                            cause = e;
                        }
                        map.put(sElems[i].getName(), cause);
                        logger.log(Level.WARNING, "Adding nested OperationalString [" + nested[i].getName() + "]", e);
                    }
                    continue;
                }
                OpStringManager nestedMgr = ProvisionMonitorImpl.this.getOpStringManager(nested[i].getName());
                if (nestedMgr.getParentCount() != 1 || !nestedMgr.parents.contains(this)) continue;
                Map nestedMap = nestedMgr.doUpdateOperationalString(nested[i]);
                map.putAll(nestedMap);
            }
            Enumeration e = notRefreshed.elements();
            while (e.hasMoreElements()) {
                ServiceElementManager svcElemMgr = (ServiceElementManager)e.nextElement();
                svcElemMgr.stopManager(false, false);
                this.svcElemMgrs.remove(svcElemMgr);
            }
            this.opString = newOpString;
            ProvisionMonitorImpl.this.stateChanged(this, false);
            if (this.isActive()) {
                this.updateServiceElements(sElems);
            }
            return map;
        }

        void verifyAndInitiateDispatch(ServiceProvisionListener listener) {
            Enumeration e = this.svcElemMgrs.elements();
            while (e.hasMoreElements()) {
                ServiceElementManager svcElemMgr = (ServiceElementManager)e.nextElement();
                svcElemMgr.initiateDispatch(listener);
            }
            e = this.nestedManagers.elements();
            while (e.hasMoreElements()) {
                OpStringManager nestedMgr = (OpStringManager)e.nextElement();
                nestedMgr.verifyAndInitiateDispatch(listener);
            }
        }

        void updateInstantiatorResources() {
            ServiceResource[] resources = ProvisionMonitorImpl.this.provisioner.getServiceResourceSelector().getServiceResources();
            for (int i = 0; i < resources.length; ++i) {
                InstantiatorResource ir = (InstantiatorResource)resources[i].getResource();
                try {
                    ir.fillWithActiveServiceRecords();
                    continue;
                }
                catch (RemoteException re) {
                    ProvisionMonitorImpl.this.provisioner.getServiceResourceSelector().remove(resources[i]);
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "Removed unreachable resource [" + ir.getName() + "] on host [" + ir.getHostAddress() + "]", re);
                    continue;
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, "Caught exception while updating resource", t);
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                StringBuilder sb = new StringBuilder();
                resources = ProvisionMonitorImpl.this.provisioner.getServiceResourceSelector().getServiceResources();
                for (int i = 0; i < resources.length; ++i) {
                    InstantiatorResource ir = (InstantiatorResource)resources[i].getResource();
                    sb.append(i + 1).append(". ").append(ir);
                    sb.append("\n ServiceElement(s):\n");
                    for (ServiceElement sElem : ir.getServiceElements()) {
                        int count = ir.getServiceElementInstances(sElem);
                        sb.append("\t  " + ServiceElementUtil.getNameWithId(sElem));
                        sb.append(", count=" + count);
                        sb.append("\n");
                    }
                }
                logger.finest("updated service-element-mappings: \n" + sb.toString());
            }
        }

        void updateServiceElements(ServiceElement[] elements) {
            if (!this.isActive()) {
                return;
            }
            ServiceResource[] resources = ProvisionMonitorImpl.this.provisioner.getServiceResourceSelector().getServiceResources();
            HashMap<InstantiatorResource, ArrayList<ServiceElement>> map = new HashMap<InstantiatorResource, ArrayList<ServiceElement>>();
            for (int i = 0; i < resources.length; ++i) {
                InstantiatorResource ir = (InstantiatorResource)resources[i].getResource();
                for (int j = 0; j < elements.length; ++j) {
                    int count = ir.getServiceElementInstances(elements[j]);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, ir.getName() + " at [" + ir.getHostAddress() + "] has [" + count + "] of [" + elements[j].getName() + "]");
                    }
                    if (count <= 0) continue;
                    ArrayList<ServiceElement> list = (ArrayList<ServiceElement>)map.get(ir.getInstantiator());
                    if (list == null) {
                        list = new ArrayList<ServiceElement>();
                    }
                    list.add(elements[j]);
                    map.put(ir, list);
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                InstantiatorResource ir = (InstantiatorResource)entry.getKey();
                ArrayList list = (ArrayList)entry.getValue();
                ServiceElement[] elems = list.toArray(new ServiceElement[list.size()]);
                try {
                    ServiceBeanInstantiator sbi = ir.getInstantiator();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Update " + ir.getName() + " at [" + ir.getHostAddress() + "] with [" + elems.length + "] elements");
                    }
                    sbi.update(elems, this.getProxy());
                }
                catch (RemoteException e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Updating ServiceElement for " + ir.getName() + " at [" + ir.getHostAddress() + "]", e);
                        continue;
                    }
                    logger.log(Level.INFO, "RemoteException Updating ServiceElement for " + ir.getName() + " at [" + ir.getHostAddress() + "]");
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        void terminate(boolean killServices, boolean undeploy) {
            void var6_12;
            block12: {
                TimerTask[] tasks = this.getTasks();
                for (int i = 0; i < tasks.length; ++i) {
                    tasks[i].cancel();
                }
                try {
                    this.exporter.unexport(true);
                }
                catch (IllegalStateException e) {
                    if (!logger.isLoggable(Level.FINE)) break block12;
                    logger.log(Level.FINE, "OperationalStringManager not unexported");
                }
            }
            Collection<Object> sortedManagers = killServices ? ServiceElementUtil.sortServiceElementManagersByMode(this.svcElemMgrs) : this.svcElemMgrs;
            for (ServiceElementManager serviceElementManager : sortedManagers) {
                serviceElementManager.stopManager(killServices, undeploy);
            }
            if (this.parents.size() > 0) {
                Enumeration en = this.parents.elements();
                while (en.hasMoreElements()) {
                    OpStringManager opStringManager = (OpStringManager)en.nextElement();
                    opStringManager.removeNested(this);
                }
                this.parents.clear();
            }
            OpStringManager[] nestedMgrs = this.nestedManagers.toArray(new OpStringManager[this.nestedManagers.size()]);
            boolean bl = false;
            while (var6_12 < nestedMgrs.length) {
                if (nestedMgrs[var6_12].getParentCount() == 1) {
                    nestedMgrs[var6_12].terminate(killServices, undeploy);
                } else {
                    nestedMgrs[var6_12].removeParent(this);
                }
                ++var6_12;
            }
            boolean bl2 = ProvisionMonitorImpl.this.opStringManagers.remove(this);
            this.activeProvisionMonitor.remove(this.getName());
            if (logger.isLoggable(Level.INFO)) {
                if (bl2) {
                    logger.info("Processing Unit [" + this.getName() + "] monitor terminated");
                } else {
                    logger.info("Processing Unit [" + this.getName() + "] has been terminated");
                }
            }
        }

        String getName() {
            return this.opString.getName();
        }

        @Override
        public void addServiceElement(ServiceElement sElem) throws OperationalStringException, RemoteException {
            if (sElem == null) {
                throw new NullPointerException("sElem is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            try {
                this.doAddServiceElement(sElem);
                ProvisionMonitorImpl.this.stateChanged(this, false);
                ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), 4, sElem);
                ProvisionMonitorImpl.this.processEvent(event);
            }
            catch (Throwable t) {
                throw new OperationalStringException("Adding ServiceElement", t);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Added service [" + sElem.getName() + "] to [" + sElem.getOperationalStringName() + "]");
            }
        }

        void doAddServiceElement(ServiceElement sElem) throws Exception {
            if (sElem.getExportBundles().length <= 0) {
                throw new OperationalStringException("Interfaces are null");
            }
            this.createServiceElementManager(sElem, true, null);
            ProvisionMonitorImpl.this.stateChanged(this, false);
        }

        @Override
        public void removeServiceElement(ServiceElement sElem, boolean destroy) throws OperationalStringException, RemoteException {
            if (sElem == null) {
                throw new NullPointerException("sElem is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            try {
                this.doRemoveServiceElement(sElem, destroy);
                ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), 5, sElem);
                ProvisionMonitorImpl.this.processEvent(event);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Removed service [" + sElem.getName() + "] from [" + sElem.getOperationalStringName() + "]");
                }
            }
            catch (Throwable t) {
                throw new OperationalStringException("Removing ServiceElement", t);
            }
        }

        void doRemoveServiceElement(ServiceElement sElem, boolean destroy) throws OperationalStringException {
            ServiceElementManager svcElemMgr = this.getServiceElementManager(sElem);
            if (svcElemMgr == null) {
                throw new OperationalStringException("Unmanaged ServiceElement [" + sElem.getName() + "]");
            }
            svcElemMgr.stopManager(destroy, false);
            this.svcElemMgrs.remove(svcElemMgr);
            ProvisionMonitorImpl.this.stateChanged(this, false);
        }

        @Override
        public void updateServiceElement(ServiceElement sElem) throws OperationalStringException, RemoteException {
            if (sElem == null) {
                throw new NullPointerException("sElem is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            try {
                this.doUpdateServiceElement(sElem);
                int action = 1;
                ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), action, sElem);
                ProvisionMonitorImpl.this.processEvent(event);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Updating ServiceElement [" + sElem.getName() + "]", t);
                throw new OperationalStringException("Updating ServiceElement [" + sElem.getName() + "]", t);
            }
        }

        void doUpdateServiceElement(ServiceElement sElem) throws Exception {
            ServiceElementManager svcElemMgr = this.getServiceElementManager(sElem);
            if (svcElemMgr == null) {
                throw new OperationalStringException("Unmanaged ServiceElement [" + sElem.getName() + "]");
            }
            svcElemMgr.setServiceElement(sElem);
            svcElemMgr.initiateDispatch(null);
            ProvisionMonitorImpl.this.stateChanged(this, false);
            this.updateServiceElements(new ServiceElement[]{sElem});
        }

        @Override
        public void relocate(ServiceBeanInstance instance, ServiceProvisionListener listener, Uuid uuid) throws OperationalStringException, RemoteException {
            if (instance == null) {
                throw new NullPointerException("instance is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            if (listener != null) {
                listener = (ServiceProvisionListener)this.serviceProvisionListenerPreparer.prepareProxy((Object)listener);
            }
            try {
                ServiceElementManager svcElemMgr = this.getServiceElementManager(instance);
                if (svcElemMgr == null) {
                    throw new OperationalStringException("Unmanaged ServiceBeanInstance [" + instance.toString() + "]");
                }
                if (svcElemMgr.getServiceElement().getProvisionType() != 1) {
                    throw new OperationalStringException("Service must be dynamic to be relocated");
                }
                svcElemMgr.relocate(instance, listener, uuid);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Relocating ServiceBeanInstance", t);
                if (t instanceof OperationalStringException) {
                    throw (OperationalStringException)t;
                }
                throw new OperationalStringException("Relocating ServiceBeanInstance", t);
            }
        }

        @Override
        public void updateServiceBeanInstance(ServiceBeanInstance instance) throws OperationalStringException, RemoteException {
            if (instance == null) {
                throw new NullPointerException("instance is null");
            }
            try {
                ServiceElement sElem = this.doUpdateServiceBeanInstance(instance);
                ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), sElem.getOperationalStringName(), instance);
                ProvisionMonitorImpl.this.processEvent(event);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Updating ServiceBeanInstance", t);
                throw new OperationalStringException("Updating ServiceBeanInstance", t);
            }
        }

        ServiceElement doUpdateServiceBeanInstance(ServiceBeanInstance instance) throws OperationalStringException {
            ServiceElementManager svcElemMgr = this.getServiceElementManager(instance);
            if (svcElemMgr == null) {
                throw new OperationalStringException("Unmanaged ServiceBeanInstance [" + instance.toString() + "]");
            }
            svcElemMgr.update(instance);
            return svcElemMgr.getServiceElement();
        }

        @Override
        public synchronized void increment(ServiceElement sElem, boolean permanent, ServiceProvisionListener listener, boolean relocated) throws OperationalStringException, RemoteException {
            if (sElem == null) {
                throw new NullPointerException("sElem is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            if (listener != null) {
                listener = (ServiceProvisionListener)this.serviceProvisionListenerPreparer.prepareProxy((Object)listener);
            }
            try {
                ServiceElementManager svcElemMgr = this.getServiceElementManager(sElem);
                if (svcElemMgr == null) {
                    throw new OperationalStringException("Unmanaged ServiceElement [" + sElem.getName() + "]");
                }
                ServiceElement changed = svcElemMgr.increment(permanent, listener, relocated);
                if (changed == null) {
                    return;
                }
                ProvisionMonitorImpl.this.stateChanged(this, false);
                this.updateServiceElements(new ServiceElement[]{changed});
                ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), 2, changed);
                ProvisionMonitorImpl.this.processEvent(event);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Incrementing ServiceElement [" + sElem.getName() + "]", t);
                throw new OperationalStringException("Incrementing ServiceElement [" + sElem.getName() + "]", t);
            }
        }

        @Override
        public int getPendingCount(ServiceElement sElem) throws RemoteException {
            if (sElem == null) {
                throw new NullPointerException("sElem is null");
            }
            int numPending = -1;
            ServiceElementManager svcElemMgr = this.getServiceElementManager(sElem);
            if (svcElemMgr != null) {
                numPending = svcElemMgr.getPendingCount();
            }
            return numPending;
        }

        @Override
        public int trim(ServiceElement sElem, int trimUp) throws OperationalStringException, RemoteException {
            if (sElem == null) {
                throw new NullPointerException("sElem is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            if (sElem.getProvisionType() != 1) {
                return -1;
            }
            int numTrimmed = 0;
            try {
                ServiceElementManager svcElemMgr = this.getServiceElementManager(sElem);
                if (svcElemMgr == null) {
                    throw new OperationalStringException("Unmanaged ServiceElement [" + sElem.getName() + "]");
                }
                numTrimmed = svcElemMgr.trim(trimUp);
                if (numTrimmed > 0) {
                    ProvisionMonitorImpl.this.stateChanged(this, false);
                    ServiceElement updatedElement = svcElemMgr.getServiceElement();
                    this.updateServiceElements(new ServiceElement[]{updatedElement});
                    ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), 3, updatedElement);
                    ProvisionMonitorImpl.this.processEvent(event);
                }
                return numTrimmed;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Decrementing ServiceElement [" + sElem.getName() + "]", t);
                throw new OperationalStringException("Decrementing ServiceElement [" + sElem.getName() + "]", t);
            }
        }

        @Override
        public void decrement(ServiceBeanInstance instance, boolean mandate, boolean destroy, boolean relocated) throws OperationalStringException, RemoteException {
            if (instance == null) {
                throw new NullPointerException("instance is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            ServiceElementManager svcElemMgr = this.getServiceElementManager(instance);
            if (svcElemMgr == null) {
                throw new OperationalStringException("Unmanaged ServiceBeanInstance [" + instance.toString() + "]");
            }
            ServiceElement sElem = svcElemMgr.decrement(instance, mandate, destroy, relocated);
            ProvisionMonitorImpl.this.stateChanged(this, false);
            this.updateServiceElements(new ServiceElement[]{sElem});
            ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), 3, sElem.getOperationalStringName(), sElem, instance);
            ProvisionMonitorImpl.this.processEvent(event);
        }

        @Override
        public boolean decrementPlannedIfPending(ServiceElement sElem) throws OperationalStringException, RemoteException {
            if (sElem == null) {
                throw new NullPointerException("sElem is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            try {
                ServiceElementManager svcElemMgr = this.getServiceElementManager(sElem);
                if (svcElemMgr == null) {
                    throw new OperationalStringException("Unmanaged ServiceElement [" + sElem.getName() + "]");
                }
                ServiceElement changed = svcElemMgr.decrementPlannedIfPending();
                if (changed == null) {
                    return false;
                }
                ProvisionMonitorImpl.this.stateChanged(this, false);
                this.updateServiceElements(new ServiceElement[]{changed});
                ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), 3, changed);
                ProvisionMonitorImpl.this.processEvent(event);
                return true;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Decrementing ServiceElement [" + sElem.getName() + "]", t);
                throw new OperationalStringException("Decrementing ServiceElement [" + sElem.getName() + "]", t);
            }
        }

        @Override
        public void destroy(ServiceBeanInstance instance) throws OperationalStringException, RemoteException {
            if (instance == null) {
                throw new NullPointerException("instance is null");
            }
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            ServiceElementManager svcElemMgr = this.getServiceElementManager(instance);
            if (svcElemMgr == null) {
                throw new OperationalStringException("Unmanaged ServiceBeanInstance [" + instance.toString() + "]");
            }
            try {
                svcElemMgr.doDestroy(instance.getService());
            }
            catch (Exception e) {
                throw new RemoteException("Failed to destroy service", e);
            }
        }

        boolean isTopLevel() {
            return this.parents.size() == 0;
        }

        @Override
        public OperationalString getOperationalString() throws RemoteException {
            return this.doGetOperationalString();
        }

        @Override
        public ServiceElement getServiceElement(Object proxy) throws OperationalStringException, RemoteException {
            ServiceElementManager mgr;
            block4: {
                if (proxy == null) {
                    throw new NullPointerException("proxy is null");
                }
                mgr = null;
                try {
                    mgr = this.getServiceElementManager(proxy);
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINEST)) break block4;
                    logger.log(Level.FINEST, "Getting ServiceElementManager for proxy", e);
                }
            }
            if (mgr == null) {
                throw new OperationalStringException("unknown service proxy");
            }
            return mgr.getServiceElement();
        }

        @Override
        public ServiceBeanInstance[] getServiceBeanInstances(ServiceElement sElem) throws OperationalStringException, RemoteException {
            if (sElem == null) {
                throw new NullPointerException("sElem is null");
            }
            try {
                ServiceElementManager mgr = this.getServiceElementManager(sElem);
                if (mgr == null) {
                    throw new OperationalStringException("Unmanaged ServiceElement [" + sElem.getName() + "]");
                }
                return mgr.getServiceBeanInstances();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Getting ServiceBeanInstances for ServiceElement [" + sElem.getName() + "]", t);
                if (t instanceof OperationalStringException) {
                    throw (OperationalStringException)t;
                }
                throw new OperationalStringException("Getting ServiceBeanInstances for ServiceElement [" + sElem.getName() + "]", t);
            }
        }

        @Override
        public ServiceElement getServiceElement(String[] interfaces, String name) throws OperationalStringException, RemoteException {
            if (interfaces == null) {
                throw new NullPointerException("interfaces cannot be null");
            }
            Enumeration e = this.svcElemMgrs.elements();
            while (e.hasMoreElements()) {
                ServiceElementManager svcElemMgr = (ServiceElementManager)e.nextElement();
                ServiceElement sElem = svcElemMgr.getServiceElement();
                boolean found = false;
                ClassBundle[] exports = sElem.getExportBundles();
                for (int i = 0; i < exports.length; ++i) {
                    boolean matched = false;
                    for (int j = 0; j < interfaces.length; ++j) {
                        if (!exports[i].getClassName().equals(interfaces[j])) continue;
                        matched = true;
                    }
                    if (!matched) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                if (name == null) {
                    return sElem;
                }
                if (!name.equals(sElem.getName())) continue;
                return sElem;
            }
            return null;
        }

        OperationalString doGetOperationalString() {
            OpString opstr = new OpString(this.opString.getName(), this.opString.loadedFrom());
            opstr.setDeployed(this.deployStatus);
            opstr.setSchedule(this.opString.getSchedule());
            opstr.setQuiesceDetails(this.opString.getQuiesceDetails());
            opstr.setQuiesceThread(this.opString.getQuiesceThread());
            Enumeration e = this.svcElemMgrs.elements();
            while (e.hasMoreElements()) {
                ServiceElementManager svcElemMgr = (ServiceElementManager)e.nextElement();
                opstr.addService(svcElemMgr.getServiceElement());
            }
            e = this.nestedManagers.elements();
            while (e.hasMoreElements()) {
                OpStringManager nestedMgr = (OpStringManager)e.nextElement();
                opstr.addOperationalString(nestedMgr.doGetOperationalString());
            }
            this.opString = opstr;
            return this.opString;
        }

        @Override
        public void redeploy(ServiceElement sElem, ServiceBeanInstance instance, boolean clean, long delay, ServiceProvisionListener listener) throws OperationalStringException, RemoteException {
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            if (listener != null) {
                listener = (ServiceProvisionListener)this.serviceProvisionListenerPreparer.prepareProxy((Object)listener);
            }
            if (delay > 0L) {
                this.doScheduleReploymentTask(delay, sElem, instance, clean, listener);
            } else if (sElem == null && instance == null) {
                this.doRedeploy(clean, listener);
            } else {
                this.doRedeploy(sElem, instance, clean, listener);
            }
        }

        void doRedeploy(boolean clean, ServiceProvisionListener listener) throws OperationalStringException {
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            ServiceElementManager[] mgrs = this.svcElemMgrs.toArray(new ServiceElementManager[this.svcElemMgrs.size()]);
            for (int i = 0; i < mgrs.length; ++i) {
                this.doRedeploy(mgrs[i].getServiceElement(), null, clean, listener);
            }
        }

        void doRedeploy(ServiceElement sElem, ServiceBeanInstance instance, boolean clean, ServiceProvisionListener listener) throws OperationalStringException {
            long exec;
            if (!this.isActive()) {
                throw new OperationalStringException("not the primary OperationalStringManager");
            }
            ServiceElementManager svcElemMgr = null;
            TimerTask scheduledTask = null;
            if (sElem != null) {
                svcElemMgr = this.getServiceElementManager(sElem);
                scheduledTask = this.getScheduledRedeploymentTask(sElem, null);
            } else if (instance != null) {
                svcElemMgr = this.getServiceElementManager(instance);
                scheduledTask = this.getScheduledRedeploymentTask(null, instance);
            }
            if (svcElemMgr == null) {
                throw new OperationalStringException("Unmanaged ServiceElement [" + sElem.getName() + "]");
            }
            if (scheduledTask != null && (exec = (scheduledTask.scheduledExecutionTime() - System.currentTimeMillis()) / 1000L) > 0L) {
                String item = sElem == null ? "ServiceBeanInstance" : "ServiceElement";
                throw new OperationalStringException(item + " already scheduled for redeployment in " + exec + " seconds");
            }
            if (sElem != null) {
                ServiceBeanInstance[] instances = svcElemMgr.getServiceBeanInstances();
                if (instances.length > 0) {
                    for (int i = 0; i < instances.length; ++i) {
                        svcElemMgr.redeploy(instances[i], clean, listener);
                    }
                } else {
                    svcElemMgr.redeploy(listener);
                }
            } else if (instance != null) {
                svcElemMgr.redeploy(instance, clean, listener);
            }
        }

        void doScheduleReploymentTask(long delay, ServiceElement sElem, ServiceBeanInstance instance, boolean clean, ServiceProvisionListener listener) throws OperationalStringException {
            int lastIndex = this.deployDateList.size() - 1;
            if (lastIndex < 0 || this.opString.getStatus() == 1) {
                throw new OperationalStringException("Cannot redeploy an OperationalString with a status of Scheduled");
            }
            Date lastDeployDate = (Date)this.deployDateList.get(lastIndex);
            if (this.opString.getSchedule().getDuration() != -1L && delay > lastDeployDate.getTime() + this.opString.getSchedule().getDuration()) {
                throw new OperationalStringException("delay is too long");
            }
            RedeploymentTask scheduledTask = this.getScheduledRedeploymentTask(sElem, instance);
            if (scheduledTask != null) {
                long exec = (scheduledTask.scheduledExecutionTime() - System.currentTimeMillis()) / 1000L;
                throw new OperationalStringException("Already scheduled for redeployment in " + exec + " seconds");
            }
            RedeploymentTask task = new RedeploymentTask(this, sElem, instance, clean, listener);
            this.addTask(task);
            ProvisionMonitorImpl.this.taskTimer.schedule((TimerTask)task, delay);
            Date redeployDate = new Date(System.currentTimeMillis() + delay);
            Object[] parms = new Object[]{redeployDate, clean, listener};
            ProvisionMonitorEvent event = new ProvisionMonitorEvent((Object)ProvisionMonitorImpl.this.getEventProxy(), this.opString.getName(), sElem, instance, parms);
            ProvisionMonitorImpl.this.processEvent(event);
            if (logger.isLoggable(Level.FINEST)) {
                String name = instance == null ? sElem.getName() : instance.getServiceBeanConfig().getName();
                String item = instance == null ? "ServiceElement" : "ServiceBeanInstance";
                logger.finest("Schedule [" + name + "] " + item + " redeploy in [" + delay + "] millis");
            }
        }

        RedeploymentTask getScheduledRedeploymentTask(ServiceElement sElem, ServiceBeanInstance instance) {
            TimerTask[] tasks = this.getTasks();
            RedeploymentTask scheduledTask = null;
            for (int i = 0; i < tasks.length; ++i) {
                if (!(tasks[i] instanceof RedeploymentTask)) continue;
                RedeploymentTask rTask = (RedeploymentTask)tasks[i];
                if (sElem == null || rTask.sElem == null) continue;
                if (rTask.sElem.equals(sElem)) {
                    scheduledTask = rTask;
                    break;
                }
                if (instance == null || rTask.instance == null || !rTask.instance.equals(instance)) continue;
                scheduledTask = rTask;
                break;
            }
            return scheduledTask;
        }

        ServiceElementManager[] getServiceElementManagers() {
            return this.svcElemMgrs.toArray(new ServiceElementManager[this.svcElemMgrs.size()]);
        }

        public ServiceElementManager getServiceElementManager(ServiceElement sElem) {
            Enumeration e = this.svcElemMgrs.elements();
            while (e.hasMoreElements()) {
                ServiceElementManager svcElemMgr = (ServiceElementManager)e.nextElement();
                ServiceElement sElem1 = svcElemMgr.getServiceElement();
                if (!sElem.equals(sElem1)) continue;
                return svcElemMgr;
            }
            return null;
        }

        ServiceElementManager getServiceElementManager(ServiceBeanInstance instance) {
            Enumeration e = this.svcElemMgrs.elements();
            while (e.hasMoreElements()) {
                ServiceElementManager mgr = (ServiceElementManager)e.nextElement();
                if (!mgr.hasServiceBeanInstance(instance)) continue;
                return mgr;
            }
            return null;
        }

        ServiceElementManager getServiceElementManager(Object proxy) throws IOException {
            MarshalledInstance mi1 = new MarshalledInstance(proxy);
            Enumeration e = this.svcElemMgrs.elements();
            while (e.hasMoreElements()) {
                ServiceElementManager mgr = (ServiceElementManager)e.nextElement();
                ServiceBeanInstance[] instances = mgr.getServiceBeanInstances();
                for (int i = 0; i < instances.length; ++i) {
                    MarshalledInstance mi2 = instances[i].getMarshalledInstance();
                    if (!mi2.fullyEquals((Object)mi1)) continue;
                    return mgr;
                }
            }
            return null;
        }

        void addNested(OpStringManager nestedMgr) {
            this.nestedManagers.add(nestedMgr);
            nestedMgr.addParent(this);
        }

        void removeNested(OpStringManager nestedMgr) {
            this.nestedManagers.remove(nestedMgr);
        }

        private void addParent(OpStringManager parent) {
            if (this.parents.contains(parent)) {
                return;
            }
            this.parents.add(parent);
        }

        private void removeParent(OpStringManager parent) {
            this.parents.remove(parent);
        }

        private int getParentCount() {
            return this.parents.size();
        }

        public TrustVerifier getProxyVerifier() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.entering(this.getClass().getName(), "getProxyVerifier");
            }
            return new BasicProxyTrustVerifier((Object)this.proxy);
        }

        TimerTask[] getTasks() {
            return this.scheduledTaskList.toArray(new TimerTask[this.scheduledTaskList.size()]);
        }

        void addTask(TimerTask task) {
            if (task != null) {
                this.scheduledTaskList.add(task);
            }
        }

        void removeTask(TimerTask task) {
            if (task != null) {
                this.scheduledTaskList.remove(task);
            }
        }

        @Override
        public boolean shouldDispatch(ServiceElement sElem) throws RemoteException {
            ServiceElementManager serviceElementManager = this.getServiceElementManager(sElem);
            if (serviceElementManager == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(sElem.getDebugName() + " should dispatch. Could not find serviceElementManager.");
                }
                return true;
            }
            return serviceElementManager.shouldDispatch(sElem);
        }

        @Override
        public boolean missingInstanceId(ServiceElement sElem) throws RemoteException {
            ServiceElementManager serviceElementManager = this.getServiceElementManager(sElem);
            if (serviceElementManager == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(sElem.getDebugName() + " is missing. Could not find serviceElementManager.");
                }
                return true;
            }
            return serviceElementManager.missingInstanceId(sElem);
        }

        @Override
        public ServiceElementTracker getServiceElementTracker(ServiceElement sElem) throws RemoteException {
            ServiceElementTracker serviceElementTracker = new ServiceElementTracker(sElem);
            ProvisionMonitorImpl.this.provisioner.getPendingManager().trackServiceElement(serviceElementTracker);
            return serviceElementTracker;
        }

        @Override
        public InternalQuiesceDetails getQuiesceDetails() throws RemoteException {
            return this.opString.getQuiesceDetails();
        }

        @Override
        public void setQuiesceDetails(InternalQuiesceDetails quiesceDetails) throws RemoteException {
            this.opString.setQuiesceDetails(quiesceDetails);
            if (this.nestedManagers.size() > 0) {
                OpStringManager[] nestedMgrs = this.nestedManagers.toArray(new OpStringManager[this.nestedManagers.size()]);
                for (int i = 0; i < nestedMgrs.length; ++i) {
                    if (nestedMgrs[i].getParentCount() != 1) continue;
                    nestedMgrs[i].setQuiesceDetails(quiesceDetails);
                    nestedMgrs[i].opString.setQuiesceDetails(quiesceDetails);
                }
            }
        }

        @Override
        public void setQuiesceThread(PoolableThread quiesceThread) throws RemoteException {
            this.opString.setQuiesceThread(quiesceThread);
        }

        public String toString() {
            return this.opString.getName();
        }
    }

    class UnDeploymentTask
    extends TimerTask {
        OpStringManager opMgr;
        boolean undeploy;

        UnDeploymentTask(OpStringManager opMgr, boolean undeploy) {
            this.opMgr = opMgr;
            this.undeploy = undeploy;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Create new UnDeploymentTask for [" + opMgr.getName() + "]");
            }
        }

        @Override
        public void run() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Undeploy [" + this.opMgr.getName() + "]");
            }
            if (this.undeploy) {
                this.opMgr.setDeploymentStatus(0);
                try {
                    if (this.opMgr.isActive()) {
                        ProvisionMonitorImpl.this.undeploy(this.opMgr.getName(), true);
                    }
                }
                catch (OperationalStringException e) {
                    logger.log(Level.WARNING, "Undeploying OperationalString", e);
                }
            } else {
                ServiceElementManager[] mgrs = this.opMgr.getServiceElementManagers();
                for (int i = 0; i < mgrs.length; ++i) {
                    mgrs[i].stopManager(true, true);
                }
                this.opMgr.setDeploymentStatus(1);
            }
        }

        @Override
        public boolean cancel() {
            if (this.opMgr != null) {
                this.opMgr.removeTask(this);
            }
            return super.cancel();
        }
    }

    class DeploymentTask
    extends TimerTask {
        int repeats;
        OperationalString loadedOpString;
        OpStringManager opMgr;

        DeploymentTask(OpStringManager opMgr) {
            this.opMgr = opMgr;
        }

        @Override
        public void run() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Deploy [" + this.opMgr.getName() + "]");
            }
            this.opMgr.addDeploymentDate(new Date(System.currentTimeMillis()));
            ServiceElementManager[] mgrs = this.opMgr.getServiceElementManagers();
            for (int i = 0; i < mgrs.length; ++i) {
                try {
                    int alreadyRunning = mgrs[i].startManager(null);
                    if (alreadyRunning <= 0) continue;
                    this.opMgr.updateServiceElements(new ServiceElement[]{mgrs[i].getServiceElement()});
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Starting ServiceElementManager", e);
                }
            }
            this.opMgr.setDeploymentStatus(2);
            this.loadedOpString = this.opMgr.doGetOperationalString();
            Schedule schedule = this.loadedOpString.getSchedule();
            ++this.repeats;
            if (schedule.getRepeatCount() != -1L && (long)this.repeats > schedule.getRepeatCount()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Repeat count [" + schedule.getRepeatCount() + "] reached for OperationalString [" + this.loadedOpString.getName() + "], cancel DeploymentTask");
                }
                this.cancel();
                UnDeploymentTask unDeploymentTask = new UnDeploymentTask(this.opMgr, true);
                this.opMgr.addTask(unDeploymentTask);
                long sheduledUndeploy = schedule.getDuration() + System.currentTimeMillis();
                ProvisionMonitorImpl.this.taskTimer.schedule((TimerTask)unDeploymentTask, new Date(sheduledUndeploy));
            } else if (schedule.getDuration() != -1L) {
                UnDeploymentTask unDeploymentTask = new UnDeploymentTask(this.opMgr, false);
                long sheduledUndeploy = schedule.getDuration() + System.currentTimeMillis();
                ProvisionMonitorImpl.this.taskTimer.schedule((TimerTask)unDeploymentTask, new Date(sheduledUndeploy));
            }
        }

        @Override
        public boolean cancel() {
            if (this.opMgr != null) {
                this.opMgr.removeTask(this);
            }
            return super.cancel();
        }
    }

    class InitialOpStringLoadTask
    extends TimerTask {
        Configuration config;

        InitialOpStringLoadTask(Configuration config) {
            this.config = config;
        }

        @Override
        public void run() {
            this.loadInitialOpStrings(this.config);
        }

        void loadInitialOpStrings(Configuration config) {
            if (!ProvisionMonitorImpl.this.inRecovery) {
                String[] initialOpStrings = new String[]{};
                try {
                    initialOpStrings = (String[])config.getEntry(ProvisionMonitorImpl.CONFIG_COMPONENT, "initialOpStrings", String[].class, (Object)initialOpStrings);
                    if (logger.isLoggable(Level.FINEST)) {
                        if (initialOpStrings.length > 0) {
                            StringBuffer sb = new StringBuffer();
                            for (int i = 0; i < initialOpStrings.length; ++i) {
                                if (i < 0) {
                                    sb.append(", ");
                                }
                                sb.append(initialOpStrings[i]);
                            }
                            logger.finest("Loading intialOpStrings [" + sb.toString() + "]");
                        } else {
                            logger.finest("No intialOpStrings to load");
                        }
                    }
                }
                catch (ConfigurationException e) {
                    logger.log(Level.WARNING, "Getting initialOpStrings", e);
                }
                for (int i = 0; i < initialOpStrings.length; ++i) {
                    URL opstringURL = null;
                    try {
                        opstringURL = initialOpStrings[i].startsWith("http:") ? new URL(initialOpStrings[i]) : new File(initialOpStrings[i]).toURI().toURL();
                        Map errorMap = ProvisionMonitorImpl.this.deploy(opstringURL, null);
                        ProvisionMonitorImpl.this.dumpOpStringError(errorMap);
                        continue;
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Loading OperationalString : " + initialOpStrings[i], t);
                    }
                }
            }
        }
    }
}

