/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.provision.ServiceBeanInstantiator;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.resources.servicecore.AbstractProxy;

class ProvisionMonitorProxy
extends AbstractProxy
implements ProvisionMonitor,
Serializable {
    private static final long serialVersionUID = 2L;

    static ProvisionMonitorProxy getInstance(ProvisionMonitor monitor, Uuid id) {
        if (monitor instanceof RemoteMethodControl) {
            return new ConstrainableProvisionMonitorProxy(monitor, id, null);
        }
        return new ProvisionMonitorProxy(monitor, id);
    }

    private ProvisionMonitorProxy(ProvisionMonitor monitor, Uuid id) {
        super(monitor, id);
    }

    @Override
    public OperationalStringManager getPrimary(String name) throws RemoteException, OperationalStringException {
        return ((ProvisionMonitor)this.server).getPrimary(name);
    }

    @Override
    public boolean assignBackupFor(ProvisionMonitor monitor) throws RemoteException {
        return ((ProvisionMonitor)this.server).assignBackupFor(monitor);
    }

    @Override
    public boolean removeBackupFor(ProvisionMonitor monitor) throws RemoteException {
        return ((ProvisionMonitor)this.server).removeBackupFor(monitor);
    }

    @Override
    public boolean isManaging() throws RemoteException {
        return ((ProvisionMonitor)this.server).isManaging();
    }

    @Override
    public void update(ProvisionMonitor.PeerInfo info) throws RemoteException {
        ((ProvisionMonitor)this.server).update(info);
    }

    @Override
    public ProvisionMonitor.PeerInfo getPeerInfo() throws RemoteException {
        return ((ProvisionMonitor)this.server).getPeerInfo();
    }

    @Override
    public EventRegistration register(ServiceBeanInstantiator instantiator, MarshalledObject handback, ResourceCapability resourceCapability, int serviceLimit, long duration, ServiceRecord[] serviceRecords) throws LeaseDeniedException, RemoteException {
        return ((ProvisionMonitor)this.server).register(instantiator, handback, resourceCapability, serviceLimit, duration, serviceRecords);
    }

    @Override
    public void update(ServiceBeanInstantiator instantiator, ResourceCapability resourceCapability, int serviceLimit, ServiceRecord[] serviceRecords) throws UnknownLeaseException, RemoteException {
        ((ProvisionMonitor)this.server).update(instantiator, resourceCapability, serviceLimit, serviceRecords);
    }

    static final class ConstrainableProvisionMonitorProxy
    extends ProvisionMonitorProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;

        private ConstrainableProvisionMonitorProxy(ProvisionMonitor monitor, Uuid id, MethodConstraints constraints) {
            super(ConstrainableProvisionMonitorProxy.constrainServer(monitor, constraints), id);
        }

        private static ProvisionMonitor constrainServer(ProvisionMonitor monitor, MethodConstraints constraints) {
            Method[] methods = ProvisionMonitor.class.getMethods();
            Method[] methodMapping = new Method[methods.length * 2];
            for (int i = 0; i < methodMapping.length; ++i) {
                methodMapping[i] = methods[i / 2];
            }
            return (ProvisionMonitor)((RemoteMethodControl)monitor).setConstraints(ConstrainableProxyUtil.translateConstraints((MethodConstraints)constraints, (Method[])methodMapping));
        }

        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableProvisionMonitorProxy((ProvisionMonitor)this.server, this.uuid, constraints);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.server).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableProvisionMonitorProxy.readObject failure - server does not implement constrainable functionality ");
            }
        }
    }
}

