/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.time.SystemTime;
import java.util.HashSet;
import java.util.Set;
import net.jini.id.Uuid;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.monitor.InstanceIDManager;
import org.jini.rio.monitor.ProvisionListener;

public class ProvisionRequest {
    static int PROVISION = 0;
    static int RELOCATE = 1;
    ServiceElement sElem;
    ProvisionListener listener;
    OperationalStringManager opStringMgr;
    ServiceProvisionListener svcProvisionListener;
    ServiceBeanInstance instance;
    Uuid excludeUuid;
    Set<Uuid> excludedUuids;
    Uuid requestedUuid;
    int type;
    InstanceIDManager instanceIDMgr;
    long timestamp;
    public long delayTimestamp = 0L;
    private boolean pending;

    public ProvisionRequest(ServiceElement sElem, ProvisionListener listener, OperationalStringManager opStringMgr, InstanceIDManager instanceIDMgr) {
        this.sElem = sElem;
        this.listener = listener;
        this.opStringMgr = opStringMgr;
        this.instanceIDMgr = instanceIDMgr;
        this.type = PROVISION;
        this.timestamp = SystemTime.timeMillis();
    }

    public ProvisionRequest(ServiceElement sElem, ProvisionListener listener, OperationalStringManager opStringMgr, InstanceIDManager instanceIDMgr, ServiceProvisionListener svcProvisionListener, ServiceBeanInstance instance) {
        this.sElem = sElem;
        this.listener = listener;
        this.opStringMgr = opStringMgr;
        this.instanceIDMgr = instanceIDMgr;
        this.svcProvisionListener = svcProvisionListener;
        this.instance = instance;
        this.type = PROVISION;
        this.timestamp = SystemTime.timeMillis();
    }

    public ProvisionRequest(ServiceElement sElem, ProvisionListener listener, OperationalStringManager opStringMgr, InstanceIDManager instanceIDMgr, ServiceProvisionListener svcProvisionListener, ServiceBeanInstance instance, Uuid excludeUuid, Uuid requestedUuid, int type) {
        this(sElem, listener, opStringMgr, instanceIDMgr);
        this.svcProvisionListener = svcProvisionListener;
        this.instance = instance;
        this.excludeUuid = excludeUuid;
        this.requestedUuid = requestedUuid;
        if (type < PROVISION || type > RELOCATE) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = type;
        this.timestamp = SystemTime.timeMillis();
    }

    public static ProvisionRequest copy(ProvisionRequest pr) {
        ProvisionRequest copy = new ProvisionRequest(pr.sElem, pr.listener, pr.opStringMgr, pr.instanceIDMgr, pr.svcProvisionListener, pr.instance, pr.excludeUuid, pr.requestedUuid, pr.type);
        copy.excludedUuids = pr.excludedUuids;
        return copy;
    }

    public void excludeUuid(Uuid excluded) {
        if (this.excludedUuids == null) {
            this.excludedUuids = new HashSet<Uuid>();
            if (this.excludeUuid != null) {
                this.excludedUuids.add(this.excludeUuid);
                this.excludeUuid = null;
            }
        }
        this.excludedUuids.add(excluded);
    }

    public boolean isTimeToReProvision() {
        return System.currentTimeMillis() > this.delayTimestamp;
    }

    public void delayNextAttempt(long delay) {
        this.delayTimestamp = System.currentTimeMillis() + delay;
    }

    public void resetNextAttempt() {
        if (this.delayTimestamp > 0L) {
            if (this.excludedUuids != null) {
                this.delayTimestamp = 0L;
                this.excludedUuids.clear();
            }
            this.excludeUuid = null;
        }
    }

    public void markPending(boolean pending) {
        this.pending = pending;
    }

    public boolean markedPending() {
        return this.pending;
    }

    public String toString() {
        return "Request for: " + this.sElem;
    }
}

