/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.grid.zone.ZoneHelper;
import com.sun.jini.landlord.LeasedResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.PriorityZoneComponent;
import org.jini.rio.monitor.ServiceResourceSelector;
import org.jini.rio.resources.servicecore.ServiceResource;

public class RelativeWeightSelector
extends ServiceResourceSelector {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.selector");
    private static final ContainerComparator containerComparator = new ContainerComparator();

    public RelativeWeightSelector() {
        this.collection = new LinkedList();
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem, Uuid uuid, boolean inclusive) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem, uuid, inclusive);
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem, Set<Uuid> excludedUuids) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem, excludedUuids);
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem);
    }

    @Override
    public void serviceResourceSelected(ServiceResource svcResource) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Selected " + svcResource.getResource());
        }
    }

    @Override
    protected void update(LeasedResource resource) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort(ServiceElement sElem) {
        ArrayList<ServiceResource> listOfResources = null;
        Collection collection = this.collection;
        synchronized (collection) {
            listOfResources = new ArrayList<ServiceResource>(this.collection.size());
            listOfResources.addAll(this.collection);
        }
        this.sort(sElem, listOfResources);
        collection = this.collection;
        synchronized (collection) {
            listOfResources.retainAll(this.collection);
            this.collection.removeAll(listOfResources);
            ((LinkedList)this.collection).addAll(0, listOfResources);
        }
    }

    private void sort(ServiceElement sElem, ArrayList<ServiceResource> listOfResources) {
        boolean probPrimary = true;
        String primaryZoneStr = (String)sElem.getServiceBeanConfig().getInitParameters().get("primaryZone");
        LinkedHashSet primaryZone = primaryZoneStr != null ? ZoneHelper.parseZones((String)primaryZoneStr) : null;
        HashMap<String, ArrayList<Container>> containersToHostMapping = new HashMap<String, ArrayList<Container>>();
        for (ServiceResource serviceResource : listOfResources) {
            ArrayList<Container> containers;
            InstantiatorResource instantiatorResource = (InstantiatorResource)serviceResource.getResource();
            Container container = new Container(serviceResource);
            container.setZones(instantiatorResource.getZones());
            container.init(sElem);
            if (probPrimary && (instantiatorResource.getServiceElementInstances(sElem) > 0 || instantiatorResource.getInProcessCounter(sElem) > 0)) {
                probPrimary = false;
            }
            if ((containers = (ArrayList<Container>)containersToHostMapping.get(this.getHostAddressKey(instantiatorResource))) == null) {
                containers = new ArrayList<Container>();
            }
            containers.add(container);
            containersToHostMapping.put(this.getHostAddressKey(instantiatorResource), containers);
        }
        ArrayList<Container> allContainers = new ArrayList<Container>(listOfResources.size());
        for (List containers : containersToHostMapping.values()) {
            int size = containers.size();
            double totalWeight = 0.0;
            for (Container container : containers) {
                allContainers.add(container);
                totalWeight += container.getWeight();
            }
            for (Container container : containers) {
                container.setWeight((container.getWeight() + totalWeight + 0.1) / (double)size);
            }
        }
        sElem.setProbPrimary(probPrimary);
        if (primaryZoneStr != null) {
            for (Container container : allContainers) {
                container.setPriorityZone(primaryZone, probPrimary);
            }
        }
        Collections.sort(allContainers, containerComparator);
        if (logger.isLoggable(Level.FINE)) {
            String string = this.toString(allContainers);
            logger.fine("Sorting for: " + sElem + (probPrimary ? " (P)" : " (B)") + "\n" + string);
        }
        listOfResources.clear();
        for (Container container : allContainers) {
            listOfResources.add(container.serviceResource);
        }
    }

    private String getHostAddressKey(InstantiatorResource instantiatorResource) {
        return instantiatorResource.getHostName() + "/" + instantiatorResource.getHostAddress();
    }

    private String toString(List<Container> containers) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (Container container : containers) {
            InstantiatorResource resource = (InstantiatorResource)container.serviceResource.getResource();
            sb.append(resource);
            sb.append(" weight: ").append(container.getWeight());
            sb.append(" instances: ").append(Arrays.toString(resource.getAllServiceElements()));
            sb.append(" actual: ").append(container.getActual());
            sb.append(" planned: ").append(container.getPlanned());
            if (logger.isLoggable(Level.FINEST)) {
                sb.append(" zones: ").append(container.getZones());
                sb.append(" priorityZone: ").append(container.getPriorityZone());
            }
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static final class ContainerComparator
    implements Comparator<Container> {
        private ContainerComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            if (c1.getPriorityZone() == c2.getPriorityZone()) {
                if (c1.getWeight() == c2.getWeight()) {
                    return c1.getPlanned() - c2.getPlanned();
                }
                return Double.compare(c1.getWeight(), c2.getWeight());
            }
            return c1.getPriorityZone() - c2.getPriorityZone();
        }
    }

    private static final class Container
    extends PriorityZoneComponent {
        private final ServiceResource serviceResource;
        int actual;
        int planned;
        double weight;

        public Container(ServiceResource serviceResource) {
            this.serviceResource = serviceResource;
        }

        public void init(ServiceElement sElem) {
            InstantiatorResource instantiatorResource = (InstantiatorResource)this.serviceResource.getResource();
            double capacityPercentile = 1.0 * (double)instantiatorResource.getServiceElementCount() / (double)instantiatorResource.getServiceLimit();
            List<ServiceElement> actualElements = Arrays.asList(instantiatorResource.getServiceElements());
            ArrayList<ServiceElement> plannedElements = new ArrayList<ServiceElement>(Arrays.asList(instantiatorResource.getServiceElementsInprocess()));
            plannedElements.removeAll(actualElements);
            int weightByService = this.calcWeightByService(sElem, actualElements) + this.calcWeightByService(sElem, plannedElements);
            this.actual = actualElements.size();
            this.planned = plannedElements.size();
            this.weight = (double)(this.actual + this.planned) + (double)weightByService * 0.1 + capacityPercentile + 0.1;
        }

        private int calcWeightByService(ServiceElement sElem, Collection<ServiceElement> elements) {
            int weightByService = 0;
            for (ServiceElement svc : elements) {
                if (!svc.getOperationalStringName().equals(sElem.getOperationalStringName())) continue;
                if (svc.getName().equals(sElem.getName())) {
                    weightByService += 2;
                }
                if (!svc.getInstanceId().equals(sElem.getInstanceId())) continue;
                ++weightByService;
            }
            return weightByService;
        }

        public int getActual() {
            return this.actual;
        }

        public int getPlanned() {
            return this.planned;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

