/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.grid.esm.ESM;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.RequiredDependency;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.monitor.InternalEsmFinder;
import org.jini.rio.monitor.InternalOpStringManagerFinder;
import org.jini.rio.monitor.ProvisionMonitorImpl;
import org.jini.rio.monitor.ServiceElementManager;
import org.jini.rio.opstring.OpString;

public class RequiredDependenciesValidator {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.dependency");
    private final InternalOpStringManagerFinder opStringManagerFinder;
    private final InternalEsmFinder esmFinder;

    public RequiredDependenciesValidator(InternalOpStringManagerFinder opStringManagerFinder, InternalEsmFinder esmFinder) {
        this.opStringManagerFinder = opStringManagerFinder;
        this.esmFinder = esmFinder;
    }

    public RequiredDependency[] findUnsatisfiedRequiredDependencies(ServiceElement serviceElement) {
        ArrayList<RequiredDependency> unsatisfiedDependencies = new ArrayList<RequiredDependency>();
        for (String dependencyName : serviceElement.getInstanceDeploymentDependencies().getRequiredDependenciesNames()) {
            RequiredDependency requiredDependency = serviceElement.getInstanceDeploymentDependencies().getRequiredDependencyByName(dependencyName);
            if (this.checkRequiredDependency(serviceElement, requiredDependency)) continue;
            unsatisfiedDependencies.add(requiredDependency);
        }
        if (logger.isLoggable(Level.FINE)) {
            if (serviceElement.getInstanceDeploymentDependencies().isEmpty()) {
                logger.fine(serviceElement.getName() + " dependencies are satisfied (no dependencies).");
            } else if (unsatisfiedDependencies.isEmpty()) {
                logger.fine(serviceElement.getName() + " dependencies are satisfied.");
            }
        }
        return unsatisfiedDependencies.toArray(new RequiredDependency[unsatisfiedDependencies.size()]);
    }

    private boolean checkRequiredDependency(ServiceElement serviceElement, RequiredDependency requiredDependency) {
        return this.checkInstances(serviceElement, requiredDependency) && this.checkDeploymentComplete(serviceElement, requiredDependency) && this.checkInstancesPerPartition(serviceElement, requiredDependency);
    }

    private boolean checkInstances(ServiceElement serviceElement, RequiredDependency requiredDependency) {
        boolean satisfied = true;
        if (requiredDependency.getMinimumNumberOfDeployedInstances() > 0) {
            ProvisionMonitorImpl.OpStringManager dependencyOpStringManager = this.getOpStringManager(serviceElement, requiredDependency);
            if (dependencyOpStringManager == null) {
                satisfied = false;
            } else {
                int actualNumberOfServiceElements = this.getActualNumberOfInstances(dependencyOpStringManager);
                if (actualNumberOfServiceElements < requiredDependency.getMinimumNumberOfDeployedInstances()) {
                    if (logger.isLoggable(Level.FINE)) {
                        String dependencyName = requiredDependency.getRequiredProcessingUnitName();
                        logger.fine(serviceElement.getName() + " depends on at least " + requiredDependency.getMinimumNumberOfDeployedInstances() + " instance of " + dependencyName + ", but there are only " + actualNumberOfServiceElements + " " + dependencyName + " instances found.");
                    }
                    satisfied = false;
                }
            }
        }
        return satisfied;
    }

    private boolean checkDeploymentComplete(ServiceElement serviceElement, RequiredDependency requiredDependency) {
        OperationalString operationalString;
        int status;
        String dependencyName = requiredDependency.getRequiredProcessingUnitName();
        if (!requiredDependency.getWaitForDeploymentToComplete()) {
            return true;
        }
        ProvisionMonitorImpl.OpStringManager dependencyOpStringManager = this.getOpStringManager(serviceElement, requiredDependency);
        if (dependencyOpStringManager == null) {
            return false;
        }
        OperationalString dependencyOperationalString = this.getOperationalString(dependencyOpStringManager);
        ServiceElement[] depenedencyServiceElements = dependencyOperationalString.getServices();
        if (depenedencyServiceElements.length == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(serviceElement.getName() + " depends on the deployment of " + dependencyName + " , but " + dependencyName + " has no instances deployed.");
            }
            return false;
        }
        boolean satisfied = true;
        if (this.isManagedByEsm(depenedencyServiceElements[0])) {
            ESM esm = this.esmFinder.getESM();
            if (esm == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, serviceElement.getName() + " depends on the deployment of " + dependencyName + ", but " + dependencyName + " ESM is not discovered");
                }
                satisfied = false;
            } else {
                try {
                    if (!esm.isManagingProcessingUnit(dependencyName)) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(serviceElement.getName() + " depends on the deployment of " + dependencyName + ", but " + dependencyName + " elastic scale has not started yet.");
                        }
                        satisfied = false;
                    } else if (!esm.isManagingProcessingUnitAndScaleNotInProgress(dependencyName)) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(serviceElement.getName() + " depends on the deployment of " + dependencyName + ", but " + dependencyName + " elastic scale is still in progress.");
                        }
                        satisfied = false;
                    }
                }
                catch (RemoteException e) {
                    logger.log(Level.WARNING, serviceElement.getName() + " depends on the deployment of " + dependencyName + ", but " + dependencyName + " elastic scale progress cannot be determined.", e);
                    satisfied = false;
                }
            }
        }
        if ((status = (operationalString = this.getOperationalString(dependencyOpStringManager)).getStatus()) != 5) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(serviceElement.getName() + " depends on the deployment of " + dependencyName + ", but " + dependencyName + " state is " + OpString.convertStatusToString(status));
            }
            satisfied = false;
        }
        return satisfied;
    }

    private boolean isManagedByEsm(ServiceElement serviceElement) {
        Map<String, String> elasticProperties = serviceElement.getElasticProperties();
        return elasticProperties != null && !elasticProperties.isEmpty();
    }

    private boolean checkInstancesPerPartition(ServiceElement serviceElement, RequiredDependency requiredDependency) {
        int expected = requiredDependency.getMinimumNumberOfDeployedInstancesPerPartition();
        String dependencyName = requiredDependency.getRequiredProcessingUnitName();
        if (expected == 0) {
            return true;
        }
        ProvisionMonitorImpl.OpStringManager dependencyOpStringManager = this.getOpStringManager(serviceElement, requiredDependency);
        if (dependencyOpStringManager == null) {
            return false;
        }
        OperationalString dependencyOperationalString = this.getOperationalString(dependencyOpStringManager);
        ServiceElement[] depenedencyServiceElements = dependencyOperationalString.getServices();
        if (depenedencyServiceElements.length == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(serviceElement.getName() + " depends on the deployment of " + expected + " " + dependencyName + " instances per partition, but " + dependencyName + " has no instances deployed.");
            }
            return false;
        }
        if (depenedencyServiceElements[0].getServiceBeanConfig() == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(serviceElement.getName() + " depends on the deployment of " + expected + " " + dependencyName + " instances per partition, but " + depenedencyServiceElements[0].getName() + " has no service bean config.");
            }
            return false;
        }
        int dependencyExpectedNumberOfPartitions = (Integer)depenedencyServiceElements[0].getServiceBeanConfig().getInitParameters().get("numberOfInstances");
        int dependencyExpectedNumberOfInstancesPerPartitions = (Integer)depenedencyServiceElements[0].getServiceBeanConfig().getInitParameters().get("numberOfBackups") + 1;
        boolean satisfied = true;
        if (dependencyExpectedNumberOfInstancesPerPartitions == 1) {
            int dependencyActualNumberOfPartitions = this.getActualNumberOfInstancesInServiceElement(dependencyOpStringManager, depenedencyServiceElements[0]);
            if (dependencyActualNumberOfPartitions < dependencyExpectedNumberOfPartitions) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(serviceElement.getName() + " depends on the deployment of " + expected + " " + dependencyName + " instances per partition, but " + dependencyName + " has currently " + dependencyActualNumberOfPartitions + " active partitions, instead of " + dependencyExpectedNumberOfPartitions + " partitions.");
                }
                satisfied = false;
            }
            if (expected > 1) {
                logger.warning(serviceElement.getName() + " depends on the deployment of " + expected + " " + dependencyName + " instances per partition, but " + dependencyName + " has been deployed with only 1 instance per partition.");
                satisfied = false;
            }
        } else {
            int dependencyActualNumberOfPartitions = depenedencyServiceElements.length;
            if (dependencyActualNumberOfPartitions < dependencyExpectedNumberOfPartitions) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(serviceElement.getName() + " depends on the deployment of " + expected + " " + dependencyName + " instances per partition, but " + dependencyName + " has currently " + dependencyActualNumberOfPartitions + " active partitions, instead of " + dependencyExpectedNumberOfPartitions + " partitions.");
                }
                satisfied = false;
            }
            for (ServiceElement dependencyServiceElement : depenedencyServiceElements) {
                int actual = this.getActualNumberOfInstancesInServiceElement(dependencyOpStringManager, dependencyServiceElement);
                if (actual >= expected) continue;
                satisfied = false;
                if (!logger.isLoggable(Level.FINE)) continue;
                String dependencyServiceElementName = dependencyServiceElement.getName();
                logger.fine(serviceElement.getName() + " depends on the deployment of " + expected + " " + dependencyName + " instances per partition, but " + dependencyServiceElementName + " partition has only " + actual + " instances.");
            }
        }
        return satisfied;
    }

    private int getActualNumberOfInstances(ProvisionMonitorImpl.OpStringManager opStringManager) {
        OperationalString operationalString = this.getOperationalString(opStringManager);
        ServiceElement[] serviceElements = operationalString.getServices();
        int actualNumberOfServiceElements = 0;
        for (ServiceElement serviceElement : serviceElements) {
            actualNumberOfServiceElements += this.getActualNumberOfInstancesInServiceElement(opStringManager, serviceElement);
        }
        return actualNumberOfServiceElements;
    }

    private int getActualNumberOfInstancesInServiceElement(ProvisionMonitorImpl.OpStringManager opStringManager, ServiceElement serviceElement) {
        ServiceElementManager serviceElementManager = opStringManager.getServiceElementManager(serviceElement);
        int actualNumberOfServiceElements = serviceElementManager.getActual();
        return actualNumberOfServiceElements;
    }

    private OperationalString getOperationalString(ProvisionMonitorImpl.OpStringManager opStringManager) {
        OperationalString operationalString;
        try {
            operationalString = opStringManager.getOperationalString();
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unexpected RemoteException, operational string is local (not remote)", e);
        }
        return operationalString;
    }

    private ProvisionMonitorImpl.OpStringManager getOpStringManager(ServiceElement serviceElement, RequiredDependency requiredDependency) {
        String dependencyName = requiredDependency.getRequiredProcessingUnitName();
        ProvisionMonitorImpl.OpStringManager dependencyOpStringManager = this.opStringManagerFinder.getOpStringManager(dependencyName);
        if (dependencyOpStringManager == null && logger.isLoggable(Level.FINE)) {
            logger.fine(serviceElement.getName() + " depends on " + dependencyName + ", but " + dependencyName + " was not found.");
        }
        return dependencyOpStringManager;
    }
}

