/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import java.util.EventObject;
import java.util.Vector;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.jsb.ServiceElementUtil;

public class ServiceChannel {
    private final Vector<Registration> registrations = new Vector();
    private static final ServiceChannel instance = new ServiceChannel();

    private ServiceChannel() {
    }

    public static ServiceChannel getInstance() {
        return instance;
    }

    public void subscribe(ServiceChannelListener listener, ServiceElement element) {
        Registration reg = new Registration(listener, element);
        if (!this.registrations.contains(reg)) {
            this.registrations.add(reg);
        }
    }

    public void subscribe(ServiceChannelListener listener, String name, String[] interfaces, String opStringName) {
        Registration reg = new Registration(listener, name, interfaces, opStringName);
        if (!this.registrations.contains(reg)) {
            this.registrations.add(reg);
        }
    }

    public void unsubscribe(ServiceChannelListener listener, String name, String[] interfaces, String opStringName) {
        Registration reg = new Registration(listener, name, interfaces, opStringName);
        if (this.registrations.contains(reg)) {
            this.registrations.remove(reg);
        }
    }

    public void unsubscribe(ServiceChannelListener listener, ServiceElement element) {
        Registration reg = new Registration(listener, element);
        if (this.registrations.contains(reg)) {
            this.registrations.remove(reg);
        }
    }

    public void unsubscribe(ServiceChannelListener listener) {
        Object[] arrLocal = this.getRegistrations();
        for (int i = 0; i < arrLocal.length; ++i) {
            Registration r = (Registration)arrLocal[i];
            if (!r.getServiceChannelListener().equals(listener)) continue;
            this.registrations.remove(r);
        }
    }

    public void broadcast(ServiceChannelEvent event) {
        Object[] arrLocal = this.getRegistrations();
        for (int i = 0; i < arrLocal.length; ++i) {
            Registration r = (Registration)arrLocal[i];
            if (!r.matches(event.getServiceElement())) continue;
            r.getServiceChannelListener().notify(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getRegistrations() {
        Object[] arrLocal;
        ServiceChannel serviceChannel = this;
        synchronized (serviceChannel) {
            arrLocal = this.registrations.toArray();
        }
        return arrLocal;
    }

    private class Registration {
        ServiceElement element;
        ServiceChannelListener listener;
        String name;
        String[] interfaces;
        String opStringName;

        Registration(ServiceChannelListener listener, ServiceElement element) {
            this.element = element;
            this.listener = listener;
            this.name = element.getName();
            ClassBundle[] exports = element.getExportBundles();
            this.interfaces = new String[exports.length];
            for (int i = 0; i < this.interfaces.length; ++i) {
                this.interfaces[i] = exports[i].getClassName();
            }
            this.opStringName = element.getOperationalStringName();
        }

        Registration(ServiceChannelListener listener, String name, String[] interfaces, String opStringName) {
            this.listener = listener;
            this.name = name;
            this.interfaces = interfaces;
            this.opStringName = opStringName;
        }

        boolean matches(ServiceElement element) {
            return ServiceElementUtil.matchesServiceElement(element, this.name, this.interfaces, this.opStringName);
        }

        ServiceChannelListener getServiceChannelListener() {
            return this.listener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Registration)) {
                return false;
            }
            Registration that = (Registration)obj;
            return this.name.equals(that.name) && this.interfaces.equals(that.interfaces) && this.opStringName.equals(that.opStringName) && this.listener == that.listener;
        }

        public int hashCode() {
            return this.name.hashCode() + this.interfaces.hashCode() + this.opStringName.hashCode() + this.listener.hashCode();
        }
    }

    public static class ServiceChannelEvent
    extends EventObject {
        private static final long serialVersionUID = -2032116307983551614L;
        public static final int PROVISIONED = 1;
        public static final int FAILED = 2;
        private ServiceElement element;
        private ServiceBeanInstance instance;
        private int type;

        public ServiceChannelEvent(Object source, ServiceElement element, ServiceBeanInstance instance, int type) {
            super(source);
            this.element = element;
            this.instance = instance;
            this.type = type;
        }

        public ServiceElement getServiceElement() {
            return this.element;
        }

        public ServiceBeanInstance getServiceBeanInstance() {
            return this.instance;
        }

        public int getType() {
            return this.type;
        }
    }

    public static interface ServiceChannelListener {
        public void notify(ServiceChannelEvent var1);
    }
}

