/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.j_spaces.kernel.threadpool.monitor.FutureExecutorService;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.constants.ThrowableConstants;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.EmptyConfiguration;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupGroups;
import net.jini.discovery.dynamic.DynamicLookupLocatorDiscovery;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalledInstance;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.boot.ClassAnnotator;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.FaultDetectionHandler;
import org.jini.rio.core.FaultDetectionListener;
import org.jini.rio.core.MonitorableService;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceElementTracker;
import org.jini.rio.core.ServiceFaultDetectionMonitorDetectedFailureAware;
import org.jini.rio.core.ServiceFaultDetectionMonitorIsAliveAware;
import org.jini.rio.core.ServiceFaultDetectionMonitorSuspectingFailureAware;
import org.jini.rio.core.ServiceFaultDetectionUnhealthySpaceAware;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.jsb.ServiceBeanAdmin;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.cybernode.ServiceBeanLoader;
import org.jini.rio.entry.ApplianceInfo;
import org.jini.rio.event.EventHandler;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.monitor.ExtraStatelessInstanceHandler;
import org.jini.rio.monitor.FaultDetectionHandlerTable;
import org.jini.rio.monitor.InstanceIDManager;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.ProvisionLifeCycleEvent;
import org.jini.rio.monitor.ProvisionListener;
import org.jini.rio.monitor.ProvisionMonitorEvent;
import org.jini.rio.monitor.ProvisionMonitorEventTask;
import org.jini.rio.monitor.ProvisionRequest;
import org.jini.rio.monitor.ServiceChannel;
import org.jini.rio.monitor.ServiceFaultDetectionEvent;
import org.jini.rio.monitor.ServiceProvisioner;
import org.jini.rio.monitor.event.ConcurrentEventsStore;
import org.jini.rio.monitor.event.Events;
import org.jini.rio.resources.client.FaultDetectionHandlerFactory;
import org.jini.rio.resources.client.ServiceDiscoveryAdapter;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.resource.ResourceUnavailableException;
import org.jini.rio.resources.servicecore.ServiceResource;

public class ServiceElementManager
implements InstanceIDManager {
    private ServiceElement svcElement;
    private volatile int maintain = 0;
    private int initialMaintain = 0;
    private static final Object sdmMonitor = new Object();
    private static int sdmCount = 0;
    private static ServiceDiscoveryManager sdm;
    private static LookupCache lCache;
    private Class[] interfaces;
    private final ServiceProvisioner provisioner;
    private volatile boolean shutdown = false;
    private final Vector services = new Vector();
    private final Hashtable<Object, String> ambiguousServices = new Hashtable();
    private boolean svcManagerStarted = false;
    private final OperationalStringManager opStringMgr;
    private final ProvisionListener listener = new JSBProvisionListener();
    private final ServiceFaultListener serviceFaultListener = new ServiceFaultListener();
    private final FaultDetectionHandlerTable fdhTable = new FaultDetectionHandlerTable();
    private final ArrayList<ServiceBeanInstance> serviceBeanList = new ArrayList();
    private final ArrayList<ServiceBeanInstance> decrementedServiceBeanList = new ArrayList();
    private final List<ProvisionRequest> redeployRequestList = Collections.synchronizedList(new ArrayList());
    private boolean active;
    private final Configuration config;
    Configuration serviceProvisionConfig;
    private final Uuid myUuid;
    private ServiceElementManagerServiceListener sElemListener;
    Object eventSource;
    EventHandler eventHandler;
    FutureExecutorService eventPool;
    InstanceIDManager instanceIDMgr;
    List<Long> instanceIDs = Collections.synchronizedList(new ArrayList());
    ProxyPreparer proxyPreparer;
    ServiceChannelClient serviceChannelClient = new ServiceChannelClient();
    static Logger logger;
    static Logger mgrLogger;
    static Logger sbiLogger;
    static final String SERVICE_PROVISION_CONFIG_COMPONENT = "service.provision";
    private final Object semMonitor = new Object();
    private final ConcurrentEventsStore eventsStore;
    private final boolean DISABLE_HANDLING_EXTRA_STATELESS_INSTANCES = Boolean.getBoolean("com.gs.disable-handling-extra-stateless-instances");

    ServiceElementManager(ServiceElement sElem, OperationalStringManager opStringMgr, ServiceProvisioner provisioner, Uuid uuid, boolean active, Configuration config, ConcurrentEventsStore eventsStore) throws Exception {
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        if (opStringMgr == null) {
            throw new NullPointerException("opStringMgr is null");
        }
        if (provisioner == null) {
            throw new NullPointerException("provisioner is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is null");
        }
        this.opStringMgr = opStringMgr;
        this.provisioner = provisioner;
        this.myUuid = uuid;
        this.active = active;
        this.config = config == null ? EmptyConfiguration.INSTANCE : config;
        this.instanceIDMgr = this;
        this.setServiceElement(sElem);
        this.eventsStore = eventsStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void setServiceElement(ServiceElement newElem) throws Exception {
        if (newElem == null) {
            throw new NullPointerException("sElem is null");
        }
        boolean update = this.svcElement != null;
        ServiceElement preElem = this.svcElement;
        this.svcElement = newElem;
        ServiceChannel channel = ServiceChannel.getInstance();
        channel.unsubscribe(this.serviceChannelClient);
        AssociationDescriptor[] aDesc = this.svcElement.getAssociationDescriptors();
        for (int i = 0; i < aDesc.length; ++i) {
            if (aDesc[i].getAssociationType().getType() != 3) continue;
            channel.subscribe(this.serviceChannelClient, aDesc[i].getName(), aDesc[i].getInterfaceNames(), aDesc[i].getOperationalStringName());
        }
        ServiceBeanConfig sc = this.svcElement.getServiceBeanConfig();
        Map configParameters = sc.getConfigurationParamaters();
        String adaptCodebase = (String)configParameters.get("adaptiveCodebase");
        if (adaptCodebase != null && adaptCodebase.equals("yes") && ServiceElementUtil.hasHTTPCodebase(this.svcElement)) {
            int i;
            final Thread currentThread = Thread.currentThread();
            ClassLoader currentLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return currentThread.getContextClassLoader();
                }
            });
            ArrayList<URL> list = new ArrayList<URL>();
            URL[] urls = null;
            if (this.svcElement.getComponentBundle() != null) {
                urls = this.svcElement.getComponentBundle().getJARs();
                for (i = 0; i < urls.length; ++i) {
                    list.add(urls[i]);
                }
            }
            urls = this.svcElement.getExportURLs();
            for (i = 0; i < urls.length; ++i) {
                list.add(urls[i]);
            }
            urls = list.toArray(new URL[list.size()]);
            ClassAnnotator annotator = ServiceBeanLoader.getClassAnnotator(urls, configParameters, this.config, currentLoader);
            if ((urls = annotator.getURLs()) != null && urls.length > 0) {
                String proto = urls[0].getProtocol();
                if (proto.equals("httpmd")) {
                    proto = "http";
                }
                String host = urls[0].getHost();
                int port = urls[0].getPort();
                String codeserver = proto + "://" + host + ":" + port;
                ServiceElementUtil.setCodebase(this.svcElement, codeserver);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[" + ServiceElementUtil.getNameWithId(this.svcElement) + "] Adapted codebase from [] to [" + codeserver + "]");
                }
            }
        }
        String[] args = (String[])configParameters.get("provisionConfig");
        this.serviceProvisionConfig = ConfigurationProvider.getInstance((String[])args);
        this.proxyPreparer = (ProxyPreparer)this.serviceProvisionConfig.getEntry(SERVICE_PROVISION_CONFIG_COMPONENT, "proxyPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        ClassNotFoundException toThrow = null;
        for (int i = 0; i < 2; ++i) {
            try {
                this.interfaces = this.loadInterfaceClasses(this.svcElement);
                toThrow = null;
                break;
            }
            catch (ClassNotFoundException e) {
                toThrow = e;
                if (!update) break;
                Object[] oldBundles = preElem.getExportBundles();
                ClassBundle[] newBundles = this.svcElement.getExportBundles();
                String cb = oldBundles[0].getCodebase();
                if (cb.equals(newBundles[0].getCodebase())) continue;
                for (int a = 0; a < newBundles.length; ++a) {
                    newBundles[a].setCodebase(cb);
                }
                continue;
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
        this.maintain = this.svcElement.getPlanned();
        Integer ips = (Integer)this.svcElement.getServiceBeanConfig().getConfigurationParamaters().get("initial.planned");
        if (ips == null) {
            this.setInitialPlanned(this.svcElement.getPlanned());
        }
        if (update) {
            ProvisionRequest[] removed;
            if (this.svcElement.getProvisionType() != preElem.getProvisionType()) {
                if (preElem.getProvisionType() == 2) {
                    this.removeFixedServiceRequests(preElem);
                } else {
                    removed = this.provisioner.getPendingManager().removeServiceElement(preElem);
                    for (ProvisionRequest pr : removed) {
                        this.removeInstanceID(pr.sElem.getInstanceId(), "change in provision type - remove instance ID for " + pr.sElem);
                    }
                }
            }
            removed = this.semMonitor;
            // MONITORENTER : this.semMonitor
            for (ServiceBeanInstance sbi : this.serviceBeanList) {
                Long instanceID = sbi.getServiceBeanConfig().getInstanceID();
                ServiceBeanConfig updated = newElem.getServiceBeanConfig();
                Map configParms = updated.getConfigurationParamaters();
                configParms.put("instanceID", instanceID);
                ServiceBeanConfig newConfig = new ServiceBeanConfig(configParms, updated.getConfigArgs());
                ServiceBeanConfig sbc = sbi.getServiceBeanConfig();
                Map initParms = sbc.getInitParameters();
                for (Map.Entry e : initParms.entrySet()) {
                    newConfig.addInitParameter(e.getKey(), e.getValue());
                }
                sbi.setServiceBeanConfig(newConfig);
            }
            // MONITOREXIT : removed
            if (sdm != null) {
                DiscoveryManagement dMgr;
                StringBuffer buffer;
                if (ServiceElementUtil.hasDifferentGroups(preElem, newElem)) {
                    String[] groups = newElem.getServiceBeanConfig().getGroups();
                    if (mgrLogger.isLoggable(Level.FINEST)) {
                        buffer = new StringBuffer();
                        if (groups == LookupGroups.all()) {
                            buffer.append("ALL_GROUPS");
                        } else {
                            for (int i = 0; i < groups.length; ++i) {
                                if (i > 0) {
                                    buffer.append(", ");
                                }
                                if (groups[i].equals("")) {
                                    buffer.append("<public>");
                                    continue;
                                }
                                buffer.append(groups[i]);
                            }
                        }
                        mgrLogger.finest("[" + ServiceElementUtil.getNameWithId(this.svcElement) + "] Discovery has changed, setting groups to : " + buffer.toString());
                    }
                    dMgr = sdm.getDiscoveryManager();
                    ((DiscoveryGroupManagement)dMgr).setGroups(groups);
                }
                if (!DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled()) {
                    if (ServiceElementUtil.hasDifferentLocators(preElem, newElem)) {
                        LookupLocator[] locators = newElem.getServiceBeanConfig().getLocators();
                        if (mgrLogger.isLoggable(Level.FINEST)) {
                            buffer = new StringBuffer();
                            if (locators == null) {
                                buffer.append("null");
                            } else {
                                for (int i = 0; i < locators.length; ++i) {
                                    if (i > 0) {
                                        buffer.append(", ");
                                    }
                                    buffer.append(locators[i].toString());
                                }
                            }
                            mgrLogger.finest("[" + ServiceElementUtil.getNameWithId(this.svcElement) + "] Discovery has changed, setting locators to : " + buffer.toString());
                        }
                        dMgr = sdm.getDiscoveryManager();
                        ((DiscoveryLocatorManagement)dMgr).setLocators(locators);
                    }
                } else if (mgrLogger.isLoggable(Level.FINEST)) {
                    mgrLogger.finest("Skipping lookup locators update due to dynamic locatorsenabled");
                }
            }
        }
        if (!this.isStarted()) return;
        this.notifyPendingManager(null);
    }

    private void setInitialPlanned(int value) {
        this.initialMaintain = value;
        this.svcElement.setServiceBeanConfig(ServiceElementUtil.addConfigParameter(this.svcElement.getServiceBeanConfig(), "initial.planned", new Integer(value)));
    }

    private Class[] loadInterfaceClasses(ServiceElement elem) throws MalformedURLException, ClassNotFoundException {
        ClassBundle[] exportBundles = elem.getExportBundles();
        Class[] classes = new Class[exportBundles.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = exportBundles[i].loadClass();
        }
        return classes;
    }

    void notifyPendingManager(ServiceProvisionListener provListener) {
        if (!this.getActive()) {
            if (this.svcElement.getProvisionType() == 1 && this.provisioner.getPendingManager().hasServiceElement(this.svcElement)) {
                ProvisionRequest[] removed;
                if (mgrLogger.isLoggable(Level.FINER)) {
                    mgrLogger.finer("Remove [" + ServiceElementUtil.getNameWithId(this.svcElement) + "] from PendingServiceManager");
                }
                for (ProvisionRequest pr : removed = this.provisioner.getPendingManager().removeServiceElement(this.svcElement)) {
                    this.removeInstanceID(pr.sElem.getInstanceId(), "No longer active, remove instance ID for " + pr.sElem);
                }
            }
            if (this.svcElement.getProvisionType() == 2) {
                this.removeFixedServiceRequests(this.svcElement);
            }
        } else {
            if (this.svcElement.getProvisionType() == 1) {
                if (this.provisioner.getPendingManager().hasServiceElement(this.svcElement)) {
                    int count;
                    if (mgrLogger.isLoggable(Level.FINER)) {
                        mgrLogger.finer("Update [" + ServiceElementUtil.getNameWithId(this.svcElement) + "] in PendingServiceManager");
                    }
                    if ((count = this.provisioner.getPendingManager().getCount(this.svcElement)) > this.svcElement.getPlanned()) {
                        ProvisionRequest[] removed;
                        int toRemove = count - this.svcElement.getPlanned();
                        for (ProvisionRequest pr : removed = this.provisioner.getPendingManager().removeServiceElement(this.svcElement, toRemove)) {
                            this.removeInstanceID(pr.sElem.getInstanceId(), "planned=" + this.svcElement.getPlanned() + " - remove instance ID for " + pr.sElem);
                        }
                    } else {
                        this.provisioner.getPendingManager().updateProvisionRequests(this.svcElement);
                    }
                }
                this.initiateDispatch(provListener);
            }
            if (this.svcElement.getProvisionType() == 2) {
                if (this.svcElement.getPlanned() == 0) {
                    this.removeFixedServiceRequests(this.svcElement);
                    return;
                }
                ProvisionRequest request = new ProvisionRequest(ServiceElementUtil.copyServiceElement(this.svcElement), this.listener, this.opStringMgr, this.instanceIDMgr);
                if (this.provisioner.getFixedServiceManager().hasServiceElement(this.svcElement)) {
                    if (mgrLogger.isLoggable(Level.FINER)) {
                        mgrLogger.finer("Update [" + ServiceElementUtil.getNameWithId(this.svcElement) + "] instance in  FixedServiceManager");
                    }
                    this.provisioner.getFixedServiceManager().updateProvisionRequests(this.svcElement);
                } else {
                    this.provisioner.getFixedServiceManager().addProvisionRequest(request, 0L);
                    if (mgrLogger.isLoggable(Level.FINER)) {
                        mgrLogger.finer("Add [" + ServiceElementUtil.getNameWithId(this.svcElement) + "] to FixedServiceManager");
                    }
                }
                this.provisioner.getFixedServiceManager().deploy(request);
            }
        }
    }

    void removeFixedServiceRequests(ServiceElement sElem) {
        if (sElem.getProvisionType() != 2) {
            return;
        }
        if (this.provisioner.getFixedServiceManager().hasServiceElement(sElem)) {
            if (mgrLogger.isLoggable(Level.FINER)) {
                mgrLogger.finer("Remove [" + sElem.getName() + "] instances from FixedServiceManager");
            }
            this.provisioner.getFixedServiceManager().removeServiceElement(sElem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActive(boolean active) {
        Object object = this.semMonitor;
        synchronized (object) {
            if (!this.getActive() && active) {
                InstantiatorResource[] instantiatorResources;
                for (InstantiatorResource instantiatorResource : instantiatorResources = this.provisioner.getServiceResourceSelector().getInstantiatorResources(this.svcElement)) {
                    try {
                        ServiceBeanInstance[] serviceBeanInstances;
                        for (ServiceBeanInstance serviceBeanInstance : serviceBeanInstances = instantiatorResource.getInstantiator().getServiceBeanInstances(this.svcElement)) {
                            this.importServiceBeanInstance(serviceBeanInstance);
                        }
                        if (!mgrLogger.isLoggable(Level.FINER)) continue;
                        StringBuilder msg = new StringBuilder();
                        for (ServiceBeanInstance beanInstance : serviceBeanInstances) {
                            msg.append(beanInstance.getServiceBeanConfig().getName()).append(" [").append(beanInstance.getServiceBeanConfig().getInstanceID()).append("], ");
                        }
                        mgrLogger.finer("Adding from GSC - [" + instantiatorResource + "] the following instances:" + msg);
                    }
                    catch (Exception e) {
                        if (!mgrLogger.isLoggable(Level.FINEST)) continue;
                        mgrLogger.log(Level.FINEST, "Failed to get the state of processing unit instances in GSC - [" + instantiatorResource + "]", e);
                    }
                }
            }
            this.active = active;
        }
        if (mgrLogger.isLoggable(Level.FINE)) {
            mgrLogger.fine("Set Active [" + active + "] for [" + this.svcElement.getName() + "]");
        }
        this.notifyPendingManager(null);
    }

    public ServiceElement getServiceElement() {
        this.svcElement.setActual(this.getActual());
        return this.svcElement;
    }

    int startManager(ServiceProvisionListener provListener) throws Exception {
        return this.startManager(provListener, new ServiceBeanInstance[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startManager(ServiceProvisionListener provListener, ServiceBeanInstance[] instances) throws Exception {
        Object object = this.semMonitor;
        synchronized (object) {
            if (this.isStarted()) {
                return 0;
            }
            if (instances == null) {
                instances = new ServiceBeanInstance[]{};
            }
            this.addServiceBeanInstancesToList(instances);
            this.startAsyncDiscoveryOfServiceElements();
            ServiceBeanInstance[] sbInstances = this.getServiceBeanInstancesInInstantiationResources(instances.length);
            this.addServiceBeanInstancesToList(sbInstances);
            this.svcManagerStarted = true;
        }
        this.notifyPendingManager(provListener);
        return this.services.size();
    }

    private void addServiceBeanInstancesToList(ServiceBeanInstance[] instances) throws IOException, ClassNotFoundException {
        for (int i = 0; i < instances.length; ++i) {
            this.importServiceBeanInstance(instances[i]);
        }
    }

    private void startAsyncDiscoveryOfServiceElements() throws IOException, ConfigurationException, RemoteException {
        this.createServiceDiscoveryManager();
        this.registerForServiceEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createServiceDiscoveryManager() throws IOException, ConfigurationException {
        Object object = sdmMonitor;
        synchronized (object) {
            ++sdmCount;
            if (sdm == null) {
                sdm = SharedDiscoveryManagement.getBackwardsServiceDiscoveryManager((String[])this.svcElement.getServiceBeanConfig().getGroups(), (LookupLocator[])this.svcElement.getServiceBeanConfig().getLocators(), null);
            }
        }
    }

    private ServiceTemplate createServiceTemplate() {
        ServiceTemplate template = new ServiceTemplate(null, this.interfaces, null);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForServiceEvents() throws RemoteException {
        ServiceTemplate template = this.createServiceTemplate();
        Object object = sdmMonitor;
        synchronized (object) {
            if (lCache == null) {
                lCache = sdm.createLookupCache(template, null, null);
            }
        }
        this.sElemListener = new ServiceElementManagerServiceListener();
        lCache.addListener((ServiceDiscoveryListener)this.sElemListener);
    }

    private ServiceBeanInstance[] getServiceBeanInstancesInInstantiationResources(int expectedInstances) {
        InstantiatorResource[] irArray = null;
        ServiceBeanInstance[] sbInstances = null;
        int count = 0;
        int retryCount = Integer.getInteger("gsc.discovery.retry.count", 3);
        long waitTime = Long.getLong("gsc.discovery.retry.wait.time", 10000L);
        if (mgrLogger.isLoggable(Level.FINEST)) {
            mgrLogger.finest("gsc.discovery.retry.count=[" + retryCount + "], gsc.discovery.retry.wait.time=[" + waitTime + "] ms");
        }
        for (count = 0; count < retryCount; ++count) {
            irArray = this.provisioner.getServiceResourceSelector().getInstantiatorResources(this.svcElement);
            if (mgrLogger.isLoggable(Level.FINEST)) {
                mgrLogger.finest("Discovered [" + irArray.length + "] GSCs");
            }
            ArrayList<ServiceBeanInstance> instanceList = new ArrayList<ServiceBeanInstance>();
            for (InstantiatorResource ir : irArray) {
                try {
                    ServiceBeanInstance[] sbi = ir.getInstantiator().getServiceBeanInstances(this.svcElement);
                    for (int j = 0; j < sbi.length; ++j) {
                        instanceList.add(sbi[j]);
                    }
                }
                catch (RemoteException e) {
                    if (!mgrLogger.isLoggable(Level.FINEST)) continue;
                    mgrLogger.log(Level.FINEST, "Unable to get ServiceBeanInstance(s) from " + ir + " - " + e, e);
                }
            }
            sbInstances = instanceList.toArray(new ServiceBeanInstance[instanceList.size()]);
            if (sbInstances.length >= expectedInstances) {
                if (!mgrLogger.isLoggable(Level.FINEST)) break;
                mgrLogger.finest("All ServiceBeanInstances discovered in GSCs: count=[" + sbInstances.length + "]");
                break;
            }
            try {
                Thread.sleep(waitTime);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (count >= retryCount && mgrLogger.isLoggable(Level.WARNING)) {
            mgrLogger.log(Level.WARNING, "Not all processing units of " + this.svcElement + " were found; Expected: " + expectedInstances + ", found:" + sbInstances.length + ", possible cause, not all GSCs have been discovered by GSM. [count=" + irArray.length + "]");
        }
        if (mgrLogger.isLoggable(Level.FINEST)) {
            mgrLogger.finest("ServiceElement [" + this.svcElement.getOperationalStringName() + ":" + this.svcElement.getName() + "] Instantiator count=" + irArray.length + ", ServiceBeanInstance count=" + sbInstances.length + ", synch manager with discovered instances");
        }
        return sbInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isStarted() {
        Object object = this.semMonitor;
        synchronized (object) {
            return this.svcManagerStarted;
        }
    }

    void initiateDispatch(ServiceProvisionListener listener) {
        this.dispatchProvisionRequests(listener);
    }

    void destroyServices(ServiceBeanInstance[] instances) {
        if (sdm == null) {
            return;
        }
        if (mgrLogger.isLoggable(Level.FINE)) {
            mgrLogger.log(Level.FINE, "Terminating [" + instances.length + "] instances of \"" + this.interfaces[0].getName() + "\" ...");
        }
        for (int i = 0; i < instances.length; ++i) {
            if (mgrLogger.isLoggable(Level.FINE)) {
                mgrLogger.log(Level.FINE, "Destroying [" + (i + 1) + "] of [" + instances.length + "] \"" + this.interfaces[0].getName() + "\" instances ...");
            }
            Object proxy = null;
            try {
                proxy = instances[i].getService();
            }
            catch (Exception e) {
                mgrLogger.log(Level.WARNING, "Getting service proxy", e);
            }
            if (proxy == null) continue;
            this.destroyService(proxy, instances[i].getServiceBeanID(), true);
        }
        if (mgrLogger.isLoggable(Level.FINE)) {
            mgrLogger.log(Level.FINE, "Completed \"" + this.interfaces[0].getName() + "\" service termination");
        }
    }

    void sendUndeployEventToServices(ServiceBeanInstance[] instances) {
        if (sdm == null) {
            return;
        }
        if (mgrLogger.isLoggable(Level.FINE)) {
            mgrLogger.log(Level.FINE, "Sending undeploy event to [" + instances.length + "] instances of \"" + this.interfaces[0].getName() + "\" ...");
        }
        for (int i = 0; i < instances.length; ++i) {
            if (mgrLogger.isLoggable(Level.FINE)) {
                mgrLogger.log(Level.FINE, "Sending undeploy event [" + (i + 1) + "] of [" + instances.length + "] \"" + this.interfaces[0].getName() + "\" instances ...");
            }
            Object proxy = null;
            try {
                proxy = instances[i].getService();
            }
            catch (Exception e) {
                mgrLogger.log(Level.WARNING, "Getting service proxy", e);
            }
            if (proxy == null) continue;
            try {
                Object admin = ((Administrable)proxy).getAdmin();
                if (!(admin instanceof ServiceBeanAdmin)) continue;
                ((ServiceBeanAdmin)admin).undeployEvent();
                continue;
            }
            catch (Exception e) {
                if (!mgrLogger.isLoggable(Level.FINE)) continue;
                mgrLogger.log(Level.FINE, "Failed to send undpeloy event", e);
            }
        }
        if (mgrLogger.isLoggable(Level.FINE)) {
            mgrLogger.log(Level.FINE, "Completed " + this.interfaces[0].getName() + " service termination");
        }
    }

    boolean destroyService(Object service, Uuid serviceID, boolean clean) {
        boolean terminated;
        ServiceID xServiceID;
        block4: {
            xServiceID = new ServiceID(serviceID.getMostSignificantBits(), serviceID.getLeastSignificantBits());
            terminated = false;
            this.removeFaultDetectionHandler(xServiceID);
            try {
                this.doDestroy(service);
                terminated = true;
            }
            catch (Exception e) {
                mgrLogger.log(Level.WARNING, "Destroying a Service", e);
                int category = ThrowableConstants.retryable((Throwable)e);
                if (category != 1 && category != 2) break block4;
                if (mgrLogger.isLoggable(Level.FINE)) {
                    mgrLogger.log(Level.FINE, "Force clean for [" + ServiceElementUtil.getNameWithId(this.svcElement) + "] ServiceBeanInstance [" + serviceID.toString() + "]");
                }
                clean = true;
            }
        }
        if (clean) {
            this.cleanService(service, xServiceID, true);
        }
        return terminated;
    }

    private void removeFaultDetectionHandler(ServiceID serviceId) {
        FaultDetectionHandlerTable.FdhHolder fdhHolder = this.fdhTable.remove(serviceId);
        if (fdhHolder != null) {
            fdhHolder.getHandler().terminate();
            if (mgrLogger.isLoggable(Level.FINEST)) {
                mgrLogger.finest("Fault-detection for service [" + serviceId + "] has been terminated.");
            }
        }
    }

    void doDestroy(Object service) throws RemoteException, ConnectException {
        block2: {
            Administrable admin = (Administrable)service;
            DestroyAdmin destroyAdmin = (DestroyAdmin)admin.getAdmin();
            try {
                destroyAdmin.destroy();
            }
            catch (ConnectException e1) {
                if (e1.getCause() instanceof ClosedChannelException) break block2;
                throw e1;
            }
        }
    }

    void relocate(ServiceBeanInstance instance, ServiceProvisionListener svcProvisionListener, Uuid requestedUuid) throws OperationalStringException {
        InstantiatorResource instantiatorGSC = null;
        Uuid excludeUuid = null;
        ServiceResource[] resources = this.provisioner.getServiceResourceSelector().getServiceResources(instance.getHostAddress(), true);
        for (int i = 0; i < resources.length; ++i) {
            InstantiatorResource ir = (InstantiatorResource)resources[i].getResource();
            if (!ir.hasServiceElementInstance(this.svcElement, instance.getServiceBeanID())) continue;
            excludeUuid = ir.getInstantiatorUuid();
            instantiatorGSC = ir;
            break;
        }
        if (excludeUuid == null) {
            throw new OperationalStringException("Unable to obtain the Uuid of the instantiator");
        }
        ServiceBeanInstance sbi = this.getServiceBeanInstance(instance.getServiceBeanID());
        if (sbi == null) {
            throw new OperationalStringException("Unable to relocate service [" + ServiceElementUtil.getNameWithId(this.svcElement) + "], unknown ServiceBeanInstance");
        }
        ServiceElement newElem = ServiceElementUtil.copyServiceElement(this.svcElement);
        newElem.setServiceBeanConfig(instance.getServiceBeanConfig());
        if (logger.isLoggable(Level.INFO)) {
            ServiceResource[] resource = this.provisioner.selector.getServiceResources(requestedUuid, true);
            if (resource.length > 0) {
                InstantiatorResource instantiatorResource = (InstantiatorResource)resource[0].getResource();
                if (instantiatorGSC.equals(instantiatorResource)) {
                    logger.info("Restarting [" + newElem + "] at [" + instantiatorGSC + "]");
                } else {
                    logger.info("Relocating [" + newElem + "] from [" + instantiatorGSC + "] to [" + instantiatorResource + "]");
                }
            } else {
                logger.info("Relocating [" + newElem + "] from [" + instantiatorGSC + "]");
            }
        }
        this.decrementAndDispatchProvisionRequests(instance, svcProvisionListener, requestedUuid, newElem, sbi, excludeUuid);
    }

    private void decrementAndDispatchProvisionRequests(ServiceBeanInstance instance, ServiceProvisionListener svcProvisionListener, Uuid requestedUuid, ServiceElement newElem, ServiceBeanInstance sbi, Uuid excludeUuid) throws OperationalStringException {
        DecrementAndDispatchProvisionEventTask decrementAndDispatchProvisionEventTask = new DecrementAndDispatchProvisionEventTask(instance, svcProvisionListener, requestedUuid, newElem, sbi, excludeUuid);
        try {
            PoolableThread thread = (PoolableThread)this.provisioner.provisioningPool.get();
            thread.execute((Runnable)decrementAndDispatchProvisionEventTask);
        }
        catch (ResourceUnavailableException e) {
            throw new OperationalStringException("Unable to relocate due to unavailable provision resource", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(ServiceBeanInstance instance) throws OperationalStringException {
        Object object = this.semMonitor;
        synchronized (object) {
            int index = this.serviceBeanList.indexOf(instance);
            if (index == -1) {
                if (sbiLogger.isLoggable(Level.FINE)) {
                    sbiLogger.log(Level.FINE, "[" + this.svcElement.getName() + "] Adding {0} ServiceBeanInstance ID {1}", new Object[]{this.svcElement.getName(), instance.getServiceBeanConfig().getInstanceID()});
                }
                this.serviceBeanList.add(instance);
            } else {
                if (sbiLogger.isLoggable(Level.FINE)) {
                    sbiLogger.log(Level.FINE, "[" + this.svcElement.getName() + "] Updating {0} ServiceBeanInstance ID {1}", new Object[]{this.svcElement.getName(), instance.getServiceBeanConfig().getInstanceID()});
                }
                this.serviceBeanList.set(index, instance);
            }
        }
    }

    void redeploy(ServiceProvisionListener svcProvisionListener) {
        if (this.svcElement.getProvisionType() == 1) {
            this.provisioner.getPendingManager().updateProvisionRequests(this.svcElement);
        }
        if (this.svcElement.getProvisionType() == 2 && this.provisioner.getFixedServiceManager().hasServiceElement(this.svcElement)) {
            this.provisioner.getFixedServiceManager().updateProvisionRequests(this.svcElement);
        }
    }

    void redeploy(ServiceBeanInstance instance) throws OperationalStringException {
        ServiceBeanInstance sbi = this.getServiceBeanInstance(instance.getServiceBeanID());
        if (sbi == null) {
            throw new OperationalStringException("Not tracking ServiceBeanInstance");
        }
        ServiceElement newElem = ServiceElementUtil.copyServiceElement(this.svcElement);
        newElem.setServiceBeanConfig(sbi.getServiceBeanConfig());
        if (this.svcElement.getProvisionType() == 1) {
            this.provisioner.getPendingManager().updateProvisionRequests(newElem);
        }
        if (this.svcElement.getProvisionType() == 2) {
            this.provisioner.getFixedServiceManager().updateProvisionRequests(newElem);
        }
        this.redeployRequestList.add(new ProvisionRequest(newElem, this.listener, this.opStringMgr, this.instanceIDMgr, null, sbi));
        Object proxy = null;
        try {
            proxy = instance.getService();
        }
        catch (Exception e) {
            mgrLogger.log(Level.WARNING, "Getting service for destroy invocation", e);
        }
        if (proxy != null) {
            this.destroyService(proxy, instance.getServiceBeanID(), true);
            ProvisionRequest provRequest = this.serviceFaultListener.getRedeploymentProvisionRequest(proxy);
            mgrLogger.info("Redeploying " + ServiceElementUtil.getNameWithId(provRequest.sElem));
            this.doDispatchProvisionRequests(new ProvisionRequest[]{provRequest});
        }
    }

    void redeploy(ServiceBeanInstance instance, boolean clean, ServiceProvisionListener svcProvisionListener) throws OperationalStringException {
        ProvisionRequest provRequest;
        boolean destroyed;
        ServiceBeanInstance sbi = this.getServiceBeanInstance(instance.getServiceBeanID());
        if (sbi == null) {
            throw new OperationalStringException("Not tracking ServiceBeanInstance");
        }
        ServiceElement newElem = ServiceElementUtil.copyServiceElement(this.svcElement);
        if (clean) {
            Long instanceID = sbi.getServiceBeanConfig().getInstanceID();
            newElem = ServiceElementUtil.prepareInstanceID(newElem, false, instanceID.intValue());
        } else {
            newElem.setServiceBeanConfig(sbi.getServiceBeanConfig());
        }
        if (this.svcElement.getProvisionType() == 1) {
            this.provisioner.getPendingManager().updateProvisionRequests(newElem);
        }
        if (this.svcElement.getProvisionType() == 2) {
            this.provisioner.getFixedServiceManager().updateProvisionRequests(newElem);
        }
        this.redeployRequestList.add(new ProvisionRequest(newElem, this.listener, this.opStringMgr, this.instanceIDMgr, svcProvisionListener, sbi));
        Object proxy = null;
        try {
            proxy = instance.getService();
        }
        catch (Exception e) {
            mgrLogger.log(Level.WARNING, "Getting service for destroy invocation", e);
        }
        if (proxy != null && !(destroyed = this.destroyService(proxy, instance.getServiceBeanID(), false)) && (provRequest = this.serviceFaultListener.getRedeploymentProvisionRequest(proxy)) != null) {
            this.doDispatchProvisionRequests(new ProvisionRequest[]{provRequest});
        }
    }

    boolean hasServiceBeanInstance(ServiceBeanInstance instance) {
        ServiceBeanInstance[] sbs = this.getServiceBeanInstances();
        for (int i = 0; i < sbs.length; ++i) {
            if (!instance.equals(sbs[i])) continue;
            return true;
        }
        return false;
    }

    ServiceBeanInstance getServiceBeanInstance(Uuid uuid) {
        ServiceBeanInstance instance = null;
        if (uuid != null) {
            ServiceBeanInstance[] sbs = this.getServiceBeanInstances();
            for (int i = 0; i < sbs.length; ++i) {
                if (!sbs[i].getServiceBeanID().equals((Object)uuid)) continue;
                instance = sbs[i];
                break;
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceServiceBeanInstance(ServiceBeanInstance instance) {
        boolean replaced = false;
        Object object = this.semMonitor;
        synchronized (object) {
            int ndx = this.serviceBeanList.indexOf(instance);
            if (ndx != -1) {
                this.serviceBeanList.set(ndx, instance);
                replaced = true;
            }
        }
        return replaced;
    }

    int getPendingCount() {
        int count = -1;
        if (this.svcElement.getProvisionType() == 1) {
            count = this.provisioner.getPendingManager().getCount(this.svcElement);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceElement increment(boolean permanent, ServiceProvisionListener svcProvisionListener, boolean relocated) {
        Object object = this.semMonitor;
        synchronized (object) {
            boolean okayToIncrement = false;
            ServiceElement serviceElement = this.svcElement;
            synchronized (serviceElement) {
                int planned = this.svcElement.getPlanned();
                StringBuffer sb = new StringBuffer();
                sb.append("INCREMENT [" + this.svcElement.getName() + "] Permanently=" + permanent + ", relocated=" + relocated + ", planned=" + planned + ", ");
                if (!permanent) {
                    int max = this.getMaxServiceCount();
                    sb.append("MAX COUNT=" + max + ", ");
                    if (planned < max) {
                        okayToIncrement = true;
                    }
                } else {
                    okayToIncrement = true;
                }
                sb.append("okayToIncrement=" + okayToIncrement);
                if (okayToIncrement) {
                    if (relocated) {
                        this.svcElement.decrementRelocateInstanceCount();
                    } else {
                        mgrLogger.info("Increment instance of [" + this.svcElement.getName() + "]");
                    }
                    this.svcElement.incrementPlanned();
                    if (permanent) {
                        this.setInitialPlanned(this.svcElement.getPlanned());
                    }
                    this.maintain = this.svcElement.getPlanned();
                    if (mgrLogger.isLoggable(Level.FINEST)) {
                        mgrLogger.finest(sb.toString() + ", was [" + planned + "], initialMaintain=" + this.initialMaintain + ", new maintain=" + this.maintain);
                    }
                    this.notifyPendingManager(svcProvisionListener);
                } else if (mgrLogger.isLoggable(Level.FINEST)) {
                    mgrLogger.finest(sb.toString() + ", cancelled, already at maximum allowed [" + planned + "]");
                }
            }
            return okayToIncrement ? this.svcElement : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int trim(int trimUp) {
        ProvisionRequest[] removed = new ProvisionRequest[]{};
        if (this.svcElement.getProvisionType() == 1) {
            if (trimUp == -1) {
                if (this.provisioner.getPendingManager().hasServiceElement(this.svcElement)) {
                    removed = this.provisioner.getPendingManager().removeServiceElement(this.svcElement);
                }
            } else {
                int numToTrim = Math.min(this.maintain - this.getActual(), trimUp);
                if (this.provisioner.getPendingManager().hasServiceElement(this.svcElement)) {
                    removed = this.provisioner.getPendingManager().removeServiceElement(this.svcElement, numToTrim);
                }
            }
            for (ProvisionRequest pr : removed) {
                this.removeInstanceID(pr.sElem.getInstanceId(), "trim - remove instance ID for " + pr.sElem);
            }
            if (mgrLogger.isLoggable(Level.FINER)) {
                mgrLogger.finer("Removed " + removed.length + " [" + this.svcElement.getName() + "] pending requests from PendingServiceManager");
            }
        }
        ProvisionRequest[] provisionRequestArray = this.svcElement;
        synchronized (this.svcElement) {
            this.svcElement.setPlanned(this.svcElement.getPlanned() - removed.length);
            this.maintain = this.svcElement.getPlanned();
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return removed.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceElement decrement(ServiceBeanInstance instance, boolean mandate, boolean destroy, boolean relocated) {
        Object object = this.semMonitor;
        synchronized (object) {
            boolean okayToDecrement = true;
            Serializable serializable = this.svcElement;
            synchronized (serializable) {
                int current = this.getServiceBeanInstances().length;
                if (current > this.initialMaintain) {
                    okayToDecrement = true;
                } else if (current == this.initialMaintain) {
                    if (!mandate) {
                        okayToDecrement = false;
                    }
                } else if (this.maintain == this.initialMaintain && !mandate) {
                    okayToDecrement = false;
                }
                if (mgrLogger.isLoggable(Level.FINEST)) {
                    mgrLogger.finest("DECREMENT [" + instance.getPresentationName() + "] current=" + current + ", maintain=" + this.initialMaintain + ", initialMaintain=" + this.initialMaintain + ", mandate=" + mandate + ", okayToDecrement=" + okayToDecrement + ", relocated=" + relocated + ", serviceID=[" + instance.getServiceBeanID() + "]");
                }
                if (okayToDecrement) {
                    if (relocated) {
                        this.svcElement.incrementRelocateInstanceCount();
                    }
                    this.svcElement.decrementPlanned();
                    int temp = this.svcElement.getPlanned();
                    this.setInitialPlanned(this.initialMaintain < temp ? this.initialMaintain : temp);
                }
                this.maintain = this.svcElement.getPlanned();
            }
            if (okayToDecrement) {
                this.removeServiceBeanInstance(instance);
                this.removeInstanceID(instance.getServiceBeanConfig().getInstanceID(), "decrement");
                serializable = this.decrementedServiceBeanList;
                synchronized (serializable) {
                    this.decrementedServiceBeanList.add(instance);
                }
                if (destroy) {
                    try {
                        if (!relocated) {
                            mgrLogger.info("Decrement instance [" + instance.getPresentationName() + "]");
                        }
                        this.destroyService(instance.getService(), instance.getServiceBeanID(), true);
                    }
                    catch (Exception e) {
                        mgrLogger.log(Level.WARNING, "Getting service for destroy invocation", e);
                    }
                }
                this.notifyPendingManager(null);
            }
            return this.svcElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceElement decrementPlannedIfPending() {
        Object object = this.semMonitor;
        synchronized (object) {
            boolean okayToDecrement = false;
            ServiceElement serviceElement = this.svcElement;
            synchronized (serviceElement) {
                int planned = this.svcElement.getPlanned();
                int current = this.getServiceBeanInstances().length;
                if (planned > 0 && current > 0 && planned > current) {
                    okayToDecrement = true;
                }
                if (okayToDecrement) {
                    ProvisionRequest[] removeServiceElement;
                    if (mgrLogger.isLoggable(Level.FINEST)) {
                        mgrLogger.finest("DECREMENT [" + this.svcElement + "] planned=" + planned + ", current=" + current + ", maintain=" + this.maintain + ", initialMaintain=" + this.initialMaintain + ", okayToDecrement=" + okayToDecrement);
                    }
                    for (ProvisionRequest pr : removeServiceElement = this.provisioner.getPendingManager().removeServiceElement(this.svcElement, 1)) {
                        this.removeInstanceID(pr.sElem.getInstanceId(), "decrement pending - remove instance ID for " + pr.sElem);
                    }
                    if (removeServiceElement.length == 0) {
                        ServiceElementTracker serviceElementTracker = new ServiceElementTracker(this.svcElement);
                        this.provisioner.getPendingManager().trackServiceElement(serviceElementTracker);
                        if (serviceElementTracker.getInProcessCount() > 0) {
                            return null;
                        }
                    }
                    this.svcElement.decrementPlanned();
                    int newPlanned = this.svcElement.getPlanned();
                    this.setInitialPlanned(this.initialMaintain < newPlanned ? this.initialMaintain : newPlanned);
                    this.maintain = newPlanned;
                    if (mgrLogger.isLoggable(Level.FINEST)) {
                        mgrLogger.finest("DECREMENT [" + this.svcElement + "] planned=" + newPlanned + ", current=" + current + ", maintain=" + this.maintain + ", initialMaintain=" + this.initialMaintain + ", okayToDecrement=" + okayToDecrement);
                    }
                }
                return okayToDecrement ? this.svcElement : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceBeanInstance(ServiceBeanInstance instance) {
        Object object = this.semMonitor;
        synchronized (object) {
            int index = this.serviceBeanList.indexOf(instance);
            if (index != -1) {
                this.serviceBeanList.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstanceID(Long id, String action) {
        Object object = this.semMonitor;
        synchronized (object) {
            if (id != null) {
                if (this.instanceIDs.remove(id)) {
                    if (sbiLogger.isLoggable(Level.FINEST)) {
                        StringBuffer buff = new StringBuffer();
                        buff.append("[" + this.svcElement.getOperationalStringName() + ":" + this.svcElement.getName() + "] ");
                        buff.append("Removed [" + this.svcElement.getName() + "] Instance ID=" + id + ", Action=[" + action + "]\n");
                        sbiLogger.log(Level.FINEST, this.instanceIDLog(buff));
                    }
                } else if (sbiLogger.isLoggable(Level.FINEST)) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("[" + this.svcElement.getOperationalStringName() + ":" + this.svcElement.getName() + "] ");
                    buff.append("Instance ID=" + id + "not removed for [" + this.svcElement.getName() + "], Action=[" + action + "]\n");
                    sbiLogger.log(Level.FINEST, this.instanceIDLog(buff));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopManager(boolean destroyServices, boolean undeploy) {
        Object object = this.semMonitor;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            ServiceChannel.getInstance().unsubscribe(this.serviceChannelClient);
            if (this.svcElement.getProvisionType() == 1) {
                this.provisioner.getPendingManager().removeServiceElement(this.svcElement);
            } else {
                this.provisioner.getFixedServiceManager().removeServiceElement(this.svcElement);
            }
            if (lCache != null && this.sElemListener != null) {
                try {
                    lCache.removeListener((ServiceDiscoveryListener)this.sElemListener);
                }
                catch (Throwable t) {
                    mgrLogger.log(Level.WARNING, "Terminating LookupCache", t);
                }
            }
            for (FaultDetectionHandlerTable.FdhHolder fdhHolder : this.fdhTable.values()) {
                fdhHolder.getHandler().terminate();
            }
            if (undeploy || destroyServices && this.svcElement.getProvisionType() != 0) {
                ServiceBeanInstance[] instances = this.getServiceBeanInstances();
                if (undeploy) {
                    this.sendUndeployEventToServices(instances);
                }
                if (destroyServices) {
                    this.destroyServices(instances);
                }
            }
            this.svcManagerStarted = false;
            Object object2 = sdmMonitor;
            synchronized (object2) {
                if (--sdmCount == 0 && sdm != null) {
                    try {
                        sdm.terminate();
                    }
                    catch (Throwable t) {
                        mgrLogger.log(Level.WARNING, "Terminating SDM", t);
                    }
                    finally {
                        sdm = null;
                        lCache = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProvisionRequests(ServiceProvisionListener provListener) {
        ProvisionRequest[] requests;
        Object object = this.semMonitor;
        synchronized (object) {
            int actual = this.getActual();
            int pending = this.countPendingInstances();
            int missing = this.maintain - (actual + pending);
            int allocatedIds = this.getAllocatedIDs().length;
            if (missing <= 0 || !this.getActive() || allocatedIds == this.maintain) {
                if (mgrLogger.isLoggable(Level.FINEST)) {
                    mgrLogger.finest("Ignored dispatch provision request for [" + this.svcElement + "] - pending [" + pending + "] actual [" + actual + "] maintain [" + this.maintain + "] active [" + this.active + "] allocated-Ids [" + allocatedIds + "]");
                }
                return;
            }
            if (mgrLogger.isLoggable(Level.FINEST)) {
                mgrLogger.finest("Dispatch [" + missing + "] provision requests for [" + this.svcElement + "] - actual [" + actual + "], pending [" + pending + "], maintain [" + this.maintain + "], missing [" + missing + "], active [" + this.active + "] allocated-Ids [" + allocatedIds + "]");
            }
            requests = new ProvisionRequest[missing];
            ServiceElement serviceElement = this.svcElement;
            synchronized (serviceElement) {
                for (int i = 0; i < missing; ++i) {
                    long instanceID = this.getNextInstanceID();
                    ServiceElement newElem = ServiceElementUtil.prepareInstanceID(this.svcElement, instanceID);
                    requests[i] = new ProvisionRequest(newElem, this.listener, this.opStringMgr, this.instanceIDMgr, provListener, null);
                }
            }
        }
        this.doDispatchProvisionRequests(requests);
    }

    private int countPendingInstances() {
        int pending = this.provisioner.getPendingManager().getCount(this.svcElement);
        int inProcess = 0;
        if (pending > 0) {
            ServiceElement[] inProcessRequests;
            ServiceBeanInstance[] provisionedInstances = this.getServiceBeanInstances();
            for (ServiceElement svcElementRequest : inProcessRequests = this.provisioner.getPendingManager().getInProcessProvisionRequests()) {
                for (ServiceBeanInstance provisionedInstance : provisionedInstances) {
                    if (!svcElementRequest.getInstanceId().equals(provisionedInstance.getInstanceId()) || !svcElementRequest.getName().equals(provisionedInstance.getServiceBeanConfig().getName())) continue;
                    ++inProcess;
                    if (!mgrLogger.isLoggable(Level.FINEST)) continue;
                    mgrLogger.finest("Found in-process provision request for: [" + svcElementRequest + "] - pending [" + pending + "], in-process [" + inProcess + "]");
                }
            }
        }
        return pending - inProcess;
    }

    private void doDispatchProvisionRequests(ProvisionRequest[] requests) {
        if (!this.getActive()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Not managing, discarding requests: " + Arrays.toString(requests));
            }
            return;
        }
        if (this.shutdown) {
            return;
        }
        if (this.svcElement.getProvisionType() == 0) {
            return;
        }
        if (this.svcElement.getProvisionType() != 1) {
            return;
        }
        for (int i = 0; i < requests.length; ++i) {
            this.provisioner.dispatch(requests[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getActive() {
        Object object = this.semMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    public int getActual() {
        return this.fdhTable.countUniqueInstanceIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfNotAlreadyDiscovered(Object proxy) {
        Vector vector = this.services;
        synchronized (vector) {
            if (this.services.contains(proxy)) {
                return false;
            }
            this.services.add(proxy);
            return true;
        }
    }

    private void setFaultDetectionHandler(Object proxy, ServiceID serviceID, ServiceBeanInstance instance) {
        try {
            Uuid uuid;
            if (serviceID == null) {
                return;
            }
            if (proxy instanceof ReferentUuid && this.myUuid.equals((Object)(uuid = ((ReferentUuid)proxy).getReferentUuid()))) {
                return;
            }
            ClassLoader cl = proxy.getClass().getClassLoader();
            FaultDetectionHandler fdh = FaultDetectionHandlerFactory.getFaultDetectionHandler(this.svcElement, cl);
            if (!this.fdhTable.addUnique(serviceID, new FaultDetectionHandlerTable.FdhHolder(fdh, instance.getInstanceId()))) {
                return;
            }
            fdh.register(this.serviceFaultListener);
            fdh.monitor(proxy, serviceID, lCache);
            if (mgrLogger.isLoggable(Level.INFO)) {
                String action = this.getActive() ? "Managing" : "Monitoring";
                String fineDetails = "";
                if (mgrLogger.isLoggable(Level.FINE)) {
                    fineDetails = "ID: [" + serviceID + "]";
                }
                mgrLogger.info(action + " Service: [" + instance.getPresentationName() + "] at host: [" + instance.getHostAddress() + "] " + fineDetails);
            }
        }
        catch (Exception e) {
            mgrLogger.log(Level.SEVERE, "Failed setting the FaultDetectionHandler for [" + this.svcElement.getName() + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceBeanInstance[] getServiceBeanInstances() {
        ServiceBeanInstance[] instances = null;
        Object object = this.semMonitor;
        synchronized (object) {
            instances = this.serviceBeanList.toArray(new ServiceBeanInstance[this.serviceBeanList.size()]);
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getAllocatedIDs() {
        Object object = this.semMonitor;
        synchronized (object) {
            long[] ids = new long[this.instanceIDs.size()];
            int i = 0;
            Iterator<Long> it = this.instanceIDs.iterator();
            while (it.hasNext()) {
                ids[i++] = it.next();
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextInstanceID() {
        Object object = this.semMonitor;
        synchronized (object) {
            long[] allocatedIDs = this.getAllocatedIDs();
            long instanceID = ServiceElementUtil.getNextID(allocatedIDs);
            this.instanceIDs.add(new Long(instanceID));
            if (instanceID == 0L) {
                throw new IllegalStateException("next instanceID=0 ; allocatedIDs: " + Arrays.toString(allocatedIDs) + " instanceIDs: " + this.instanceIDs);
            }
            return instanceID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceBeanInstance cleanService(Object proxy, ServiceID serviceID, boolean removeInstanceID) {
        ServiceBeanInstance instance = null;
        try {
            Object object = this.semMonitor;
            synchronized (object) {
                ServiceBeanInstance[] instances = this.getServiceBeanInstances();
                for (int i = 0; i < instances.length; ++i) {
                    if (!instances[i].getService().equals(proxy)) continue;
                    instance = instances[i];
                    this.removeServiceBeanInstance(instance);
                    if (!removeInstanceID) break;
                    this.removeInstanceID(instance.getServiceBeanConfig().getInstanceID(), "clean");
                    break;
                }
            }
        }
        catch (Exception e) {
            mgrLogger.log(Level.WARNING, "Getting ServiceBeanInstance", e);
        }
        if (instance == null) {
            Object e = this.semMonitor;
            synchronized (e) {
                try {
                    for (ServiceBeanInstance sbi : this.decrementedServiceBeanList) {
                        if (!sbi.getService().equals(proxy)) continue;
                        instance = sbi;
                        break;
                    }
                }
                catch (Exception e2) {
                    mgrLogger.log(Level.WARNING, "Getting ServiceBeanInstance", e2);
                }
                if (instance != null) {
                    this.decrementedServiceBeanList.remove(instance);
                }
            }
        }
        if (instance != null) {
            if (mgrLogger.isLoggable(Level.FINEST)) {
                mgrLogger.finest("CLEAN SBI = " + instance.toString());
            }
            if (instance.getHostAddress() != null) {
                ServiceResource[] resources = this.provisioner.getServiceResourceSelector().getServiceResources(instance.getHostAddress(), true);
                for (int i = 0; i < resources.length; ++i) {
                    InstantiatorResource ir = (InstantiatorResource)resources[i].getResource();
                    ir.removeServiceElementInstance(this.svcElement, instance.getServiceBeanID());
                }
            } else {
                InstantiatorResource[] ir = this.provisioner.getServiceResourceSelector().getInstantiatorResources(this.svcElement);
                for (int i = 0; i < ir.length; ++i) {
                    ir[i].removeServiceElementInstance(this.svcElement, instance.getServiceBeanID());
                }
            }
        } else {
            mgrLogger.warning("No ServiceBeanInstance for service [" + this.svcElement.getName() + "], cannot remove from InstantiatorResource objects");
        }
        this.services.remove(proxy);
        this.removeFaultDetectionHandler(serviceID);
        if (mgrLogger.isLoggable(Level.FINEST)) {
            StringBuffer buff = new StringBuffer();
            buff.append("[" + this.svcElement.getOperationalStringName() + ":" + this.svcElement.getName() + "] ");
            mgrLogger.log(Level.FINEST, this.instanceIDLog(buff));
        }
        if (instance != null && this.provisioner.getPendingManager().getCount(this.svcElement) > 0) {
            this.provisioner.getPendingManager().process();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceBeanInstance createServiceBeanInstance(ServiceItem item) throws IOException {
        ServiceBeanInstance instance = null;
        Uuid uuid = UuidFactory.create((long)item.serviceID.getMostSignificantBits(), (long)item.serviceID.getLeastSignificantBits());
        ServiceBeanInstance[] instances = this.getServiceBeanInstances();
        for (int i = 0; i < instances.length; ++i) {
            if (!instances[i].getServiceBeanID().equals((Object)uuid)) continue;
            instance = instances[i];
            break;
        }
        if (instance == null) {
            ApplianceInfo ai;
            String hostAddress = null;
            String hostName = null;
            ServiceBeanConfig jsbConfig = null;
            if (item.service instanceof Administrable) {
                try {
                    Object admin = ((Administrable)item.service).getAdmin();
                    if (admin instanceof ServiceBeanAdmin) {
                        ServiceBeanAdmin jsbAdmin = (ServiceBeanAdmin)admin;
                        jsbConfig = jsbAdmin.getServiceElement().getServiceBeanConfig();
                    }
                }
                catch (Exception e) {
                    mgrLogger.log(Level.WARNING, "Getting ServiceBeanConfig for service [" + this.svcElement.getName() + "]", e);
                }
            }
            if ((ai = this.getApplianceInfo(item.attributeSets)) != null) {
                hostAddress = ai.hostAddress;
                hostName = ai.hostName;
            }
            if (this.svcElement.getProvisionType() == 0) {
                jsbConfig = this.svcElement.getServiceBeanConfig();
                if (sbiLogger.isLoggable(Level.FINEST)) {
                    sbiLogger.finest("ServiceElement [" + this.svcElement.getOperationalStringName() + ":" + this.svcElement.getName() + "] is an external service, create generic ServiceBeanInstance");
                }
            }
            if (jsbConfig == null) {
                InstantiatorResource[] resources = this.provisioner.getServiceResourceSelector().getInstantiatorResources(this.svcElement);
                block8: for (int i = 0; i < resources.length; ++i) {
                    ServiceRecord[] records;
                    block24: {
                        records = new ServiceRecord[]{};
                        try {
                            records = resources[i].getActiveServiceRecords();
                        }
                        catch (RemoteException e) {
                            if (!mgrLogger.isLoggable(Level.FINEST)) break block24;
                            mgrLogger.log(Level.FINEST, "Getting active ServiceRecords", e);
                        }
                    }
                    for (int j = 0; j < records.length; ++j) {
                        if (!uuid.equals((Object)records[j].getServiceID())) continue;
                        jsbConfig = records[j].getServiceElement().getServiceBeanConfig();
                        hostAddress = resources[i].getHostAddress();
                        hostName = resources[i].getHostName();
                        continue block8;
                    }
                }
                if (jsbConfig == null) {
                    if (sbiLogger.isLoggable(Level.FINEST)) {
                        sbiLogger.finest("ServiceBeanConfiguration cannot be obtained from [" + this.svcElement.getOperationalStringName() + ":" + this.svcElement.getName() + "], Proxy [" + item.service.getClass().getName() + "], Uuid " + uuid.toString());
                    }
                } else if (sbiLogger.isLoggable(Level.FINEST)) {
                    sbiLogger.finest("MATCHED\n\t[" + jsbConfig.getName() + "], [" + jsbConfig.getOperationalStringName() + "]\nTHIS\n\t[" + this.svcElement.getName() + "], [" + this.svcElement.getOperationalStringName() + "]");
                }
            }
            if (jsbConfig != null) {
                if (!this.isDifferenceServiceElement(jsbConfig)) {
                    Object object = this.semMonitor;
                    synchronized (object) {
                        if (!this.instanceIDs.contains(jsbConfig.getInstanceID())) {
                            this.instanceIDs.add(jsbConfig.getInstanceID());
                        }
                    }
                }
                instance = new ServiceBeanInstance(uuid, new MarshalledInstance(item.service), jsbConfig, hostAddress, hostName);
            }
        }
        return instance;
    }

    void importServiceBeanInstance(ServiceBeanInstance instance) throws IOException, ClassNotFoundException {
        Object proxy = instance.getService();
        this.addIfNotAlreadyDiscovered(proxy);
        this.addServiceBeanInstance(instance);
        Uuid uuid = instance.getServiceBeanID();
        ServiceID serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        this.setFaultDetectionHandler(proxy, serviceID, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExtraStatelessInstance(ServiceBeanInstance instance) {
        if (instance == null) {
            return;
        }
        if (this.isDifferenceServiceElement(instance.getServiceBeanConfig())) {
            return;
        }
        Object object = this.semMonitor;
        synchronized (object) {
            if (instance.getServiceBeanConfig().getInitParameters().get("pu.type").equals("STATELESS") || instance.getServiceBeanConfig().getInitParameters().get("pu.type").equals("MIRROR")) {
                ServiceBeanInstance extraSBI = null;
                for (ServiceBeanInstance sbi : this.serviceBeanList) {
                    if (!sbi.getInstanceId().equals(instance.getInstanceId()) || sbi.getServiceBeanID().equals((Object)instance.getServiceBeanID())) continue;
                    extraSBI = sbi;
                    break;
                }
                if (extraSBI != null) {
                    this.provisioner.handleExtraInstance(new ExtraStatelessInstanceHandler(this, instance, extraSBI));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addServiceBeanInstance(ServiceBeanInstance instance) {
        if (instance == null) {
            return;
        }
        if (this.isDifferenceServiceElement(instance.getServiceBeanConfig())) {
            return;
        }
        Object object = this.semMonitor;
        synchronized (object) {
            boolean changed = false;
            StringBuffer buff = new StringBuffer();
            buff.append("[" + this.svcElement.getOperationalStringName() + ":" + this.svcElement.getName() + "] ");
            if (!this.serviceBeanList.contains(instance)) {
                this.serviceBeanList.add(instance);
                Long instanceID = instance.getServiceBeanConfig().getInstanceID();
                if (!this.instanceIDs.contains(instanceID)) {
                    this.instanceIDs.add(instanceID);
                }
                changed = true;
                if (sbiLogger.isLoggable(Level.FINE)) {
                    buff.append(" Added SBI = " + instance.getServiceBeanConfig().getInstanceID() + ", " + instance.getServiceBeanID().toString() + "\n");
                }
            } else {
                Long iid;
                int ndx = this.serviceBeanList.indexOf(instance);
                ServiceBeanInstance current = this.serviceBeanList.get(ndx);
                if (current.getHostAddress() == null && instance.getHostAddress() != null) {
                    this.serviceBeanList.set(ndx, instance);
                    changed = true;
                    if (sbiLogger.isLoggable(Level.FINE)) {
                        buff.append("Adjusted SBI host address, was [null], now = " + instance.getHostAddress() + ", instanceID : " + instance.getServiceBeanConfig().getInstanceID() + "\n");
                    }
                }
                if (((iid = current.getServiceBeanConfig().getInstanceID()) == null || iid == 0L) && instance.getServiceBeanConfig().getInstanceID() != null) {
                    this.serviceBeanList.set(ndx, instance);
                    changed = true;
                    if (sbiLogger.isLoggable(Level.FINE)) {
                        buff.append("Adjusted SBI instanceID, was [null], now = " + instance.getServiceBeanConfig().getInstanceID() + "\n");
                    }
                }
            }
            if (changed && sbiLogger.isLoggable(Level.FINEST)) {
                sbiLogger.log(Level.FINEST, this.instanceIDLog(buff));
            }
        }
    }

    private boolean isDifferenceServiceElement(ServiceBeanConfig serviceBeanConfig) {
        if (!this.svcElement.getOperationalStringName().equals(serviceBeanConfig.getOperationalStringName())) {
            sbiLogger.log(Level.FINEST, "This OpString " + this.svcElement.getOperationalStringName() + " != " + serviceBeanConfig.getOperationalStringName());
            return true;
        }
        if (!this.svcElement.getName().equals(serviceBeanConfig.getName())) {
            sbiLogger.log(Level.FINEST, "This Name " + this.svcElement.getName() + " != " + serviceBeanConfig.getName());
            return true;
        }
        return false;
    }

    public void updatePlanOnServiceProvisionedEvent(int planned) {
        this.maintain = planned;
        this.svcElement.setPlanned(planned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceBeenList(ArrayList<ServiceBeanInstance> instances) {
        Object object = this.semMonitor;
        synchronized (object) {
            this.serviceBeanList.clear();
            this.serviceBeanList.addAll(instances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceBeanInstance getServiceBeanInstanceByProxy(Object proxy) throws IOException, ClassNotFoundException {
        Object object = this.semMonitor;
        synchronized (object) {
            ServiceBeanInstance[] instances = this.getServiceBeanInstances();
            for (int i = 0; i < instances.length; ++i) {
                if (!instances[i].getService().equals(proxy)) continue;
                return instances[i];
            }
        }
        return null;
    }

    protected InstantiatorResource getInstantiatorResourceByServiceBeanID(Uuid serviceBeanId) throws RemoteException {
        InstantiatorResource[] instantiatorResources;
        for (InstantiatorResource ir : instantiatorResources = this.provisioner.getServiceResourceSelector().getInstantiatorResources(this.svcElement)) {
            ServiceBeanInstance[] serviceBeanInstances;
            for (ServiceBeanInstance serviceBeanInstance : serviceBeanInstances = ir.getInstantiator().getServiceBeanInstances(this.svcElement)) {
                if (!serviceBeanInstance.getServiceBeanID().equals((Object)serviceBeanId)) continue;
                return ir;
            }
        }
        return null;
    }

    void processEvent(ProvisionMonitorEvent event) {
        try {
            this.eventPool.submit((Runnable)new ProvisionMonitorEventTask(this.eventHandler, event));
        }
        catch (Exception e) {
            mgrLogger.log(Level.WARNING, "Creating a ProvisionMonitorEventTask", e);
        }
    }

    void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    void setEventPool(FutureExecutorService monitorEventPool) {
        this.eventPool = monitorEventPool;
    }

    ApplianceInfo getApplianceInfo(Entry[] attrs) {
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof ApplianceInfo)) continue;
            return (ApplianceInfo)attrs[x];
        }
        return null;
    }

    String instanceIDLog(StringBuffer buff) {
        ServiceBeanInstance[] instances;
        long[] ids = this.getAllocatedIDs();
        if (ids.length > 0) {
            buff.append("     Instance ID list [");
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(ids[i]);
            }
            buff.append("]\n");
        }
        if ((instances = this.getServiceBeanInstances()).length == 0) {
            buff.append("     ServiceBeanInstance List: {empty}");
        } else {
            buff.append("     ServiceBeanInstance List:\n");
            for (int i = 0; i < instances.length; ++i) {
                if (i > 0) {
                    buff.append("\n");
                }
                buff.append("     " + instances[i].toString());
            }
        }
        return buff.toString();
    }

    int getMaxServiceCount() {
        SLA[] slas = this.svcElement.getServiceLevelAgreements().getServiceSLAs();
        int count = -1;
        for (int i = 0; i < slas.length; ++i) {
            String[] args = slas[i].getConfigArgs();
            for (int j = 0; j < args.length; ++j) {
                int x;
                if (args[j].indexOf("ScalingPolicyHandler") == -1 || (x = this.getSLAMaxServiceCount(args)) <= count) continue;
                count = x;
            }
        }
        return count;
    }

    int getSLAMaxServiceCount(String[] config) {
        int max = Integer.MAX_VALUE;
        for (int i = 0; i < config.length; ++i) {
            if (config[i].indexOf("ScalingPolicyHandler.MaxServices") == -1) continue;
            StringTokenizer tok = new StringTokenizer(config[i], " =");
            tok.nextToken();
            String value = tok.nextToken();
            try {
                max = Integer.parseInt(value);
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDispatch(ServiceElement sElem) {
        boolean result;
        Object object = this.semMonitor;
        synchronized (object) {
            int actual = this.getActual();
            int pending = this.countPendingInstances();
            int missing = this.maintain - (actual + pending);
            boolean active = this.getActive();
            boolean inFdhTable = this.fdhTable.containsInstanceID(sElem.getInstanceId());
            boolean bl = result = !inFdhTable && active && missing > 0;
            if (mgrLogger.isLoggable(Level.FINE)) {
                mgrLogger.fine((result ? "Allow " : "Deny ") + "dispatch provision request for: [" + sElem + "] - actual [" + actual + "], pending [" + pending + "], maintain [" + this.maintain + "], missing [" + missing + "], active [" + active + "], monitored [" + inFdhTable + "]");
            }
        }
        return result;
    }

    public boolean missingInstanceId(ServiceElement sElem) {
        boolean missing;
        boolean bl = missing = !this.fdhTable.containsInstanceID(sElem.getInstanceId());
        if (logger.isLoggable(Level.FINER)) {
            String message = "name:" + sElem.getName() + " fdhTable:" + this.fdhTable.toString();
            if (missing) {
                message = message + " debugName:" + sElem.getDebugName() + " is missing. fdhTable does not contain " + sElem.getInstanceId();
            }
            logger.finer(message);
        }
        return missing;
    }

    public Events getServiceFaultDetectionEvents(int cursor, int maxEvents) {
        return this.eventsStore.getEventsFromCursor(cursor, maxEvents);
    }

    static {
        logger = Logger.getLogger("com.gigaspaces.grid.gsm");
        mgrLogger = Logger.getLogger("com.gigaspaces.grid.gsm.services");
        sbiLogger = Logger.getLogger("com.gigaspaces.grid.gsm.service-instances");
    }

    class RelocationListener
    implements ServiceProvisionListener {
        ServiceProvisionListener remoteListener;
        ServiceBeanInstance original;

        RelocationListener(ServiceProvisionListener remoteListener, ServiceBeanInstance original) {
            this.remoteListener = remoteListener;
            this.original = original;
        }

        @Override
        public void succeeded(ServiceBeanInstance jsbInstance) throws RemoteException {
            block7: {
                try {
                    if (mgrLogger.isLoggable(Level.FINEST)) {
                        mgrLogger.finest("Invoking increment on " + ServiceElementManager.this.svcElement.getName() + " notification that ServiceElement has been provisioned successfully.");
                    }
                    ServiceElementManager.this.opStringMgr.increment(ServiceElementManager.this.svcElement, true, null, true);
                }
                catch (OperationalStringException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.log(Level.WARNING, "Failed to increment after succeeded relocation", e);
                }
            }
            if (this.remoteListener != null) {
                try {
                    this.remoteListener.succeeded(jsbInstance);
                }
                catch (Exception e) {
                    if (mgrLogger.isLoggable(Level.FINEST)) {
                        mgrLogger.log(Level.FINEST, "[" + ServiceElementManager.this.svcElement.getName() + "] Notifying ServiceProvisionListeners on success", e);
                    }
                    mgrLogger.log(Level.INFO, "[" + ServiceElementManager.this.svcElement.getName() + "] Notifying ServiceProvisionListeners on success");
                }
            }
        }

        @Override
        public void failed(ServiceElement sElem, boolean resubmitted) throws RemoteException {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block5: {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        try {
                            if (mgrLogger.isLoggable(Level.FINEST)) {
                                mgrLogger.finest("Invoking increment on " + ServiceElementManager.this.svcElement.getName() + " notification that ServiceElement has not been provisioned successfully.");
                            }
                            ServiceElementManager.this.opStringMgr.increment(ServiceElementManager.this.svcElement, true, null, true);
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.WARNING)) break block5;
                            logger.log(Level.WARNING, "Failed to increment after failed relocation", e);
                        }
                    }
                }
            });
            thread.start();
            if (this.remoteListener != null) {
                try {
                    this.remoteListener.failed(ServiceElementManager.this.svcElement, true);
                }
                catch (NoSuchObjectException e) {
                    mgrLogger.log(Level.WARNING, "ServiceBeanInstantiatorListener failure notification did not succeeded, [java.rmi.NoSuchObjectException:" + e.getLocalizedMessage() + "], remove ServiceBeanInstantiatorListener [" + this.remoteListener + "]");
                }
                catch (Exception e) {
                    mgrLogger.log(Level.WARNING, "ServiceBeanInstantiatorListener notification", e);
                }
            }
        }
    }

    class DecrementAndDispatchProvisionEventTask
    implements Runnable {
        private final ServiceBeanInstance instance;
        private final ServiceProvisionListener svcProvisionListener;
        private final Uuid requestedUuid;
        private final ServiceElement newElem;
        private final ServiceBeanInstance sbi;
        private final Uuid excludeUuid;

        public DecrementAndDispatchProvisionEventTask(ServiceBeanInstance instance, ServiceProvisionListener svcProvisionListener, Uuid requestedUuid, ServiceElement newElem, ServiceBeanInstance sbi, Uuid excludeUuid) {
            this.instance = instance;
            this.svcProvisionListener = svcProvisionListener;
            this.requestedUuid = requestedUuid;
            this.newElem = newElem;
            this.sbi = sbi;
            this.excludeUuid = excludeUuid;
        }

        @Override
        public void run() {
            try {
                ServiceElementManager.this.opStringMgr.decrement(this.instance, true, true, true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to relocate instance [" + this.instance + "]", e);
                try {
                    if (this.svcProvisionListener != null) {
                        this.svcProvisionListener.failed(this.newElem, false);
                    }
                }
                catch (RemoteException rex) {
                    logger.log(Level.WARNING, "Failed to notify listener on failed relocation of instance [" + this.instance + "]", rex);
                }
                return;
            }
            ProvisionRequest request = new ProvisionRequest(this.newElem, ServiceElementManager.this.listener, ServiceElementManager.this.opStringMgr, ServiceElementManager.this.instanceIDMgr, new RelocationListener(this.svcProvisionListener, this.instance), this.sbi, this.excludeUuid, this.requestedUuid, ProvisionRequest.RELOCATE);
            ServiceElementManager.this.doDispatchProvisionRequests(new ProvisionRequest[]{request});
        }
    }

    class ServiceFaultListener
    implements FaultDetectionListener,
    ServiceFaultDetectionMonitorIsAliveAware,
    ServiceFaultDetectionMonitorSuspectingFailureAware,
    ServiceFaultDetectionMonitorDetectedFailureAware,
    ServiceFaultDetectionUnhealthySpaceAware {
        ServiceFaultListener() {
        }

        @Override
        public boolean handleUnhealthy(Object proxy, ServiceID serviceID) {
            block4: {
                if (ServiceElementManager.this.shutdown || !ServiceElementManager.this.getActive()) {
                    return false;
                }
                if (!(proxy instanceof Administrable)) {
                    return false;
                }
                ServiceBeanInstance instance = ServiceElementManager.this.getServiceBeanInstance(UuidFactory.create((long)serviceID.getMostSignificantBits(), (long)serviceID.getLeastSignificantBits()));
                String serviceName = instance != null ? instance.getPresentationName() : ServiceElementUtil.getNameWithId(ServiceElementManager.this.svcElement);
                try {
                    mgrLogger.info("Forcefully destroy unhealthy service [" + serviceName + "]");
                    Administrable admin = (Administrable)proxy;
                    DestroyAdmin destroyAdmin = (DestroyAdmin)admin.getAdmin();
                    destroyAdmin.destroy();
                }
                catch (Exception e) {
                    if (!mgrLogger.isLoggable(Level.WARNING)) break block4;
                    mgrLogger.log(Level.WARNING, "Caught exception while trying to forcefully destroy unhealthy service: [" + serviceName + "]", e);
                }
            }
            return true;
        }

        @Override
        public void serviceFailure(Object proxy, ServiceID serviceID) {
            if (ServiceElementManager.this.shutdown) {
                return;
            }
            if (mgrLogger.isLoggable(Level.FINE)) {
                mgrLogger.fine("[" + ServiceElementUtil.getNameWithId(ServiceElementManager.this.svcElement) + "] service failure, proxy=[" + proxy.getClass().getName() + "], ID=[" + serviceID.toString() + "]");
            }
            boolean isActive = ServiceElementManager.this.getActive();
            ServiceBeanInstance instance = null;
            try {
                ServiceBeanConfig sbConfig;
                String serviceName;
                boolean shouldRemoveInstance = ServiceElementManager.this.svcElement.getProvisionType() == 1;
                instance = ServiceElementManager.this.cleanService(proxy, serviceID, shouldRemoveInstance);
                String string = serviceName = instance != null ? instance.getPresentationName() : ServiceElementUtil.getNameWithId(ServiceElementManager.this.svcElement);
                if (isActive) {
                    if (mgrLogger.isLoggable(Level.FINE)) {
                        mgrLogger.fine("Service: [" + serviceName + "] is no longer monitored by active GSM.");
                    }
                } else {
                    if (mgrLogger.isLoggable(Level.FINE)) {
                        mgrLogger.fine("Service: [" + serviceName + "] is no longer monitored by backup GSM.");
                    }
                    return;
                }
                String hostAddress = instance == null ? null : instance.getHostAddress();
                ProvisionRequest provRequest = this.getRedeploymentProvisionRequest(proxy);
                if (mgrLogger.isLoggable(Level.FINEST)) {
                    mgrLogger.finest("Redeployment ProvisionRequest for [" + ServiceElementManager.this.svcElement.getName() + "] obtained : " + (provRequest == null ? "no" : "yes"));
                }
                if (provRequest == null) {
                    ServiceElement newElem = ServiceElementUtil.copyServiceElement(ServiceElementManager.this.svcElement);
                    if (instance != null) {
                        newElem.setServiceBeanConfig(instance.getServiceBeanConfig());
                        if (mgrLogger.isLoggable(Level.FINE)) {
                            mgrLogger.fine("Detected failure of service [" + ServiceElementUtil.getNameWithId(newElem) + "]");
                        }
                    } else if (mgrLogger.isLoggable(Level.FINEST)) {
                        mgrLogger.finest("[" + ServiceElementManager.this.svcElement.getName() + "] instance not found, use default ServiceElement settings");
                    }
                    provRequest = new ProvisionRequest(newElem, ServiceElementManager.this.listener, ServiceElementManager.this.opStringMgr, ServiceElementManager.this.instanceIDMgr, null, instance);
                }
                if ((sbConfig = this.addHost(instance, hostAddress)) != null) {
                    provRequest.sElem.setServiceBeanConfig(sbConfig);
                }
                provRequest.sElem.setPlanned(ServiceElementManager.this.maintain);
                ServiceElementManager.this.doDispatchProvisionRequests(new ProvisionRequest[]{provRequest});
            }
            catch (Throwable t) {
                mgrLogger.log(Level.SEVERE, "Service Fault Detection", t);
            }
            ProvisionMonitorEvent event = new ProvisionMonitorEvent(ServiceElementManager.this.eventSource, 12, ServiceElementManager.this.svcElement.getOperationalStringName(), ServiceElementManager.this.svcElement, instance);
            ServiceElementManager.this.processEvent(event);
            ServiceChannel channel = ServiceChannel.getInstance();
            channel.broadcast(new ServiceChannel.ServiceChannelEvent(this, ServiceElementManager.this.svcElement, instance, 2));
        }

        ServiceBeanConfig addHost(ServiceBeanInstance instance, String host) {
            ServiceBeanConfig config = null;
            if (instance != null) {
                if (host == null) {
                    config = instance.getServiceBeanConfig();
                } else {
                    ServiceBeanConfig current = instance.getServiceBeanConfig();
                    Map configMap = current.getConfigurationParamaters();
                    Map initMap = current.getInitParameters();
                    List seenHosts = (List)configMap.get("hostList");
                    ArrayList<String> hosts = new ArrayList<String>(seenHosts);
                    boolean addHost = true;
                    if (hosts.size() > 0 && hosts.get(hosts.size() - 1).equals(host)) {
                        addHost = false;
                    }
                    if (addHost) {
                        hosts.add(host);
                    }
                    configMap.put("hostList", hosts);
                    config = new ServiceBeanConfig(configMap, current.getConfigArgs());
                    for (Map.Entry e : initMap.entrySet()) {
                        config.addInitParameter(e.getKey(), e.getValue());
                    }
                }
            }
            return config;
        }

        ProvisionRequest getRedeploymentProvisionRequest(Object service) {
            ProvisionRequest pr = null;
            ProvisionRequest[] prs = ServiceElementManager.this.redeployRequestList.toArray(new ProvisionRequest[ServiceElementManager.this.redeployRequestList.size()]);
            for (int i = 0; i < prs.length; ++i) {
                try {
                    if (prs[i].instance == null || !prs[i].instance.getService().equals(service)) continue;
                    pr = prs[i];
                    ServiceElementManager.this.redeployRequestList.remove(pr);
                    break;
                }
                catch (Exception e) {
                    mgrLogger.log(Level.WARNING, "Getting service for redeployment invocation", e);
                }
            }
            return pr;
        }

        @Override
        public void isAlive(ServiceID serviceID) {
            if (!ServiceElementManager.this.getActive()) {
                return;
            }
            ServiceFaultDetectionEvent event = new ServiceFaultDetectionEvent(serviceID, 0);
            ServiceElementManager.this.eventsStore.addEvent(event);
        }

        @Override
        public void suspectingFailure(ServiceID serviceID) {
            if (!ServiceElementManager.this.getActive()) {
                return;
            }
            ServiceFaultDetectionEvent event = new ServiceFaultDetectionEvent(serviceID, 1);
            ServiceElementManager.this.eventsStore.addEvent(event);
        }

        @Override
        public void detectedFailure(ServiceID serviceID) {
            if (!ServiceElementManager.this.getActive()) {
                return;
            }
            ServiceFaultDetectionEvent event = new ServiceFaultDetectionEvent(serviceID, 2);
            ServiceElementManager.this.eventsStore.addEvent(event);
        }
    }

    class ServiceElementManagerServiceListener
    extends ServiceDiscoveryAdapter {
        ServiceElementManagerServiceListener() {
        }

        @Override
        public void serviceAdded(ServiceDiscoveryEvent sdEvent) {
            try {
                ServiceItem item = sdEvent.getPostEventServiceItem();
                if (item.service == null) {
                    mgrLogger.log(Level.WARNING, "ServiceElementManager.serviceAdded(): item.service is NULL");
                    return;
                }
                item.service = ServiceElementManager.this.proxyPreparer.prepareProxy(item.service);
                ServiceBeanInstance sbi = ServiceElementManager.this.createServiceBeanInstance(item);
                if (sbi != null) {
                    if (ServiceElementManager.this.isDifferenceServiceElement(sbi.getServiceBeanConfig())) {
                        return;
                    }
                    if (mgrLogger.isLoggable(Level.FINE)) {
                        mgrLogger.fine("Adding instance: " + sbi.toString());
                    }
                } else {
                    if (mgrLogger.isLoggable(Level.FINER)) {
                        mgrLogger.log(Level.FINER, "Unresolved service - ServiceID [" + item.serviceID + "]; might be of a failed service.");
                    }
                    return;
                }
                ServiceElementManager.this.addServiceBeanInstance(sbi);
                if (ServiceElementManager.this.ambiguousServices.containsKey(item.service)) {
                    ServiceElementManager.this.ambiguousServices.remove(item.service);
                    if (mgrLogger.isLoggable(Level.FINER)) {
                        mgrLogger.log(Level.FINER, "Resolved ambiguous service [" + item.service.getClass().getName() + "]");
                    }
                    ServiceElementManager.this.setFaultDetectionHandler(item.service, item.serviceID, sbi);
                }
                if (ServiceElementManager.this.getActive()) {
                    if (ServiceElementManager.this.svcElement.getProvisionType() == 0) {
                        boolean added = ServiceElementManager.this.addIfNotAlreadyDiscovered(item.service);
                        if (!added) {
                            return;
                        }
                        ServiceElementManager.this.setFaultDetectionHandler(item.service, item.serviceID, sbi);
                    } else {
                        boolean added;
                        if (ServiceElementManager.this.provisioner.getPendingManager().removeServiceBeanInstance(sbi) && logger.isLoggable(Level.INFO)) {
                            logger.info("Discovered instance [" + sbi.getPresentationName() + "] is no longer pending to be provisioned.");
                        }
                        if (!(added = ServiceElementManager.this.addIfNotAlreadyDiscovered(item.service))) {
                            return;
                        }
                        ServiceElementManager.this.setFaultDetectionHandler(item.service, item.serviceID, sbi);
                    }
                } else {
                    boolean added = ServiceElementManager.this.addIfNotAlreadyDiscovered(item.service);
                    if (!added) {
                        return;
                    }
                    ServiceElementManager.this.setFaultDetectionHandler(item.service, item.serviceID, sbi);
                }
                if (!ServiceElementManager.this.DISABLE_HANDLING_EXTRA_STATELESS_INSTANCES) {
                    ServiceElementManager.this.handleExtraStatelessInstance(sbi);
                }
            }
            catch (Throwable t) {
                mgrLogger.log(Level.SEVERE, "Service discovery notification", t);
            }
        }
    }

    class ServiceChannelClient
    implements ServiceChannel.ServiceChannelListener {
        ServiceChannelClient() {
        }

        @Override
        public void notify(ServiceChannel.ServiceChannelEvent event) {
            if (ServiceElementManager.this.getActive() && event.getType() == 1 && ServiceElementManager.this.provisioner.getPendingManager().getCount(ServiceElementManager.this.svcElement) > 0) {
                ServiceElementManager.this.provisioner.getPendingManager().process();
            }
        }
    }

    class JSBProvisionListener
    implements ProvisionListener {
        final Logger provisionListenerLogger = Logger.getLogger("com.gigaspaces.grid.gsm.provision.events");

        JSBProvisionListener() {
        }

        @Override
        public void onProvisionLifeCycleEvent(ProvisionLifeCycleEvent event) {
            if (this.provisionListenerLogger.isLoggable(Level.FINE)) {
                this.provisionListenerLogger.fine(event.toString());
            }
            ServiceElementManager.this.eventsStore.addEvent(event);
        }

        @Override
        public void uninstantiable(ProvisionRequest request) {
            ServiceBeanConfig sbc = null;
            sbc = request.instance != null ? request.instance.getServiceBeanConfig() : request.sElem.getServiceBeanConfig();
            if (sbc != null) {
                ServiceElementManager.this.removeInstanceID(sbc.getInstanceID(), "uninstantiable");
            } else {
                mgrLogger.warning("Received uninstantiable service notification, getServiceBeanConfig property null");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceProvisioned(ServiceBeanInstance instance, InstantiatorResource resource) {
            Object proxy = null;
            try {
                ServiceID serviceID;
                Uuid uuid;
                proxy = instance.getService();
                proxy = ServiceElementManager.this.proxyPreparer.prepareProxy(proxy);
                ServiceElementManager.this.addIfNotAlreadyDiscovered(proxy);
                String hostAddress = instance.getHostAddress();
                if (hostAddress == null) {
                    hostAddress = resource.getHostAddress();
                    String hostName = resource.getHostName();
                    instance = new ServiceBeanInstance(instance.getServiceBeanID(), instance.getMarshalledInstance(), instance.getServiceBeanConfig(), hostAddress, hostName);
                }
                if (mgrLogger.isLoggable(Level.FINE)) {
                    mgrLogger.fine("[" + ServiceElementManager.this.svcElement.getOperationalStringName() + ":" + ServiceElementManager.this.svcElement.getName() + "] service provisioned, instance=" + instance.toString());
                }
                if (ServiceElementManager.this.hasServiceBeanInstance(instance)) {
                    ServiceElementManager.this.replaceServiceBeanInstance(instance);
                } else {
                    ServiceElementManager.this.addServiceBeanInstance(instance);
                }
                if (proxy instanceof MonitorableService) {
                    uuid = instance.getServiceBeanID();
                    serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                    ServiceElementManager.this.setFaultDetectionHandler(proxy, serviceID, instance);
                } else if (proxy instanceof ReferentUuid) {
                    uuid = ((ReferentUuid)proxy).getReferentUuid();
                    serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                    ServiceElementManager.this.setFaultDetectionHandler(proxy, serviceID, instance);
                } else {
                    if (mgrLogger.isLoggable(Level.FINER)) {
                        mgrLogger.log(Level.FINER, "Ambiguous service [" + proxy.getClass().getName() + "] provisioned to [" + hostAddress + "]");
                    }
                    ServiceElementManager.this.ambiguousServices.put(proxy, hostAddress);
                }
            }
            catch (Throwable t) {
                mgrLogger.log(Level.SEVERE, "Service provision notification", t);
            }
            ProvisionMonitorEvent event = new ProvisionMonitorEvent(ServiceElementManager.this.eventSource, 11, ServiceElementManager.this.svcElement.getOperationalStringName(), ServiceElementManager.this.svcElement, instance);
            ServiceElementManager.this.processEvent(event);
            ServiceChannel channel = ServiceChannel.getInstance();
            channel.broadcast(new ServiceChannel.ServiceChannelEvent(this, ServiceElementManager.this.svcElement, instance, 1));
            if (ServiceElementManager.this.shutdown) {
                Object object = ServiceElementManager.this.semMonitor;
                synchronized (object) {
                    boolean needToDestroyServiceInstance;
                    boolean bl = needToDestroyServiceInstance = proxy != null && ServiceElementManager.this.shutdown && ServiceElementManager.this.svcElement.getProvisionType() != 0;
                    if (needToDestroyServiceInstance) {
                        if (sbiLogger.isLoggable(Level.INFO)) {
                            sbiLogger.info("Destroying recently provisioned instance " + instance.getPresentationName() + " ID:" + instance.getServiceBeanID() + " since service has already shutdown.");
                        }
                        ServiceElementManager.this.destroyService(proxy, instance.getServiceBeanID(), true);
                    }
                }
            }
        }
    }
}

