/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.monitor.event.Event;

public class ServiceFaultDetectionEvent
implements Event {
    private static final long serialVersionUID = 1L;
    public static final int ALIVE = 0;
    public static final int SUSPECTING_FAILURE = 1;
    public static final int DETECTED_FAILURE = 2;
    private ServiceID serviceID;
    private int eventType;

    public ServiceFaultDetectionEvent() {
    }

    public ServiceFaultDetectionEvent(ServiceID serviceID, int eventType) {
        this.serviceID = serviceID;
        this.eventType = eventType;
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public boolean isAlive() {
        return this.eventType == 0;
    }

    public boolean isSuspectedFailure() {
        return this.eventType == 1;
    }

    public boolean isDetectedFailure() {
        return this.eventType == 2;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long mostSignificantBits = in.readLong();
        long leastSignificantBits = in.readLong();
        this.serviceID = new ServiceID(mostSignificantBits, leastSignificantBits);
        this.eventType = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.serviceID.getMostSignificantBits());
        out.writeLong(this.serviceID.getLeastSignificantBits());
        out.writeInt(this.eventType);
    }
}

