/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.SystemTimeFixedLeasePeriodPolicy;
import java.net.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.core.JSBInstantiationException;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceElementTracker;
import org.jini.rio.core.provision.ServiceBeanInstantiator;
import org.jini.rio.core.provision.ServiceProvisionEvent;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.core.util.ExceptionUtils;
import org.jini.rio.event.EventHandler;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.monitor.ExtraStatelessInstanceHandler;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.InternalEsmFinder;
import org.jini.rio.monitor.InternalOpStringManagerFinder;
import org.jini.rio.monitor.PendingServiceElementManager;
import org.jini.rio.monitor.ProvisionFailureEvent;
import org.jini.rio.monitor.ProvisionLifeCycleEvent;
import org.jini.rio.monitor.ProvisionRequest;
import org.jini.rio.monitor.RelativeWeightSelector;
import org.jini.rio.monitor.RequiredDependenciesValidator;
import org.jini.rio.monitor.ServiceResourceSelector;
import org.jini.rio.monitor.WeightedSelector;
import org.jini.rio.monitor.leader.ActiveProvisionMonitor;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.resource.ResourceUnavailableException;
import org.jini.rio.resources.resource.ThreadPool;
import org.jini.rio.resources.servicecore.LandlordLessor;
import org.jini.rio.resources.servicecore.LeaseListenerAdapter;
import org.jini.rio.resources.servicecore.ServiceResource;
import org.jini.rio.watch.StopWatch;

public class ServiceProvisioner {
    static final int PROVISION_FAILURE = 1;
    static final int UNINSTANTIABLE_JSB = 2;
    LandlordLessor landlord;
    int sequenceNumber = 0;
    Object eventSource;
    EventHandler failureHandler;
    ThreadPool provisioningPool;
    static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    static final int DEFAULT_MIN_THREADS = Math.max(8, AVAILABLE_PROCESSORS * 3 / 4);
    static final int DEFAULT_MAX_THREADS = Math.max(64, AVAILABLE_PROCESSORS);
    ThreadPool provisionFailurePool;
    List inProcess = Collections.synchronizedList(new ArrayList());
    StopWatch watch;
    PendingManager pendingMgr = new PendingManager();
    FixedServiceManager fixedServiceManager = new FixedServiceManager();
    ServiceResourceSelector selector;
    ProxyPreparer instantiatorPreparer;
    private final RequiredDependenciesValidator requiredDepenenciesValidator;
    private final ServiceID serviceID;
    long pendingRequestDelay;
    static final long DEFAULT_PENDING_REQUEST_DELAY = 60000L;
    static final long PENDING_DISPATCH_DELAY = Long.getLong("com.gs.grid.gsm.pending-dispatch-delay", (Long)1000L);
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm");
    static final Logger feedbackLogger = Logger.getLogger("com.gigaspaces.grid.gsm.feedback");
    static final Logger provisionLogger = Logger.getLogger("com.gigaspaces.grid.gsm.provision");
    private ScheduledExecutorService extraStatelessHandlerExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new GSThreadFactory("GS-ExtraStatelessHandler", true));

    ServiceProvisioner(Configuration config, InternalOpStringManagerFinder opStringManagerFinder, InternalEsmFinder esmFinder, ActiveProvisionMonitor activeProvisionMonitor) throws Exception {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        long ONE_MINUTE = 60000L;
        long DEFAULT_LEASE_TIME = ONE_MINUTE * 5L;
        long DEFAULT_MAX_LEASE_TIME = ONE_MINUTE * 60L * 24L;
        int provisioningPoolMinThreads = Config.getIntEntry((Configuration)config, (String)"org.jini.rio.monitor", (String)"provisioningPoolMinThreads", (int)Integer.getInteger("org.jini.rio.monitor.provisioningPoolMinThreads", DEFAULT_MIN_THREADS), (int)1, (int)500);
        int provisioningPoolMaxThreads = Config.getIntEntry((Configuration)config, (String)"org.jini.rio.monitor", (String)"provisioningPoolMaxThreads", (int)Integer.getInteger("org.jini.rio.monitor.provisioningPoolMaxThreads", DEFAULT_MAX_THREADS), (int)provisioningPoolMinThreads, (int)500);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Provisioning pool threads - Min: {0}, Max: {1}", new Object[]{new Integer(provisioningPoolMinThreads), new Integer(provisioningPoolMaxThreads)});
        }
        LeasePeriodPolicy provisionerLeasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry((Configuration)config, (String)"org.jini.rio.monitor", (String)"provisionerLeasePeriodPolicy", LeasePeriodPolicy.class, (Object)new SystemTimeFixedLeasePeriodPolicy(DEFAULT_MAX_LEASE_TIME, Long.getLong("com.gs.gsm.gscLeaseTime", DEFAULT_LEASE_TIME).longValue()));
        this.instantiatorPreparer = (ProxyPreparer)config.getEntry("org.jini.rio.monitor", "instantiatorPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        this.provisioningPool = new ThreadPool("ProvisionPool:" + System.currentTimeMillis(), provisioningPoolMinThreads, provisioningPoolMaxThreads);
        this.provisionFailurePool = new ThreadPool("ProvisionFailurePool:" + System.currentTimeMillis(), provisioningPoolMinThreads, provisioningPoolMaxThreads);
        this.landlord = new LandlordLessor(config, provisionerLeasePolicy);
        this.landlord.addLeaseListener(new LeaseMonitor());
        String serviceResourceSelectorClass = System.getProperty("org.jini.rio.monitor.serviceResourceSelector");
        if (serviceResourceSelectorClass != null) {
            this.selector = (ServiceResourceSelector)Class.forName(serviceResourceSelectorClass).newInstance();
            logger.info("Applying org.jini.rio.monitor.serviceResourceSelector=" + serviceResourceSelectorClass);
        } else {
            ServiceResourceSelector defaultSelector = activeProvisionMonitor.isActiveActive() ? new WeightedSelector() : new RelativeWeightSelector();
            this.selector = (ServiceResourceSelector)config.getEntry("org.jini.rio.monitor", "serviceResourceSelector", ServiceResourceSelector.class, (Object)defaultSelector);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "ServiceResourceSelector : " + this.selector.getClass().getName());
            }
        }
        this.selector.setLandlordLessor(this.landlord);
        this.pendingRequestDelay = Config.getLongEntry((Configuration)config, (String)"org.jini.rio.monitor", (String)"pendingRequestDelay", (long)Long.getLong("org.jini.rio.monitor.pendingRequestDelay", 60000L), (long)1000L, (long)Long.MAX_VALUE);
        this.requiredDepenenciesValidator = new RequiredDependenciesValidator(opStringManagerFinder, esmFinder);
        this.serviceID = opStringManagerFinder.getServiceID();
    }

    void terminate() {
        this.landlord.stop(true);
        this.provisioningPool.destroy();
        this.provisionFailurePool.destroy();
        if (this.extraStatelessHandlerExecutor != null) {
            this.extraStatelessHandlerExecutor.shutdown();
        }
    }

    ServiceResourceSelector getServiceResourceSelector() {
        return this.selector;
    }

    PendingManager getPendingManager() {
        return this.pendingMgr;
    }

    FixedServiceManager getFixedServiceManager() {
        return this.fixedServiceManager;
    }

    void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    void setProvisionFailureHandler(EventHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    void setWatch(StopWatch watch) {
        this.watch = watch;
    }

    EventRegistration register(ServiceBeanInstantiator instantiator, MarshalledObject handback, ResourceCapability resourceCapability, int serviceLimit, long duration, ServiceRecord[] serviceRecords) throws LeaseDeniedException, RemoteException {
        instantiator = (ServiceBeanInstantiator)this.instantiatorPreparer.prepareProxy((Object)instantiator);
        String name = null;
        try {
            name = instantiator.getName();
        }
        catch (Throwable t) {
            name = "GSC";
        }
        Uuid uuid = instantiator.getInstantiatorUuid();
        InstantiatorResource resource = new InstantiatorResource(instantiator, name, uuid, handback, resourceCapability, serviceLimit);
        resource.setServiceRecords(serviceRecords);
        ServiceResource serviceResource = new ServiceResource(resource);
        Lease lease = this.landlord.newLease(serviceResource, duration);
        GSEventRegistration registration = new GSEventRegistration(-5934673946890420068L, this.eventSource, lease, (long)this.sequenceNumber);
        if (logger.isLoggable(Level.INFO)) {
            int instantiatorCount = this.landlord.total();
            logger.log(Level.INFO, "Registered GSC - [" + resource + "], count [" + instantiatorCount + "]");
        }
        this.fixedServiceManager.process(serviceResource);
        this.pendingMgr.process(serviceResource);
        return registration;
    }

    void handleFeedback(ServiceBeanInstantiator resource, ResourceCapability updatedCapabilities, int serviceLimit, ServiceRecord[] serviceRecords) throws UnknownLeaseException, RemoteException {
        resource = (ServiceBeanInstantiator)this.instantiatorPreparer.prepareProxy((Object)resource);
        ServiceResource[] svcResources = this.selector.getServiceResources();
        if (svcResources.length == 0) {
            throw new UnknownLeaseException("Empty Collection, no leases");
        }
        for (int i = 0; i < svcResources.length; ++i) {
            InstantiatorResource ir = (InstantiatorResource)svcResources[i].getResource();
            if (feedbackLogger.isLoggable(Level.FINEST)) {
                feedbackLogger.log(Level.FINEST, "Update from [{0}:{1}] updatedCapabilities: {2}, serviceLimit {3}", new Object[]{ir.getHostAddress(), resource.toString(), updatedCapabilities, new Integer(serviceLimit)});
            }
            if (!ir.getInstantiator().equals(resource)) continue;
            if (!this.landlord.ensure(svcResources[i])) {
                throw new UnknownLeaseException("No matching Lease found");
            }
            ir.setResourceCapability(updatedCapabilities);
            ir.setServiceLimit(serviceLimit);
            ir.setServiceRecords(serviceRecords);
            this.fixedServiceManager.process(svcResources[i]);
            this.pendingMgr.process();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceResource acquireServiceResource(ProvisionRequest request) {
        ServiceResource resource = null;
        ServiceResourceSelector serviceResourceSelector = this.selector;
        synchronized (serviceResourceSelector) {
            try {
                if (request.requestedUuid != null) {
                    resource = this.selector.getServiceResource(request.sElem, request.requestedUuid, true);
                } else if (request.excludeUuid != null) {
                    resource = this.selector.getServiceResource(request.sElem, request.excludeUuid, false);
                } else if (request.excludedUuids != null && !request.excludedUuids.isEmpty()) {
                    resource = this.selector.getServiceResource(request.sElem, request.excludedUuids);
                    if (resource == null) {
                        request.delayNextAttempt(this.pendingRequestDelay);
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, "Provision attempt failed for [" + ServiceElementUtil.getNameWithId(request.sElem) + "] on all available resources. Next attempt delayed by [" + this.pendingRequestDelay + "ms] or until a new GSC becomes available.");
                        }
                    }
                } else {
                    resource = this.selector.getServiceResource(request.sElem);
                }
                if (resource != null) {
                    InstantiatorResource ir = (InstantiatorResource)resource.getResource();
                    ir.incrementProvisionCounter(request.sElem);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Getting ServiceResource", e);
            }
        }
        return resource;
    }

    void dispatch(ProvisionRequest request) {
        if (this.verifyDispatch(request)) {
            ServiceResource resource = this.acquireServiceResource(request);
            this.dispatch(request, resource, 0L);
        }
    }

    private boolean verifyDispatch(ProvisionRequest request) {
        try {
            if (request.type == ProvisionRequest.PROVISION && !request.opStringMgr.shouldDispatch(request.sElem)) {
                if (!request.opStringMgr.missingInstanceId(request.sElem)) {
                    boolean reProvision;
                    boolean bl = reProvision = !request.markedPending();
                    if (reProvision) {
                        String failureReason = "Pending decision to provision request for [" + request.sElem + "] - instance is still being monitored by fault-detector";
                        this.failedToProvision(request, 0L, failureReason, reProvision);
                    } else {
                        String failureReason = "Discarding provision request for [" + request.sElem + "] - instance is still being monitored by fault-detector";
                        this.failedToProvision(request, 0L, failureReason, reProvision);
                    }
                } else {
                    String failureReason = "Deny dispatch provision request for [" + request.sElem + "] - SLA already satisfied";
                    this.failedToProvision(request, 0L, failureReason, true);
                }
                return false;
            }
            Object[] unsatisfiedRequiredDependencies = this.requiredDepenenciesValidator.findUnsatisfiedRequiredDependencies(request.sElem);
            if (unsatisfiedRequiredDependencies.length > 0) {
                String failureReason = "Could not meet required dependencies of: [" + request.sElem + "] reasons: " + StringUtils.arrayToCommaDelimitedString((Object[])unsatisfiedRequiredDependencies);
                this.failedToProvision(request, 0L, failureReason, true);
                return false;
            }
        }
        catch (RemoteException re) {
            logger.log(Level.WARNING, "Verify dispatching provision request failed for [" + request.sElem + "]", re);
            return false;
        }
        return true;
    }

    private void dispatch(ProvisionRequest request, ServiceResource resource, long index) {
        try {
            if (resource != null) {
                this.inProcess.add(request.sElem);
                PoolableThread thread = (PoolableThread)this.provisioningPool.get();
                thread.execute((Runnable)new ProvisionTask(request, resource, index, this.pendingMgr, this.selector));
            } else {
                String failureReason = "A GSC could not be obtained to " + (request.type == ProvisionRequest.PROVISION ? "provision" : "relocate") + " [" + ServiceElementUtil.getNameWithId(request.sElem) + "], count [" + this.selector.getServiceResources().length + "]";
                this.failedToProvision(request, index, failureReason, true);
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Dispatching ProvisionRequest", t);
            this.processProvisionFailure(new ProvisionFailureEvent(this.eventSource, request.sElem, t.getClass().getName() + ":" + t.getLocalizedMessage(), t));
        }
    }

    private void failedToProvision(ProvisionRequest request, long index, String failureReason, boolean reprovision) {
        if (request.markedPending() && request.type == ProvisionRequest.PROVISION && reprovision) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, failureReason);
            }
            this.pendingMgr.addProvisionRequest(request, index);
            return;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, failureReason);
        }
        if (request.svcProvisionListener != null) {
            try {
                request.svcProvisionListener.failed(request.sElem, true);
            }
            catch (NoSuchObjectException e) {
                logger.log(Level.WARNING, "ServiceBeanInstantiatorListener failure notification did not succeed, [java.rmi.NoSuchObjectException:" + e.getLocalizedMessage() + "], remove ServiceBeanInstantiatorListener [" + request.svcProvisionListener + "]");
                request.svcProvisionListener = null;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "ServiceBeanInstantiatorListener notification", e);
            }
        }
        if (request.type == ProvisionRequest.PROVISION) {
            if (reprovision) {
                boolean added = this.pendingMgr.addProvisionRequest(request, index);
                if (added) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Pending allocation request for [" + ServiceElementUtil.getNameWithId(request.sElem) + "] until an available GSC is obtained, and all dependencies are met.");
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        this.pendingMgr.dumpCollection("ServiceProvisioner#failedToProvision():");
                    }
                    request.listener.onProvisionLifeCycleEvent(new ProvisionLifeCycleEvent(3).parse(request).parse(failureReason, reprovision));
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Reject re-provision request for [" + request.sElem + "]");
                }
            } else {
                request.listener.onProvisionLifeCycleEvent(new ProvisionLifeCycleEvent(2).parse(request).parse(failureReason, reprovision));
            }
        }
        this.processProvisionFailure(new ProvisionFailureEvent(this.eventSource, request.sElem, failureReason, null));
    }

    public PoolableThread execute(Runnable runnable) {
        PoolableThread thread;
        try {
            thread = (PoolableThread)this.provisioningPool.get();
            thread.execute(runnable);
        }
        catch (ResourceUnavailableException e) {
            return null;
        }
        return thread;
    }

    void processProvisionFailure(ProvisionFailureEvent event) {
        try {
            PoolableThread thread = (PoolableThread)this.provisionFailurePool.get();
            thread.execute((Runnable)new ProvisionFailureEventTask(event));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Creating a ProvisionFailureEventTask", e);
        }
    }

    public int getProvisionTasksCount(String serviceElementName) {
        int counter = 0;
        for (ProvisionTask task : this.provisioningPool.getAllocedOfType(ProvisionTask.class)) {
            if (!task.getServiceElementName().equals(serviceElementName)) continue;
            ++counter;
        }
        return counter;
    }

    public void handleExtraInstance(ExtraStatelessInstanceHandler handler) {
        this.extraStatelessHandlerExecutor.scheduleAtFixedRate(handler, 5L, 5L, TimeUnit.SECONDS);
    }

    class LeaseMonitor
    extends LeaseListenerAdapter {
        LeaseMonitor() {
        }

        @Override
        public void removed(LeasedResource resource) {
            InstantiatorResource ir = (InstantiatorResource)((ServiceResource)resource).getResource();
            int instantiatorCount = ServiceProvisioner.this.landlord.total();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Unregistered GSC - [" + ir + "], count [" + instantiatorCount + "]");
            }
        }
    }

    class ProvisionFailureEventTask
    implements Runnable {
        ProvisionFailureEvent event;

        ProvisionFailureEventTask(ProvisionFailureEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                ServiceProvisioner.this.failureHandler.fire(this.event);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception notifying ProvisionFailureEvent consumers", e);
            }
        }
    }

    class FixedServiceManager
    extends AbstractPendingServiceElementManager {
        List inProcessResource;

        FixedServiceManager() {
            super("Fixed-Service Manager");
            this.inProcessResource = Collections.synchronizedList(new ArrayList());
        }

        @Override
        void process() {
            ServiceResource[] resources = ServiceProvisioner.this.selector.getServiceResources();
            for (int i = 0; i < resources.length; ++i) {
                this.process(resources[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deploy(ProvisionRequest request) {
            try {
                ServiceResource[] resources;
                if (provisionLogger.isLoggable(Level.FINER)) {
                    provisionLogger.log(Level.FINER, "Deploy [" + ServiceElementUtil.getNameWithId(request.sElem) + "]");
                }
                if ((resources = ServiceProvisioner.this.selector.getServiceResources(request.sElem)).length > 0) {
                    ArrayList list = new ArrayList();
                    for (int i = 0; i < resources.length; ++i) {
                        try {
                            this.inProcessResource.add(resources[i]);
                            int n = this.doDeploy(resources[i], request, list);
                            continue;
                        }
                        finally {
                            this.inProcessResource.remove(resources[i]);
                        }
                    }
                    if (list.size() > 0) {
                        this.taskJoiner(list);
                    }
                }
            }
            catch (Throwable t) {
                provisionLogger.log(Level.WARNING, "FixedServiceManager deployNew", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void process(ServiceResource resource) {
            if (resource == null) {
                throw new NullPointerException("ServiceResource is null");
            }
            if (this.inProcessResource.contains(resource)) {
                return;
            }
            this.inProcessResource.add(resource);
            InstantiatorResource ir = (InstantiatorResource)resource.getResource();
            try {
                int fixedServiceSize = this.getSize();
                if (fixedServiceSize == 0) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    this.dumpCollection("FixedServiceManager#process():");
                }
                TreeMap treeMap = this.collection;
                synchronized (treeMap) {
                    ArrayList list = new ArrayList();
                    Set keys2 = this.collection.keySet();
                    Iterator it = keys2.iterator();
                    while (it.hasNext()) {
                        ProvisionRequest request = (ProvisionRequest)this.collection.get(it.next());
                        if (!ir.canProvision(request.sElem, null)) continue;
                        this.doDeploy(resource, request, list);
                    }
                    if (list.size() > 0) {
                        this.taskJoiner(list);
                    }
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Processing FixedService Collection", t);
            }
            finally {
                this.inProcessResource.remove(resource);
                ir.setDynamicEnabledOn();
            }
        }

        int doDeploy(ServiceResource resource, ProvisionRequest request, List list) throws Exception {
            return this.doDeploy(resource, request, list, true);
        }

        int doDeploy(ServiceResource resource, ProvisionRequest req, List list, boolean changeInstanceID) throws Exception {
            int numAllowed = this.getNumAllowed(resource, req);
            if (numAllowed > 0) {
                long currentID = req.sElem.getServiceBeanConfig().getInstanceID();
                for (int i = 0; i < numAllowed; ++i) {
                    ProvisionRequest request = ProvisionRequest.copy(req);
                    long nextID = changeInstanceID ? request.instanceIDMgr.getNextInstanceID() : currentID;
                    request.sElem = ServiceElementUtil.prepareInstanceID(request.sElem, true, nextID);
                    if (provisionLogger.isLoggable(Level.FINEST)) {
                        provisionLogger.finest("doDeploy " + numAllowed + " [" + req.sElem.getName() + "] instances; instanceID=" + request.sElem.getServiceBeanConfig().getInstanceID() + ", changeInstanceID=" + changeInstanceID);
                    }
                    ServiceProvisioner.this.inProcess.add(request.sElem);
                    PoolableThread thread = (PoolableThread)ServiceProvisioner.this.provisioningPool.get();
                    InstantiatorResource ir = (InstantiatorResource)resource.getResource();
                    ir.incrementProvisionCounter(request.sElem);
                    list.add(thread);
                    thread.execute((Runnable)new ProvisionTask(request, resource));
                }
                if (!changeInstanceID) {
                    Throwable t = new Throwable();
                    t.printStackTrace();
                }
            }
            return numAllowed;
        }

        int getNumAllowed(ServiceResource resource, ProvisionRequest request) {
            InstantiatorResource ir = (InstantiatorResource)resource.getResource();
            int planned = request.sElem.getPlanned();
            int actual = ir.getServiceElementInstances(request.sElem);
            int numAllowed = planned - actual;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Resource : " + ir.getName() + " planned = " + planned + " actual = " + actual + "numAllowed=planned-actual=" + numAllowed);
            }
            return numAllowed;
        }

        void taskJoiner(ArrayList list) {
            if (provisionLogger.isLoggable(Level.FINEST)) {
                provisionLogger.log(Level.FINEST, "Wait until all ProvisionTask threads are complete ...");
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    ((PoolableThread)it.next()).joinResource();
                }
                catch (InterruptedException ie) {
                    provisionLogger.log(Level.WARNING, "PoolableThread join interruption", ie);
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                provisionLogger.log(Level.FINEST, "ProvisionTask threads join complete");
            }
        }
    }

    class PendingManager
    extends AbstractPendingServiceElementManager {
        final ExecutorService executorService;

        PendingManager() {
            super("Dynamic-Service Manager");
            this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "GSM-PendingManagerTask");
                    t.setDaemon(true);
                    return t;
                }
            });
        }

        @Override
        void process() {
            this.process(null);
        }

        @Override
        void process(ServiceResource targetResource) {
            this.executorService.execute(new ProcessTask(targetResource));
        }

        private class ProcessTask
        implements Runnable {
            private final ServiceResource targetResource;

            public ProcessTask(ServiceResource targetResource) {
                this.targetResource = targetResource;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int pendingSize = PendingManager.this.getSize();
                if (pendingSize == 0) {
                    return;
                }
                if (PendingServiceElementManager.logger.isLoggable(Level.FINEST)) {
                    PendingManager.this.dumpCollection("ProcessTask#run:");
                }
                try {
                    PendingServiceElementManager.Key[] keys = null;
                    TreeMap treeMap = PendingManager.this.collection;
                    synchronized (treeMap) {
                        Set keySet = PendingManager.this.collection.keySet();
                        keys = keySet.toArray(new PendingServiceElementManager.Key[keySet.size()]);
                    }
                    for (int i = 0; i < keys.length; ++i) {
                        Thread.sleep(PENDING_DISPATCH_DELAY);
                        ProvisionRequest request = null;
                        TreeMap treeMap2 = PendingManager.this.collection;
                        synchronized (treeMap2) {
                            boolean timeToReProvision;
                            request = (ProvisionRequest)PendingManager.this.collection.get(keys[i]);
                            if (request == null || request.sElem == null) {
                                continue;
                            }
                            boolean bl = timeToReProvision = this.targetResource != null || request.isTimeToReProvision();
                            if (!timeToReProvision) {
                                if (PendingServiceElementManager.logger.isLoggable(Level.FINER)) {
                                    PendingServiceElementManager.logger.finer("Dispatch request for [" + request.sElem + "] is delayed by " + (request.delayTimestamp - System.currentTimeMillis()) + " ms");
                                }
                                continue;
                            }
                            request.resetNextAttempt();
                            PendingManager.this.collection.remove(keys[i]);
                        }
                        try {
                            if (PendingServiceElementManager.logger.isLoggable(Level.FINEST)) {
                                PendingServiceElementManager.logger.finest("Dispatching request for [" + request.sElem + "] ");
                            }
                            ServiceProvisioner.this.dispatch(request);
                            continue;
                        }
                        catch (Exception e) {
                            if (!PendingServiceElementManager.logger.isLoggable(Level.WARNING)) continue;
                            PendingServiceElementManager.logger.log(Level.WARNING, "Exception caught while dispatching pending request for service [" + request.sElem + "] - request discarded", e);
                        }
                    }
                }
                catch (Throwable t) {
                    PendingServiceElementManager.logger.log(Level.WARNING, "Exception caught while processing pending requests. Current pending [" + PendingManager.this.getSize() + "]", t);
                }
            }
        }
    }

    abstract class AbstractPendingServiceElementManager
    extends PendingServiceElementManager {
        AbstractPendingServiceElementManager(String type) {
            super(type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int getCount(ServiceElement sElem) {
            List list = ServiceProvisioner.this.inProcess;
            synchronized (list) {
                int count = super.getCount(sElem);
                return count + this.countInProcess(sElem);
            }
        }

        private int countInProcess(ServiceElement sElem) {
            int count = 0;
            Object[] array = ServiceProvisioner.this.inProcess.toArray();
            for (int i = 0; i < array.length; ++i) {
                ServiceElement s = (ServiceElement)array[i];
                if (!s.equals(sElem)) continue;
                ++count;
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        ServiceElement[] getInProcessProvisionRequests() {
            List list = ServiceProvisioner.this.inProcess;
            synchronized (list) {
                return ServiceProvisioner.this.inProcess.toArray(new ServiceElement[ServiceProvisioner.this.inProcess.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackServiceElement(ServiceElementTracker serviceElementTracker) {
            ServiceElement sElem = serviceElementTracker.getServiceElement();
            List list = ServiceProvisioner.this.inProcess;
            synchronized (list) {
                serviceElementTracker.setInProcessCount(this.countInProcess(sElem));
                serviceElementTracker.setPendingCount(super.getCount(sElem));
            }
        }
    }

    class ProvisionTask
    implements Runnable {
        ProvisionRequest request;
        ServiceResource svcResource;
        PendingServiceElementManager pendingMgr;
        long index;
        StopWatch stopWatch;
        ServiceBeanInstance jsbInstance = null;
        Throwable thrown = null;
        String failureReason = null;
        private final ServiceResourceSelector selector;

        ProvisionTask(ProvisionRequest request, ServiceResource svcResource) {
            this(request, svcResource, 0L, null, null);
        }

        ProvisionTask(ProvisionRequest request, ServiceResource svcResource, long index, PendingServiceElementManager pendingMgr, ServiceResourceSelector selector) {
            this.request = request;
            this.svcResource = svcResource;
            this.index = index;
            this.pendingMgr = pendingMgr;
            this.selector = selector;
        }

        String getServiceElementName() {
            return this.request.sElem.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block32: {
                try {
                    this.jsbInstance = null;
                    this.thrown = null;
                    this.stopWatch = new StopWatch(ServiceProvisioner.this.watch.getWatchDataSource(), ServiceProvisioner.this.watch.getId());
                    int result = this.doProvision(this.request, this.svcResource);
                    if ((result & 1) != 0) {
                        boolean resubmitted = true;
                        provisionLogger.log(Level.SEVERE, "Provision attempt failed for [" + ServiceElementUtil.getNameWithId(this.request.sElem) + "] on [" + this.svcResource.getResource() + "]");
                        if ((result & 2) != 0) {
                            resubmitted = false;
                            provisionLogger.log(Level.SEVERE, "Service [" + ServiceElementUtil.getNameWithId(this.request.sElem) + "] is un-instantiable, do not resubmit");
                            this.request.listener.uninstantiable(this.request);
                            this.request.listener.onProvisionLifeCycleEvent(new ProvisionLifeCycleEvent(2).parse(this.request).parse((InstantiatorResource)this.svcResource.getResource()).parse(this.failureReason, resubmitted));
                        } else if (this.pendingMgr != null) {
                            Uuid toExclude;
                            if (this.request.type == ProvisionRequest.PROVISION) {
                                toExclude = ((InstantiatorResource)this.svcResource.getResource()).getInstantiatorUuid();
                                this.request.excludeUuid(toExclude);
                                resubmitted = this.pendingMgr.addProvisionRequest(this.request, this.index);
                                if (resubmitted) {
                                    provisionLogger.log(Level.INFO, "Re-submitted failed allocation of [" + ServiceElementUtil.getNameWithId(this.request.sElem) + "]");
                                } else if (this.pendingMgr.isUndeployed(this.request)) {
                                    provisionLogger.log(Level.INFO, this.request.sElem.getOperationalStringName() + " has been un-deployed; Ignoring allocation of [" + ServiceElementUtil.getNameWithId(this.request.sElem) + "]");
                                } else {
                                    provisionLogger.info(ServiceElementUtil.getNameWithId(this.request.sElem) + " is already pending allocation");
                                }
                            } else if (this.request.type == ProvisionRequest.RELOCATE) {
                                toExclude = ((InstantiatorResource)this.svcResource.getResource()).getInstantiatorUuid();
                                ProvisionRequest newRequest = new ProvisionRequest(this.request.sElem, this.request.listener, this.request.opStringMgr, this.request.instanceIDMgr, null, this.request.instance, toExclude, null, ProvisionRequest.PROVISION);
                                resubmitted = this.pendingMgr.addProvisionRequest(newRequest, this.index);
                                if (resubmitted) {
                                    provisionLogger.log(Level.INFO, "Re-submitted failed relocation of [" + ServiceElementUtil.getNameWithId(this.request.sElem) + "]");
                                } else if (this.pendingMgr.isUndeployed(this.request)) {
                                    provisionLogger.log(Level.INFO, this.request.sElem.getOperationalStringName() + " has been undeployed; Ignoring relocation of [" + ServiceElementUtil.getNameWithId(this.request.sElem) + "]");
                                } else {
                                    provisionLogger.info(ServiceElementUtil.getNameWithId(this.request.sElem) + " is already pending allocation");
                                }
                            }
                        }
                        if (this.thrown != null || result != 0) {
                            this.request.listener.onProvisionLifeCycleEvent(new ProvisionLifeCycleEvent(2).parse(this.request).parse((InstantiatorResource)this.svcResource.getResource()).parse(this.failureReason, resubmitted));
                            if (resubmitted) {
                                this.request.listener.onProvisionLifeCycleEvent(new ProvisionLifeCycleEvent(3).parse(this.request).parse((InstantiatorResource)this.svcResource.getResource()).parse(this.failureReason, resubmitted));
                            }
                            ServiceProvisioner.this.processProvisionFailure(new ProvisionFailureEvent(ServiceProvisioner.this.eventSource, this.request.sElem, this.failureReason, this.thrown));
                        }
                        if (this.request.svcProvisionListener == null) break block32;
                        try {
                            this.request.svcProvisionListener.failed(this.request.sElem, resubmitted);
                        }
                        catch (Exception e) {
                            Throwable t = e;
                            if (e.getCause() != null) {
                                t = e.getCause();
                            }
                            if (provisionLogger.isLoggable(Level.FINEST)) {
                                provisionLogger.log(Level.FINEST, "Notifying ServiceProvisionListeners on failure", t);
                                break block32;
                            }
                            provisionLogger.log(Level.INFO, "Error Notifying ServiceProvisionListeners on failure [" + t.getClass().getName() + ":" + t.getLocalizedMessage() + "]");
                        }
                        break block32;
                    }
                    if (this.jsbInstance == null) {
                        this.request.listener.onProvisionLifeCycleEvent(new ProvisionLifeCycleEvent(2).parse(this.request).parse((InstantiatorResource)this.svcResource.getResource()).parse("service limit has been met", false));
                        if (provisionLogger.isLoggable(Level.INFO)) {
                            String addr = ((InstantiatorResource)this.svcResource.getResource()).getHostAddress();
                            String name = ((InstantiatorResource)this.svcResource.getResource()).getName();
                            provisionLogger.log(Level.INFO, name + " at [" + addr + "] did not allocate [" + ServiceElementUtil.getNameWithId(this.request.sElem) + "], service limit assumed to have been met");
                        }
                        return;
                    }
                    this.request.listener.serviceProvisioned(this.jsbInstance, (InstantiatorResource)this.svcResource.getResource());
                    this.request.listener.onProvisionLifeCycleEvent(new ProvisionLifeCycleEvent(1).parse(this.request).parse((InstantiatorResource)this.svcResource.getResource()).parse(this.jsbInstance));
                    if (this.request.svcProvisionListener != null) {
                        try {
                            this.request.svcProvisionListener.succeeded(this.jsbInstance);
                        }
                        catch (Exception e) {
                            if (provisionLogger.isLoggable(Level.FINEST)) {
                                provisionLogger.log(Level.FINEST, "Notifying ServiceProvisionListeners on success", e);
                            }
                            Throwable t = e;
                            if (e.getCause() != null) {
                                t = e.getCause();
                            }
                            provisionLogger.log(Level.INFO, "Error Notifying ServiceProvisionListeners on success [" + t.getClass().getName() + ":" + t.getLocalizedMessage() + "]");
                        }
                    }
                    this.pendingMgr.process();
                }
                finally {
                    this.removeInProcessSvcElementByInstanceId();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeInProcessSvcElementByInstanceId() {
            List list = ServiceProvisioner.this.inProcess;
            synchronized (list) {
                Iterator iterator = ServiceProvisioner.this.inProcess.iterator();
                while (iterator.hasNext()) {
                    ServiceElement svcElement = (ServiceElement)iterator.next();
                    if (!svcElement.equals(this.request.sElem) || !svcElement.getInstanceId().equals(this.request.sElem.getInstanceId())) continue;
                    iterator.remove();
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int doProvision(ProvisionRequest request, ServiceResource serviceResource) {
            int result = 0;
            InstantiatorResource ir = (InstantiatorResource)serviceResource.getResource();
            try {
                this.selector.delayBackupIfPrimaryInProcess(request.sElem);
                ServiceProvisionEvent event = new ServiceProvisionEvent(ServiceProvisioner.this.eventSource, request.opStringMgr, request.sElem);
                event.setSequenceNumber(ServiceProvisioner.this.sequenceNumber);
                event.setHandback(ir.getHandback());
                try {
                    int numProvisionRetries = 2;
                    for (int i = 0; i < numProvisionRetries; ++i) {
                        request.listener.onProvisionLifeCycleEvent(new ProvisionLifeCycleEvent(0).parse(request).parse(ir));
                        if (provisionLogger.isLoggable(Level.INFO)) {
                            String retry = i == 0 ? "" : ", retry [" + i + "] ";
                            String requestInfo = "";
                            if (provisionLogger.isLoggable(Level.FINER)) {
                                requestInfo = "Request {type=" + (request.type == ProvisionRequest.PROVISION ? "provision" : "relocate") + ", pending=" + request.markedPending() + "}";
                            }
                            provisionLogger.log(Level.INFO, "Attempting to allocate processing unit instance [" + ServiceElementUtil.getNameWithId(request.sElem) + "] on [" + ir.toString() + "] " + retry + requestInfo);
                        }
                        this.stopWatch.startTiming();
                        this.jsbInstance = ir.getInstantiator().instantiate(event);
                        if (this.jsbInstance != null) {
                            ir.addServiceElementInstance(request.sElem, this.jsbInstance.getServiceBeanID());
                            ++ServiceProvisioner.this.sequenceNumber;
                            if (provisionLogger.isLoggable(Level.INFO)) {
                                provisionLogger.log(Level.INFO, "Allocated processing unit instance [" + ServiceElementUtil.getNameWithId(request.sElem) + "] on [" + ir.toString() + "]");
                            }
                            if (provisionLogger.isLoggable(Level.FINEST)) {
                                provisionLogger.log(Level.FINEST, "{0} ServiceBeanInstance {1}, Annotation {2}", new Object[]{request.sElem.getName(), this.jsbInstance, RMIClassLoader.getClassAnnotation(this.jsbInstance.getService().getClass())});
                            }
                            break;
                        }
                        if (provisionLogger.isLoggable(Level.FINER)) {
                            provisionLogger.log(Level.FINER, ir.getName() + " at [" + ir.getHostAddress() + "] did not allocate [" + ServiceElementUtil.getNameWithId(request.sElem) + "], retry ...");
                        }
                        long retryWait = 1000L;
                        try {
                            Thread.sleep(retryWait);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            if (!logger.isLoggable(Level.FINEST)) continue;
                            logger.log(Level.FINEST, "Interrupted while sleeping [" + retryWait + "] millisfor provision retry", ie);
                        }
                    }
                }
                catch (UnknownEventException e) {
                    result = 1;
                    this.failureReason = ExceptionUtils.getNestedFailureReasons(e);
                    logger.log(Level.SEVERE, "Failed to provision service [" + request.sElem + "] on [" + ir + "],\n\tGSC reported: " + this.failureReason, e);
                    this.thrown = e;
                    this.selector.dropServiceResource(serviceResource);
                }
                catch (RemoteException e) {
                    result = 1;
                    this.failureReason = ExceptionUtils.getNestedFailureReasons(e);
                    provisionLogger.log(Level.WARNING, "Failed to provision service [" + request.sElem + "] on [" + ir + "],\n\tGSC reported: " + this.failureReason, e);
                    this.thrown = e;
                    int category = ThrowableConstants.retryable((Throwable)e);
                    if (category == 1 || category == 2 || e.detail != null && e.detail instanceof ConnectException) {
                        if (provisionLogger.isLoggable(Level.FINER)) {
                            provisionLogger.log(Level.FINER, "Drop {0} {1} from collection", new Object[]{ir.getName(), ir.getInstantiator()});
                        }
                        this.selector.dropServiceResource(serviceResource);
                    }
                    try {
                        provisionLogger.info("Forcefully destroy service [" + request.sElem + "] after provision failure: " + e);
                        ir.getInstantiator().destroy(event);
                    }
                    catch (Exception ignore) {
                        this.failureReason = ExceptionUtils.getNestedFailureReasons(ignore);
                        logger.log(Level.WARNING, "Unable to destroy failed service [" + request.sElem + "] on [" + ir + "],\n\tGSC reported: " + this.failureReason, ignore);
                    }
                }
                catch (JSBInstantiationException e) {
                    result = e.isUninstantiable() ? 3 : 1;
                    this.failureReason = ExceptionUtils.getNestedFailureReasons(e);
                    this.thrown = e;
                    if (provisionLogger.isLoggable(Level.FINEST)) {
                        provisionLogger.log(Level.SEVERE, "Failed to instantiate service [" + request.sElem + "] on [" + ir + "],\n\tGSC reported:: " + this.failureReason, e);
                    } else if (provisionLogger.isLoggable(Level.SEVERE)) {
                        provisionLogger.log(Level.SEVERE, "Failed to instantiate service [" + request.sElem + "] on [" + ir + "],\n\tGSC reported: " + this.failureReason);
                    }
                }
                catch (Throwable t) {
                    this.failureReason = ExceptionUtils.getNestedFailureReasons(t);
                    logger.log(Level.WARNING, "Failed to provision service [" + request.sElem + "] on [" + ir + "],\n\tGSC reported: " + this.failureReason, t);
                    result = 3;
                    this.thrown = t;
                }
            }
            finally {
                ir.decrementProvisionCounter(request.sElem);
                this.stopWatch.stopTiming();
            }
            return result;
        }
    }
}

