/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.j_spaces.kernel.TimeUnitProperty;
import com.sun.jini.landlord.LeasedResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.resources.servicecore.LandlordLessor;
import org.jini.rio.resources.servicecore.LeaseListener;
import org.jini.rio.resources.servicecore.ServiceResource;

public abstract class ServiceResourceSelector
implements LeaseListener {
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.provision");
    static final int numberOfBackupRetries;
    protected Collection collection;
    protected LandlordLessor landlord;

    public void setLandlordLessor(LandlordLessor landlord) {
        this.landlord = landlord;
        landlord.addLeaseListener(this);
    }

    public ServiceResource getServiceResource(ServiceElement sElem) throws Exception {
        ServiceResource[] svcResources = this.getServiceResources();
        return this.selectServiceResource(sElem, svcResources);
    }

    public ServiceResource getServiceResource(ServiceElement sElem, Uuid uuid, boolean inclusive) throws Exception {
        return this.selectServiceResource(sElem, this.getServiceResources(uuid, inclusive));
    }

    public ServiceResource getServiceResource(ServiceElement sElem, Set<Uuid> excludedUuids) throws Exception {
        return this.selectServiceResource(sElem, this.getServiceResources(excludedUuids));
    }

    private ServiceResource[] getServiceResources(Set<Uuid> excludedUuids) {
        ServiceResource[] serviceResources;
        ArrayList<ServiceResource> list = new ArrayList<ServiceResource>();
        for (ServiceResource serviceResource : serviceResources = this.getServiceResources()) {
            Uuid serviceUuid = ((InstantiatorResource)serviceResource.getResource()).getInstantiatorUuid();
            if (excludedUuids.contains(serviceUuid)) continue;
            list.add(serviceResource);
        }
        ServiceResource[] resources = list.toArray(new ServiceResource[list.size()]);
        return resources;
    }

    private ServiceResource selectServiceResource(ServiceElement sElem, ServiceResource[] svcResources) throws Exception {
        for (int i = 0; i < svcResources.length; ++i) {
            InstantiatorResource ir = (InstantiatorResource)svcResources[i].getResource();
            int serviceLimit = ir.getServiceLimit();
            int total = ir.getServiceElementCount() + ir.getInProcessCounter();
            if (total >= serviceLimit) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "GSC - [" + ir + "] has reached service limit of [" + serviceLimit + "], cannot be used to instantiate [" + sElem.getName() + "]");
                continue;
            }
            int planned = sElem.getPlanned();
            int actual = ir.getServiceElementInstances(sElem);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "GSC - [" + ir + "] has [" + actual + "] instance(s), planned [" + planned + "] of [" + sElem.getName() + "]");
            }
            if (actual >= planned) continue;
            if (ir.getDynamicEnabled()) {
                if (!ir.canProvision(sElem, this.getInstantiatorResources())) continue;
                this.serviceResourceSelected(svcResources[i]);
                return svcResources[i];
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("GSC - [" + ir + "] dynamic enabled: " + ir.getDynamicEnabled());
        }
        return null;
    }

    void delayBackupIfPrimaryInProcess(ServiceElement sElem) {
        ServiceResource serviceResource;
        InstantiatorResource instantiatorResource;
        if (sElem.isProbPrimary()) {
            return;
        }
        int numberOfBackups = (Integer)sElem.getServiceBeanConfig().getInitParameters().get("numberOfBackups");
        if (numberOfBackups == 0) {
            return;
        }
        ServiceResource[] serviceResources = this.getServiceResources();
        InstantiatorResource instantiatorResourceWithServiceInProcess = null;
        ServiceResource[] serviceResourceArray = serviceResources;
        int n = serviceResourceArray.length;
        block2: for (int i = 0; i < n && (instantiatorResource = (InstantiatorResource)(serviceResource = serviceResourceArray[i]).getResource()).getServiceElementInstances(sElem) <= 0; ++i) {
            ServiceElement[] serviceElementsInprocess;
            for (ServiceElement inprocess : serviceElementsInprocess = instantiatorResource.getServiceElementsInprocess()) {
                if (!sElem.equals(inprocess) || sElem.getInstanceId().equals(inprocess.getInstanceId())) continue;
                instantiatorResourceWithServiceInProcess = instantiatorResource;
                continue block2;
            }
        }
        if (instantiatorResourceWithServiceInProcess != null) {
            for (int i = 0; i < numberOfBackupRetries && instantiatorResourceWithServiceInProcess.getInProcessCounter(sElem) > 0; ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public abstract void serviceResourceSelected(ServiceResource var1);

    public ServiceResource[] getServiceResources(ServiceElement sElem) throws Exception {
        ServiceResource[] svcResources = this.getServiceResources();
        ArrayList<ServiceResource> list = new ArrayList<ServiceResource>();
        for (int i = 0; i < svcResources.length; ++i) {
            InstantiatorResource ir = (InstantiatorResource)svcResources[i].getResource();
            if (!ir.canProvision(sElem, this.getInstantiatorResources())) continue;
            list.add(svcResources[i]);
        }
        ServiceResource[] resources = list.toArray(new ServiceResource[list.size()]);
        return resources;
    }

    ServiceResource[] getServiceResources(Uuid uuid, boolean inclusive) {
        ServiceResource[] svcResources = this.getServiceResources();
        ArrayList<ServiceResource> list = new ArrayList<ServiceResource>();
        for (int i = 0; i < svcResources.length; ++i) {
            InstantiatorResource ir = (InstantiatorResource)svcResources[i].getResource();
            if (ir.getInstantiatorUuid().equals((Object)uuid)) {
                if (!inclusive) continue;
                list.add(svcResources[i]);
                continue;
            }
            if (inclusive) continue;
            list.add(svcResources[i]);
        }
        ServiceResource[] resources = list.toArray(new ServiceResource[list.size()]);
        return resources;
    }

    ServiceResource[] getServiceResources(String hostAddress, boolean inclusive) {
        ServiceResource[] svcResources = this.getServiceResources();
        ArrayList<ServiceResource> list = new ArrayList<ServiceResource>();
        for (int i = 0; i < svcResources.length; ++i) {
            InstantiatorResource ir = (InstantiatorResource)svcResources[i].getResource();
            if (ir.getHostAddress().equals(hostAddress)) {
                if (!inclusive) continue;
                list.add(svcResources[i]);
                continue;
            }
            if (inclusive) continue;
            list.add(svcResources[i]);
        }
        ServiceResource[] resources = list.toArray(new ServiceResource[list.size()]);
        return resources;
    }

    void dropServiceResource(ServiceResource resource) {
        this.remove(resource);
        try {
            this.landlord.cancel(resource.getCookie());
        }
        catch (Exception ignore) {
            logger.log(Level.WARNING, "Failed to cancel lease [" + resource.lease + "]", ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceResource[] getServiceResources() {
        ServiceResource[] svcResources = null;
        Collection collection = this.collection;
        synchronized (collection) {
            svcResources = this.collection.toArray(new ServiceResource[this.collection.size()]);
        }
        return svcResources;
    }

    @Override
    public void expired(LeasedResource resource) {
        if (resource != null) {
            this.remove(resource);
        }
    }

    @Override
    public void removed(LeasedResource resource) {
        if (resource != null) {
            this.remove(resource);
        }
    }

    @Override
    public void register(LeasedResource resource) {
        this.add(resource);
    }

    @Override
    public void renewed(LeasedResource resource) {
        this.update(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(LeasedResource resource) {
        try {
            Collection collection = this.collection;
            synchronized (collection) {
                this.collection.add(resource);
            }
        }
        catch (UnsupportedOperationException uoe) {
            logger.log(Level.WARNING, "Adding LeasedResource Failed", uoe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(LeasedResource resource) {
        try {
            Collection collection = this.collection;
            synchronized (collection) {
                if (resource != null) {
                    this.collection.remove(resource);
                }
            }
        }
        catch (UnsupportedOperationException uoe) {
            logger.log(Level.WARNING, "Removing LeasedResource Failed", uoe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(LeasedResource resource) {
        try {
            Collection collection = this.collection;
            synchronized (collection) {
                this.collection.add(resource);
            }
        }
        catch (UnsupportedOperationException uoe) {
            logger.log(Level.WARNING, "Updating LeasedResource Failed", uoe);
        }
    }

    InstantiatorResource[] getInstantiatorResources() {
        ServiceResource[] svcResources = this.getServiceResources();
        ArrayList<InstantiatorResource> list = new ArrayList<InstantiatorResource>();
        for (int i = 0; i < svcResources.length; ++i) {
            InstantiatorResource ir = (InstantiatorResource)svcResources[i].getResource();
            list.add(ir);
        }
        InstantiatorResource[] resources = list.toArray(new InstantiatorResource[list.size()]);
        return resources;
    }

    InstantiatorResource[] getInstantiatorResources(ServiceElement sElem) {
        ServiceResource[] svcResources = this.getServiceResources();
        ArrayList<InstantiatorResource> list = new ArrayList<InstantiatorResource>();
        for (int i = 0; i < svcResources.length; ++i) {
            InstantiatorResource ir = (InstantiatorResource)svcResources[i].getResource();
            if (ir.getServiceElementInstances(sElem) <= 0) continue;
            list.add(ir);
        }
        InstantiatorResource[] resources = list.toArray(new InstantiatorResource[list.size()]);
        return resources;
    }

    static {
        String millisToWaitS = System.getProperty("com.gs.grid.gsm.provision.maxBackupDelay", "10s");
        long millisToWait = TimeUnitProperty.getParsedValue((String)millisToWaitS);
        if (millisToWait < 1000L) {
            millisToWait = 1000L;
        }
        numberOfBackupRetries = (int)Math.round(1.0 * (double)millisToWait / 1000.0);
        logger.fine("Maximum backup delay is [" + millisToWaitS + "] resulting in [" + numberOfBackupRetries + "] retries with a one second resolution");
    }
}

