/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.sun.jini.landlord.LeasedResource;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.jsb.ServiceState;
import org.jini.rio.monitor.InstantiatorResource;
import org.jini.rio.monitor.PriorityZoneComponent;
import org.jini.rio.monitor.ServiceResourceSelector;
import org.jini.rio.resources.servicecore.ServiceResource;

public class WeightedSelector
extends ServiceResourceSelector {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.selector");
    private static final MachineComparator machineComparator = new MachineComparator();
    private static final ContainerComparator containerComparator = new ContainerComparator();
    private static final PUServiceBeanAccessor serviceBeanAccessor = new PUServiceBeanAccessor();

    public WeightedSelector() {
        this.collection = new ArrayList();
    }

    @Override
    public void serviceResourceSelected(ServiceResource resource) {
    }

    @Override
    protected void update(LeasedResource resource) {
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem, Uuid uuid, boolean inclusive) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem, uuid, inclusive);
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem, Set<Uuid> excludedUuids) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem, excludedUuids);
    }

    @Override
    public ServiceResource getServiceResource(ServiceElement sElem) throws Exception {
        this.sort(sElem);
        return super.getServiceResource(sElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort(ServiceElement sElem) {
        ArrayList<ServiceResource> listOfResources = new ArrayList<ServiceResource>(this.collection.size());
        Collection collection = this.collection;
        synchronized (collection) {
            listOfResources.addAll(this.collection);
        }
        this.sort(sElem, listOfResources);
        collection = this.collection;
        synchronized (collection) {
            listOfResources.retainAll(this.collection);
            this.collection.removeAll(listOfResources);
            ((ArrayList)this.collection).addAll(0, listOfResources);
        }
    }

    private void sort(ServiceElement sElem, Collection<ServiceResource> listOfResources) {
        boolean probPrimary = true;
        ArrayList<Machine> machines = new ArrayList<Machine>(listOfResources.size());
        for (ServiceResource serviceResource : listOfResources) {
            InstantiatorResource instantiatorResource = (InstantiatorResource)serviceResource.getResource();
            String hostAddress = this.getHostAddressKey(instantiatorResource);
            Machine machine = new Machine(hostAddress);
            int indexOf = machines.indexOf(machine);
            if (indexOf == -1) {
                machines.add(machine);
            } else {
                machine = (Machine)machines.get(indexOf);
            }
            machine.setZones(instantiatorResource.getZones());
            Container container = new Container(serviceResource);
            container.setZones(instantiatorResource.getZones());
            machine.addContainer(container);
            if (instantiatorResource.getServiceElementInstances(sElem) <= 0 && instantiatorResource.getInProcessCounter(sElem) <= 0) continue;
            probPrimary = false;
        }
        sElem.setProbPrimary(probPrimary);
        String primaryZoneStr = (String)sElem.getServiceBeanConfig().getInitParameters().get("primaryZone");
        LinkedHashSet primaryZone = ZoneHelper.parseZones((String)primaryZoneStr);
        for (Machine machine : machines) {
            machine.setPriorityZone(primaryZone, probPrimary);
            for (Container container : machine.containers) {
                container.setPriorityZone(primaryZone, probPrimary);
                container.calcWeight(sElem, probPrimary);
            }
            machine.calcWeight();
        }
        Collections.sort(machines, machineComparator);
        for (Machine machine : machines) {
            Collections.sort(machine.containers, containerComparator);
        }
        if (logger.isLoggable(Level.FINE)) {
            String msg = this.toString(machines);
            logger.fine("Sorting for : " + sElem + " " + (probPrimary ? "primary" : "backup") + "\n" + msg);
        }
        listOfResources.clear();
        for (Machine machine : machines) {
            for (Container container : machine.containers) {
                listOfResources.add(container.serviceResource);
            }
        }
    }

    private String getHostAddressKey(InstantiatorResource instantiatorResource) {
        return instantiatorResource.getHostName() + "/" + instantiatorResource.getHostAddress();
    }

    private String toString(List<Machine> machines) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (Machine machine : machines) {
            sb.append("Machine ").append(machine.host).append(" weights: ").append(machine.getWeight());
            if (logger.isLoggable(Level.FINEST)) {
                sb.append(" zones: ").append(machine.getZones());
                sb.append(" priorityZone: ").append(machine.getPriorityZone());
            }
            for (Container container : machine.containers) {
                InstantiatorResource resource = (InstantiatorResource)container.serviceResource.getResource();
                sb.append("\n\t").append(resource).append(" weights: ").append(container.getWeight());
                if (!logger.isLoggable(Level.FINEST)) continue;
                sb.append(" - ").append(container.details);
                sb.append(" zones: ").append(container.getZones());
                sb.append(" priorityZone: ").append(container.getPriorityZone());
            }
            sb.append("\n\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static final class PUServiceBeanAccessor {
        private final Class puServiceBeanClass;
        private final Method listSpaceModesMethod;

        public PUServiceBeanAccessor() {
            try {
                this.puServiceBeanClass = Thread.currentThread().getContextClassLoader().loadClass("org.openspaces.pu.container.servicegrid.PUServiceBean");
                this.listSpaceModesMethod = this.puServiceBeanClass.getMethod("listSpacesModes", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public SpaceMode[] getSpaceModes(Object serviceObj) throws Exception {
            return (SpaceMode[])this.listSpaceModesMethod.invoke(serviceObj, new Object[0]);
        }

        public boolean isAssignableFrom(Class<? extends Object> clazz) {
            return this.puServiceBeanClass.isAssignableFrom(clazz);
        }
    }

    private static final class ContainerComparator
    implements Comparator<Container> {
        private ContainerComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            if (c1.getPriorityZone() == c2.getPriorityZone()) {
                return c1.getWeight() - c2.getWeight();
            }
            return c1.getPriorityZone() - c2.getPriorityZone();
        }
    }

    private static final class MachineComparator
    implements Comparator<Machine> {
        private MachineComparator() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            if (m1.getPriorityZone() == m2.getPriorityZone()) {
                if (m1.getWeight() == m2.getWeight()) {
                    return m2.getStrength() - m1.getStrength();
                }
                return m1.getWeight() - m2.getWeight();
            }
            return m1.getPriorityZone() - m2.getPriorityZone();
        }
    }

    private static final class Container
    extends PriorityZoneComponent {
        private final ServiceResource serviceResource;
        int weight;
        String details;

        public Container(ServiceResource serviceResource) {
            this.serviceResource = serviceResource;
        }

        public void calcWeight(ServiceElement sElem, boolean probPrimary) {
            this.weight = this.weightOfGSC(this.serviceResource, sElem, probPrimary);
        }

        public int getWeight() {
            return this.weight;
        }

        private int weightOfGSC(ServiceResource serviceResource, ServiceElement sElem, boolean probPrimary) {
            int weight = 0;
            try {
                ServiceElement[] serviceElements;
                ServiceBeanInstance[] serviceBeanInstances;
                ServiceElement[] serviceElementsInProcess;
                int primaries = 0;
                int backups = 0;
                int fromSamePartition = 0;
                int fromSameDeployment = 0;
                int unadvertised = 0;
                InstantiatorResource instantiatorResource = (InstantiatorResource)serviceResource.getResource();
                for (ServiceElement srvElem : serviceElementsInProcess = instantiatorResource.getServiceElementsInprocess()) {
                    if (srvElem.getInstanceId() == 1L) {
                        ++primaries;
                    } else {
                        ++backups;
                    }
                    if (srvElem.getOperationalStringName().equals(sElem.getOperationalStringName())) {
                        ++fromSameDeployment;
                    }
                    if (!srvElem.getName().equals(sElem.getName())) continue;
                    ++fromSamePartition;
                }
                for (ServiceBeanInstance serviceInstance : serviceBeanInstances = instantiatorResource.getInstantiator().getServiceBeanInstances(null)) {
                    try {
                        Object serviceObj = serviceInstance.getService();
                        int state = this.isServiceAPrimary(serviceObj);
                        if (state == 1) {
                            ++primaries;
                            continue;
                        }
                        if (state == 0) {
                            ++backups;
                            continue;
                        }
                        ++unadvertised;
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "Failed reaching service [" + serviceInstance.getServiceBeanConfig() + "] at [" + serviceInstance.getHostAddress() + "]", e);
                    }
                }
                for (ServiceElement srvElm : serviceElements = instantiatorResource.getServiceElements()) {
                    if (srvElm.getOperationalStringName().equals(sElem.getOperationalStringName())) {
                        ++fromSameDeployment;
                    }
                    if (!srvElm.getName().equals(sElem.getName())) continue;
                    ++fromSamePartition;
                }
                weight += fromSameDeployment;
                weight += fromSamePartition;
                weight += unadvertised;
                weight += primaries;
                weight += backups;
                weight = probPrimary ? (weight += primaries) : (weight += backups);
                int capacityPercentile = (int)Math.round(100.0 * (double)instantiatorResource.getServiceElementCount() / (double)instantiatorResource.getServiceLimit());
                weight += capacityPercentile;
                if (logger.isLoggable(Level.FINEST)) {
                    this.details = "primaries: [" + primaries + "] backups: [" + backups + "] un-advertised: [" + unadvertised + "] same-deployment: [" + fromSameDeployment + "] same-partition: [" + fromSamePartition + "] in-process: [" + serviceElementsInProcess.length + "] capacity-percentile: [" + capacityPercentile + "]";
                }
            }
            catch (RemoteException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Failed reaching service", e);
                }
                weight = Integer.MAX_VALUE;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Failed to weight service", e);
                }
                weight = Integer.MAX_VALUE;
            }
            return weight;
        }

        private int isServiceAPrimary(Object serviceObj) throws Exception {
            if (serviceBeanAccessor.isAssignableFrom(serviceObj.getClass())) {
                SpaceMode[] spacesModes;
                ServiceState serviceState;
                int state;
                if (serviceObj instanceof ServiceState && (state = this.getServiceState(serviceState = (ServiceState)serviceObj)) != 5) {
                    return -1;
                }
                for (SpaceMode mode : spacesModes = serviceBeanAccessor.getSpaceModes(serviceObj)) {
                    if (!mode.equals((Object)SpaceMode.PRIMARY)) continue;
                    return 1;
                }
            }
            return 0;
        }

        private int getServiceState(ServiceState serviceState) throws RemoteException {
            int state = serviceState.getState();
            return state;
        }
    }

    private static final class Machine
    extends PriorityZoneComponent {
        private final String host;
        private final List<Container> containers;
        private int weight;
        private int strength;

        public Machine(String host) {
            this.host = host;
            this.containers = new ArrayList<Container>();
        }

        public void calcWeight() {
            int weight = 0;
            int empty = 0;
            for (Container container : this.containers) {
                if (container.getWeight() == 0) {
                    ++empty;
                    continue;
                }
                weight += container.getWeight();
            }
            this.weight = weight;
            this.strength = this.containers.size() + empty;
        }

        public void addContainer(Container container) {
            this.containers.add(container);
        }

        public int getWeight() {
            return this.weight;
        }

        public int getStrength() {
            return this.strength;
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Machine other = (Machine)obj;
            return !(this.host == null ? other.host != null : !this.host.equals(other.host));
        }
    }
}

