/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor.event;

import java.util.ArrayList;
import java.util.List;
import org.jini.rio.monitor.event.Event;
import org.jini.rio.monitor.event.Events;

public class EventsStore {
    private final List<Event> buffer;
    private final int bufferCapacity;
    private int bufferFirstIndex;
    private long minStartCursor;
    private static final int DEFAULT_CAPACITY = 1000;

    public EventsStore() {
        this(1000);
    }

    public EventsStore(int capacity) {
        this.bufferCapacity = capacity;
        this.buffer = new ArrayList<Event>(capacity);
        this.bufferFirstIndex = 0;
        this.minStartCursor = 0L;
    }

    public void addEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        if (this.buffer.size() == this.bufferCapacity) {
            this.buffer.set(this.bufferFirstIndex, event);
            this.bufferFirstIndex = (this.bufferFirstIndex + 1) % this.buffer.size();
            ++this.minStartCursor;
        } else {
            this.buffer.add(event);
        }
    }

    public Events getEventsFromCursor(long cursor, int maxEvents) {
        long nextCursor;
        this.verifyArguments(cursor, maxEvents);
        long maxNextCursor = this.minStartCursor + (long)this.buffer.size();
        long startCursor = cursor;
        if (startCursor < this.minStartCursor) {
            startCursor = this.minStartCursor;
        }
        if (startCursor >= maxNextCursor) {
            startCursor = maxNextCursor;
        }
        if ((nextCursor = startCursor + (long)maxEvents) > maxNextCursor) {
            nextCursor = maxNextCursor;
        }
        int startIndex = (int)(startCursor - this.minStartCursor);
        int length = (int)(nextCursor - startCursor);
        Event[] array = new Event[length];
        for (int i = 0; i < length; ++i) {
            if (startIndex + i > this.buffer.size()) {
                throw new IllegalStateException("startIndex+i=" + startIndex + "+" + i + ">" + this.buffer.size());
            }
            Event event = this.buffer.get((this.bufferFirstIndex + startIndex + i) % this.buffer.size());
            if (event == null) {
                throw new IllegalStateException("Event cannot be null");
            }
            array[i] = event;
        }
        Events events = new Events(nextCursor, array);
        return events;
    }

    private void verifyArguments(long cursor, int maxEvents) throws IllegalArgumentException {
        if (cursor < 0L) {
            throw new IllegalArgumentException("Invalid cursor " + cursor);
        }
        if (maxEvents < 0) {
            throw new IllegalArgumentException("maxEvents must be positive");
        }
    }
}

