/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor.leader;

import com.gigaspaces.start.SystemInfo;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.monitor.ProvisionMonitorImpl;
import org.jini.rio.monitor.leader.AbstractLeaderHandler;
import org.jini.rio.monitor.leader.ActiveProvisionMonitorException;
import org.jini.rio.monitor.leader.LeadershipListener;
import org.jini.rio.monitor.leader.OpStringLeaderHandler;
import org.jini.rio.monitor.leader.ZooKeeperLeaderHandler;
import org.jini.rio.monitor.leader.ZooKeeperLeaderHandlerLifecycle;

public class ActiveProvisionMonitor
implements LeadershipListener {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm.leader");
    private final boolean useZooKeeper;
    private final AbstractLeaderHandler leaderHandler;
    private final ProvisionMonitorImpl provisionMonitor;

    public ActiveProvisionMonitor(ProvisionMonitorImpl provisionMonitor) throws ActiveProvisionMonitorException {
        this.provisionMonitor = provisionMonitor;
        boolean bl = this.useZooKeeper = !SystemInfo.singleton().getManagerClusterInfo().isEmpty();
        if (this.useZooKeeper) {
            logger.config("Using ZooKeeper as leader handler");
            ZooKeeperLeaderHandler zkLeaderSelectorHandler = new ZooKeeperLeaderHandler(this);
            zkLeaderSelectorHandler.start();
            this.leaderHandler = zkLeaderSelectorHandler;
        } else {
            logger.config("Using OpString as leader handler");
            OpStringLeaderHandler opStringLeaderHandler = new OpStringLeaderHandler();
            this.leaderHandler = opStringLeaderHandler;
        }
    }

    public boolean getAndSetActive(String key, boolean active) {
        OpStringLeaderHandler leaderSelectorHandler = (OpStringLeaderHandler)this.leaderHandler;
        return leaderSelectorHandler.getAndSetActive(key, active);
    }

    public boolean isActive() {
        return this.isActive(null);
    }

    public boolean isActive(String key) {
        if (key == null) {
            if (this.useZooKeeper) {
                return ((ZooKeeperLeaderHandlerLifecycle)((Object)this.leaderHandler)).hasLeadership();
            }
            return ((OpStringLeaderHandler)this.leaderHandler).isActive();
        }
        return ((OpStringLeaderHandler)this.leaderHandler).isActive(key);
    }

    public void remove(String key) {
        ((OpStringLeaderHandler)this.leaderHandler).remove(key);
    }

    @Override
    public String getId() {
        return this.provisionMonitor.getServiceID().toString();
    }

    @Override
    public boolean tryTakeLeadership() {
        long startTime = System.currentTimeMillis();
        logger.info("Leadership is being offered");
        OperationalStringManager[] operationalStringManagers = this.provisionMonitor.getOperationalStringManagers();
        ArrayList<String> opStringNames = new ArrayList<String>(operationalStringManagers.length);
        for (OperationalStringManager manager : operationalStringManagers) {
            try {
                manager.setManaging(true);
                opStringNames.add(manager.getOperationalString().getName());
            }
            catch (RemoteException e) {
                logger.log(Level.SEVERE, "Error invoking setManaging(true) on: " + manager, e);
                throw new IllegalStateException(e);
            }
        }
        if (!opStringNames.isEmpty()) {
            logger.info("Actively managing: " + opStringNames);
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        logger.info("Leadership taken - (took " + elapsedTime + "ms)");
        return true;
    }

    @Override
    public void relinquishLeadership() {
        long startTime = System.currentTimeMillis();
        logger.info("Leadership is being relinquished");
        OperationalStringManager[] operationalStringManagers = this.provisionMonitor.getOperationalStringManagers();
        ArrayList<String> opStringNames = new ArrayList<String>(operationalStringManagers.length);
        for (OperationalStringManager manager : operationalStringManagers) {
            try {
                manager.setManaging(false);
                opStringNames.add(manager.getOperationalString().getName());
            }
            catch (RemoteException e) {
                logger.log(Level.SEVERE, "Error invoking setManaging(false) on: " + manager, e);
                throw new IllegalStateException(e);
            }
        }
        if (!opStringNames.isEmpty()) {
            logger.info("No longer managing: " + opStringNames);
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        logger.info("Leadership relinquished - (took " + elapsedTime + "ms)");
    }

    public boolean isActiveActive() {
        return !this.useZooKeeper;
    }

    public boolean isActivePassive() {
        return this.useZooKeeper;
    }

    public String __toString() {
        String pidHostInfo;
        try {
            pidHostInfo = this.provisionMonitor.getPeerInfo().toString();
        }
        catch (RemoteException e) {
            pidHostInfo = "GSM";
        }
        return pidHostInfo + " service-id[" + this.getId() + "]";
    }

    public void terminate() {
        if (this.leaderHandler != null && this.leaderHandler instanceof ZooKeeperLeaderHandlerLifecycle) {
            ((ZooKeeperLeaderHandlerLifecycle)((Object)this.leaderHandler)).stop();
        }
    }
}

