/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.monitor.leader;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jini.rio.jmx.MBeanServerFactory;
import org.jini.rio.monitor.leader.ActiveProvisionMonitorException;
import org.jini.rio.monitor.leader.LeadershipListener;
import org.jini.rio.monitor.leader.ZooKeeperLeaderHandlerLifecycle;

public class JmxLeaderHandler
implements ZooKeeperLeaderHandlerLifecycle {
    private final JmxLeaderCallback mBean;

    public JmxLeaderHandler(LeadershipListener leadershipListener) throws ActiveProvisionMonitorException {
        try {
            MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
            String objectName = "com.gigaspaces.grid:type=GSM,*";
            Set<ObjectInstance> objectInstances = mbeanServer.queryMBeans(new ObjectName(objectName), null);
            ObjectInstance objectInstance = objectInstances.iterator().next();
            this.mBean = new JmxLeaderCallback(leadershipListener);
            mbeanServer.registerMBean(this.mBean, new ObjectName(objectInstance.getObjectName() + ",zk=Leader"));
        }
        catch (Exception e) {
            throw new ActiveProvisionMonitorException("Failed to register MBean", e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean awaitLeader() {
        return false;
    }

    @Override
    public boolean hasLeadership() {
        return this.mBean.isLeader();
    }

    private class JmxLeaderCallback
    implements JmxLeaderCallbackMBean {
        private volatile boolean isLeader = false;
        private final LeadershipListener leadershipListener;

        public JmxLeaderCallback(LeadershipListener leadershipListener) {
            this.leadershipListener = leadershipListener;
        }

        @Override
        public boolean isLeader() {
            return this.isLeader;
        }

        @Override
        public void setLeader(boolean leader) {
            this.isLeader = leader;
            if (this.isLeader) {
                this.leadershipListener.tryTakeLeadership();
            } else {
                this.leadershipListener.relinquishLeadership();
            }
        }
    }

    public static interface JmxLeaderCallbackMBean {
        public boolean isLeader();

        public void setLeader(boolean var1);
    }
}

