/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.opstring;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.log.LoggerConfig;

public class GlobalAttrs {
    protected ArrayList groupList = new ArrayList();
    protected ArrayList locatorList = new ArrayList();
    protected Properties initParms = new Properties();
    protected ArrayList configParms = new ArrayList();
    protected ArrayList cluster = new ArrayList();
    protected String codebase;
    protected String organization;
    protected ArrayList logConfigs = new ArrayList();
    boolean adaptiveCodebase;
    protected String[] provisionConfig;
    private ClassBundle fdhBundle;
    private ServiceLevelAgreements slaAgreements;
    protected Vector associations = new Vector();
    protected boolean autoAdvertise = false;

    public void setCluster(String[] machines, boolean append) {
        if (!append) {
            this.cluster.clear();
        }
        for (int i = 0; i < machines.length; ++i) {
            this.cluster.add(machines[i]);
        }
    }

    public String[] getCluster() {
        return this.cluster.toArray(new String[this.cluster.size()]);
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public void setConfigParameters(String[] parms, boolean append) {
        if (parms == null) {
            return;
        }
        if (!append || this.configParms.size() == 0) {
            this.configParms.clear();
            for (int i = 0; i < parms.length; ++i) {
                this.configParms.add(parms[i]);
            }
        } else {
            String[] currentConfigs = this.getConfigParameters();
            for (int i = 0; i < parms.length; ++i) {
                for (int j = 0; j < currentConfigs.length; ++j) {
                    if (currentConfigs[j].equals("-") || !this.getName(parms[i]).equals(this.getName(currentConfigs[j]))) continue;
                    this.configParms.remove(currentConfigs[j]);
                    break;
                }
                if (parms[i].equals("-")) continue;
                this.configParms.add(parms[i]);
            }
        }
    }

    private String getName(String parm) {
        String[] values = parm.split("=");
        return values[0].trim();
    }

    public String[] getConfigParameters() {
        if (this.configParms.size() == 0) {
            return new String[]{"-"};
        }
        return this.configParms.toArray(new String[this.configParms.size()]);
    }

    public void setGroups(String[] groups, boolean append) {
        if (!append) {
            this.groupList.clear();
        }
        for (int i = 0; i < groups.length; ++i) {
            String group = groups[i];
            if (group.equals("public")) {
                group = "";
            }
            this.groupList.add(groups[i]);
        }
    }

    public String[] getGroups() {
        String[] groups = new String[this.groupList.size()];
        for (int i = 0; i < this.groupList.size(); ++i) {
            groups[i] = (String)this.groupList.get(i);
        }
        return groups;
    }

    public void setLocators(String[] locators, boolean append) {
        if (!append) {
            this.locatorList.clear();
        }
        for (int i = 0; i < locators.length; ++i) {
            this.locatorList.add(locators[i]);
        }
    }

    public String[] getLocators() {
        String[] locators = new String[this.locatorList.size()];
        for (int i = 0; i < locators.length; ++i) {
            locators[i] = (String)this.locatorList.get(i);
        }
        return locators;
    }

    public void setLogConfigs(LoggerConfig[] configs, boolean append) {
        if (configs == null) {
            return;
        }
        if (!append || this.logConfigs.size() == 0) {
            this.logConfigs.clear();
            for (int i = 0; i < configs.length; ++i) {
                this.logConfigs.add(configs[i]);
            }
        } else {
            LoggerConfig[] currentConfigs = this.getLogConfigs();
            for (int i = 0; i < configs.length; ++i) {
                for (int j = 0; j < currentConfigs.length; ++j) {
                    if (!configs[i].getLoggerName().equals(currentConfigs[j].getLoggerName())) continue;
                    this.logConfigs.remove(currentConfigs[j]);
                    break;
                }
                this.logConfigs.add(configs[i]);
            }
        }
    }

    public LoggerConfig[] getLogConfigs() {
        return this.logConfigs.toArray(new LoggerConfig[this.logConfigs.size()]);
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setParameters(Map params, boolean append) {
        if (append) {
            this.initParms.putAll((Map<?, ?>)params);
        } else {
            this.initParms.clear();
            this.initParms.putAll((Map<?, ?>)params);
        }
    }

    public Properties getParameters() {
        return this.initParms;
    }

    public void useAdaptiveCodebase() {
        this.adaptiveCodebase = true;
    }

    public boolean getAdaptiveCodebase() {
        return this.adaptiveCodebase;
    }

    public void setServiceProvisionConfig(String[] args) {
        if (args != null) {
            this.provisionConfig = new String[args.length];
            System.arraycopy(args, 0, this.provisionConfig, 0, args.length);
        }
    }

    public String[] getServiceProvisionConfig() {
        if (this.provisionConfig == null) {
            this.provisionConfig = new String[]{"-"};
        }
        return this.provisionConfig;
    }

    public void setFaultDetectionHandlerBundle(ClassBundle bundle) {
        if (bundle != null) {
            this.fdhBundle = bundle;
        }
    }

    public ClassBundle getFaultDetectionHandlerBundle() {
        return this.fdhBundle;
    }

    public void setServiceLevelAgreements(ServiceLevelAgreements sla) {
        this.slaAgreements = sla;
    }

    public ServiceLevelAgreements getServiceLevelAgreements() {
        if (this.slaAgreements == null) {
            this.slaAgreements = new ServiceLevelAgreements();
        }
        return this.slaAgreements;
    }

    public void addAssociationDescriptor(AssociationDescriptor a) throws Exception {
        if (this.associations.contains(a)) {
            throw new Exception("Duplicate AssociationDescriptor [" + a.getName() + "]");
        }
        this.associations.add(a);
    }

    public void setAutoAdvertise(String value) {
        this.autoAdvertise = value.equals("yes");
    }

    public AssociationDescriptor[] getAssociationDescriptors() {
        return this.associations.toArray(new AssociationDescriptor[this.associations.size()]);
    }
}

