/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.opstring;

import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.internal.quiesce.InternalQuiesceRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.Schedule;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.resources.resource.PoolableThread;

public class OpString
implements OperationalString,
Serializable {
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm");
    static final long serialVersionUID = 1L;
    private String name;
    private final ArrayList services = new ArrayList();
    private final ArrayList nestedOpStrings = new ArrayList();
    private int deployedStatus = 0;
    private final URL loadedFrom;
    private Schedule schedule = new Schedule();
    private volatile InternalQuiesceDetails quiesceDetails = new InternalQuiesceDetails(QuiesceState.UNQUIESCED, null, "initial");
    private transient PoolableThread quiesceThread;

    public OpString(String name, URL loadedFrom) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        this.loadedFrom = loadedFrom;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.quiesceDetails == null) {
            this.quiesceDetails = new InternalQuiesceDetails(QuiesceState.UNQUIESCED, null, "initial");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeployed(int deployed) {
        if (deployed < 0 && deployed > 2) {
            throw new IllegalArgumentException("bad deployment status [" + deployed + "]");
        }
        OpString opString = this;
        synchronized (opString) {
            this.deployedStatus = deployed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStatus() {
        int myStatus;
        OpString opString = this;
        synchronized (opString) {
            if (this.deployedStatus < 2) {
                myStatus = this.deployedStatus;
            } else {
                myStatus = 5;
                ServiceElement[] sElems = this.getServices();
                for (int i = 0; i < sElems.length; ++i) {
                    int actual = sElems[i].getActual();
                    int planned = sElems[i].getPlanned();
                    if (actual == 0) {
                        myStatus = 3;
                        break;
                    }
                    if (actual < planned) {
                        myStatus = 4;
                        break;
                    }
                    if (sElems[i].getRelocateInstanceCount() <= 0) continue;
                    myStatus = 1;
                    break;
                }
                OperationalString[] nested = this.getNestedOperationalStrings();
                for (int i = 0; i < nested.length; ++i) {
                    int nestedStatus = nested[i].getStatus();
                    if (nestedStatus >= myStatus) continue;
                    myStatus = nestedStatus;
                }
            }
        }
        return myStatus;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        ServiceElement[] services = this.getServices();
        for (int i = 0; i < services.length; ++i) {
            services[i].getServiceBeanConfig().setOperationalStringName(name);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceElement[] getServices() {
        ServiceElement[] sams = null;
        ArrayList arrayList = this.services;
        synchronized (arrayList) {
            sams = new ServiceElement[this.services.size()];
            for (int i = 0; i < sams.length; ++i) {
                sams[i] = (ServiceElement)this.services.get(i);
            }
        }
        return sams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(ServiceElement sElem) {
        if (sElem == null) {
            throw new NullPointerException("ServiceElement is null");
        }
        ArrayList arrayList = this.services;
        synchronized (arrayList) {
            if (!this.services.contains(sElem)) {
                this.services.add(sElem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(ServiceElement sElem) {
        if (sElem == null) {
            throw new NullPointerException("ServiceElement is null");
        }
        ArrayList arrayList = this.services;
        synchronized (arrayList) {
            this.services.remove(sElem);
        }
    }

    public void addOperationalString(OperationalString[] opStrings) {
        if (opStrings == null) {
            throw new NullPointerException("OperationalString is null");
        }
        for (int i = 0; i < opStrings.length; ++i) {
            this.addOperationalString(opStrings[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperationalString(OperationalString opString) {
        if (opString == null) {
            throw new NullPointerException("OperationalString is null");
        }
        ArrayList arrayList = this.nestedOpStrings;
        synchronized (arrayList) {
            this.nestedOpStrings.add(opString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationalString[] getNestedOperationalStrings() {
        OperationalString[] ops = null;
        ArrayList arrayList = this.nestedOpStrings;
        synchronized (arrayList) {
            ops = new OperationalString[this.nestedOpStrings.size()];
            for (int i = 0; i < ops.length; ++i) {
                ops[i] = (OperationalString)this.nestedOpStrings.get(i);
            }
        }
        return ops;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.name.hashCode();
        hc = 37 * hc + this.services.hashCode();
        return hc;
    }

    public boolean equals(Object obj) {
        ServiceElement[] thatServices;
        ServiceElement[] thisServices;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OpString)) {
            return false;
        }
        OpString that = (OpString)obj;
        if (this.name.equals(that.name) && (thisServices = this.getServices()).length == (thatServices = that.getServices()).length) {
            for (int i = 0; i < thisServices.length; ++i) {
                boolean matched = false;
                for (int j = 0; j < thatServices.length; ++j) {
                    if (!thisServices[i].equals(thatServices[j])) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsNamedService(String serviceName) {
        boolean found = false;
        ArrayList arrayList = this.services;
        synchronized (arrayList) {
            for (ServiceElement sElem : this.services) {
                if (!sElem.getName().equals(serviceName)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceElement getNamedService(String serviceName) {
        ServiceElement foundService = null;
        ArrayList arrayList = this.services;
        synchronized (arrayList) {
            for (ServiceElement sElem : this.services) {
                if (!sElem.getName().equals(serviceName)) continue;
                foundService = sElem;
                break;
            }
        }
        return foundService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsOperationalString(String operationalStringName) {
        boolean found = false;
        ArrayList arrayList = this.nestedOpStrings;
        synchronized (arrayList) {
            for (OperationalString opString : this.nestedOpStrings) {
                if (!opString.getName().equals(operationalStringName)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationalString getNestedOperationalString(String operationalStringName) {
        OperationalString nested = null;
        ArrayList arrayList = this.nestedOpStrings;
        synchronized (arrayList) {
            for (OperationalString opString : this.nestedOpStrings) {
                if (!opString.getName().equals(operationalStringName)) continue;
                nested = opString;
                break;
            }
        }
        return nested;
    }

    @Override
    public URL loadedFrom() {
        return this.loadedFrom;
    }

    public void setSchedule(Schedule schedule) {
        if (schedule == null) {
            throw new NullPointerException("schedule is null");
        }
        this.schedule = schedule;
    }

    @Override
    public Schedule getSchedule() {
        return this.schedule;
    }

    public String toString() {
        return this.name;
    }

    public static String convertStatusToString(int status) {
        String sStatus = String.valueOf(status);
        switch (status) {
            case 0: {
                sStatus = "Undeployed";
                break;
            }
            case 1: {
                sStatus = "Scheduled";
                break;
            }
            case 2: {
                sStatus = "Deployed";
                break;
            }
            case 3: {
                sStatus = "Broken";
                break;
            }
            case 4: {
                sStatus = "Compromised";
                break;
            }
            case 5: {
                sStatus = "Intact";
            }
        }
        return sStatus;
    }

    @Override
    public InternalQuiesceDetails quiesce(InternalQuiesceRequest quiesceRequest) {
        if (this.quiesceDetails.getStatus() == QuiesceState.UNQUIESCED) {
            this.quiesceDetails = new InternalQuiesceDetails(QuiesceState.QUIESCED, quiesceRequest.getToken(), quiesceRequest.getDescription());
            if (this.quiesceThread != null) {
                try {
                    logger.log(Level.INFO, String.format("received quiesce request [%s] for processing unit %s, waiting for unquiesce to complete", this.quiesceDetails.getDescription(), this.getName()));
                    this.quiesceThread.joinResource();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.quiesceThread = null;
        }
        return this.quiesceDetails;
    }

    @Override
    public InternalQuiesceDetails unquiesce(InternalQuiesceRequest quiesceRequest) {
        this.quiesceDetails = new InternalQuiesceDetails(QuiesceState.UNQUIESCED, null, quiesceRequest.getDescription());
        if (this.quiesceThread != null) {
            logger.log(Level.INFO, String.format("received unquiesce request [%s] for processing unit %s, canceling previous quiesce request", this.quiesceDetails.getDescription(), this.getName()));
            this.quiesceThread.stopExecution();
            try {
                this.quiesceThread.joinResource();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.quiesceThread = null;
        return this.quiesceDetails;
    }

    @Override
    public void setQuiesceDetails(InternalQuiesceDetails quiesceDetails) {
        this.quiesceDetails = quiesceDetails;
    }

    @Override
    public InternalQuiesceDetails getQuiesceDetails() {
        return this.quiesceDetails;
    }

    @Override
    public void setQuiesceThread(PoolableThread quiesceThread) {
        this.quiesceThread = quiesceThread;
    }

    @Override
    public PoolableThread getQuiesceThread() {
        return this.quiesceThread;
    }
}

