/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.opstring;

import com.sun.jini.config.ConfigUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jini.core.discovery.LookupLocator;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.AssociationType;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.SLA;
import org.jini.rio.core.Schedule;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.provision.SoftwareLoad;
import org.jini.rio.log.LoggerConfig;
import org.jini.rio.opstring.GlobalAttrs;
import org.jini.rio.opstring.OpString;
import org.jini.rio.opstring.OverrideHelper;
import org.jini.rio.opstring.ParsedService;
import org.jini.rio.resources.util.JavaEntityResolver;
import org.jini.rio.resources.util.PropertyHelper;
import org.jini.rio.watch.WatchDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OpStringLoader {
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder = null;
    protected String loadPath;
    protected String codebaseOverride;
    protected String[] defaultExportJars;
    private static Logger logger = Logger.getLogger("org.jini.rio.opstring");
    static final Hashtable associationTable = new Hashtable();
    static final Hashtable opStringRefTable = new Hashtable();
    public static final String DEFAULT_FDH = "org.jini.rio.resources.client.AdminFaultDetectionHandler";
    static final Hashtable overrideTable = new Hashtable();
    protected boolean processingOverrides = false;
    private String[] defaultGroups = null;
    private LookupLocator[] defaultLocators = null;

    public OpStringLoader() throws Exception {
        this(true);
    }

    public OpStringLoader(boolean verify) throws Exception {
        this.factory.setValidating(verify);
        this.factory.setNamespaceAware(true);
        this.factory.setExpandEntityReferences(true);
        this.factory.setCoalescing(true);
        this.builder = this.factory.newDocumentBuilder();
        if (verify) {
            this.builder.setErrorHandler(new XMLErrorHandler());
        }
        this.builder.setEntityResolver(new JavaEntityResolver());
    }

    public OpStringLoader(ClassLoader loader) throws Exception {
        this(true, loader);
    }

    public OpStringLoader(boolean verify, ClassLoader loader) throws Exception {
        this.factory.setValidating(verify);
        this.factory.setNamespaceAware(true);
        this.factory.setExpandEntityReferences(true);
        this.factory.setCoalescing(true);
        this.builder = this.factory.newDocumentBuilder();
        if (verify) {
            this.builder.setErrorHandler(new XMLErrorHandler());
        }
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
        this.builder.setEntityResolver(new JavaEntityResolver(loader));
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    public void setCodebaseOverride(String codebase) {
        this.codebaseOverride = codebase;
    }

    public void setDefaultExportJars(String[] jars) {
        if (jars == null) {
            return;
        }
        this.defaultExportJars = new String[jars.length];
        System.arraycopy(jars, 0, this.defaultExportJars, 0, jars.length);
    }

    public void setDefaultGroups(String[] groups) {
        if (groups == null) {
            this.defaultGroups = null;
            return;
        }
        if (groups.length == 0) {
            throw new IllegalArgumentException("groups is empty");
        }
        this.defaultGroups = new String[groups.length];
        System.arraycopy(groups, 0, this.defaultGroups, 0, groups.length);
    }

    public void setDefaultLookupLocators(LookupLocator[] locators) {
        if (locators == null) {
            this.defaultLocators = null;
            return;
        }
        this.defaultLocators = new LookupLocator[locators.length];
        System.arraycopy(locators, 0, this.defaultLocators, 0, locators.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceOverride(String override) throws MalformedURLException {
        URL url = this.getURL(override);
        if (url == null) {
            throw new IllegalArgumentException("Override [" + override + "] not found");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setCoalescing(true);
        try {
            DocumentBuilder overrideBuilder = dbf.newDocumentBuilder();
            overrideBuilder.setEntityResolver(new JavaEntityResolver());
            InputStream is = null;
            try {
                this.processingOverrides = true;
                is = url.openStream();
                Document document = overrideBuilder.parse(is);
                NodeList nList = document.getElementsByTagName("ServiceBean");
                if (nList.getLength() == 0) {
                    nList = document.getElementsByTagName("servicebean");
                }
                GlobalAttrs global = new GlobalAttrs();
                for (int i = 0; i < nList.getLength(); ++i) {
                    NodeList children;
                    String attribute;
                    Node node = nList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String name = attribute = element.getAttribute("Name");
                    attribute = element.getAttribute("NewName");
                    String newName = null;
                    if (attribute.length() > 0) {
                        newName = attribute;
                    }
                    ParsedService svcDescriptor = new ParsedService(newName == null ? name : newName, global);
                    attribute = element.getAttribute("MatchOnName");
                    if (attribute.length() > 0) {
                        svcDescriptor.setMatchOnName(attribute);
                    }
                    if ((attribute = element.getAttribute("ProvisionType")).length() > 0) {
                        svcDescriptor.setProvisionType(attribute);
                    }
                    if ((attribute = element.getAttribute("AutoAdvertise")).length() > 0) {
                        svcDescriptor.setAutoAdvertise(attribute);
                    }
                    if ((attribute = element.getAttribute("DiscoveryManagementPooling")).length() > 0) {
                        svcDescriptor.setDiscoveryManagementPooling(attribute);
                    }
                    if ((children = element.getChildNodes()).getLength() > 0) {
                        try {
                            this.processChildren(children, global, svcDescriptor, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    overrideTable.put(name, svcDescriptor);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            finally {
                this.processingOverrides = false;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public OperationalString[] parseOperationalString(File xmlFile) throws Exception {
        if (this.loadPath == null) {
            String path = xmlFile.getCanonicalPath();
            int index = path.lastIndexOf(System.getProperty("file.separator"));
            this.loadPath = path.substring(0, index + 1);
        }
        Document document = this.builder.parse(xmlFile);
        return this.parseOperationalString(document, xmlFile.toURI().toURL());
    }

    public OperationalString[] parseOperationalString(InputStream is) throws Exception {
        Document document = null;
        try {
            document = this.builder.parse(is);
        }
        finally {
            is.close();
        }
        return this.parseOperationalString(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationalString[] parseOperationalString(URL xmlURL) throws Exception {
        if (xmlURL == null) {
            throw new NullPointerException("xmlURL is null");
        }
        if (this.loadPath == null) {
            String path = xmlURL.toExternalForm();
            int index = path.lastIndexOf(47);
            this.loadPath = path.substring(0, index + 1);
        }
        Document document = null;
        try (InputStream is = xmlURL.openStream();){
            document = this.builder.parse(is);
        }
        return this.parseOperationalString(document, xmlURL);
    }

    public OperationalString[] parseOperationalString(String xmlLocation) throws Exception {
        if (xmlLocation == null) {
            throw new NullPointerException("xmlLocation is null");
        }
        URL fileURL = this.getURL(xmlLocation);
        if (fileURL == null) {
            throw new FileNotFoundException("XML Location [" + xmlLocation + "] not found");
        }
        return this.parseOperationalString(fileURL);
    }

    protected URL getURL(String location) throws MalformedURLException {
        URL url = null;
        url = location.startsWith("http") || location.startsWith("file:") ? new URL(location) : new File(location).toURI().toURL();
        return url;
    }

    public OperationalString[] parseOperationalString(Document document, URL loadedFrom) throws Exception {
        NodeList nList = document.getElementsByTagName("OperationalString");
        if (nList.getLength() == 0) {
            nList = document.getElementsByTagName("gs-deployment");
        }
        OperationalString[] opStrings = new OpString[nList.getLength()];
        for (int i = 0; i < nList.getLength(); ++i) {
            Element element = (Element)nList.item(i);
            if (element.getTagName().equals("OperationalString") || element.getTagName().equals("gs-deployment")) {
                opStrings[i] = new OpString(element.getAttribute("Name"), loadedFrom);
                associationTable.put(((OpString)opStrings[i]).getName(), new Hashtable());
                GlobalAttrs gAttrs = new GlobalAttrs();
                if (this.codebaseOverride != null) {
                    gAttrs.setCodebase(this.codebaseOverride);
                }
                this.parseElement(element, gAttrs, null, (OpString)opStrings[i]);
                Hashtable aTable = (Hashtable)associationTable.get(((OpString)opStrings[i]).getName());
                if (aTable.size() <= 0) continue;
                ServiceElement[] sElems = ((OpString)opStrings[i]).getServices();
                for (int j = 0; j < sElems.length; ++j) {
                    AssociationDescriptor[] aDescs = (AssociationDescriptor[])aTable.get(sElems[j].getName());
                    if (aDescs == null) continue;
                    for (int k = 0; k < aDescs.length; ++k) {
                        String svcName;
                        String associatedName = aDescs[k].getName();
                        if (associatedName.equals(svcName = sElems[j].getName())) {
                            throw new IllegalArgumentException("Invalid AssociationDescriptor : A service cannot have an association to itself");
                        }
                        String assocOpStringName = aDescs[k].getOperationalStringName();
                        if (assocOpStringName == null && aDescs[k].getInterfaceNames().length == 0) {
                            throw new IllegalArgumentException("Invalid AssociationDescriptor : Unknown service interface");
                        }
                        if (aDescs[k].getInterfaceNames().length > 0) {
                            if (aDescs[k].getFaultDetectionHandlerBundle() == null) {
                                aDescs[k].setFaultDetectionHandlerBundle(OpStringLoader.getDefaultFDH());
                            }
                            aDescs[k].setGroups(sElems[j].getServiceBeanConfig().getGroups());
                            aDescs[k].setLocators(sElems[j].getServiceBeanConfig().getLocators());
                            continue;
                        }
                        if (!assocOpStringName.equals(((OpString)opStrings[i]).getName())) {
                            if (((OpString)opStrings[i]).containsOperationalString(assocOpStringName)) {
                                OpString op = (OpString)((OpString)opStrings[i]).getNestedOperationalString(assocOpStringName);
                                ServiceElement sElem = op.getNamedService(associatedName);
                                if (sElem == null) {
                                    throw new IllegalArgumentException("Associated service [" + associatedName + "] not in [" + assocOpStringName + "] OperationalString");
                                }
                                this.setAssociationDescriptorAttrs(sElem, aDescs[k]);
                                continue;
                            }
                            throw new IllegalArgumentException("OperationalString [" + assocOpStringName + "] not included in [" + ((OpString)opStrings[i]).getName() + "] OperationalString");
                        }
                        ServiceElement sElem = ((OpString)opStrings[i]).getNamedService(associatedName);
                        if (sElem == null) {
                            throw new IllegalArgumentException("Associated service [" + associatedName + "] not in [" + assocOpStringName + "] OperationalString");
                        }
                        this.setAssociationDescriptorAttrs(sElem, aDescs[k]);
                    }
                    sElems[j].setAssociationDescriptors(aDescs);
                }
                continue;
            }
            throw new NoSuchFieldException("XML Element is not an OperationalString");
        }
        return opStrings;
    }

    private void setAssociationDescriptorAttrs(ServiceElement sElem, AssociationDescriptor aDesc) {
        ClassBundle[] bundles = sElem.getExportBundles();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < bundles.length; ++i) {
            list.add(bundles[i].getClassName());
        }
        aDesc.setInterfaceNames(list.toArray(new String[list.size()]));
        ClassBundle fdhBundle = sElem.getFaultDetectionHandlerBundle();
        aDesc.setFaultDetectionHandlerBundle(fdhBundle);
        aDesc.setGroups(sElem.getServiceBeanConfig().getGroups());
        aDesc.setLocators(sElem.getServiceBeanConfig().getLocators());
        aDesc.setMatchOnName(sElem.getMatchOnName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseElement(Element element, GlobalAttrs global, ParsedService sDescriptor, OpString opString) throws Exception {
        if (element.getTagName().equals("OperationalString") || element.getTagName().equals("gs-deployment")) {
            NodeList serviceList;
            NodeList serviceBeanList;
            NodeList nodeList;
            NodeList includeList = element.getElementsByTagName("Include");
            if (includeList.getLength() > 0) {
                this.processChildren(includeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Cluster")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Codebase")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Configuration")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Groups")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Locators")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Logging")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Organization")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Parameters")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("ServiceProvisionConfig")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("ServiceLevelAgreements")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("FaultDetectionHandler")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Associations")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("Association")).getLength() > 0) {
                this.processChildren(nodeList, global, null, opString);
            }
            if ((nodeList = element.getElementsByTagName("DeploymentSchedule")).getLength() > 0) {
                Schedule schedule = OpStringLoader.createSchedule((Element)nodeList.item(0));
                System.out.println(schedule.getStartDate());
                System.out.println(schedule.toString());
                opString.setSchedule(schedule);
            }
            if ((serviceBeanList = element.getElementsByTagName("ServiceBean")).getLength() > 0) {
                this.processChildren(serviceBeanList, global, null, opString);
            }
            if ((serviceList = element.getElementsByTagName("Service")).getLength() <= 0) return;
            this.processChildren(serviceList, global, null, opString);
            return;
        }
        if (element.getTagName().equals("ServiceBean")) {
            this.verify(element, global);
            ParsedService svcDescriptor = new ParsedService(element.getAttribute("Name"), global);
            String jmxName = element.getAttribute("jmxname");
            if (jmxName.length() > 0) {
                svcDescriptor.setJMXName(jmxName);
            }
            svcDescriptor.setOperationalStringName(opString.getName());
            svcDescriptor.setMatchOnName(element.getAttribute("MatchOnName"));
            svcDescriptor.setProvisionType(element.getAttribute("ProvisionType"));
            svcDescriptor.setAutoAdvertise(element.getAttribute("AutoAdvertise"));
            svcDescriptor.setDiscoveryManagementPooling(element.getAttribute("DiscoveryManagementPooling"));
            NodeList nList = element.getChildNodes();
            if (nList.getLength() > 0) {
                this.processChildren(nList, global, svcDescriptor, opString);
            }
            opString.addService(this.makeServiceElement(svcDescriptor));
            return;
        }
        if (element.getTagName().equals("Service")) {
            this.verify(element, global);
            ParsedService svcDescriptor = new ParsedService(element.getAttribute("Name"), global);
            svcDescriptor.setOperationalStringName(opString.getName());
            svcDescriptor.setMatchOnName(element.getAttribute("MatchOnName"));
            svcDescriptor.setProvisionType("external");
            NodeList nList = element.getChildNodes();
            if (nList.getLength() > 0) {
                this.processChildren(nList, global, svcDescriptor, opString);
            }
            opString.addService(this.makeServiceElement(svcDescriptor));
            return;
        }
        if (element.getTagName().equals("Include")) {
            String opStringRef = OpStringLoader.getTextValue(element);
            boolean resolved = false;
            try {
                File file = new File(opStringRef);
                if (file.exists()) {
                    resolved = true;
                }
            }
            catch (Exception file) {
                // empty catch block
            }
            if (!(resolved || opStringRef.startsWith("http:") || opStringRef.startsWith("file:") || this.loadPath == null)) {
                opStringRef = this.loadPath.startsWith("file:") ? this.loadPath.substring(5) + opStringRef : this.loadPath + opStringRef;
            }
            try {
                String id;
                OperationalString[] includes = this.parseOperationalString(opStringRef);
                if (opString != null) {
                    opString.addOperationalString(includes);
                }
                if ((id = element.getAttribute("id")) == null) return;
                for (int i = 0; i < includes.length; ++i) {
                    opStringRefTable.put(includes[i], id);
                }
                return;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to include OperationalString : " + opStringRef, ex);
                return;
            }
        }
        if (element.getTagName().equals("Cluster")) {
            if (element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null) return;
            String includeGlobalDecl = element.getAttribute("IncludeGlobalDecl");
            boolean append = includeGlobalDecl.equals("yes");
            ArrayList<String> list = new ArrayList<String>();
            NodeList nList = element.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                Element el;
                Node node = nList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equals("Machine")) continue;
                list.add(OpStringLoader.getTextValue(el));
            }
            String[] cluster = list.toArray(new String[list.size()]);
            if (sDescriptor != null) {
                sDescriptor.setCluster(cluster, append);
                return;
            } else {
                global.setCluster(cluster, append);
            }
            return;
        } else if (element.getTagName().equals("Codebase")) {
            if ((element.getParentNode().getNodeName().equals("ServiceBean") || element.getParentNode().getNodeName().equals("Service")) && sDescriptor == null) return;
            String adaptive = element.getAttribute("Adaptive");
            if (adaptive.equalsIgnoreCase("yes")) {
                if (sDescriptor != null) {
                    sDescriptor.useAdaptiveCodebase();
                } else {
                    global.useAdaptiveCodebase();
                }
            }
            if (this.codebaseOverride != null) {
                return;
            }
            String codebase = OpStringLoader.getTextValue(element);
            if (!codebase.endsWith("/")) {
                codebase = codebase + "/";
            }
            if (sDescriptor != null) {
                sDescriptor.setCodebase(codebase);
                return;
            } else {
                global.setCodebase(codebase);
            }
            return;
        } else if (element.getTagName().equals("ServiceProvisionConfig")) {
            if ((element.getParentNode().getNodeName().equals("ServiceBean") || element.getParentNode().getNodeName().equals("Service")) && sDescriptor == null) return;
            String[] config = null;
            NodeList nList = element.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                Element el;
                Node node = nList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equals("Configuration")) continue;
                config = OpStringLoader.parseConfiguration(el);
                break;
            }
            if (sDescriptor != null) {
                sDescriptor.setServiceProvisionConfig(config);
                return;
            } else {
                global.setServiceProvisionConfig(config);
            }
            return;
        } else if (element.getTagName().equals("Configuration")) {
            if (!element.getParentNode().getNodeName().equals("OperationalString") && !element.getParentNode().getNodeName().equals("gs-deployment") && !element.getParentNode().getNodeName().equals("ServiceBean") && !element.getParentNode().getNodeName().equals("Service") || element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null) return;
            String includeGlobalDecl = element.getAttribute("IncludeGlobalDecl");
            boolean append = includeGlobalDecl.equals("yes");
            String[] config = OpStringLoader.parseConfiguration(element);
            if (sDescriptor != null) {
                sDescriptor.setConfigParameters(config, append);
                return;
            } else {
                global.setConfigParameters(config, append);
            }
            return;
        } else if (element.getTagName().equals("Groups")) {
            if ((element.getParentNode().getNodeName().equals("ServiceBean") || element.getParentNode().getNodeName().equals("Service")) && sDescriptor == null) return;
            String includeGlobalDecl = element.getAttribute("IncludeGlobalDecl");
            boolean append = includeGlobalDecl.equals("yes");
            ArrayList<String> list = new ArrayList<String>();
            NodeList nList = element.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                Element el;
                Node node = nList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equals("Group")) continue;
                list.add(OpStringLoader.getTextValue(el));
            }
            String[] groups = list.toArray(new String[list.size()]);
            if (sDescriptor != null) {
                sDescriptor.setGroups(groups, append);
                return;
            } else {
                global.setGroups(groups, append);
            }
            return;
        } else if (element.getTagName().equals("Locators")) {
            if ((element.getParentNode().getNodeName().equals("ServiceBean") || element.getParentNode().getNodeName().equals("Service")) && sDescriptor == null) return;
            String includeGlobalDecl = element.getAttribute("IncludeGlobalDecl");
            boolean append = includeGlobalDecl.equals("yes");
            ArrayList<String> list = new ArrayList<String>();
            NodeList nList = element.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                Element el;
                Node node = nList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equals("Locator")) continue;
                list.add(OpStringLoader.getTextValue(el));
            }
            String[] locators = list.toArray(new String[list.size()]);
            if (sDescriptor != null) {
                sDescriptor.setLocators(locators, append);
                return;
            } else {
                global.setLocators(locators, append);
            }
            return;
        } else if (element.getTagName().equals("Logging")) {
            if (element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null) return;
            String includeGlobalDecl = element.getAttribute("IncludeGlobalDecl");
            boolean append = includeGlobalDecl.equals("yes");
            LoggerConfig[] logConfigs = this.parseLogging(element);
            if (sDescriptor != null) {
                sDescriptor.setLogConfigs(logConfigs, append);
                return;
            } else {
                global.setLogConfigs(logConfigs, append);
            }
            return;
        } else if (element.getTagName().equals("Organization")) {
            if (element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null) return;
            String organization = OpStringLoader.getTextValue(element);
            if (sDescriptor != null) {
                sDescriptor.setOrganization(organization);
                return;
            } else {
                global.setOrganization(organization);
            }
            return;
        } else if (element.getTagName().equals("Parameters")) {
            if (element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null) return;
            String includeGlobalDecl = element.getAttribute("IncludeGlobalDecl");
            boolean append = includeGlobalDecl.equals("yes");
            Properties props = OpStringLoader.parseParameters(element);
            if (sDescriptor != null) {
                sDescriptor.setParameters(props, append);
                return;
            } else {
                global.setParameters(props, append);
            }
            return;
        } else if (element.getTagName().equals("Interfaces")) {
            ArrayList<String> iList = new ArrayList<String>();
            NodeList nList = element.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                Element el;
                Node node = nList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equals("Interface")) continue;
                iList.add(OpStringLoader.getTextValue(el));
            }
            ClassBundle[] bundles = new ClassBundle[iList.size()];
            for (int i = 0; i < bundles.length; ++i) {
                bundles[i] = this.parseResources(element, (String)iList.get(i), sDescriptor.getCodebase());
            }
            boolean found = false;
            if (this.defaultExportJars != null) {
                ArrayList<String> toAdd = new ArrayList<String>();
                for (int i = 0; i < bundles.length; ++i) {
                    for (int j = 0; j < this.defaultExportJars.length; ++j) {
                        String[] jars = bundles[i].getJARNames();
                        for (int k = 0; k < jars.length; ++k) {
                            if (!this.defaultExportJars[j].equals(jars[k])) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        toAdd.add(this.defaultExportJars[j]);
                    }
                }
                if (toAdd.size() > 0) {
                    for (String jar : toAdd) {
                        bundles[0].addJAR(jar);
                    }
                }
            }
            sDescriptor.setInterfaceBundles(bundles);
            return;
        } else if (element.getTagName().equals("ImplementationClass")) {
            String className = OpStringLoader.getTextValue(element);
            ClassBundle bundle = this.parseResources(element, className, sDescriptor.getCodebase());
            sDescriptor.setComponentBundle(bundle);
            return;
        } else if (element.getTagName().equalsIgnoreCase("Association")) {
            if (element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null || element.getParentNode().getNodeName().equals("Associations")) return;
            this.parseAssociation(element, opString, global, sDescriptor);
            return;
        } else if (element.getTagName().equals("Associations")) {
            if (element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null) return;
            NodeList nList = element.getElementsByTagName("Association");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node assoc = nList.item(i);
                this.parseAssociation(assoc, opString, global, sDescriptor);
            }
            return;
        } else if (element.getTagName().equals("ServiceLevelAgreements")) {
            if (element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null) return;
            ServiceLevelAgreements sla = new ServiceLevelAgreements();
            NodeList nList = element.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                String codebase;
                Node node = nList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                String string = codebase = sDescriptor == null ? global.getCodebase() : sDescriptor.getCodebase();
                if (el.getTagName().equals("SystemRequirements")) {
                    this.parseSystemRequirements(el, sla, codebase);
                }
                if (!el.getTagName().equals("SLA")) continue;
                SLA parsedSLA = this.parseSLA(el, false);
                sla.addServiceSLA(parsedSLA);
            }
            if (sDescriptor != null) {
                sDescriptor.setServiceLevelAgreements(sla);
                return;
            } else {
                global.setServiceLevelAgreements(sla);
            }
            return;
        } else if (element.getTagName().equals("FaultDetectionHandler")) {
            if (element.getParentNode().getNodeName().equals("ServiceBean") && sDescriptor == null) return;
            String codebase = sDescriptor == null ? global.getCodebase() : sDescriptor.getCodebase();
            ClassBundle fdhBundle = this.parseFDH(element, codebase);
            if (sDescriptor != null) {
                sDescriptor.setFaultDetectionHandlerBundle(fdhBundle);
                return;
            } else {
                global.setFaultDetectionHandlerBundle(fdhBundle);
            }
            return;
        } else {
            String value;
            NodeList eList = element.getChildNodes();
            if (eList.getLength() <= 0 || (value = OpStringLoader.getTextValue(element)) == null || value.length() <= 0) return;
            Method method = sDescriptor.getClass().getMethod("set" + element.getTagName(), String.class);
            try {
                method.invoke((Object)sDescriptor, value);
                return;
            }
            catch (Exception e) {
                if (e.getCause() == null || !(e.getCause() instanceof Exception)) throw e;
                throw (Exception)e.getCause();
            }
        }
    }

    protected void processChildren(NodeList nodeList, GlobalAttrs global, ParsedService sDescriptor, OpString opString) throws Exception {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.parseElement((Element)node, global, sDescriptor, opString);
        }
    }

    protected void parseAssociation(Node assoc, OperationalString opString, GlobalAttrs global, ParsedService sDescriptor) throws Exception {
        String opStringName = null;
        String refID = null;
        String propertyName = null;
        String className = null;
        String matchOnName = null;
        String[] configArgs = new String[]{"-"};
        ClassBundle fdhBundle = null;
        NodeList childList = assoc.getChildNodes();
        for (int j = 0; j < childList.getLength(); ++j) {
            Node childNode = childList.item(j);
            if (childNode.getNodeType() != 1) continue;
            Element el = (Element)childNode;
            if (el.getTagName().equalsIgnoreCase("Configuration")) {
                configArgs = OpStringLoader.parseConfiguration(el);
            }
            if (!el.getTagName().equalsIgnoreCase("FaultDetectionHandler")) continue;
            fdhBundle = this.parseFDH(el, sDescriptor.getCodebase());
        }
        NamedNodeMap nm = assoc.getAttributes();
        Node node = nm.getNamedItem("Type");
        String sType = node.getNodeValue();
        node = nm.getNamedItem("Name");
        String name = node.getNodeValue();
        node = nm.getNamedItem("Property");
        if (node != null) {
            propertyName = node.getNodeValue();
        }
        if ((node = nm.getNamedItem("ClassName")) != null) {
            className = node.getNodeValue();
        }
        if ((node = nm.getNamedItem("refid")) != null) {
            refID = node.getNodeValue();
        }
        if ((node = nm.getNamedItem("OperationalString")) != null) {
            opStringName = node.getNodeValue();
        } else if (refID != null) {
            for (Map.Entry mapEntry : opStringRefTable.entrySet()) {
                OpString opstring = (OpString)mapEntry.getKey();
                String value = (String)mapEntry.getValue();
                if (!value.equals(refID)) continue;
                opStringName = opstring.getName();
                break;
            }
        } else if (className == null) {
            opStringName = opString.getName();
        }
        node = nm.getNamedItem("MatchOnName");
        matchOnName = node != null ? node.getNodeValue() : null;
        int type = 0;
        if (sType.equals("uses")) {
            type = 1;
        } else if (sType.equals("requires")) {
            type = 2;
        } else if (sType.equals("colocated")) {
            type = 3;
        } else if (sType.equals("opposed")) {
            type = 4;
        }
        AssociationDescriptor association = new AssociationDescriptor(new AssociationType(type), name, opStringName, propertyName, configArgs);
        if (className != null) {
            association.setInterfaceNames(new String[]{className});
        }
        if (matchOnName != null) {
            association.setMatchOnName(matchOnName.equals("yes"));
        }
        if (fdhBundle != null) {
            association.setFaultDetectionHandlerBundle(fdhBundle);
        }
        if (sDescriptor != null) {
            sDescriptor.addAssociationDescriptor(association);
            if (type == 2) {
                sDescriptor.setAutoAdvertise("no");
            }
        } else {
            global.addAssociationDescriptor(association);
            if (type == 2) {
                global.setAutoAdvertise("no");
            }
        }
    }

    public ServiceElement makeServiceElement(ParsedService parsedSvc) throws Exception {
        ClassBundle fdhBundle;
        parsedSvc = OverrideHelper.override(parsedSvc, (ParsedService)overrideTable.get(parsedSvc.getName()));
        ServiceBeanConfig sbConfig = this.makeServiceBeanConfig(parsedSvc);
        AssociationDescriptor[] aDescs = parsedSvc.getAssociationDescriptors();
        if (aDescs != null && aDescs.length > 0) {
            Hashtable aTable = (Hashtable)associationTable.get(parsedSvc.getOperationalStringName());
            aTable.put(parsedSvc.getName(), aDescs);
            associationTable.put(parsedSvc.getOperationalStringName(), aTable);
        }
        if ((fdhBundle = parsedSvc.getFaultDetectionHandlerBundle()) == null) {
            fdhBundle = OpStringLoader.getDefaultFDH();
        }
        ServiceElement elem = new ServiceElement(parsedSvc.getProvisionType(), sbConfig, parsedSvc.getServiceLevelAgreements(), parsedSvc.getInterfaceBundles(), fdhBundle, parsedSvc.getComponentBundle());
        String maintain = parsedSvc.getMaintain();
        if (maintain == null) {
            maintain = "0";
        }
        elem.setPlanned(Integer.parseInt(maintain));
        elem.setCluster(parsedSvc.getCluster());
        elem.setMaxPerMachine(Integer.parseInt(parsedSvc.getMaxPerMachine()));
        elem.setRequiresIsolation(Boolean.parseBoolean(parsedSvc.isRequiresIsolation()));
        elem.setMaxPerPhysicalMachine(Integer.parseInt(parsedSvc.getMaxPerPhysicalMachine()));
        elem.setTotalNumberOfServices(Integer.parseInt(parsedSvc.getTotalNumberOfServices()));
        elem.setMatchOnName(parsedSvc.getMatchOnName().equals("yes"));
        elem.setAutoAdvertise(parsedSvc.getAutoAdvertise());
        elem.setDiscoveryManagementPooling(parsedSvc.getDiscoveryManagementPooling());
        return elem;
    }

    public ServiceBeanConfig makeServiceBeanConfig(ParsedService parsedService) throws Exception {
        String[] parsedGroups;
        if (parsedService == null) {
            throw new NullPointerException("parsedService is null");
        }
        String component = OpStringLoader.getComponentName(parsedService);
        HashMap<String, Object> configParms = new HashMap<String, Object>();
        configParms.put("configComponent", component);
        configParms.put("serviceName", parsedService.getName());
        if (parsedService.getJMXName() != null) {
            configParms.put("jmxName", parsedService.getJMXName());
        }
        if (parsedService.getComment() != null) {
            configParms.put("serviceComment", parsedService.getComment());
        }
        configParms.put("opStringName", parsedService.getOperationalStringName());
        if (parsedService.getAdaptiveCodebase()) {
            configParms.put("adaptiveCodebase", "yes");
        }
        configParms.put("configuredCodebase", parsedService.getCodebase());
        configParms.put("provisionConfig", parsedService.getServiceProvisionConfig());
        if (parsedService.getOrganization() != null) {
            configParms.put("organization", parsedService.getOrganization());
        }
        if ((parsedGroups = parsedService.getGroups()).length == 0) {
            parsedGroups = this.defaultGroups;
        }
        for (int i = 0; i < parsedGroups.length; ++i) {
            parsedGroups[i] = OpStringLoader.replaceProperties(parsedGroups[i]);
        }
        configParms.put("lookupGroups", parsedGroups);
        LookupLocator[] locators = null;
        if (parsedService.getLocators() != null) {
            locators = OpStringLoader.getLocators(parsedService);
        }
        if (locators == null || locators.length == 0) {
            locators = this.defaultLocators;
        }
        if (locators != null) {
            configParms.put("lookupLocators", locators);
        }
        if (parsedService.getLogConfigs() != null) {
            configParms.put("loggerConfig", parsedService.getLogConfigs());
        }
        String[] configArgs = parsedService.getConfigParameters();
        ServiceBeanConfig sbConfig = new ServiceBeanConfig(configParms, configArgs);
        Properties initParms = parsedService.getParameters();
        for (Map.Entry<Object, Object> entry : initParms.entrySet()) {
            sbConfig.addInitParameter(entry.getKey(), entry.getValue());
        }
        return sbConfig;
    }

    static String replaceProperties(String arg) {
        return PropertyHelper.expandProperties(arg, PropertyHelper.PARSETIME);
    }

    static LookupLocator[] getLocators(ParsedService svc) throws MalformedURLException {
        String[] sLocators = svc.getLocators();
        LookupLocator[] locators = new LookupLocator[sLocators.length];
        for (int i = 0; i < locators.length; ++i) {
            locators[i] = new LookupLocator(sLocators[i]);
        }
        return locators;
    }

    static String getComponentName(ParsedService parsedService) {
        String implClass = "";
        if (parsedService.getComponentBundle() != null) {
            implClass = parsedService.getComponentBundle().getClassName();
        } else {
            ClassBundle[] bundles = parsedService.getInterfaceBundles();
            implClass = bundles[0].getClassName();
        }
        String componentName = implClass;
        int ndx = implClass.lastIndexOf(".");
        if (ndx != -1) {
            componentName = implClass.substring(0, ndx);
        }
        return componentName;
    }

    static String getNameNoBlanks(ParsedService parsedService) {
        return parsedService.getName().replace(' ', '_');
    }

    public static String getTextValue(Node node) {
        NodeList eList = node.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < eList.getLength(); ++i) {
            Node n = eList.item(i);
            if (n.getNodeType() == 5) {
                sb.append(OpStringLoader.getTextValue(n));
                continue;
            }
            if (n.getNodeType() != 3) continue;
            sb.append(n.getNodeValue());
        }
        return OpStringLoader.replaceProperties(sb.toString().trim());
    }

    public static String[] parseConfiguration(Element element) throws Exception {
        String componentName = null;
        ArrayList<String> configList = new ArrayList<String>();
        NodeList nList = element.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            Element el;
            Node node = nList.item(i);
            if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equals("Component")) continue;
            NamedNodeMap nm = nList.item(i).getAttributes();
            Node node1 = nm.getNamedItem("Name");
            componentName = node1.getNodeValue();
            if (!componentName.endsWith(".")) {
                componentName = componentName + ".";
            }
            Properties parms = OpStringLoader.parseParameters(el);
            for (Map.Entry entry : parms.entrySet()) {
                configList.add(OpStringLoader.createConfigEntry(componentName + entry.getKey() + " = " + entry.getValue()));
            }
        }
        String[] configArgs = new String[configList.size() + 1];
        configArgs[0] = "-";
        for (int i = 1; i < configArgs.length; ++i) {
            configArgs[i] = (String)configList.get(i - 1);
        }
        return configArgs;
    }

    public static String createConfigEntry(String item) {
        return ConfigUtil.concat((Object[])new Object[]{item});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties parseParameters(Element element) throws Exception {
        Properties props = new Properties();
        String name = null;
        String value = null;
        NodeList nList = element.getElementsByTagName("Parameter");
        for (int i = 0; i < nList.getLength(); ++i) {
            Element parameterElement = (Element)nList.item(i);
            NamedNodeMap nm = parameterElement.getAttributes();
            Node node = nm.getNamedItem("Name");
            name = node.getNodeValue();
            String elementValue = OpStringLoader.getTextValue(parameterElement);
            node = nm.getNamedItem("Value");
            if (elementValue.length() > 0 && node != null) {
                throw new Exception("Declare either a Value attribute or a <Parameter> value, not both");
            }
            if (node == null) {
                if (elementValue.length() <= 0) throw new Exception("You must declare a Value attribute or a <Parameter> value");
                value = elementValue;
            } else {
                value = node.getNodeValue();
            }
            props.put(name, value);
        }
        if (!logger.isLoggable(Level.FINEST)) return props;
        String tagName = element.getTagName();
        if (element.getParentNode() != null && element.getParentNode() instanceof Element) {
            tagName = ((Element)element.getParentNode()).getTagName() + "." + tagName;
        }
        logger.finest("Element [" + tagName + "], Parameters: " + props.toString());
        return props;
    }

    private Hashtable getAttributeTable(Element el) {
        String name = null;
        String value = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        NodeList nList = el.getElementsByTagName("Attribute");
        for (int i = 0; i < nList.getLength(); ++i) {
            NamedNodeMap nm = nList.item(i).getAttributes();
            Node node = nm.getNamedItem("Name");
            name = node.getNodeValue();
            node = nm.getNamedItem("Value");
            value = node.getNodeValue();
            table.put(name, value);
        }
        return table;
    }

    private void parseSystemRequirements(Element element, ServiceLevelAgreements sla, String codebase) throws Exception {
        NodeList nList = element.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            SoftwareLoad softwareLoad;
            String className;
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            if (el.getTagName().equals("Utilization")) {
                SLA sysSLA = this.parseSLA(el, true);
                ThresholdValues tVal = new ThresholdValues(sysSLA.getLowThreshold(), sysSLA.getHighThreshold());
                sla.addSystemThreshold(sysSLA.getIdentifier(), tVal);
            }
            if (!el.getTagName().equals("SystemComponent")) continue;
            String name = el.getAttribute("Name");
            if (name.length() == 0) {
                name = null;
            }
            if ((className = el.getAttribute("ClassName")).length() == 0) {
                className = null;
            }
            Hashtable table = this.getAttributeTable(el);
            ServiceLevelAgreements.SystemRequirement sysReq = new ServiceLevelAgreements.SystemRequirement(name, className, table);
            if (className != null) {
                ClassBundle bundle = this.parseResources(el, className, codebase);
                sysReq.setClasspath(bundle.getJARs());
            }
            if ((softwareLoad = this.parseSoftwareLoad(el)) != null) {
                sysReq.setSoftwareLoad(softwareLoad);
            }
            sla.addSystemRequirement(sysReq);
        }
    }

    private SLA parseSLA(Element el, boolean enforceRelativeValues) throws Exception {
        String identifier = el.getAttribute("ID");
        String sLow = el.getAttribute("Low");
        String sHigh = el.getAttribute("High");
        double low = 0.0;
        if (sLow.length() > 0) {
            low = new Double(sLow);
        } else if (this.processingOverrides) {
            low = Double.NaN;
        }
        if (!(!enforceRelativeValues || this.processingOverrides && Double.isNaN(low) || !(low < 0.0) && !(low > 1.0))) {
            logger.severe("A value for the low range is inaccurate, must be between 0.0 and 1.0");
            throw new IllegalArgumentException("Bad low value, must be between 0.0 and 1.0");
        }
        double high = 1.0;
        if (sHigh.length() > 0) {
            high = new Double(sHigh);
        } else if (this.processingOverrides) {
            high = Double.NaN;
        }
        if (!(!enforceRelativeValues || this.processingOverrides && Double.isNaN(high) || !(high < 0.0) && !(high > 1.0))) {
            logger.severe("A value for the high range is inaccurate, must be between 0.0 and 1.0");
            throw new IllegalArgumentException("Bad high value, must be between 0.0 and 1.0");
        }
        if (low > high) {
            throw new IllegalArgumentException("Bad range, low value must be less then the high range value");
        }
        String[] configParms = null;
        NodeList nList = el.getElementsByTagName("Configuration");
        if (nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                configParms = OpStringLoader.parseConfiguration(element);
                break;
            }
        } else {
            nList = el.getElementsByTagName("PolicyHandler");
            if (nList.getLength() > 0) {
                String type = null;
                String max = null;
                String lowerDampener = null;
                String upperDampener = null;
                for (int i = 0; i < nList.getLength(); ++i) {
                    Node node = nList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    type = element.getAttribute("type");
                    max = element.getAttribute("max");
                    lowerDampener = element.getAttribute("lowerDampener");
                    upperDampener = element.getAttribute("upperDampener");
                    break;
                }
                configParms = this.getSLAConfigArgs(type, max, lowerDampener, upperDampener);
            }
        }
        nList = el.getElementsByTagName("Monitor");
        ArrayList<WatchDescriptor> watchDescList = new ArrayList<WatchDescriptor>();
        WatchDescriptor[] watchDescriptors = null;
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getAttribute("name");
            String property = element.getAttribute("property");
            String sPeriod = element.getAttribute("period");
            long period = 0L;
            try {
                Long l = new Long(sPeriod);
                period = l;
            }
            catch (NumberFormatException e) {
                logger.severe("A value for the [" + name + "] Monitor period is inaccurate [" + sPeriod + "], must be a number");
                throw new IllegalArgumentException("A value for the [" + name + "] Monitor period is inaccurate [" + sPeriod + "], must be a number");
            }
            watchDescList.add(new WatchDescriptor(name, "gauge", property, period));
        }
        watchDescriptors = watchDescList.toArray(new WatchDescriptor[watchDescList.size()]);
        SLA sla = new SLA(identifier, new double[]{low, high}, configParms, watchDescriptors);
        return sla;
    }

    String[] getSLAConfigArgs(String type, String max, String lowerDampener, String upperDampener) {
        int handlerType;
        String[] args = null;
        String handler = "org.jini.rio.qos.";
        if (type.equals("scaling")) {
            handler = handler + "ScalingPolicyHandler";
            handlerType = 1;
        } else if (type.equals("relocation")) {
            handler = handler + "RelocationPolicyHandler";
            handlerType = 2;
        } else {
            handler = handler + "SLAPolicyHandler";
            handlerType = 3;
        }
        String slaPolicyHandler = "org.jini.rio.qos.SLAPolicyHandler.slaPolicyHandler";
        switch (handlerType) {
            case 1: {
                args = new String[]{"-", slaPolicyHandler + "=new " + handler + "((org.jini.rio.core.SLA)$data)", handler + ".MaxServices=" + max, handler + ".LowerThresholdDampeningFactor=" + lowerDampener, handler + ".UpperThresholdDampeningFactor=" + upperDampener};
                break;
            }
            case 2: {
                args = new String[]{"-", slaPolicyHandler + "=new " + handler + "((org.jini.rio.core.SLA)$data)", handler + ".LowerThresholdDampeningFactor=" + lowerDampener, handler + ".UpperThresholdDampeningFactor=" + upperDampener};
                break;
            }
            default: {
                args = new String[]{"-", slaPolicyHandler + "=new " + handler + "((org.jini.rio.core.SLA)$data)"};
            }
        }
        return args;
    }

    private ClassBundle parseFDH(Element element, String codebase) throws Exception {
        String className = element.getAttribute("ClassName");
        NodeList nList = element.getChildNodes();
        ClassBundle bundle = this.parseResources(element, className, codebase);
        boolean setConfiguration = false;
        for (int i = 0; i < nList.getLength(); ++i) {
            Element el;
            Node node = nList.item(i);
            if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equals("Configuration")) continue;
            String[] configArgs = OpStringLoader.parseConfiguration(el);
            bundle.addMethod("setConfiguration", new Object[]{configArgs});
            setConfiguration = true;
        }
        if (!setConfiguration) {
            String[] empty = new String[]{"-"};
            bundle.addMethod("setConfiguration", new Object[]{empty});
        }
        return bundle;
    }

    private ClassBundle parseResources(Element el, String className, String codebase) {
        ArrayList<String> jars = new ArrayList<String>();
        HashMap<String, String[]> sharedComponents = new HashMap<String, String[]>();
        HashMap<String, String> httpmdResources = new HashMap<String, String>();
        String algorithm = null;
        NodeList nList = el.getElementsByTagName("Resources");
        boolean computeHttpMD = false;
        for (int i = 0; i < nList.getLength(); ++i) {
            Element element;
            Node node = nList.item(i);
            if (node.getNodeType() != 1 || (element = (Element)node).getParentNode().getLocalName() != null && !element.getParentNode().getLocalName().equals(el.getLocalName())) continue;
            String computeHttpmd = element.getAttribute("ComputeHttpmd");
            computeHttpMD = computeHttpmd.equals("yes");
            algorithm = element.getAttribute("Algorithm");
            String location = element.getAttribute("Location");
            NodeList nodeList = element.getElementsByTagName("JAR");
            Element[] elems = this.getElements(nodeList);
            for (int k = 0; k < elems.length; ++k) {
                String jar = OpStringLoader.getTextValue(elems[k]);
                jars.add(jar);
                if (location.length() <= 0) continue;
                httpmdResources.put(jar, location);
            }
            nodeList = element.getElementsByTagName("SharedComponent");
            elems = this.getElements(nodeList);
            for (int j = 0; j < nodeList.getLength(); ++j) {
                nList = elems[j].getChildNodes();
                Element[] childElems = this.getElements(nList);
                ArrayList<String> jarList = new ArrayList<String>();
                String sharedComponentClassName = null;
                for (int k = 0; k < childElems.length; ++k) {
                    if (childElems[k].getTagName().equals("JAR")) {
                        String jar = OpStringLoader.getTextValue(childElems[k]);
                        jarList.add(jar);
                        if (location.length() > 0) {
                            httpmdResources.put(jar, location);
                        }
                    }
                    if (!childElems[k].getTagName().equals("ClassName")) continue;
                    sharedComponentClassName = OpStringLoader.getTextValue(childElems[k]);
                }
                String[] shJars = jarList.toArray(new String[jarList.size()]);
                sharedComponents.put(sharedComponentClassName, shJars);
            }
        }
        ClassBundle bundle = new ClassBundle(className, jars.toArray(new String[jars.size()]), sharedComponents, algorithm, httpmdResources, codebase);
        bundle.setComputeHttpMD(computeHttpMD);
        return bundle;
    }

    private SoftwareLoad parseSoftwareLoad(Element elem) throws MalformedURLException {
        SoftwareLoad softwareLoad = null;
        NodeList nList = elem.getElementsByTagName("SoftwareLoad");
        Element[] elems = this.getElements(nList);
        for (int i = 0; i < elems.length; ++i) {
            boolean removeOnDestroy = true;
            String sRemoveOnDestroy = elems[i].getAttribute("RemoveOnDestroy");
            if (sRemoveOnDestroy != null) {
                removeOnDestroy = sRemoveOnDestroy.equals("yes");
            }
            softwareLoad = new SoftwareLoad(removeOnDestroy);
            NodeList nList1 = elems[i].getChildNodes();
            Element[] elems1 = this.getElements(nList1);
            for (int j = 0; j < elems1.length; ++j) {
                if (elems1[j].getTagName().equals("Download")) {
                    SoftwareLoad.SoftwareDownloadAttributes downloadAttrs = this.parseDownload(elems1[j]);
                    softwareLoad.setSoftwareDownloadAttributes(downloadAttrs);
                }
                if (!elems1[j].getTagName().equals("PostInstall")) continue;
                boolean removeOnCompletion = true;
                String sRemoveOnCompletion = elems1[j].getAttribute("RemoveOnCompletion");
                if (sRemoveOnCompletion != null) {
                    removeOnCompletion = sRemoveOnCompletion.equals("yes");
                }
                String executionTarget = null;
                SoftwareLoad.SoftwareDownloadAttributes downloadAttrs = null;
                NodeList nList2 = elems1[j].getChildNodes();
                Element[] elems2 = this.getElements(nList2);
                for (int k = 0; k < elems2.length; ++k) {
                    if (elems2[k].getTagName().equals("Download")) {
                        downloadAttrs = this.parseDownload(elems2[k]);
                    }
                    if (!elems2[k].getTagName().equals("ExecutionTarget")) continue;
                    executionTarget = elems2[k].getAttribute("Name");
                }
                SoftwareLoad.PostInstallAttributes postInstall = new SoftwareLoad.PostInstallAttributes(executionTarget, downloadAttrs, removeOnCompletion);
                softwareLoad.setPostInstallAttributes(postInstall);
            }
        }
        return softwareLoad;
    }

    private SoftwareLoad.SoftwareDownloadAttributes parseDownload(Element element) throws MalformedURLException {
        String source = element.getAttribute("Source");
        String installRoot = element.getAttribute("InstallRoot");
        String unarchive = element.getAttribute("Unarchive");
        NodeList nList = element.getChildNodes();
        Element[] elems = this.getElements(nList);
        String location = null;
        for (int i = 0; i < elems.length; ++i) {
            if (!elems[i].getTagName().equals("Location")) continue;
            location = OpStringLoader.getTextValue(elems[i]);
        }
        return new SoftwareLoad.SoftwareDownloadAttributes(new URL(location + source), installRoot, unarchive.equals("yes"));
    }

    private LoggerConfig[] parseLogging(Element element) throws Exception {
        NodeList nList = element.getChildNodes();
        Element[] elems = this.getElements(nList);
        ArrayList<LoggerConfig> configs = new ArrayList<LoggerConfig>();
        for (int i = 0; i < elems.length; ++i) {
            if (!elems[i].getTagName().equals("Logger")) continue;
            configs.add(this.parseLogger(elems[i]));
        }
        return configs.toArray(new LoggerConfig[configs.size()]);
    }

    private LoggerConfig parseLogger(Element element) throws Exception {
        String name = null;
        Level level = null;
        boolean useParent = false;
        String rBundle = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("Name")) {
                name = attr.getValue();
            }
            if (attr.getName().equals("Level")) {
                level = Level.parse(attr.getValue());
            }
            if (attr.getName().equals("UseParent")) {
                useParent = Boolean.valueOf(attr.getValue());
            }
            if (!attr.getName().equals("ResourceBundle")) continue;
            rBundle = attr.getValue();
        }
        NodeList nList = element.getChildNodes();
        Element[] elems = this.getElements(nList);
        ArrayList<LoggerConfig.LogHandlerConfig> handlerList = new ArrayList<LoggerConfig.LogHandlerConfig>();
        for (int i = 0; i < elems.length; ++i) {
            if (!elems[i].getTagName().equals("Handler")) continue;
            handlerList.add(this.parseHandler(elems[i]));
        }
        LoggerConfig.LogHandlerConfig[] configs = handlerList.toArray(new LoggerConfig.LogHandlerConfig[handlerList.size()]);
        return new LoggerConfig(name, level, useParent, rBundle, configs);
    }

    private LoggerConfig.LogHandlerConfig parseHandler(Element element) throws Exception {
        ArrayList<LoggerConfig.FormalArgument> params = new ArrayList<LoggerConfig.FormalArgument>();
        String className = null;
        Level level = null;
        String formatter = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("ClassName")) {
                className = attr.getValue();
            }
            if (!attr.getName().equals("Level")) continue;
            level = Level.parse(attr.getValue());
        }
        NodeList nList = element.getChildNodes();
        Element[] elems = this.getElements(nList);
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i].getTagName().equals("Parameters")) {
                String name = null;
                String value = null;
                NodeList paramList = elems[i].getElementsByTagName("Parameter");
                for (int j = 0; j < paramList.getLength(); ++j) {
                    NamedNodeMap nm = paramList.item(j).getAttributes();
                    Node node = nm.getNamedItem("Name");
                    name = node.getNodeValue();
                    node = nm.getNamedItem("Value");
                    value = node.getNodeValue();
                    LoggerConfig.FormalArgument arg = new LoggerConfig.FormalArgument(name, value);
                    params.add(arg);
                }
            }
            if (!elems[i].getTagName().equals("Formatter")) continue;
            formatter = elems[i].getAttribute("ClassName");
        }
        return new LoggerConfig.LogHandlerConfig(className, level, params, formatter);
    }

    public Element[] getElements(NodeList nList) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            list.add(node);
        }
        return list.toArray(new Element[list.size()]);
    }

    void verify(Element element, GlobalAttrs global) throws Exception {
        if (this.defaultGroups == null) {
            NodeList groups = element.getElementsByTagName("Groups");
            NodeList locators = element.getElementsByTagName("Locators");
            if (global.getGroups().length == 0 && groups.getLength() == 0 && global.getLocators().length == 0 && locators.getLength() == 0) {
                throw new Exception("Specify either Groups or Locators");
            }
        }
    }

    static ClassBundle getDefaultFDH() {
        ClassBundle fdhBundle = new ClassBundle(DEFAULT_FDH);
        String[] empty = new String[]{"-"};
        fdhBundle.addMethod("setConfiguration", new Object[]{empty});
        return fdhBundle;
    }

    static Schedule createSchedule(Element element) {
        String NO_VALUE = "novalue";
        String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        String[] days = new String[]{NO_VALUE, "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        String DEPLOY_DATE = "DeployDate";
        String MONTH = "Month";
        String DoM = "DayOfMonth";
        String DoW = "DayOfWeek";
        String HOUR = "Hour";
        String MINUTE = "Minute";
        String DURATION = "Duration";
        String REPEATS = "Repeats";
        String REPEAT_COUNT = "Count";
        String INTERVAL = "Interval";
        String FORMAT = "Format";
        String format = "";
        NodeList nList = element.getChildNodes();
        HashMap<String, Number> scheduleMap = new HashMap<String, Number>();
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            if (elem.getNodeName().equals(DEPLOY_DATE)) {
                int j;
                String month = elem.getAttribute(MONTH);
                String dom = elem.getAttribute(DoM);
                String dow = elem.getAttribute(DoW);
                String hour = elem.getAttribute(HOUR);
                String minute = elem.getAttribute(MINUTE);
                format = elem.getAttribute(FORMAT);
                if (month.length() > 0 && !month.equals(NO_VALUE)) {
                    for (j = 0; j < months.length; ++j) {
                        if (!month.equals(months[j])) continue;
                        scheduleMap.put(MONTH, new Integer(j));
                        break;
                    }
                }
                if (dom.length() > 0) {
                    if (scheduleMap.get(MONTH) == null) {
                        throw new IllegalArgumentException("You must specify a Month if a DayOfMonth is used");
                    }
                    scheduleMap.put(DoM, new Integer(dom));
                } else if (scheduleMap.get(MONTH) != null) {
                    throw new IllegalArgumentException("You must specify a DayOfMonth if a Month is used");
                }
                if (dow.length() > 0 && !dow.equals(NO_VALUE)) {
                    if (scheduleMap.get(DoM) != null) {
                        throw new IllegalArgumentException("DayOfMonth and DayOfWeek are mutually exclusive");
                    }
                    for (j = 0; j < days.length; ++j) {
                        if (!dow.equals(days[j])) continue;
                        scheduleMap.put(DoW, new Integer(j));
                        break;
                    }
                }
                if (hour.length() > 0) {
                    scheduleMap.put(HOUR, new Integer(hour));
                } else {
                    if (scheduleMap.get(DoM) != null) {
                        throw new IllegalArgumentException("You must specify an Hour if " + DoM + " is used");
                    }
                    if (scheduleMap.get(DoW) != null) {
                        throw new IllegalArgumentException("You must specify an Hour if " + DoW + " is used");
                    }
                }
                if (minute.length() > 0) {
                    scheduleMap.put(MINUTE, new Integer(minute));
                } else {
                    scheduleMap.put(MINUTE, new Integer(0));
                }
            }
            if (elem.getNodeName().equals(DURATION)) {
                scheduleMap.put(DURATION, new Long(OpStringLoader.computeTime(elem)));
            }
            if (!elem.getNodeName().equals(REPEATS)) continue;
            String count = elem.getAttribute(REPEAT_COUNT);
            NodeList nl = elem.getElementsByTagName(INTERVAL);
            if (nl.getLength() > 0) {
                scheduleMap.put(INTERVAL, new Long(OpStringLoader.computeTime((Element)nl.item(0))));
            } else {
                scheduleMap.put(INTERVAL, new Long(5000L));
            }
            if (count.length() > 0) {
                scheduleMap.put(REPEAT_COUNT, new Long(count));
                continue;
            }
            scheduleMap.put(REPEAT_COUNT, new Long(-1L));
        }
        if (scheduleMap.get(DURATION) == null) {
            scheduleMap.put(DURATION, new Long(-1L));
        } else {
            if (scheduleMap.get(REPEAT_COUNT) == null) {
                scheduleMap.put(REPEAT_COUNT, new Long(-1L));
            }
            if (scheduleMap.get(INTERVAL) == null) {
                scheduleMap.put(INTERVAL, new Long(5000L));
            }
        }
        if (scheduleMap.get(HOUR) != null && format.equals("PM")) {
            int hour = (Integer)scheduleMap.remove(HOUR);
            scheduleMap.put(HOUR, new Integer(hour += 12));
        }
        Schedule schedule = null;
        schedule = scheduleMap.get(MONTH) != null ? new Schedule((Integer)scheduleMap.get(MONTH), (Integer)scheduleMap.get(DoM), (Integer)scheduleMap.get(HOUR), (Integer)scheduleMap.get(MINUTE), (Long)scheduleMap.get(DURATION), (Long)scheduleMap.get(REPEAT_COUNT), (Long)scheduleMap.get(INTERVAL)) : (scheduleMap.get(DoW) != null ? new Schedule((Integer)scheduleMap.get(DoW), (Integer)scheduleMap.get(HOUR), (Integer)scheduleMap.get(MINUTE), (Long)scheduleMap.get(DURATION), (Long)scheduleMap.get(REPEAT_COUNT), (Long)scheduleMap.get(INTERVAL)) : (scheduleMap.get(HOUR) != null ? new Schedule((Integer)scheduleMap.get(HOUR), (Integer)scheduleMap.get(MINUTE), (Long)scheduleMap.get(DURATION), (Long)scheduleMap.get(REPEAT_COUNT), (Long)scheduleMap.get(INTERVAL)) : (scheduleMap.get(MINUTE) != null ? new Schedule((Integer)scheduleMap.get(MINUTE), (Long)scheduleMap.get(DURATION), (Long)scheduleMap.get(REPEAT_COUNT), (Long)scheduleMap.get(INTERVAL)) : new Schedule())));
        return schedule;
    }

    static long computeTime(Element element) {
        long MINUTE = 60000L;
        long HOUR = MINUTE * 60L;
        long DAY = HOUR * 24L;
        String DAYS = "Days";
        String HOURS = "Hours";
        String MINUTES = "Minutes";
        long lDays = 0L;
        long lHours = 0L;
        long lMinutes = 0L;
        String days = element.getAttribute(DAYS);
        String hours = element.getAttribute(HOURS);
        String minutes = element.getAttribute(MINUTES);
        if (days.length() > 0) {
            lDays = Long.parseLong(days);
        }
        if (hours.length() > 0) {
            lHours = Long.parseLong(hours);
        }
        if (minutes.length() > 0) {
            lMinutes = Long.parseLong(minutes);
        }
        return lDays * DAY + lHours * HOUR + lMinutes * MINUTE;
    }

    public static void main(String[] args) {
        try {
            OpStringLoader loader = new OpStringLoader();
            if (args.length == 0) {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                while (true) {
                    try {
                        while (true) {
                            String prompt = "Enter an command:\n1: Parse Override\n2: Parse OperationalString\nq/quit\n> ";
                            System.out.print(prompt);
                            String input = br.readLine();
                            if (input == null || input.length() <= 0) continue;
                            if (input.equals("q") || input.equals("quit")) {
                                try {
                                    br.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                System.exit(0);
                                continue;
                            }
                            String pwd = System.getProperty("user.dir");
                            System.out.println("[" + pwd + "]");
                            if (input.startsWith("1")) {
                                System.out.print("Enter Override to parse> ");
                                String override = br.readLine();
                                loader.setServiceOverride(override);
                                continue;
                            }
                            if (input.startsWith("2")) {
                                System.out.print("Enter OperationalString to parse> ");
                                String opstring = br.readLine();
                                loader.parseOperationalString(opstring);
                                continue;
                            }
                            System.out.println("? Invalid command");
                            System.out.println(prompt);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            loader.parseOperationalString(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class XMLErrorHandler
    implements ErrorHandler {
        @Override
        public void warning(SAXParseException err) throws SAXException {
            System.out.println("+++ Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println("   " + err.getMessage());
        }

        @Override
        public void error(SAXParseException err) throws SAXException {
            System.out.println("+++ Error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println("   " + err.getMessage());
            throw err;
        }

        @Override
        public void fatalError(SAXParseException err) throws SAXException {
            System.out.println("+++ Fatal, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println("   " + err.getMessage());
            throw err;
        }
    }
}

