/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.opstring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.opstring.ParsedService;

public class OverrideHelper {
    static ParsedService override(ParsedService base, ParsedService override) {
        ClassBundle[] cb;
        if (override == null) {
            return base;
        }
        base.setName(override.getName());
        if (override.getComment() != null) {
            base.setComment(override.getComment());
        }
        if (override.getOrganization() != null) {
            base.setOrganization(override.getOrganization());
        }
        if (override.getGroups().length > 0) {
            base.setGroups(override.getGroups(), false);
        }
        if (override.getLocators().length > 0) {
            base.setLocators(override.getLocators(), false);
        }
        if (override.getLogConfigs().length > 0) {
            base.setLogConfigs(override.getLogConfigs(), false);
        }
        if (override.getConfigParameters().length > 0) {
            base.setConfigParameters(override.getConfigParameters(), true);
        }
        if (override.getServiceProvisionConfig().length > 1) {
            String[] overrideArgs = override.getServiceProvisionConfig();
            String[] origArgs = base.getServiceProvisionConfig();
            String[] tunedArgs = OverrideHelper.overrideArgs(origArgs, overrideArgs);
            base.setServiceProvisionConfig(tunedArgs);
        }
        Properties initParms = base.getParameters();
        Properties overrideParms = override.getParameters();
        for (Map.Entry<Object, Object> me : overrideParms.entrySet()) {
            initParms.setProperty((String)me.getKey(), (String)me.getValue());
        }
        base.setParameters(initParms, true);
        if (override.getMaintain() != null) {
            base.setMaintain(override.getMaintain());
        }
        if (override.getCluster().length > 0) {
            base.setCluster(override.getCluster(), false);
        }
        if (override.getMaxPerMachine() != null) {
            base.setMaxPerMachine(override.getMaxPerMachine());
        }
        if (override.getMaxPerPhysicalMachine() != null) {
            base.setMaxPerPhysicalMachine(override.getMaxPerPhysicalMachine());
        }
        if (override.getTotalNumberOfServices() != null) {
            base.setTotalNumberOfServices(override.getTotalNumberOfServices());
        }
        if (override.getMatchOnName() != null) {
            base.setMatchOnName(override.getMatchOnName());
        }
        if (override.getCodebase() != null) {
            base.setCodebase(override.getCodebase());
        }
        if (override.getComponentBundle() != null) {
            cb = override.getComponentBundle();
            if (cb.getCodebase() == null) {
                cb.setCodebase(base.getCodebase());
            }
            base.setComponentBundle((ClassBundle)cb);
        }
        if (override.getInterfaceBundles().length > 0) {
            cb = override.getInterfaceBundles();
            for (int i = 0; i < cb.length; ++i) {
                if (cb[i].getCodebase() != null) continue;
                cb[i].setCodebase(base.getCodebase());
            }
            base.setInterfaceBundles(override.getInterfaceBundles());
        }
        if (override.getServiceLevelAgreements() != null) {
            ServiceLevelAgreements overridenSLAs = override.getServiceLevelAgreements();
            ServiceLevelAgreements baseSLAs = base.getServiceLevelAgreements();
            if (baseSLAs == null) {
                base.setServiceLevelAgreements(overridenSLAs);
            } else {
                ThresholdValues tValue;
                int i;
                ServiceLevelAgreements sla = new ServiceLevelAgreements();
                HashMap<String, ThresholdValues> map = new HashMap<String, ThresholdValues>();
                String[] sysThresholdIDs = baseSLAs.getSystemThresholdIDs();
                for (i = 0; i < sysThresholdIDs.length; ++i) {
                    tValue = baseSLAs.getSystemThresholdValue(sysThresholdIDs[i]);
                    map.put(sysThresholdIDs[i], tValue);
                }
                sysThresholdIDs = overridenSLAs.getSystemThresholdIDs();
                for (i = 0; i < sysThresholdIDs.length; ++i) {
                    tValue = overridenSLAs.getSystemThresholdValue(sysThresholdIDs[i]);
                    map.put(sysThresholdIDs[i], tValue);
                }
                for (Map.Entry mEntry : map.entrySet()) {
                    String id = (String)mEntry.getKey();
                    ThresholdValues tValue2 = (ThresholdValues)mEntry.getValue();
                    sla.addSystemThreshold(id, tValue2);
                }
                ServiceLevelAgreements.SystemRequirement[] sysReqs = overridenSLAs.getSystemRequirements();
                for (int i2 = 0; i2 < sysReqs.length; ++i2) {
                    sla.addSystemRequirement(sysReqs[i2]);
                }
                SLA[] serviceSLAs = baseSLAs.getServiceSLAs();
                for (int i3 = 0; i3 < serviceSLAs.length; ++i3) {
                    SLA tunedSLA = OverrideHelper.tuneSLA(serviceSLAs[i3], overridenSLAs);
                    sla.addServiceSLA(tunedSLA);
                }
                base.setServiceLevelAgreements(sla);
            }
        }
        if (override.getFaultDetectionHandlerBundle() != null) {
            ClassBundle fdhOverride = override.getFaultDetectionHandlerBundle();
            ClassBundle fdhOrig = base.getFaultDetectionHandlerBundle();
            if (fdhOrig.getClassName().equals(fdhOverride.getClassName())) {
                Object[] o1 = fdhOverride.getMethodObjects("setConfiguration");
                String[] overrideArgs = (String[])o1[0];
                Object[] o2 = fdhOrig.getMethodObjects("setConfiguration");
                String[] origArgs = (String[])o2[0];
                String[] tunedArgs = OverrideHelper.overrideArgs(origArgs, overrideArgs);
                fdhOrig.addMethod("setConfiguration", new Object[]{tunedArgs});
                base.setFaultDetectionHandlerBundle(fdhOrig);
            } else {
                base.setFaultDetectionHandlerBundle(override.getFaultDetectionHandlerBundle());
            }
        }
        return base;
    }

    static SLA tuneSLA(SLA original, ServiceLevelAgreements slAgree) {
        SLA[] slas;
        int i;
        SLA tunedSLA = original;
        if (slAgree != null && (i = 0) < (slas = slAgree.getServiceSLAs()).length && slas[i].getIdentifier().equals(original.getIdentifier())) {
            String[] overridenArgs = OverrideHelper.overrideArgs(original.getConfigArgs(), slas[i].getConfigArgs());
            double low = Double.isNaN(slas[i].getLowThreshold()) ? original.getLowThreshold() : slas[i].getLowThreshold();
            double high = Double.isNaN(slas[i].getHighThreshold()) ? original.getHighThreshold() : slas[i].getHighThreshold();
            tunedSLA = new SLA(original.getIdentifier(), new double[]{low, high}, overridenArgs);
        }
        return tunedSLA;
    }

    static String[] overrideArgs(String[] original, String[] overrides) {
        int y;
        String prop;
        int ndx;
        int x;
        ArrayList<String> list = new ArrayList<String>();
        list.add("-");
        for (x = 0; x < original.length; ++x) {
            ndx = original[x].indexOf("=");
            if (ndx == -1) continue;
            boolean replaced = false;
            prop = original[x].substring(0, ndx).trim();
            for (y = 0; y < overrides.length; ++y) {
                String overrideProp;
                ndx = overrides[y].indexOf("=");
                if (ndx == -1 || !prop.equals(overrideProp = overrides[y].substring(0, ndx).trim())) continue;
                list.add(overrides[y]);
                replaced = true;
                break;
            }
            if (replaced) continue;
            list.add(original[x]);
        }
        for (x = 0; x < overrides.length; ++x) {
            ndx = overrides[x].indexOf("=");
            if (ndx == -1) continue;
            boolean found = false;
            prop = overrides[x].substring(0, ndx).trim();
            for (y = 0; y < original.length; ++y) {
                String originalProp;
                ndx = original[y].indexOf("=");
                if (ndx == -1 || !prop.equals(originalProp = original[y].substring(0, ndx).trim())) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(overrides[x]);
        }
        return list.toArray(new String[list.size()]);
    }
}

