/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.opstring;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.log.LoggerConfig;
import org.jini.rio.opstring.GlobalAttrs;

public class ParsedService
extends GlobalAttrs {
    static final String DYNAMIC = "dynamic";
    static final String EXTERNAL = "external";
    static final String FIXED = "fixed";
    private String name;
    private String comment;
    private String opStringName;
    private ClassBundle[] interfaceBundle;
    private String maintain;
    private String maxPerMachine;
    private String maxPerPhysicalMachine;
    private String requiresIsolation;
    private String totalNumberOfServices;
    private String useName;
    private String provisionType;
    private boolean discoPool = true;
    private ClassBundle componentBundle;
    private String jmxName;

    public ParsedService(String name, GlobalAttrs global) {
        this.name = name;
        if (global.cluster.size() > 0) {
            this.cluster.addAll(global.cluster);
        }
        if (global.getCodebase() != null) {
            this.setCodebase(global.getCodebase());
        }
        this.configParms.addAll(global.configParms);
        this.groupList.addAll(global.groupList);
        this.locatorList.addAll(global.locatorList);
        this.logConfigs.addAll(global.logConfigs);
        if (global.organization != null) {
            this.organization = global.organization;
        }
        this.initParms.putAll((Map<?, ?>)global.initParms);
        this.associations.addAll(global.associations);
        this.adaptiveCodebase = global.getAdaptiveCodebase();
        if (global.getFaultDetectionHandlerBundle() != null) {
            this.setFaultDetectionHandlerBundle(global.getFaultDetectionHandlerBundle());
        }
        this.setServiceLevelAgreements(global.getServiceLevelAgreements());
        this.setServiceProvisionConfig(global.getServiceProvisionConfig());
    }

    public boolean getAutoAdvertise() {
        return this.autoAdvertise;
    }

    public void setDiscoveryManagementPooling(String value) {
        this.discoPool = value.equals("yes");
    }

    public boolean getDiscoveryManagementPooling() {
        return this.discoPool;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setJMXName(String name) {
        String test = name.trim();
        int ndx = test.indexOf(":");
        if (ndx == -1) {
            throw new IllegalArgumentException("malformed jmxname, missing ':'");
        }
        if ((ndx = (test = test.substring(ndx)).indexOf("=")) == -1) {
            throw new IllegalArgumentException("malformed jmxame, missing key=value pairing");
        }
        if ((test = test.substring(ndx)).length() == 1) {
            throw new IllegalArgumentException("malformed jmxame, missing key=value pairing");
        }
        this.jmxName = name.trim();
    }

    public String getJMXName() {
        return this.jmxName;
    }

    public void setComment(String comment) {
        this.comment = comment.trim();
    }

    public String getComment() {
        return this.comment;
    }

    public void setOperationalStringName(String opStringName) {
        this.opStringName = opStringName;
    }

    public String getOperationalStringName() {
        return this.opStringName;
    }

    public void setInterfaceBundles(ClassBundle[] bundles) {
        if (bundles == null) {
            this.interfaceBundle = new ClassBundle[0];
        } else {
            this.interfaceBundle = new ClassBundle[bundles.length];
            System.arraycopy(bundles, 0, this.interfaceBundle, 0, bundles.length);
        }
    }

    public ClassBundle[] getInterfaceBundles() {
        if (this.interfaceBundle == null) {
            this.interfaceBundle = new ClassBundle[0];
        }
        for (int i = 0; i < this.interfaceBundle.length; ++i) {
            if (this.interfaceBundle[i].getCodebase() != null) continue;
            this.interfaceBundle[i].setCodebase(this.getCodebase());
        }
        ClassBundle[] bundle = new ClassBundle[this.interfaceBundle.length];
        System.arraycopy(this.interfaceBundle, 0, bundle, 0, this.interfaceBundle.length);
        return bundle;
    }

    public void setComponentBundle(ClassBundle bundle) {
        this.componentBundle = bundle;
    }

    public ClassBundle getComponentBundle() {
        if (this.componentBundle != null && this.componentBundle.getCodebase() == null) {
            this.componentBundle.setCodebase(this.getCodebase());
        }
        return this.componentBundle;
    }

    public void setMaintain(String maintain) {
        int value = new Integer(maintain);
        if (value < 0) {
            throw new IllegalArgumentException("Illegal Maintain value [" + maintain + "], must be > 0");
        }
        this.maintain = maintain;
    }

    public String getMaintain() {
        return this.maintain;
    }

    public void setMaxPerMachine(String maxPerMachine) {
        int value = new Integer(maxPerMachine);
        if (value < -1) {
            throw new IllegalArgumentException("Illegal MaxPerMachine value [" + maxPerMachine + "], must be > -1");
        }
        this.maxPerMachine = maxPerMachine;
    }

    public String getMaxPerMachine() {
        return this.maxPerMachine == null ? "-1" : this.maxPerMachine;
    }

    public void setMaxPerPhysicalMachine(String maxPerPhysicalMachine) {
        int value = new Integer(maxPerPhysicalMachine);
        if (value < -1) {
            throw new IllegalArgumentException("Illegal MaxPerPhyiscalMachine value [" + maxPerPhysicalMachine + "], must be > -1");
        }
        this.maxPerPhysicalMachine = maxPerPhysicalMachine;
    }

    public String getMaxPerPhysicalMachine() {
        return this.maxPerPhysicalMachine == null ? "-1" : this.maxPerPhysicalMachine;
    }

    public void setTotalNumberOfServices(String totalNumberOfServices) {
        int value = new Integer(totalNumberOfServices);
        if (value < 0) {
            throw new IllegalArgumentException("Illegal totalNumberOfServices value [" + totalNumberOfServices + "], must be >= 0");
        }
        this.totalNumberOfServices = totalNumberOfServices;
    }

    public String isRequiresIsolation() {
        return this.requiresIsolation == null ? "false" : this.requiresIsolation;
    }

    public void setRequiresIsolation(String requiresIsolation) {
        this.requiresIsolation = requiresIsolation;
    }

    public String getTotalNumberOfServices() {
        return this.totalNumberOfServices == null ? "1" : this.totalNumberOfServices;
    }

    public void setMatchOnName(String value) {
        this.useName = value;
    }

    public String getMatchOnName() {
        return this.useName;
    }

    public void setProvisionType(String value) {
        if (!(value.equals(DYNAMIC) || value.equals(EXTERNAL) || value.equals(FIXED))) {
            throw new IllegalArgumentException(value + " : unknown provision type");
        }
        this.provisionType = value;
    }

    public int getProvisionType() {
        int type = 0;
        if (this.provisionType.equals(DYNAMIC)) {
            type = 1;
        } else if (this.provisionType.equals(FIXED)) {
            type = 2;
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var6_16;
        StringBuffer buffer = new StringBuffer();
        buffer.append("ParsedService : " + this.name + "\n");
        buffer.append("Use Name      : " + this.useName + "\n");
        buffer.append("JMX Name      : " + (this.jmxName == null ? "<null>" : this.jmxName) + "\n");
        buffer.append("OpString      : " + this.opStringName + "\n");
        buffer.append("Maintain      : " + this.maintain + "\n");
        buffer.append("MaxPerMachine : " + this.maxPerMachine + "\n");
        buffer.append("MaxPerPhyiscalMachine : " + this.maxPerPhysicalMachine + "\n");
        buffer.append("TotalNumberOfServices : " + this.totalNumberOfServices + "\n");
        buffer.append("ProvisionType : " + this.provisionType + "\n");
        buffer.append("AutoAdvertise : " + this.autoAdvertise + "\n");
        buffer.append("Comment       : " + this.comment + "\n");
        buffer.append("Codebase      : " + this.codebase + "\n");
        buffer.append("Organization  : " + this.organization + "\n");
        buffer.append("Groups\n");
        String[] g = this.getGroups();
        for (int i = 0; i < g.length; ++i) {
            buffer.append("\t" + g[i] + "\n");
        }
        buffer.append("Locators\n");
        String[] l = this.getLocators();
        for (int i = 0; i < l.length; ++i) {
            buffer.append("\t" + l[i] + "\n");
        }
        buffer.append("Implementation\n");
        if (this.componentBundle != null) {
            buffer.append("\t" + this.componentBundle.getClassName() + "\n");
            String[] jars = this.componentBundle.getJARNames();
            for (int i = 0; i < jars.length; ++i) {
                buffer.append("\t\t" + jars[i] + "\n");
            }
        } else {
            buffer.append("\tnull\n");
        }
        buffer.append("Interfaces\n");
        if (this.interfaceBundle != null) {
            for (int i = 0; i < this.interfaceBundle.length; ++i) {
                buffer.append("\t" + this.interfaceBundle[i].getClassName() + "\n");
                String[] jars = this.interfaceBundle[i].getJARNames();
                for (int j = 0; j < jars.length; ++j) {
                    buffer.append("\t\t" + jars[j] + "\n");
                }
            }
        } else {
            buffer.append("\tnull\n");
        }
        buffer.append("Parameters\n");
        Set<Object> keys = this.initParms.keySet();
        for (String string : keys) {
            String value = (String)this.initParms.get(string);
            buffer.append("\tName=" + string + " Value=" + value + "\n");
        }
        buffer.append("Configuration\n");
        String[] config = this.getConfigParameters();
        boolean bl = false;
        while (var6_16 < config.length) {
            buffer.append("\t" + config[var6_16] + "\n");
            ++var6_16;
        }
        buffer.append("Cluster\n");
        Iterator iterator = this.cluster.iterator();
        while (iterator.hasNext()) {
            buffer.append("\t" + iterator.next() + "\n");
        }
        buffer.append("Logging\n");
        for (LoggerConfig lc : this.logConfigs) {
            buffer.append(lc.toString() + "\n");
        }
        buffer.append("ServiceLevelAgreements\n");
        ServiceLevelAgreements serviceLevelAgreements = this.getServiceLevelAgreements();
        if (serviceLevelAgreements != null) {
            ServiceLevelAgreements.SystemRequirement[] sysReqs = serviceLevelAgreements.getSystemRequirements();
            if (sysReqs.length > 0) {
                buffer.append("SystemRequirements:\n");
                for (int i = 0; i < sysReqs.length; ++i) {
                    buffer.append(sysReqs[i].toString());
                }
                buffer.append("\n");
            } else {
                buffer.append("\tNo SystemRequirements\n");
            }
            SLA[] slas = serviceLevelAgreements.getServiceSLAs();
            if (slas.length > 0) {
                buffer.append("SLAs:\n");
                for (int i = 0; i < slas.length; ++i) {
                    buffer.append(slas[i].toString());
                }
                buffer.append("\n");
            } else {
                buffer.append("\tNo SLAs\n");
            }
        } else {
            buffer.append("\tnull\n");
        }
        buffer.append("\nServiceProvisionConfig\n");
        String[] provisionConfig = this.getServiceProvisionConfig();
        for (int i = 0; i < provisionConfig.length; ++i) {
            buffer.append("\t" + provisionConfig[i] + "\n");
        }
        buffer.append("FaultDetectionHandler\n");
        ClassBundle fdh = this.getFaultDetectionHandlerBundle();
        if (fdh == null) {
            buffer.append("\tNo FaultDetectionHandler\n");
        } else {
            buffer.append("\t" + fdh.getClassName() + "\n");
        }
        buffer.append("Associations\n");
        AssociationDescriptor[] ads = this.getAssociationDescriptors();
        if (ads.length == 0) {
            buffer.append("\tnone declared");
        } else {
            for (int i = 0; i < provisionConfig.length; ++i) {
                buffer.append("\t" + ads[i].toString() + "\n");
            }
        }
        return buffer.toString();
    }
}

