/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.management.SystemCapabilities;
import com.gigaspaces.start.SystemInfo;
import com.sun.jini.config.Config;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.AggregateConfig;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import org.jini.rio.core.MeasuredResource;
import org.jini.rio.core.provision.SoftwareDownloadRecord;
import org.jini.rio.core.provision.SoftwareLoad;
import org.jini.rio.qos.InetAddressFactory;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.qos.SystemCapabilitiesLoader;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.qos.measurable.MeasurableCapability;
import org.jini.rio.qos.measurable.disk.DiskSpace;
import org.jini.rio.qos.measurable.memory.Memory;
import org.jini.rio.resources.util.SoftwareLoadManager;
import org.jini.rio.watch.ThresholdListener;

public class ComputeResource
extends Observable {
    static final String COMPONENT = "org.jini.rio.qos";
    static Logger logger = Logger.getLogger("org.jini.rio.qos");
    private String description;
    private InetAddress address;
    private final Vector platformCapabilities = new Vector();
    private final Vector measurables = new Vector();
    private final CapabilityChannel capabilityChannel = new CapabilityChannel();
    private boolean persistentProvisioning = false;
    private String provisionRoot;
    private final String[] configArgs;
    private Configuration config;
    private boolean initializing = false;

    public ComputeResource(String[] configArgs, Configuration sharedConfig) {
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        this.configArgs = configArgs;
        String system = System.getProperty("os.name") + ", " + System.getProperty("os.arch") + ", " + System.getProperty("os.version");
        try {
            this.config = sharedConfig == null ? ConfigurationProvider.getInstance((String[])configArgs) : new AggregateConfig(sharedConfig, configArgs);
            String hostAddr = System.getProperty("org.jini.rio.qos.address");
            this.address = hostAddr != null ? InetAddressFactory.getByName(hostAddr) : (InetAddress)this.config.getEntry(COMPONENT, "address", InetAddress.class, (Object)SystemInfo.singleton().network().getHost());
            String defaultDescription = this.address.getHostName() + " " + system;
            this.description = (String)this.config.getEntry(COMPONENT, "description", String.class, (Object)defaultDescription);
            long reportInterval = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)"reportInterval", (long)Long.getLong("org.jini.rio.qos.reportInterval", 60000L), (long)1000L, (long)Long.MAX_VALUE);
            this.capabilityChannel.setReportInterval(reportInterval);
        }
        catch (Exception e) {
            this.description = system;
            logger.log(Level.WARNING, "Creating ComputeResource", e);
        }
    }

    public void setReportInterval(long reportInterval) {
        this.capabilityChannel.setReportInterval(reportInterval);
    }

    public long getReportInterval() {
        return this.capabilityChannel.getReportInterval();
    }

    public String getDescription() {
        return this.description;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void addPlatformCapability(PlatformCapability pCap) {
        if (!this.platformCapabilities.contains(pCap)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Have PlatformCapability : " + pCap.getClass().getName() + " load any system resources");
            }
            pCap.loadResources();
            if (this.platformCapabilities.add(pCap)) {
                this.stateChange();
            }
        }
    }

    public SoftwareDownloadRecord[] provision(PlatformCapability pCap, SoftwareLoad softwareLoad) {
        if (!this.platformCapabilities.contains(pCap)) {
            this.platformCapabilities.add(pCap);
        }
        if (softwareLoad != null) {
            SoftwareLoadManager slm = new SoftwareLoadManager(this.provisionRoot, softwareLoad);
            SoftwareDownloadRecord record = null;
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Provisioning SoftwareLoad for PlatformCapability : " + pCap.getClass().getName());
                }
                record = slm.download();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(record.toString());
                }
                pCap.setSoftwareLoad(softwareLoad);
                pCap.addSoftwareDownloadRecord(record);
                SoftwareDownloadRecord postInstallRecord = slm.postInstall();
                if (postInstallRecord != null) {
                    pCap.addSoftwareDownloadRecord(postInstallRecord);
                }
                pCap.setPath(record.getPath());
                if (!softwareLoad.removeOnDestroy()) {
                    String configFileLocation = this.configArgs[0];
                    logger.info("Not capable of updating Configuration file " + configFileLocation);
                }
            }
            catch (IOException e) {
                if (record != null) {
                    slm.remove();
                }
                logger.log(Level.WARNING, "Provisioning SoftwareLoad for PlatformCapability : " + pCap.getClass().getName(), e);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Have PlatformCapability : " + pCap.getClass().getName() + " load any system resources");
            }
            pCap.loadResources();
            this.stateChange();
        }
        return pCap.getSoftwareDownloadRecords();
    }

    public boolean hasPlatformCapability(PlatformCapability capability) {
        return this.platformCapabilities.contains(capability);
    }

    public void updatePlatformCapability(PlatformCapability capability) throws Exception {
        this.removePlatformCapability(capability, false);
        this.addPlatformCapability(capability);
    }

    public boolean removePlatformCapability(PlatformCapability pCap, boolean clean) {
        boolean removed = false;
        if (clean) {
            SoftwareDownloadRecord[] downloadRecords = pCap.getSoftwareDownloadRecords();
            if (downloadRecords.length > 0 && logger.isLoggable(Level.FINEST)) {
                logger.finest("Removing SoftwareLoad for PlatformCapability : " + pCap.getClass().getName());
            }
            for (int i = 0; i < downloadRecords.length; ++i) {
                SoftwareLoadManager.remove(downloadRecords[i]);
            }
        }
        if (this.platformCapabilities.remove(pCap)) {
            removed = true;
            this.stateChange();
        }
        return removed;
    }

    public boolean addMeasurableCapability(MeasurableCapability capability) {
        boolean added = false;
        if (this.measurables.contains(capability)) {
            return false;
        }
        if (this.measurables.add(capability)) {
            added = true;
            this.capabilityChannel.subscribe(capability);
            this.stateChange();
        }
        return added;
    }

    public boolean hasMeasurableCapability(MeasurableCapability capability) {
        return this.measurables.contains(capability);
    }

    public void updateMeasurableCapability(MeasurableCapability capability) {
        if (this.measurables.contains(capability)) {
            this.measurables.remove(capability);
            this.capabilityChannel.unsubscribe(capability);
        }
        this.addMeasurableCapability(capability);
    }

    public boolean removeMeasurableCapability(MeasurableCapability capability) {
        boolean removed = false;
        if (this.measurables.remove(capability)) {
            removed = true;
            this.capabilityChannel.unsubscribe(capability);
            this.stateChange();
        }
        return removed;
    }

    public void stateChange() {
        if (this.initializing) {
            return;
        }
        this.setChanged();
        this.notifyObservers(this.getResourceCapability());
    }

    public void addThresholdListener(ThresholdListener listener) {
        MeasurableCapability[] mCaps = this.getMeasurableCapabilities();
        for (int i = 0; i < mCaps.length; ++i) {
            mCaps[i].addThresholdListener(listener);
        }
    }

    public void removeThresholdListener(ThresholdListener listener) {
        MeasurableCapability[] mCaps = this.getMeasurableCapabilities();
        for (int i = 0; i < mCaps.length; ++i) {
            mCaps[i].removeThresholdListener(listener);
        }
    }

    public PlatformCapability[] getPlatformCapabilities() {
        return this.platformCapabilities.toArray(new PlatformCapability[this.platformCapabilities.size()]);
    }

    public PlatformCapability getPlatformCapability(String description) {
        PlatformCapability[] pCaps = this.getPlatformCapabilities();
        for (int i = 0; i < pCaps.length; ++i) {
            if (!pCaps[i].getDescription().equals(description)) continue;
            return pCaps[i];
        }
        return null;
    }

    public MeasurableCapability getMeasurableCapability(String description) {
        MeasurableCapability[] mCaps = this.getMeasurableCapabilities();
        for (int i = 0; i < mCaps.length; ++i) {
            if (!mCaps[i].getId().equals(description)) continue;
            return mCaps[i];
        }
        return null;
    }

    public MeasurableCapability[] getMeasurableCapabilities() {
        return this.measurables.toArray(new MeasurableCapability[this.measurables.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasuredResource[] getMeasuredResources() {
        MeasurableCapability[] mCaps = null;
        Vector vector = this.measurables;
        synchronized (vector) {
            mCaps = this.getMeasurableCapabilities();
        }
        MeasuredResource[] measured = new MeasuredResource[mCaps.length];
        for (int i = 0; i < mCaps.length; ++i) {
            measured[i] = mCaps[i].getMeasuredResource();
        }
        return measured;
    }

    public double getUtilization() {
        MeasuredResource[] mCaps = this.getMeasuredResources();
        double utilization = 0.0;
        for (int i = 0; i < mCaps.length; ++i) {
            utilization += mCaps[i].getValue();
        }
        return utilization /= (double)mCaps.length;
    }

    public void setPersistentProvisioning(boolean persistentProvisioning) {
        boolean changed = false;
        if (this.persistentProvisioning != persistentProvisioning) {
            changed = true;
        }
        this.persistentProvisioning = persistentProvisioning;
        if (changed) {
            this.stateChange();
        }
    }

    public boolean getPersistentProvisioning() {
        return this.persistentProvisioning;
    }

    String getPersistentProvisioningRoot() {
        return this.provisionRoot;
    }

    public void setPersistentProvisioningRoot(String provisionRoot) {
        if (provisionRoot != null) {
            this.provisionRoot = provisionRoot;
        }
    }

    public ResourceCapability getResourceCapability() {
        return new ResourceCapability(this.address.getHostAddress(), this.address.getHostName(), ZoneHelper.getSystemZones(), SystemInfo.singleton().os().processId(), this.getPersistentProvisioning(), this.getPlatformCapabilities(), this.getMeasuredResources());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot() {
        if (this.config == null) {
            throw new NullPointerException("config is null, cannot boot");
        }
        this.initializing = true;
        try {
            SystemCapabilitiesLoader systemCapabilitiesLoader = (SystemCapabilitiesLoader)this.config.getEntry(COMPONENT, "systemCapabilitiesLoader", SystemCapabilitiesLoader.class, (Object)new SystemCapabilities());
            PlatformCapability[] pCaps = systemCapabilitiesLoader.getPlatformCapabilities(this.config);
            PlatformCapability storage = null;
            PlatformCapability memory = null;
            for (int i = 0; i < pCaps.length; ++i) {
                if (pCaps[i].getClass().getName().equals("org.jini.rio.qos.capability.system.StorageCapability")) {
                    storage = pCaps[i];
                }
                if (pCaps[i].getClass().getName().equals("org.jini.rio.qos.capability.system.Memory")) {
                    memory = pCaps[i];
                }
                this.addPlatformCapability(pCaps[i]);
            }
            this.capabilityChannel.init();
            MeasurableCapability[] mCaps = systemCapabilitiesLoader.getMeasurableCapabilities(this.config);
            for (int i = 0; i < mCaps.length; ++i) {
                if (mCaps[i] instanceof DiskSpace && storage != null) {
                    mCaps[i].getObservable().addObserver((Observer)((Object)storage));
                }
                if (mCaps[i] instanceof Memory && memory != null) {
                    mCaps[i].getObservable().addObserver((Observer)((Object)memory));
                }
                this.addMeasurableCapability(mCaps[i]);
                mCaps[i].start();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Booting ComputeResource", e);
        }
        finally {
            this.initializing = false;
        }
    }

    public void shutdown() {
        for (MeasurableCapability mc : this.measurables) {
            mc.stop();
        }
        this.capabilityChannel.terminate();
    }

    public class CapabilityChannel
    implements Observer,
    Runnable {
        public static final long DEFAULT_REPORT_INTERVAL = 60000L;
        volatile long reportInterval = 60000L;
        volatile boolean hasChanged;
        volatile Thread channelThread;
        volatile boolean run = true;

        void init() {
            this.channelThread = new Thread((Runnable)this, "CapabilityChannel");
            this.channelThread.setDaemon(true);
            this.channelThread.start();
        }

        public void terminate() {
            this.run = false;
            if (this.channelThread != null) {
                this.channelThread.interrupt();
            }
        }

        public void setReportInterval(long reportInterval) {
            this.reportInterval = reportInterval;
        }

        public long getReportInterval() {
            return this.reportInterval;
        }

        public void subscribe(MeasurableCapability capability) {
            capability.getObservable().addObserver(this);
        }

        public void unsubscribe(MeasurableCapability capability) {
            capability.getObservable().deleteObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.setHasChanged(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(Math.abs((long)System.identityHashCode(this) % this.reportInterval));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.run) {
                try {
                    if (this.getHasChanged()) {
                        ComputeResource.this.stateChange();
                        this.setHasChanged(false);
                    }
                    Thread.sleep(this.reportInterval);
                }
                catch (InterruptedException ignore) {
                    if (this.run) continue;
                    break;
                }
            }
        }

        private synchronized void setHasChanged(boolean hasChanged) {
            this.hasChanged = hasChanged;
        }

        private synchronized boolean getHasChanged() {
            return this.hasChanged;
        }
    }
}

