/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import org.jini.rio.core.MeasuredResource;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.entry.ComputeResourceUtilization;
import org.jini.rio.event.EventHandler;
import org.jini.rio.qos.ComputeResource;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.qos.SLAThresholdEvent;
import org.jini.rio.resources.servicecore.Joiner;
import org.jini.rio.watch.Calculable;

public class ComputeResourceObserver
implements Observer {
    private final ComputeResource computeResource;
    private final Joiner joiner;
    private boolean ignore = false;
    private Object source;
    private final EventHandler eventHandler;
    private final Uuid uuid;
    private final ServiceElement sElem;
    private double utilizationLimit;
    private boolean computeCostBreached = false;
    private final SLA utilizationSLA;
    private static String DESCRIPTION = "ComputeResource Utilization Listener";
    private static Logger logger = Logger.getLogger("org.jini.rio.qos");

    public ComputeResourceObserver(ComputeResource computeResource, Uuid uuid, ServiceElement sElem, EventHandler eventHandler, Joiner joiner) {
        if (computeResource == null) {
            throw new NullPointerException("computeResource is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is null");
        }
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler is null");
        }
        if (joiner == null) {
            throw new NullPointerException("joiner is null");
        }
        this.computeResource = computeResource;
        this.eventHandler = eventHandler;
        this.sElem = sElem;
        this.joiner = joiner;
        this.uuid = uuid;
        ServiceLevelAgreements slas = sElem.getServiceLevelAgreements();
        this.utilizationLimit = 0.99;
        if (slas != null) {
            String[] systemThresholdIDs = slas.getSystemThresholdIDs();
            for (int i = 0; i < systemThresholdIDs.length; ++i) {
                if (!systemThresholdIDs[i].equals("System")) continue;
                ThresholdValues systemThreshold = slas.getSystemThresholdValue(systemThresholdIDs[i]);
                this.utilizationLimit = systemThreshold.getHighThreshold();
                break;
            }
        }
        this.utilizationSLA = new SLA("ComputeResource", new double[]{0.0, this.utilizationLimit});
        computeResource.addObserver(this);
    }

    public void disconnect() {
        this.computeResource.deleteObserver(this);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public ComputeResourceUtilization getComputeResourceUtilization() {
        MeasuredResource[] mrs = this.computeResource.getMeasuredResources();
        HashMap<String, Double> uMap = new HashMap<String, Double>();
        for (int i = 0; i < mrs.length; ++i) {
            uMap.put(mrs[i].getIdentifier(), new Double(mrs[i].getValue()));
        }
        ComputeResourceUtilization computeResourceUtilization = new ComputeResourceUtilization(this.computeResource.getDescription(), this.computeResource.getAddress().getHostName(), this.computeResource.getAddress().getHostAddress(), new Double(this.computeResource.getUtilization()), uMap);
        return computeResourceUtilization;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.ignore) {
            return;
        }
        if (!(o instanceof ComputeResource)) {
            logger.warning("ComputeResourceObserver: Observable update is not a ComputeResource, detach");
            this.disconnect();
            return;
        }
        try {
            SLAThresholdEvent event;
            ServiceBeanInstance instance;
            String hostName;
            String hostAddress;
            Calculable calc;
            long now;
            ResourceCapability resourceCapability = (ResourceCapability)arg;
            double currentUtilization = resourceCapability.getUtilization();
            if (currentUtilization > this.utilizationLimit && !this.computeCostBreached) {
                this.computeCostBreached = true;
                now = System.currentTimeMillis();
                calc = new Calculable("ComputeResource.Utilization", currentUtilization, now);
                try {
                    hostAddress = this.computeResource.getAddress().getHostAddress();
                    hostName = this.computeResource.getAddress().getHostName();
                    instance = new ServiceBeanInstance(this.uuid, new MarshalledInstance(this.source), this.sElem.getServiceBeanConfig(), hostAddress, hostName);
                    event = new SLAThresholdEvent(this.source, this.sElem, instance, calc, this.utilizationSLA, DESCRIPTION, hostAddress, 0);
                    new Thread(new SLAThresholdEventTask(event)).start();
                }
                catch (Throwable t) {
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                    logger.log(Level.WARNING, "Creating SLAThresholdEvent", t);
                }
            }
            if (currentUtilization < this.utilizationLimit && this.computeCostBreached) {
                this.computeCostBreached = true;
                now = System.currentTimeMillis();
                calc = new Calculable("ComputeResource.Utilization", currentUtilization, now);
                try {
                    hostAddress = this.computeResource.getAddress().getHostAddress();
                    hostName = this.computeResource.getAddress().getHostName();
                    instance = new ServiceBeanInstance(this.uuid, new MarshalledInstance(this.source), this.sElem.getServiceBeanConfig(), hostAddress, hostName);
                    event = new SLAThresholdEvent(this.source, this.sElem, instance, calc, this.utilizationSLA, DESCRIPTION, hostAddress, 1);
                    new Thread(new SLAThresholdEventTask(event)).start();
                }
                catch (Throwable t) {
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                    logger.log(Level.WARNING, "Creating SLAThresholdEvent", t);
                }
            }
            if (this.joiner.getJoinManager() != null && !this.ignore) {
                ComputeResourceUtilization computeResourceUtilization = this.getComputeResourceUtilization();
                try {
                    this.joiner.getJoinManager().modifyAttributes(new Entry[]{new ComputeResourceUtilization()}, new Entry[]{computeResourceUtilization});
                }
                catch (IllegalStateException e) {
                    this.ignore = true;
                }
            }
        }
        catch (Throwable t) {
            if (t.getCause() != null) {
                t = t.getCause();
            }
            logger.log(Level.WARNING, "Processing notify from ComputeResource", t);
        }
    }

    class SLAThresholdEventTask
    implements Runnable {
        SLAThresholdEvent event;

        SLAThresholdEventTask(SLAThresholdEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                ComputeResourceObserver.this.eventHandler.fire(this.event);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception notifying SLAThresholdEvent consumers", e);
            }
        }
    }
}

