/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import com.sun.jini.config.Config;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.export.Exporter;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.event.EventHandler;
import org.jini.rio.qos.SLAPolicyEvent;
import org.jini.rio.qos.SLAPolicyHandler;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.ThresholdManager;

public class RelocationPolicyHandler
extends SLAPolicyHandler
implements ServiceProvisionListener,
ServerProxyTrust {
    private static final String description = "Relocation Policy Handler";
    public static final String SEND_NOTIFICATION = "SendRemoteNotification";
    public static final String UPPER_DAMPER = "UpperThresholdDampeningFactor";
    public static final String LOWER_DAMPER = "LowerThresholdDampeningFactor";
    private long upperThresholdDampeningTime;
    private long lowerThresholdDampeningTime;
    private Timer taskTimer;
    private RelocationTask relocationTask;
    public static final String RELOCATION_PENDING = "RELOCATION_PENDING";
    public static final String RELOCATION_FAILURE = "RELOCATION_FAILURE";
    public static final String RELOCATION_SUCCEEDED = "RELOCATION_SUCCEEDED";
    private Object ourRemoteRef;
    private Exporter exporter;
    private static final String COMPONENT = "org.jini.rio.qos.RelocationPolicyHandler";
    static Logger logger = Logger.getLogger("org.jini.rio.qos.RelocationPolicyHandler");

    public RelocationPolicyHandler(SLA sla) {
        super(sla);
        try {
            this.exporter = ExporterConfig.getExporter(this.getConfiguration(), COMPONENT, "provisionListenerExporter");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Getting provisionListenerExporter", e);
        }
        this.taskTimer = new Timer(true);
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setThresholdManager(ThresholdManager thresholdManager) {
        if (this.ourRemoteRef == null) {
            this.exportDo();
        }
        super.setThresholdManager(thresholdManager);
    }

    @Override
    public void disconnect() {
        try {
            this.exporter.unexport(true);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.ourRemoteRef = null;
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
        }
        super.disconnect();
    }

    @Override
    public void initialize(Object proxy, Object eventSource, EventHandler eventHandler, ServiceBeanContext context) {
        super.initialize(proxy, eventSource, eventHandler, context);
        try {
            Configuration config = this.getConfiguration();
            boolean sendRemoteNotification = (Boolean)config.getEntry(COMPONENT, SEND_NOTIFICATION, Boolean.TYPE, (Object)true);
            this.setSendRemoteNotification(sendRemoteNotification);
            this.upperThresholdDampeningTime = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)UPPER_DAMPER, (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            this.lowerThresholdDampeningTime = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)LOWER_DAMPER, (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            if (logger.isLoggable(Level.FINE)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("[" + context.getServiceElement().getName() + "] ");
                buffer.append("RelocationPolicyHandler [" + this.getID() + "]: properties\n");
                buffer.append("low Threshold=" + this.getSLA().getLowThreshold() + ", ");
                buffer.append("high Threshold=" + this.getSLA().getHighThreshold() + ", ");
                buffer.append("sendRemoteNotification=" + sendRemoteNotification + ", ");
                buffer.append("upperThresholdDampeningTime=" + this.upperThresholdDampeningTime + ", ");
                buffer.append("lowerThresholdDampeningTime=" + this.lowerThresholdDampeningTime);
                logger.fine(buffer.toString());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Getting Operational Configuration", e);
        }
    }

    @Override
    public void notify(Calculable calculable, ThresholdValues thresholdValues, int type) {
        if (logger.isLoggable(Level.FINE)) {
            String status = type == 0 ? "breached" : "cleared";
            logger.fine("RelocationPolicyHandler [" + this.getID() + "]: Threshold [" + calculable.getId() + "] " + status + " value [" + calculable.getValue() + "\n] low [" + thresholdValues.getCurrentLowThreshold() + "] high [" + thresholdValues.getCurrentHighThreshold() + "]");
        }
        if (type == 0) {
            double tValue = calculable.getValue();
            if (tValue > thresholdValues.getCurrentHighThreshold()) {
                this.fireRelocation(this.upperThresholdDampeningTime, "upper");
            } else {
                this.fireRelocation(this.lowerThresholdDampeningTime, "lower");
            }
        } else if (this.relocationTask != null) {
            this.relocationTask.cancel();
            this.relocationTask = null;
        }
        this.sendSLAThresholdEvent(calculable, thresholdValues, type);
    }

    void fireRelocation(long dampener, String type) {
        if (dampener > 0L) {
            this.relocationTask = new RelocationTask();
            long now = System.currentTimeMillis();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("[" + this.context.getServiceElement().getName() + "] RelocationPolicyHandler [" + this.getID() + "]: Schedule relocation task in [" + dampener + "] millis");
            }
            try {
                this.taskTimer.schedule((TimerTask)this.relocationTask, new Date(now + dampener));
            }
            catch (IllegalStateException e) {
                logger.log(Level.WARNING, "Force disconnect of [" + this.context.getServiceElement().getName() + "] RelocationPolicyHandler", e);
                this.disconnect();
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("[" + this.context.getServiceElement().getName() + "] RelocationPolicyHandler [" + this.getID() + "]: no " + type + " dampener, perform relocation");
            }
            this.doRelocate();
        }
    }

    @Override
    public void succeeded(ServiceBeanInstance jsbInstance) throws RemoteException {
        try {
            this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), RELOCATION_SUCCEEDED, jsbInstance.getService()));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Getting service to create SLAPolicyEvent", e);
        }
    }

    @Override
    public void failed(ServiceElement sElem, boolean resubmitted) throws RemoteException {
        this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), RELOCATION_FAILURE));
    }

    public TrustVerifier getProxyVerifier() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(this.getClass().getName(), "getProxyVerifier");
        }
        if (this.ourRemoteRef == null) {
            this.exportDo();
        }
        return new BasicProxyTrustVerifier(this.ourRemoteRef);
    }

    private void exportDo() {
        try {
            this.ourRemoteRef = this.exporter.export((Remote)this);
        }
        catch (RemoteException e) {
            logger.log(Level.SEVERE, "Exporting RelocationPolicyHandler [" + this.getID() + "]", e);
        }
    }

    void doRelocate() {
        this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), RELOCATION_PENDING));
        try {
            if (this.ourRemoteRef == null) {
                this.exportDo();
            }
            this.context.getServiceBeanManager().relocate((ServiceProvisionListener)this.ourRemoteRef, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Attempt to invoke relocate method on ProvisionManager", e);
            this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), RELOCATION_FAILURE));
        }
    }

    class RelocationTask
    extends TimerTask {
        RelocationTask() {
        }

        @Override
        public void run() {
            RelocationPolicyHandler.this.doRelocate();
        }
    }
}

